package com.kidoz.sdk.api.players.web_player;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Point;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.KidozTopBar;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;

/**
 * Created by Eugine on 7/22/2015.
 */
public class WebPlayerView extends FrameLayout {

    private static final int DEFAULT_TOP_BAR_COLOR = Color.parseColor("#36a7ec");
    private static final float LOADING_PROGRESS_DEFAULT_RATIO = 0.25f;

    private RelativeLayout mInnerContainer;
    private KidozTopBar mKidozTopBar;
    private KidozWebView mKidozWebView;
    private WebPlayerType mWebPlayerType;

    private OnClickListener mCloseBtnClickListener = null;
    private IOnRemoveViewRequestListener mRemoveViewRequestListener;

    private String mWidgetType;
    private LoadingProgressView mLoadingProgressView;

    public WebPlayerView(Context context, WebPlayerType webPlayerType, String widgetType) {
        super(context);
        mWidgetType = widgetType;
        mWebPlayerType = webPlayerType;

        initiateView();
    }

    private void initiateView() {
        mInnerContainer = new RelativeLayout(getContext());

        addView(mInnerContainer, new RelativeLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.MATCH_PARENT));

        initWebView();
        initTopBar();

        if (mWebPlayerType != null && mWebPlayerType == WebPlayerType.EXTERNAL_LINK) {
            mKidozWebView.setAlpha(0);
            mInnerContainer.setBackgroundColor(Color.parseColor("#77000000"));
            mKidozTopBar.setVisibility(View.INVISIBLE);

            mLoadingProgressView = new LoadingProgressView(getContext());

            Point point = Utils.getScreenSize(getContext());
            int size = (int) (Math.min(point.x, point.y) * LOADING_PROGRESS_DEFAULT_RATIO);
            RelativeLayout.LayoutParams prParams = new RelativeLayout.LayoutParams(size, size);
            prParams.addRule(RelativeLayout.CENTER_IN_PARENT);
            mInnerContainer.addView(mLoadingProgressView,prParams);
            mLoadingProgressView.startLoadingAnimation();

        } else {
            //setAlpha(1);
            mInnerContainer.setBackgroundColor(Color.WHITE);
        }
    }

    /**
     * Initiate Top header bar
     */
    private void initTopBar() {
        //Create top header view
        mKidozTopBar = new KidozTopBar(getContext(), true, mWidgetType, null);
        mKidozTopBar.setId(Utils.generateViewId());
        mKidozTopBar.setTopBarBackgroundColor(DEFAULT_TOP_BAR_COLOR);
        mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener() {
            @Override
            public void onExitClicked(View view) {
                if (mCloseBtnClickListener != null) {
                    mCloseBtnClickListener.onClick(view);
                }
            }
        });
        mKidozTopBar.showParentalLockIcon(false);

        // Add header lay mo view
        mInnerContainer.addView(mKidozTopBar, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT));
    }


    private void initWebView() {
        mKidozWebView = new KidozWebView(getContext(), mWebPlayerType);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        Point point = com.kidoz.sdk.api.general.utils.Utils.getScreenSize(getContext());
        int paddingTop = (int) (Math.max(point.x, point.y) * KidozTopBar.BACKGROUND_RATIO);
        params.topMargin = paddingTop;
        mInnerContainer.addView(mKidozWebView, params);

        mKidozWebView.setOnLounchExternalAppFromRedirect(new KidozWebView.IOnLounchExternalAppFromRedirectListener() {
            @Override
            public void onLounch() {
                if (mRemoveViewRequestListener != null) {
                    mRemoveViewRequestListener.onRemoveView();
                }
            }
        });
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public void loadWebUrl(String url, String googlePlayAppId, String title) {
        mKidozWebView.loadWebUrl(url, googlePlayAppId);
        if (title != null) {
            mKidozTopBar.setTitle(title);
        } else {
            mKidozTopBar.setTitle("");
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();

        if (mKidozWebView != null) {
            mKidozWebView.stopLoading();
        }
    }

    /**
     * Set on close button click listener
     *
     * @param clickListener click listener
     */
    public void setOnCloseButtonClickListenr(OnClickListener clickListener) {
        mCloseBtnClickListener = clickListener;
    }

    /**
     * Set on remove view request listener
     *
     * @param listener click listener
     */
    public void setOnRemoveViewRequestListener(IOnRemoveViewRequestListener listener) {
        mRemoveViewRequestListener = listener;
    }

    /**
     * Close the view and release inner resources
     */
    public void releaseAndcloseView() {
        if (mKidozWebView != null) {
            mKidozWebView.stopAndReleaseWebView();
        }

        if(mLoadingProgressView != null) {
            mLoadingProgressView.stopLoadingAnimation();
        }
    }

    /**
     * Request remove view listener
     */
    public interface IOnRemoveViewRequestListener {
        void onRemoveView();
    }
}
