package com.kidoz.sdk.api.interfaces;

import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;

import de.greenrobot.event.EventBus;

/**
 * Created by RonyBrosh on 2/2/2016.
 */
public class KidozPlayerEventHelper
{
    private WidgetType mWidgetType;
    private IPlayerListener iPlayerListener;

    public KidozPlayerEventHelper(IPlayerListener listener, WidgetType widgetType)
    {
        iPlayerListener = listener;
        mWidgetType = widgetType;
    }

    public void register()
    {
        if (EventBus.getDefault().isRegistered(this) == false)
        {
            EventBus.getDefault().register(this);
        }
    }

    public void unRegister()
    {
        if (EventBus.getDefault().isRegistered(this))
        {
            EventBus.getDefault().unregister(this);
        }
    }

    public void onEvent(WidgetEventMessage event)
    {
        if (event != null && event.getWidgetType() == mWidgetType && iPlayerListener != null)
        {
            switch (event.getMessageType())
            {
                case PLAYER_OPEN:
                {
                    iPlayerListener.onOpen();
                    break;
                }
                case PLAYER_CLOSE:
                {
                    iPlayerListener.onClose();
                    break;
                }
            }
        }
    }

    public interface IPlayerListener
    {
        void onOpen();

        void onClose();
    }
}
