package com.kidoz.sdk.api.general.utils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by orikam on 22/03/16.
 */
public enum StorageLife {

    WIDGET,
    SESSION,
    APP;


    private static final Map<StorageLife, Integer> lookup = new HashMap<StorageLife, Integer>();
    private static final Map<Integer, StorageLife> reverseLookup = new HashMap<Integer, StorageLife>();


    static
    {
        // Lookup
        lookup.put(WIDGET, 0);
        lookup.put(SESSION, 1);
        lookup.put(APP, 2);


        // Reverse Lookup
        reverseLookup.put(0, WIDGET);
        reverseLookup.put(1, SESSION);
        reverseLookup.put(2, APP);


    }

    public static int getValueFromType(StorageLife inVal)
    {
        return lookup.get(inVal);
    }

    public static StorageLife getTypeByValue(int val)
    {
        return reverseLookup.get(val);
    }
}//end enum
