package com.kidoz.sdk.api.general.utils;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Eugine on 9/30/2015.
 */
public class PropertiesObj
{
    public static final String DEFAULT_YOUTUBE_HTML_URL = "http://cdn.kidoz.net/video_player/video_player_sdk.html";

    private static final String CONFIG_VERSION_KEY = "configuration_version";
    private static final String IS_PARENTAL_LOCK_KEY = "is_parental_lock_activated";
    private static final String FEED_BUTTON_VIEW_URL_KEY = "btnUrl";
    private static final String FEED_BUTTON_ANIMATION_TYPE_KEY = "btnAnimation";
    private static final String PANEL_BUTTON_URL_KEY = "panelBtn";
    private static final String PANEL_BUTTON_CLOSE_URL_KEY = "panelBtnClose";
    private static final String PANEL_BUTTON_ANIMATION_TYPE_KEY = "panelBtnAnimation";
    private static final String PANEL_BACKGROUND_COLOR_KEY = "panelBgClr";
    private static final String SDK_STYLE_VERSION_KEY = "style";
    private static final String PANEL_BUTTON_SCALE_PERCENTAGE_KEY = "panelBtnScale";
    private static final String FAMILY_PANEL_ANIMATION_URL_KEY = "familyPanelAnimation";
    private static final String HTML_LOADER_DEFAULT_URL_KEY = "htmlLoaderDefaultURL";
    private static final String YOUTUBE_PLAYER_DEFAULT_HTML_KEY = "defaultHTMLPlayerURL";

    JSONObject mProperties = new JSONObject();

    public PropertiesObj(JSONObject data)
    {
        mProperties = data;
    }

    public JSONObject getData()
    {
        return mProperties;
    }

    public int getConfigVersion()
    {
        int result = -1;
        if (mProperties != null)
        {
            result = mProperties.optInt(CONFIG_VERSION_KEY, 1);
        }
        return result;
    }

    public boolean isParentalLockActive()
    {
        boolean result = false;
        if (mProperties != null)
        {
            result = mProperties.optBoolean(IS_PARENTAL_LOCK_KEY, false);
        }
        return result;
    }

    public String getFeedButtonUrl()
    {
        String result = null;
        if (mProperties != null)
        {
            result = mProperties.optString(FEED_BUTTON_VIEW_URL_KEY);
        }
        return result;
    }

    public String getPanelButtonUrl()
    {
        String result = null;
        if (mProperties != null)
        {
            result = mProperties.optString(PANEL_BUTTON_URL_KEY);
        }
        return result;
    }

    public String getFamilyPanelAnimationUrl()
    {
        String result = null;
        if (mProperties != null)
        {
            result = mProperties.optString(FAMILY_PANEL_ANIMATION_URL_KEY);
        }
        return result;
    }

    public String getPanelButtonCloseUrl()
    {
        String result = null;
        if (mProperties != null)
        {
            result = mProperties.optString(PANEL_BUTTON_CLOSE_URL_KEY);
        }
        return result;
    }

    public int getFeedButtonAnimationType()
    {
        int result = -1;
        if (mProperties != null)
        {
            result = mProperties.optInt(FEED_BUTTON_ANIMATION_TYPE_KEY, 0);
        }
        return result;
    }

    public int getPanelButtonAnimationType()
    {
        int result = -1;
        if (mProperties != null)
        {
            result = mProperties.optInt(PANEL_BUTTON_ANIMATION_TYPE_KEY, 0);
        }
        return result;
    }

    public String getPanelBackGroundColor()
    {
        String result = null;
        if (mProperties != null)
        {
            result = mProperties.optString(PANEL_BACKGROUND_COLOR_KEY, "#ffffff");
        }
        return result;
    }

    public double getPanelButtonScaleValue()
    {
        double result = 0.0;
        if (mProperties != null)
        {
            result = mProperties.optDouble(PANEL_BUTTON_SCALE_PERCENTAGE_KEY, 0.15f);
        }
        return result;
    }

    public int getSdkStyleVersion()
    {
        int result = -1;
        if (mProperties != null)
        {
            result = mProperties.optInt(SDK_STYLE_VERSION_KEY, 0);
        }
        return result;
    }

    public JSONObject getProperties()
    {
        return mProperties;
    }

    public String getHtmlLoaderDefaultLink()
    {
        String result = "";
        if (mProperties != null)
        {
            result = mProperties.optString(HTML_LOADER_DEFAULT_URL_KEY, "");
//            result = "http://s3.amazonaws.com/kidoz.test.bucket/HTML5_Unit/html_loader.html";
        }
        return result;
    }

    public String getDefaultYouTubePlayerHtmlLink()
    {
        String result = DEFAULT_YOUTUBE_HTML_URL;
        if (mProperties != null)
        {
            result = mProperties.optString(YOUTUBE_PLAYER_DEFAULT_HTML_KEY, result);
        }
        return result;
    }

    public void setConfigVersion(int version)
    {
        try
        {
            mProperties.put(CONFIG_VERSION_KEY, version);
        } catch (Exception ex)
        {

        }
    }

    // Update Configuration properties from other properties object (Updates all except the Configuration Version field)
    public void updateConfigFromData(PropertiesObj data)
    {
        try
        {
            if (data != null)
            {
                mProperties.put(FEED_BUTTON_ANIMATION_TYPE_KEY, data.getFeedButtonAnimationType());
                mProperties.put(FEED_BUTTON_VIEW_URL_KEY, data.getFeedButtonUrl());
                mProperties.put(IS_PARENTAL_LOCK_KEY, data.isParentalLockActive());
                mProperties.put(PANEL_BUTTON_ANIMATION_TYPE_KEY, data.getPanelButtonAnimationType());
                mProperties.put(PANEL_BUTTON_URL_KEY, data.getPanelButtonUrl());
                mProperties.put(FAMILY_PANEL_ANIMATION_URL_KEY, data.getFamilyPanelAnimationUrl());
                mProperties.put(PANEL_BUTTON_CLOSE_URL_KEY, data.getPanelButtonCloseUrl());
                mProperties.put(PANEL_BACKGROUND_COLOR_KEY, data.getPanelBackGroundColor());
                mProperties.put(SDK_STYLE_VERSION_KEY, data.getSdkStyleVersion());
                mProperties.put(PANEL_BUTTON_SCALE_PERCENTAGE_KEY, data.getPanelButtonScaleValue());
                mProperties.put(HTML_LOADER_DEFAULT_URL_KEY, data.getHtmlLoaderDefaultLink());
                mProperties.put(YOUTUBE_PLAYER_DEFAULT_HTML_KEY, data.getDefaultYouTubePlayerHtmlLink());
            }
        } catch (JSONException e)
        {
        }
    }
}
