package com.kidoz.sdk.api;

import android.content.Context;

import com.kidoz.sdk.api.ui_views.interstitial.BaseInterstitial;
import com.kidoz.sdk.api.ui_views.interstitial.IntrstWrapper;

import de.greenrobot.event.EventBus;

public class KidozInterstitial extends BaseInterstitial
{
    public static final String TAG = KidozInterstitial.class.getSimpleName();

    /**
     * Initiate kidoz interstitial
     */
    public KidozInterstitial(Context context)
    {
        super(context);
        if (EventBus.getDefault().isRegistered(this) == false)
        {
            EventBus.getDefault().register(this);
        }
    }

    public void onEvent(IntrstWrapper.InterstitialEvents event)
    {
        if (eventLinstener != null)
        {
            if (event == IntrstWrapper.InterstitialEvents.OPENED)
            {
                eventLinstener.onOpened();
            } else if (event == IntrstWrapper.InterstitialEvents.CLOSED)
            {
                eventLinstener.onClosed();
            }
        }
    }

    /**
     * Sow interstitial view
     */
    public void show()
    {
        if (mInterstitialView != null)
        {
            mInterstitialView.show(true);
        }
    }
}


