package com.kidoz.sdk.api.ui_views.panel_view;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.ContentExecutionHandler;
import com.kidoz.sdk.api.ContentLogicLoader;
import com.kidoz.sdk.api.PanelView;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.AssetUtil;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.custom_drawables.ShadowView;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.one_item_view.OneItemView;

import org.json.JSONObject;

/**
 * Created by Eugine on 12/8/2015.
 */
public class FamilyPanelView extends AbstractPanelView {

    public static final String TAG = FamilyPanelView.class.getSimpleName();
    private static final int DEFAULT_CORNER_RADIUS = 4;

    protected String mBtnNextUrl = null;
    protected String mMainAnimationUrl = null;
    protected float mBtnNextRatio = 1;
    protected int mBtnAnimType = 1;

    public FamilyPanelView(Context context, JSONObject jsonObject) {
        super(context, jsonObject);
    }

    @Override
    protected void prepareProperties() {
        super.prepareProperties();

        mBtnNextUrl = mWidgetProperties.optString(NEXT_BTN_URL, null);
        mMainAnimationUrl = mWidgetProperties.optString(MAIN_ANIMATION_URL, null);
        mBtnNextRatio = (float) mWidgetProperties.optDouble(NEXT_BTN_RATIO, 1);
        mBtnAnimType = mWidgetProperties.optInt(NEXT_BTN_ANIMATION_TYPE, 1);
    }

    @Override
    protected void initInnerPanelContentView() {
        mOneItemView = new OneItemView(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId, mBtnNextUrl, mMainAnimationUrl);
        mOneItemView.setId(Utils.generateViewId());
        LayoutParams params = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        mInnerContainer.addView(mOneItemView, params);

        mOneItemView.setViewPagerItemClickListener(new ItemViewPagerAdapter.ViewPagerItemClickListener() {
            @Override
            public void onClickEnd(ContentItem contentItem, int position) {
                if (mAllowClickHandling) {
                    mAllowClickHandling = false;
                    ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId, position, true, false, new ContentExecutionHandler.IOnHandleClickListener() {
                        @Override
                        public void onRestoreClick() {
                            mAllowClickHandling = true;
                        }
                    });
                }
            }
        });
    }


    @Override
    protected void initPanelViewsRules() {

        LayoutParams containerParams = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        mContainer.setLayoutParams(containerParams);

        // 1. Set inner container params.
        // Inner container width is the width of the content view pager + animation view + next button.
        // Inner container height is 2 times the view pager margin + view pager height.
        int viewPagerWidth = (int) (517f * ScreenUtils.getScaleFactor(getContext()));
        int viewPagerMargin = Utils.dpTOpx(getContext(), 6);
        int button = Utils.dpTOpx(getContext(), 30);
        int innerContainerWidth = (viewPagerWidth * 2) + button;
        //  int innerContainerHeight = viewPagerWidth + (viewPagerMargin * 2);

        LayoutParams innerContainerParams = new LayoutParams(innerContainerWidth, ViewGroup.LayoutParams.WRAP_CONTENT);
        mInnerContainer.setLayoutParams(innerContainerParams);

        // 2. Fix one item view params.
        mOneItemView.fixParams();

        // 3. Set bottom container params and.
        LayoutParams bottomBarParams = new LayoutParams(innerContainerWidth, LayoutParams.WRAP_CONTENT);
        mBottomBarContainer.setLayoutParams(bottomBarParams);

        LayoutParams parentalLockParams = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        mParentalLockButton.setLayoutParams(parentalLockParams);

        LayoutParams aboutKidozParams = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        mAboutKidozButton.setLayoutParams(aboutKidozParams);

        // 4. Fix bottom container views rules.
        bottomBarParams.addRule(RelativeLayout.BELOW, mOneItemView.getId());
        bottomBarParams.addRule(RelativeLayout.RIGHT_OF, mAboutKidozButton.getId());
        bottomBarParams.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());

        aboutKidozParams.addRule(RelativeLayout.ALIGN_BOTTOM, mBottomBarContainer.getId());

        parentalLockParams.addRule(RelativeLayout.ALIGN_BOTTOM, mBottomBarContainer.getId());
        parentalLockParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);


        // 5. Set shadow view params.
        RelativeLayout.LayoutParams shadowParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        mShadowView.setLayoutParams(shadowParams);
        shadowParams.addRule(RelativeLayout.ALIGN_LEFT, mInnerContainer.getId());
        shadowParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
        shadowParams.addRule(RelativeLayout.ALIGN_TOP, mInnerContainer.getId());
        shadowParams.addRule(RelativeLayout.ALIGN_BOTTOM, mInnerContainer.getId());

        // 6. Set handle params.
        LayoutParams handleParams = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        mPanelHandle.setLayoutParams(handleParams);

        // 7. Set init visibility of shadow and KIDOZ label.
        mPoweredByTextView.setVisibility(View.VISIBLE);
        mShadowView.setVisibility(View.INVISIBLE);

        int shadowMargin = Utils.dpTOpx(getContext(), 10);

        // 8. Fix rules.
        switch (mPanelType) {
            case TOP: {
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                handleParams.addRule(RelativeLayout.BELOW, mInnerContainer.getId());
                shadowParams.bottomMargin = -shadowMargin;
                break;
            }
            case BOTTOM: {
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                handleParams.addRule(RelativeLayout.ABOVE, mInnerContainer.getId());
                shadowParams.topMargin = -shadowMargin;
                break;
            }
        }

        int margin = Utils.dpTOpx(getContext(), 6);
        switch (mHandlePosition) {
            case CENTER: {
                handleParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                innerContainerParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                shadowParams.leftMargin = -shadowMargin;
                shadowParams.rightMargin = -shadowMargin;
                break;
            }
            case END: {
                handleParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
                handleParams.rightMargin = margin;
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                shadowParams.leftMargin = -shadowMargin;
                break;
            }
            default: {
                handleParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                handleParams.leftMargin = margin;
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                shadowParams.rightMargin = -shadowMargin;
                break;
            }
        }

        mShadowView.setConfiguration(mPanelType, mHandlePosition);
    }

    @Override
    protected void initContentLogicLoader() {
        mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback() {
            @Override
            public void onDataReady(ContentData contentData) {
                mOneItemView.showLoadingProgressView(false);
                if (contentData != null) {
                    mOneItemView.setContent(contentData.getContentDataItems(), mPanelType);
                }
            }

            @Override
            public void onLoadContentFailed() {

            }
        });
    }

    @Override
    protected void initShadowView() {
        mShadowView = new ShadowView(getContext());
        LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
        mContainer.addView(mShadowView, params);
    }

    @Override
    protected void initBottomTitleBar() {
        super.initBottomTitleBar();
        mPoweredByTextView.setGravity(Gravity.CENTER);
    }

    @Override
    public void setPanelColor(int color) {
        super.setPanelColor(color);

        if (mInnerContainer != null) {
            setFamilyColorAndShape(mPanelType, mHandlePosition, mPanelBgColor);
        }
    }

    private void setFamilyColorAndShape(PANEL_TYPE panelType, HANDLE_POSITION handlePosition, int color) {
        GradientDrawable shape = new GradientDrawable();
        shape.setColor(color);

        float cornerRadius = Utils.dpTOpx(getContext(), DEFAULT_CORNER_RADIUS);
        switch (panelType) {
            case TOP: {
                switch (handlePosition) {
                    case CENTER: {
                        shape.setCornerRadii(new float[]{0, 0, 0, 0, cornerRadius, cornerRadius, cornerRadius, cornerRadius});
                        break;
                    }
                    case END: {
                        shape.setCornerRadii(new float[]{0, 0, 0, 0, 0, 0, cornerRadius, cornerRadius});
                        break;
                    }
                    default: {
                        shape.setCornerRadii(new float[]{0, 0, 0, 0, cornerRadius, cornerRadius, 0, 0});
                        break;
                    }
                }
                break;
            }
            default: {
                switch (handlePosition) {
                    case CENTER: {
                        shape.setCornerRadii(new float[]{cornerRadius, cornerRadius, cornerRadius, cornerRadius, 0, 0, 0, 0});
                        break;
                    }
                    case END: {
                        shape.setCornerRadii(new float[]{cornerRadius, cornerRadius, 0, 0, 0, 0, 0, 0});
                        break;
                    }
                    default: {
                        shape.setCornerRadii(new float[]{0, 0, cornerRadius, cornerRadius, 0, 0, 0, 0});
                        break;
                    }
                }
                break;
            }
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            mInnerContainer.setBackground(shape);
        } else {
            mInnerContainer.setBackgroundDrawable(shape);
        }
    }


    @Override
    protected void onExpandPanelAnimationStarted() {
        super.onExpandPanelAnimationStarted();

        mShadowView.setVisibility(View.VISIBLE);
        mOneItemView.showLoadingProgressView(true);
        mContentLogicLoader.loadContent(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId);
        startHandlers();
    }

    @Override
    protected void onCollapsePanelAnimationEnded() {
        super.onCollapsePanelAnimationEnded();

        mShadowView.setVisibility(View.INVISIBLE);
        stopHandlers();
    }

    public static final String MAIN_ANIMATION_URL = "animUrl";
    public static final String NEXT_BTN_URL = "nextBtnUrl";
    public static final String NEXT_BTN_RATIO = "nextBtnRatio";
    public static final String NEXT_BTN_ANIMATION_TYPE = "nextBtnAnimType";


    /**
     * Compare new JSON to old JSON, save the updated JSON to database, delete old assets if needed and download new assets.
     *
     * @param context
     * @param jsonObject
     */
    public static boolean parseFamilyPanelData(Context context, JSONObject jsonObject) {

        boolean result = false;
        if (jsonObject != null) {
            try {

                jsonObject.put(PanelView.TAG, FamilyPanelView.TAG);
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(PanelView.TAG);

                AssetUtil.loadAsset(context, oldData, jsonObject, BTN_OPENED_URL);
                AssetUtil.loadAsset(context, oldData, jsonObject, BTN_CLOSED_URL);

                result = AssetUtil.loadAsset(context, oldData, jsonObject, MAIN_ANIMATION_URL);
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, NEXT_BTN_URL);
                }

                if (result == true) {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(PanelView.TAG, jsonObject);
                }
            } catch (Exception ex) {
                result = false;
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(PanelView.TAG, "Error when trying to parse kidoz FamilyPanelView properties" + ex.getMessage());
            }
        }
        return result;
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus == true) {
            startHandlers();
        } else {
            stopHandlers();
        }
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);

        if (mOneItemView != null && mOneItemView.isEmpty() == false) {
            if (visibility == View.VISIBLE) {
                startHandlers();
            } else {
                stopHandlers();
            }
        }
    }

    private void stopHandlers() {
        mOneItemView.stopAutoScroll();
    }

    private void startHandlers() {
        stopHandlers();
        if (getIsPanelViewExpanded()) {
            mOneItemView.startAutoScroll();
        }
    }
}
