package com.kidoz.sdk.api.ui_views.one_item_view;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Point;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.utils.AssetUtil;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;

import java.util.ArrayList;
import java.util.HashMap;


public class OneItemView extends RelativeLayout {

    private static final float LOADING_PROGRESS_DEFAULT_RATIO = 0.13f;

    private final int AUTO_SCROLL_DELAY = 10000;
    private final String TAG = OneItemView.class.getSimpleName();
    private final int BUTTON_WIDTH = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 30);
    private AssetView mNextButton;
    private AssetView mGifView;
    private AutoScrollViewPager mViewPager;
    private ItemViewPagerAdapter mAdapter;
    private int mViewPagerWidth;
    private int mViewPagerHeight;
    private HashMap<String, Integer> mSponsoredContentDisplayed = new HashMap<String, Integer>();
    private ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;

    private String mNextBtnUrl;
    private String mAnimationUrl;
    private LoadingProgressView mLoadingProgressView;

    private String mWidgetType;
    private String mStyleId;

    public OneItemView(Context context, String widgetType, String styleId, String nextBtnUrl, String animationUrl) {
        super(context);
        mNextBtnUrl = nextBtnUrl;
        mAnimationUrl = animationUrl;
        mWidgetType = widgetType;
        mStyleId = styleId;
        initView();
    }

    private void initView() {
        float SCALE_FACTOR = ScreenUtils.getScaleFactor(getContext());
        mViewPagerWidth = (int) (517f * SCALE_FACTOR);
        mViewPagerHeight = (int) (402f * SCALE_FACTOR);

        initNextButton();
        initViewPager();
        initAnimationView();
        initLoadingProgressView();
    }

    private void initAnimationView() {
        mGifView = new AssetView(getContext());
        mGifView.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        mGifView.setScaleType(ImageView.ScaleType.FIT_END);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(mViewPagerWidth, mViewPagerHeight);
        addView(mGifView, params);

        mGifView.setOnTouchListener(new OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });

        loadAnimation();
    }

    private void initLoadingProgressView() {

        mLoadingProgressView = new LoadingProgressView(getContext());
        mLoadingProgressView.setVisibility(View.GONE);

        Point point = Utils.getScreenSize(getContext());
        int size = (int) (Math.min(point.x, point.y) * LOADING_PROGRESS_DEFAULT_RATIO);

        LinearLayout layout = new LinearLayout(getContext());
        layout.setGravity(Gravity.CENTER);
        layout.addView(mLoadingProgressView, new LinearLayout.LayoutParams(size, size));

        RelativeLayout.LayoutParams prParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        prParams.addRule(RelativeLayout.ALIGN_LEFT, mViewPager.getId());
        prParams.addRule(RelativeLayout.ALIGN_RIGHT, mViewPager.getId());
        addView(layout, prParams);
    }

    private void loadAnimation() {
        if (mGifView != null) {
            mGifView.loadAsset(AssetUtil.getAssetFile(getContext(), mAnimationUrl), null);
        }
    }

    private void initViewPager() {
        mViewPager = new AutoScrollViewPager(getContext());
        mViewPager.setInterval(AUTO_SCROLL_DELAY);
        mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {

                sendImpressionLog(position % mAdapter.getCount());

            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
        mViewPager.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        int margin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 6);
        mViewPager.setPageMargin(margin);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(mViewPagerWidth, mViewPagerHeight);
        addView(mViewPager, params);
    }

    private void initNextButton() {
        mNextButton = new AssetView(getContext());
        mNextButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mNextButton.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        addView(mNextButton, params);
        mNextButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mNextButton.setClickable(false);
                SdkAnimationsUtils.animateClick(mNextButton, new Animator.AnimatorListener() {
                    @Override
                    public void onAnimationStart(Animator animation) {

                    }

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        mNextButton.setClickable(true);
                        mViewPager.setCurrentItem(mViewPager.getCurrentItem() + 1);
                    }

                    @Override
                    public void onAnimationCancel(Animator animation) {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation) {

                    }
                });
            }
        });
        mNextButton.loadAsset(AssetUtil.getAssetFile(getContext(), mNextBtnUrl), null);
    }

    private void sendImpressionLog(int position) {
        ContentItem contentItem = mAdapter.getContentItem(position);
        if (contentItem != null && contentItem.isPromoted() == true) {
            if (mSponsoredContentDisplayed != null) {
                if (mSponsoredContentDisplayed.containsKey(contentItem.getId()) == false) {
                    mSponsoredContentDisplayed.put(contentItem.getId(), position);
                    EventManager.getInstance(getContext()).logSponsoredContentImpressionEvent(getContext(), mWidgetType, mStyleId, EventParameters.ACTION_IMPRESSION, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position, false);
                }
            }
        }
    }

    /**
     * Show or Hide loading progress view
     *
     * @param show
     */
    public void showLoadingProgressView(boolean show) {
        if (show) {
            mLoadingProgressView.setVisibility(View.VISIBLE);
            mLoadingProgressView.startLoadingAnimation();
        } else {
            mLoadingProgressView.stopLoadingAnimation();
            mLoadingProgressView.setVisibility(View.GONE);
        }
    }

    public void fixParams() {
        int margin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 6);

        RelativeLayout.LayoutParams viewPagerParams = new RelativeLayout.LayoutParams(mViewPagerWidth, mViewPagerHeight);
        RelativeLayout.LayoutParams nextButtonParams = new RelativeLayout.LayoutParams(BUTTON_WIDTH, (int) (mViewPagerHeight * 0.87f));
        RelativeLayout.LayoutParams animationParams = new RelativeLayout.LayoutParams(mViewPagerWidth, mViewPagerHeight);

        mViewPager.setLayoutParams(viewPagerParams);
        mNextButton.setLayoutParams(nextButtonParams);
        animationParams.rightMargin = -2 * margin;
        mGifView.setLayoutParams(animationParams);
        getLayoutParams().width = (mViewPagerWidth * 2) + BUTTON_WIDTH;
        getLayoutParams().height = mViewPagerHeight + (margin * 2);
        setPadding(0, margin, 0, margin);
        nextButtonParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        viewPagerParams.addRule(RelativeLayout.LEFT_OF, mNextButton.getId());
        animationParams.addRule(RelativeLayout.LEFT_OF, mViewPager.getId());
    }

    public void setViewPagerItemClickListener(ItemViewPagerAdapter.ViewPagerItemClickListener viewPagerItemClickListener) {
        mViewPagerItemClickListener = viewPagerItemClickListener;
    }

    public void setContent(ArrayList<ContentItem> content, PANEL_TYPE panelType) {
        mSponsoredContentDisplayed.clear();

        mAdapter = new ItemViewPagerAdapter(getContext());
        mAdapter.setViewPagerItemClickListener(mViewPagerItemClickListener);
        mAdapter.setContent(content, panelType);
        PagerAdapter wrappedAdapter = new InfinitePagerAdapter(mAdapter);
        mViewPager.setAdapter(wrappedAdapter);
        mViewPager.startAutoScroll(AUTO_SCROLL_DELAY);

        if (content != null && content.isEmpty() == false) {
            mViewPager.setCurrentItem(0);
            sendImpressionLog(0);
        }

        //SdkSoundManager.playSound(getContext(), SoundAssetsUtils.getSoundAssetFile(getContext(), SoundAssetsUtils.SOUND_ASSET_TYPE.FAMILY_PANEL_VIEW).getAbsolutePath());
    }

    public void startAutoScroll() {
        mViewPager.startAutoScroll(AUTO_SCROLL_DELAY);
    }

    public void stopAutoScroll() {
        mViewPager.stopAutoScroll();
    }

    public boolean isEmpty() {
        if (mAdapter == null) {
            return true;
        } else {
            return mAdapter.isAdapterEmpty();
        }
    }

    @Override
    protected void onDetachedFromWindow() {

        super.onDetachedFromWindow();
    }
}
