package com.kidoz.sdk.api.ui_views.kidoz_banner;

import android.content.Context;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.widget.RelativeLayout;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;

import org.json.JSONObject;

/**
 * Created by RonyBrosh on 12/13/2015.
 */
public class BaseBanner extends RelativeLayout {
    public static final String STYLE_ID = "style_id";

    protected KidozBannerListener mKidozBannerListener;
    protected JSONObject mProperties;
    protected boolean mIsWaitingToOpen = false;
    protected boolean mIsSmartBanner;
    protected boolean mIsOverrideUser;

    protected BannerViewPagerAdapter mAdapter;

    protected String mStyleId;
    private Utils.StaticHandler mStaticHandler;
    protected boolean mAllowClickHandling = true;

    public BaseBanner(Context context) {
        super(context);
    }

    public void setKidozBannerListener(KidozBannerListener kidozBannerListener) {
        mKidozBannerListener = kidozBannerListener;
    }

    public void setProperties(JSONObject properties) {
        mProperties = properties;
        if (mProperties != null) {
            mStyleId = mProperties.optString(STYLE_ID, null);
        }
        initView();
    }

    protected void initView() {

    }

    public void loadContent() {

    }

    protected boolean getIsCanOpen() {
        return false;
    }

    public void showBanner() {
        mIsWaitingToOpen = true;

    }

    protected void sendActionWidgetViewImpression() {
        EventManager.getInstance(getContext()).logEvent(getContext(), WidgetType.WIDGET_TYPE_BANNER.getStringValue(), mStyleId, EventManager.LOG_CRITICAL_LEVEL, null, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, EventParameters.LABEL_BANNER_VIEW, false);
    }

    public void hideBanner() {
        setVisibility(View.GONE);
        //postInvalidate();
    }

    protected void autoOpen() {

    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);

        if (KidozSDK.isInitialised()) {
            if (!isInEditMode() && (visibility == View.GONE || visibility == View.INVISIBLE)) {
                EventManager.getInstance(getContext()).startEventsSync(getContext());
            }
        }

        mAllowClickHandling = true;
    }

    public void setIsSmartBanner(boolean isSmartBanner) {
        mIsSmartBanner = isSmartBanner;
        // If user set banner as smart server won't override it
        // If the user didn't set the banner as smart the server can override it.
        mIsOverrideUser = !mIsSmartBanner;
    }

    @Override
    protected void onDetachedFromWindow() {

        getMyHandlerInstance().removeCallbacksAndMessages(null);

        super.onDetachedFromWindow();
    }

    protected Utils.StaticHandler getMyHandlerInstance() {
        if (mStaticHandler == null) {
            mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper()) {
                @Override
                public void handleMessage(Message message) {
                    // This is where you do your work in the UI thread.
                    // Your worker tells you in the message what to do.
                }
            };
        }
        return mStaticHandler;
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if(hasWindowFocus) {
            mAllowClickHandling = true;
        }else {
            mAllowClickHandling = false;
        }
    }
}
