package com.kidoz.sdk.api.ui_views.flexi_view;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.media.ThumbnailUtils;

import com.squareup.imagelib.Transformation;

/**
 * Created by Eugine on 1/19/2016.
 */
public class RoundedCornerTransformation implements Transformation {

    private int mMargin = 0;
    private int mBorder = 0;
    private int mRoundingCorners = 0;
    private int mContainerSize = 0;

    private String mBorderColor;
    private String mFillColor;

    public RoundedCornerTransformation(int borderWith, String borderColor, String fillColor, int roundedRadius, int containerSize) {
        mBorder = borderWith;
        mBorderColor = borderColor;
        mRoundingCorners = roundedRadius;
        mContainerSize = containerSize;
        mFillColor = fillColor;
    }

    @Override
    public Bitmap transform(Bitmap source) {

        Bitmap squaredBitmap = ThumbnailUtils.extractThumbnail(source, mContainerSize, mContainerSize);
        source.recycle();

        Bitmap bitmap = Bitmap.createBitmap(squaredBitmap.getWidth(), squaredBitmap.getHeight(), squaredBitmap.getConfig());

        Paint borderPaint = new Paint();
        try {
            borderPaint.setColor(Color.parseColor(mFillColor));
        } catch (Exception e) {
            borderPaint.setColor(Color.WHITE);
        }
        borderPaint.setStyle(Paint.Style.FILL);
        borderPaint.setAntiAlias(true);
        borderPaint.setFilterBitmap(true);

        Canvas canvas = new Canvas(bitmap);
        RectF rectF = new RectF(mMargin + mBorder, mMargin + mBorder, squaredBitmap.getWidth() - mMargin - mBorder, squaredBitmap.getHeight() - mMargin - mBorder);

        // Draw fill paint bg
        canvas.drawRoundRect(rectF, mRoundingCorners, mRoundingCorners, borderPaint);

        Paint paint = new Paint();
        BitmapShader shader = new BitmapShader(squaredBitmap, BitmapShader.TileMode.CLAMP, BitmapShader.TileMode.CLAMP);
        paint.setShader(shader);
        paint.setFilterBitmap(true);
        paint.setAntiAlias(true);

        // Draw image
        canvas.drawRoundRect(rectF, mRoundingCorners, mRoundingCorners, paint);

        if (mBorder != 0) {
            // Draw stroke
            borderPaint.setStyle(Paint.Style.STROKE);
            borderPaint.setStrokeWidth(mBorder);
            try {
                borderPaint.setColor(Color.parseColor(mBorderColor));
            } catch (Exception e) {
                borderPaint.setColor(Color.WHITE);
            }
            canvas.drawRoundRect(rectF, mRoundingCorners, mRoundingCorners, borderPaint);
        }

        if (squaredBitmap.isRecycled() == false) {
            squaredBitmap.recycle();
        }

        if (source.isRecycled() == false) {
            source.recycle();
        }

        return bitmap;

    }

    @Override
    public String key() {
        return "roundedFlexiTransform";
    }
}
