package com.kidoz.sdk.api.ui_views.flexi_view;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.FlexiView;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.AssetUtil;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import com.squareup.imagelib.Callback;
import com.squareup.imagelib.Transformation;

import org.json.JSONObject;


public class MovableView extends RelativeLayout {

    private static final String TAG = MovableView.class.getSimpleName();

    private static final float SHADOW_LAYER__OVAL_OFFSET = 1.235f;
    private static final float SHADOW_LAYER_RECTANGLE_OFFSET = 1.20f;


    private static final float FLEXI_DEFAULT_THUMB_RATIO = 0.25f;
    private static final float CLOSE_BTN_RATIO = 0.32f;
    private static final float PARENTAL_LOCK_RATIO = 0.32f;


    private JSONObject mPropertiesObject;
    private ImageView mMainThumbnailView;
    private ImageView mShadowLayerView;
    private AssetView mAnimateView;
    private AssetView mLockIconView;
    private AssetView mCloseIconView;
    private IMovableActionListener mActionListener;

    public Transformation mImageTransformation = null;
    private boolean mIsCircle;
    private float mBrderWidth;
    private float mCornersRadius;
    private String mBorderColor;
    private String mFillColor;

    private GradientDrawable mShadowBgDrawable;

    // Used for synchronization of loading assets sequence
    private final Object mSyncObject = new Object();

    public MovableView(Context context, JSONObject jsonObject, IMovableActionListener actionListener) {
        super(context);
        mActionListener = actionListener;
        mPropertiesObject = jsonObject;

        setVisibility(View.INVISIBLE);
        initView();
    }

    /**
     * Initiate movable flexi view
     */
    private void initView() {
        if (mPropertiesObject != null) {

            // Load image properties
            mIsCircle = mPropertiesObject.optInt(FlexiView.IS_CIRCLE, 1) == 1 ? true : false;
            mBrderWidth = (float) mPropertiesObject.optDouble(FlexiView.BORDER_WIDTH, 0);
            mCornersRadius = (float) mPropertiesObject.optDouble(FlexiView.CORNER_ROUND_RADIUS, 0);
            mBorderColor = mPropertiesObject.optString(FlexiView.BORDER_COLOR, "#ffffff");
            mFillColor = mPropertiesObject.optString(FlexiView.FILL_COLOR, "#ffffff");

            Point point = Utils.getScreenSize(getContext());

            // Calculate main content thum size relative to screen width
            float thumbRatio = (float) mPropertiesObject.optDouble(FlexiView.CONTENT_THUMB_RATIO, FLEXI_DEFAULT_THUMB_RATIO);
            int mainThumbSize = (int) (Math.min(point.x, point.y) * thumbRatio);

            initMainThumbView(mainThumbSize);
            if (mIsCircle == false) {
                initBottomShadowLayerView(mainThumbSize);
            } else {
                initBottomShadowLayerView(mainThumbSize);
            }

            // Calculate gif animated overlay relative to content thumb
            final int animViewSize = (int) (mainThumbSize * mPropertiesObject.optDouble(FlexiView.ANIM_OVERLAY_RATIO, 1f));
            initAnimatedView(animViewSize);

            // Calculate the side of lock and parental button and their offset
            int offset = 0;
            int diff = (animViewSize - mainThumbSize) / 2;

            int parentalSize = (int) (mainThumbSize * PARENTAL_LOCK_RATIO);
            if (diff > parentalSize / 2) {
                offset = diff - parentalSize / 2;
            }
            initParentalLockView(parentalSize, offset);

            int closeSize = (int) (mainThumbSize * CLOSE_BTN_RATIO);
            if (diff > closeSize / 2) {
                offset = diff - closeSize / 2;
            }
            initCloseView(closeSize, offset);

            // Generate shadow drawable
            generateAndSetProperShadowBackground();
        }
    }

    /**
     * Generate and set proper shadow drawable layer
     */
    private void generateAndSetProperShadowBackground() {

        mShadowBgDrawable = new GradientDrawable();
        RelativeLayout.LayoutParams params = (LayoutParams) mShadowLayerView.getLayoutParams();
        if (mIsCircle) {
            mShadowBgDrawable.setShape(GradientDrawable.OVAL);
            params.setMargins(-Utils.dpTOpx(getContext(), SHADOW_LAYER__OVAL_OFFSET), 0, 0, -Utils.dpTOpx(getContext(), SHADOW_LAYER__OVAL_OFFSET));
        } else {
            mShadowBgDrawable.setShape(GradientDrawable.RECTANGLE);
            mShadowBgDrawable.setCornerRadius(Utils.dpTOpx(getContext(), mCornersRadius + mBrderWidth / 2.5f));
            params.setMargins(
                    Utils.dpTOpx(getContext(), mBrderWidth) / 2 - Utils.dpTOpx(getContext(), SHADOW_LAYER_RECTANGLE_OFFSET)
                    , Utils.dpTOpx(getContext(), mBrderWidth) / 2 + Utils.dpTOpx(getContext(), 2f)
                    , Utils.dpTOpx(getContext(), mBrderWidth) / 2 + Utils.dpTOpx(getContext(), 2f)
                    , Utils.dpTOpx(getContext(), mBrderWidth) / 2 - Utils.dpTOpx(getContext(), SHADOW_LAYER_RECTANGLE_OFFSET));
        }

        mShadowBgDrawable.setDither(true);
        mShadowBgDrawable.mutate();
        mShadowBgDrawable.setColor(Color.BLACK);
        mShadowBgDrawable.setAlpha(126);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            mShadowLayerView.setBackground(mShadowBgDrawable);
        } else {
            mShadowLayerView.setBackgroundDrawable(mShadowBgDrawable);
        }
    }


    /**
     * Init main thumb view
     */
    private void initMainThumbView(int mainSize) {
        mMainThumbnailView = new ImageView(getContext());
        mMainThumbnailView.setId(Utils.generateViewId());
        mMainThumbnailView.setScaleType(ImageView.ScaleType.FIT_XY);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(mainSize, mainSize);
        params.addRule(RelativeLayout.CENTER_IN_PARENT);
        addView(mMainThumbnailView, params);
    }

    /**
     * Init main thumb view
     */
    private void initBottomShadowLayerView(int mainSize) {
        mShadowLayerView = new ImageView(getContext());
        mShadowLayerView.setId(Utils.generateViewId());
        mShadowLayerView.setScaleType(ImageView.ScaleType.FIT_XY);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(mainSize, mainSize);
        params.addRule(RelativeLayout.ALIGN_RIGHT, mMainThumbnailView.getId());
        params.addRule(RelativeLayout.ALIGN_TOP, mMainThumbnailView.getId());
        params.addRule(RelativeLayout.ALIGN_BOTTOM, mMainThumbnailView.getId());
        params.addRule(RelativeLayout.ALIGN_LEFT, mMainThumbnailView.getId());
        addView(mShadowLayerView, 0, params);
    }


    /**
     * Init animate gi overlay view
     */
    private void initAnimatedView(int size) {

        mAnimateView = new AssetView(getContext());
        mAnimateView.setScaleType(ImageView.ScaleType.FIT_XY);
        mAnimateView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
        params.addRule(RelativeLayout.CENTER_IN_PARENT);
        addView(mAnimateView, params);
    }

    /**
     * Init close button view
     */
    private void initCloseView(int size, int fixOffset) {
        mCloseIconView = new AssetView(getContext());
        mCloseIconView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
        params.addRule(RelativeLayout.ALIGN_TOP, mAnimateView.getId());
        params.addRule(RelativeLayout.ALIGN_END, mAnimateView.getId());
        params.setMargins(0, fixOffset, fixOffset, 0);
        addView(mCloseIconView, params);

        mCloseIconView.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 95, new GenAnimator.ViewAnimationListener() {
                    @Override
                    public void onAnimationEnd() {
                        if (mActionListener != null) {
                            mActionListener.onCloseClick();
                        }
                    }

                    @Override
                    public void onAnimationStart() {

                    }
                });
            }
        });
    }

    /**
     * Init parental button view
     */
    private void initParentalLockView(int size, int fixOffset) {

        mLockIconView = new AssetView(getContext());
        mLockIconView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);

        params.addRule(RelativeLayout.ALIGN_BOTTOM, mAnimateView.getId());
        params.addRule(RelativeLayout.ALIGN_END, mAnimateView.getId());
        params.setMargins(0, 0, fixOffset, fixOffset);
        addView(mLockIconView, params);

        mLockIconView.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 95, new GenAnimator.ViewAnimationListener() {
                    @Override
                    public void onAnimationEnd() {
                        if (ParentalLockDialog.getIsCanShowDialog(getContext()) == true) {
                            int[] popLocation = new int[2];
                            popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                            popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                            ParentalLockDialog parentalLockDialog = new ParentalLockDialog(getContext(), false, popLocation);
                            parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                                @Override
                                public void onDismiss(DialogInterface dialog) {
                                    //Refresh the parental lock icon
                                    updateLockIcon();
                                }
                            });
                            parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener() {
                                @Override
                                public void onPasswordEntered(boolean isPasswordCorrect) {
                                    updateLockIcon();
                                }
                            });
                            parentalLockDialog.show();
                        }
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
    }

    /**
     * Load secondary assets (images) close icon.parental lock, gif overlay..
     */
    public void loadSecondaryAssets(final IMovableAssetReadyListener listener) {
        String url = null;
        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
        if (isLockActive) {
            url = mPropertiesObject.optString(FlexiView.LOCK_CLOSE_BUTTON);
        } else {
            url = mPropertiesObject.optString(FlexiView.LOCK_OPEN_BUTTON);
        }
        mLockIconView.loadAsset(AssetUtil.getAssetFile(getContext(), url), new AssetView.IOnAssetLoadedListener() {
            @Override
            public void onAssetLoaded(boolean successful) {
                synchronized (mSyncObject) {
                    if (mAnimateView.getIsAssetLoaded() && mLockIconView.getIsAssetLoaded() && mCloseIconView.getIsAssetLoaded()) {
                        listener.onAssetsReady();
                    }
                }
            }
        });

        mCloseIconView.loadAsset(AssetUtil.getAssetFile(getContext(), mPropertiesObject.optString(FlexiView.CLOSE_BTN)), new AssetView.IOnAssetLoadedListener() {
            @Override
            public void onAssetLoaded(boolean successful) {
                synchronized (mSyncObject) {
                    if (mAnimateView.getIsAssetLoaded() && mLockIconView.getIsAssetLoaded() && mCloseIconView.getIsAssetLoaded()) {
                        listener.onAssetsReady();
                    }
                }
            }
        });

        mAnimateView.loadAsset(AssetUtil.getAssetFile(getContext(), mPropertiesObject.optString(FlexiView.ANIMATION_OVERLAY)), new AssetView.IOnAssetLoadedListener() {
            @Override
            public void onAssetLoaded(boolean successful) {
                synchronized (mSyncObject) {
                    if (mAnimateView.getIsAssetLoaded() && mLockIconView.getIsAssetLoaded() && mCloseIconView.getIsAssetLoaded()) {
                        listener.onAssetsReady();
                    }
                }
            }
        });
    }

    /**
     * Load main content thumbnail
     *
     * @param url
     * @param listener success listener
     */
    public void loadMainAsset(String url, final IMovableAssetReadyListener listener) {

        if (mImageTransformation == null) {
            if (mIsCircle) {
                mImageTransformation = new CircleTransformation(Utils.dpTOpx(getContext(), mBrderWidth), mBorderColor, mFillColor, mMainThumbnailView.getWidth());
            } else {
                mImageTransformation = new RoundedCornerTransformation(Utils.dpTOpx(getContext(), mBrderWidth), mBorderColor, mFillColor, Utils.dpTOpx(getContext(), mCornersRadius), mMainThumbnailView.getWidth());
            }
        }

        PicassoOk.getPicasso(getContext())
                .load(url)
                .transform(mImageTransformation)
                .into(mMainThumbnailView, new Callback() {
                    @Override
                    public void onSuccess() {
                        listener.onAssetsReady();
                    }

                    @Override
                    public void onError() {

                    }
                });
    }

    /**
     * Update lock icon image stateLoad main content thumbnail
     */
    private void updateLockIcon() {
        try {
            boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
            if (isLockActive == true) {
                mLockIconView.loadAsset(AssetUtil.getAssetFile(getContext(), mPropertiesObject.optString(FlexiView.LOCK_CLOSE_BUTTON)), new AssetView.IOnAssetLoadedListener() {
                    @Override
                    public void onAssetLoaded(boolean successfull) {

                    }
                });
            } else {
                mLockIconView.loadAsset(AssetUtil.getAssetFile(getContext(), mPropertiesObject.optString(FlexiView.LOCK_OPEN_BUTTON)), new AssetView.IOnAssetLoadedListener() {
                    @Override
                    public void onAssetLoaded(boolean successfull) {

                    }
                });
            }
        } catch (Exception ex) {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to load parental lock image: " + ex.getMessage());
        }
    }


    public interface IMovableActionListener {
        void onCloseClick();
    }

    public interface IMovableAssetReadyListener {
        void onAssetsReady();
    }


    public void playOrStopTheGifAnimationIfExists(boolean isToPlay) {
        if (mAnimateView != null) {
            if (isToPlay) {
                mAnimateView.startGifAnim();
            } else {
                mAnimateView.pauseGifAnim();
            }
        }
    }


    /**
     * Show or hide the movable view close btn
     */
    public void showCloseBtn(boolean show) {
        if (mCloseIconView != null) {
            if (show) {
                mCloseIconView.setVisibility(View.VISIBLE);
            } else {
                mCloseIconView.setVisibility(View.GONE);
            }
        }
    }
}
