package com.kidoz.sdk.api.ui_views.family_feed;

import android.animation.Animator;
import android.content.Context;
import android.content.res.Configuration;
import android.support.v4.view.PagerAdapter;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.sdk.api.general.assets_handling.SoundAssetsUtils;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SdkSoundManager;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.picasso_related.RoundedTransformation;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.ContentItemView;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;

import java.util.ArrayList;

/**
 * Created by roni on 11/18/2015.
 */
public class FamilyFeedViewPagerAdapter extends PagerAdapter
{
    private ArrayList<ContentItem> mContent;
    private ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;
    private boolean mIsCanClick;
    private boolean mIsImageCropped;
    private int mContentTypeThubmnailSize;

    public FamilyFeedViewPagerAdapter(Context context,boolean isImageCropped)
    {
        mContent = new ArrayList<>();
        mIsCanClick = true;
        mIsImageCropped = isImageCropped;
    }

    public void setViewPagerItemClickListener(ItemViewPagerAdapter.ViewPagerItemClickListener viewPagerItemClickListener)
    {
        mViewPagerItemClickListener = viewPagerItemClickListener;
    }

    @Override
    public int getCount()
    {
        int result = 0;
        if (mContent != null)
        {
            result = mContent.size();
        }
        return result;
    }

    public void setContent(ArrayList<ContentItem> content)
    {
        mContent = content;
        notifyDataSetChanged();
    }

    @Override
    public Object instantiateItem(ViewGroup container, final int position)
    {
        final ContentItem contentItem = mContent.get(position);
        ContentItemView convertView = new ContentItemView(container.getContext());
        convertView.disableCardElevation();
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(container.getWidth(), container.getHeight());
        convertView.setLayoutParams(params);
        convertView.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View view)
            {
                if (mIsCanClick == true)
                {
                    SdkSoundManager.playSound(view.getContext(), SoundAssetsUtils.getSoundAssetFile(view.getContext(), SoundAssetsUtils.SOUND_ASSET_TYPE.ITEM_CLICK).getAbsolutePath());
                    mIsCanClick = false;
                    SdkAnimationsUtils.animateClick(view, new Animator.AnimatorListener()
                    {
                        @Override
                        public void onAnimationStart(Animator animation)
                        {
                        }

                        @Override
                        public void onAnimationEnd(Animator animation)
                        {
                            mViewPagerItemClickListener.onClickEnd(contentItem, position);
                            mIsCanClick = true;
                        }

                        @Override
                        public void onAnimationCancel(Animator animation)
                        {

                        }

                        @Override
                        public void onAnimationRepeat(Animator animation)
                        {

                        }
                    }, 50, 100);
                }
            }
        });
        if (contentItem != null)
        {
            convertView.getNameTextView().setText(contentItem.getName());
            convertView.getNameTextView().setLines(1);
            fixTextSize(convertView.getNameTextView());

            setCorrectItemSize(convertView, contentItem);
            loadSecondaryThumbnail(convertView, contentItem);
        }
        container.addView(convertView);
        convertView.setTag("BannerThumbnailNumber_" + String.valueOf(position));
        return convertView;
    }

    private void setCorrectItemSize(final ContentItemView contentItemView, final ContentItem contentItem)
    {
        RelativeLayout.LayoutParams relParams = (RelativeLayout.LayoutParams) contentItemView.getMainThumbView().getLayoutParams();
        relParams.height = (int) (contentItemView.getLayoutParams().height * 0.8f);
        if (contentItem != null)
        {
            loadMainThumbnail(contentItemView, contentItem, contentItemView.getLayoutParams().width, relParams.height);
        }
    }

    private void loadMainThumbnail(final ContentItemView viewHolder, final ContentItem contentItem, int widht, int height)
    {
        if (contentItem != null)
        {
            int roundedCorners = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(viewHolder.getContext(), ContentItemView.DEFAULT_SHADOW_ELEVATION_RADIUS_DP);
            viewHolder.getMainThumbView().setImageBitmap(null);
            viewHolder.getNameTextView().setTextColor(contentItem.getPaliteTextColor());
            viewHolder.setItemBgColor(contentItem.getPaliteBgColor());
            mContentTypeThubmnailSize = (int) (widht * 0.2f);

            if (contentItem.getThumb() != null && !contentItem.getThumb().equals("") && widht > 0 && height > 0)
            {
                PicassoOk.getPicasso(viewHolder.getContext()).load(contentItem.getThumb()).transform(new RoundedTransformation(roundedCorners, 0)).resize(widht, height).centerCrop().noFade().into(viewHolder.getMainThumbView());
                viewHolder.setPromotedIndication(contentItem, widht, height, roundedCorners);
            }
        }
    }

    private void loadSecondaryThumbnail(ContentItemView viewHolder, final ContentItem contentItem)
    {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) viewHolder.getSecondaryThumbView().getLayoutParams();
        params.height = mContentTypeThubmnailSize;
        params.width = mContentTypeThubmnailSize;
        params.rightMargin = (int) (mContentTypeThubmnailSize * 0.22);
        params.bottomMargin = (int) (mContentTypeThubmnailSize * 0.5) * -1;
        if (contentItem.getSecThumb() != null && !contentItem.getSecThumb().equals(""))
        {
            PicassoOk.getPicasso(viewHolder.getContext()).load(contentItem.getSecThumb()).into(viewHolder.getSecondaryThumbView());
        }
    }

    @Override
    public boolean isViewFromObject(View view, Object object)
    {
        return view == object;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object)
    {
        container.removeView((ContentItemView) object);
    }

    public ContentItem getContentItem(int position)
    {
        ContentItem result = null;
        if (mContent != null && mContent.size() > position)
        {
            result = mContent.get(position);
        }
        return result;
    }

    @Override
    public int getItemPosition(Object object)
    {
        return POSITION_NONE;
    }

    private void fixTextSize(TextView textView)
    {
        textView.getLayoutParams().height = RelativeLayout.LayoutParams.MATCH_PARENT;
        textView.setPadding(0, 0, 0, 0);
        if (ScreenUtils.getIsTablet(textView.getContext()) == false)
        {
            if (textView.getContext().getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT)
            {
                textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, ContentItemView.getNameTextSizeByScreenLayout(textView.getContext()) * 0.9f);
            }
            else
            {
                textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, ContentItemView.getNameTextSizeByScreenLayout(textView.getContext()));
            }
        }
    }
}
