package com.kidoz.sdk.api.ui_views.custom_drawables;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;

import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;

/**
 * Created by Eugine on 11/5/2015.
 */
public class DefaultPanelDrawable extends Drawable {

    public enum PanelDrawableType {
        CLOSED_VIEW, OPENED_VIEW
    }

    private Paint mPaint;
    private int mWidth;
    private int mHeight;

    private RectF mWhiteBackgroundRoundedRectF;
    private RectF mWhiteBackgroundRectF;
    private int mBaseColor;
    private PANEL_TYPE mPanelType;
    private PanelDrawableType mDrawableType;

    public DefaultPanelDrawable(Context context, PANEL_TYPE panel_type, PanelDrawableType panelDrawableType) {
        float scaleFactor = ScreenUtils.getScaleFactor(context);
        mWidth = 142;
        mHeight = 142;

        mWidth *= scaleFactor;
        mHeight *= scaleFactor;

        mBaseColor = Color.parseColor("#ffffff");
        mPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        mPaint.setColor(mBaseColor);
        mPaint.setDither(true);

        mPanelType = panel_type;

        mDrawableType = panelDrawableType;
        initRectF();
    }

    @Override
    public void setAlpha(int alpha) {
        mPaint.setAlpha(alpha);
    }

    @Override
    public void setColorFilter(ColorFilter cf) {
        mPaint.setColorFilter(cf);
    }

    @Override
    public int getOpacity() {
        return PixelFormat.TRANSLUCENT;
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);

        mWidth = bounds.width();
        mHeight = bounds.height();

        initRectF();
    }

    private void initRectF() {
        float left;
        float top;
        float right;
        float bottom;


        switch (mPanelType) {
            case LEFT: {
                left = 0f;
                top = 0f;
                right = mWidth / 2;
                bottom = mHeight;
                mWhiteBackgroundRectF = new RectF(left, top, right, bottom);
                break;
            }
            case TOP: {
                left = 0f;
                top = 0f;
                right = mWidth;
                bottom = mHeight / 2;
                mWhiteBackgroundRectF = new RectF(left, top, right, bottom);
                break;
            }
            case RIGHT: {
                left = mWidth / 2;
                top = 0f;
                right = mWidth;
                bottom = mHeight;
                mWhiteBackgroundRectF = new RectF(left, top, right, bottom);
                break;
            }
            case BOTTOM: {
                left = 0f;
                top = mHeight / 2;
                right = mWidth;
                bottom = mHeight;
                mWhiteBackgroundRectF = new RectF(left, top, right, bottom);
                break;
            }
        }
        left = 0f;
        top = 0f;
        right = mWidth;
        bottom = mHeight;
        mWhiteBackgroundRoundedRectF = new RectF(left, top, right, bottom);
    }

    @Override
    public void draw(Canvas canvas) {
        // Draw background shape
        float centerX = (71f / 142f) * mWidth;
        float centerY = (71f / 142f) * mHeight;

        mPaint.setColor(mBaseColor);
        float radius = (20f / 142f) * mWidth;
        canvas.drawRect(mWhiteBackgroundRectF, mPaint);
        canvas.drawRoundRect(mWhiteBackgroundRoundedRectF, radius, radius, mPaint);

        // Draw the + shape
        switch (mDrawableType) {
            case CLOSED_VIEW: {
                mPaint.setColor(Color.parseColor("#39b0c5"));
                float left = (62f / 142f) * mWidth;
                float top = (28f / 142f) * mHeight;
                float right = (80f / 142f) * mWidth;
                float bottom = (114f / 142f) * mHeight;
                canvas.drawRect(left, top, right, bottom, mPaint);
                int saveCount = canvas.save();
                canvas.rotate(90f, centerX, centerY);
                canvas.drawRect(left, top, right, bottom, mPaint);
                canvas.restoreToCount(saveCount);
                break;
            }

            case OPENED_VIEW: {
                // Draw the + shape
                mPaint.setColor(Color.parseColor("#39b0c5"));
                float left = (62f / 142f) * mWidth;
                float top = (28f / 142f) * mHeight;
                float right = (80f / 142f) * mWidth;
                float bottom = (114f / 142f) * mHeight;

                int saveCount = canvas.save();
                canvas.rotate(45f, centerX, centerY);
                canvas.drawRect(left, top, right, bottom, mPaint);
                canvas.restoreToCount(saveCount);

                saveCount = canvas.save();
                canvas.rotate(-45f, centerX, centerY);
                canvas.drawRect(left, top, right, bottom, mPaint);
                canvas.restoreToCount(saveCount);
                break;
            }
        }
    }

    public void setPanelType(PANEL_TYPE panelType) {
        mPanelType = panelType;
        initRectF();
    }

    public void setBaseColor(int baseColor) {
        mBaseColor = baseColor;
    }
}
