package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.widget.ImageView;

import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;

import java.io.File;

/**
 * Created by roni on 9/30/2015.
 */
public class OnBoardingCloud extends ImageView {
    private final String TAG = ExitButton.class.getSimpleName();

    private File mImageFile;
    private int mWidth;
    private int mHeight;
    private Paint mWhitePaint;
    private Paint mTextPaint;

    public OnBoardingCloud(Context context, File imageFile) {
        super(context);
        mImageFile = imageFile;
        setScaleType(ScaleType.FIT_XY);
        initView();
    }

    private void initView() {
        initImageParameters();
        initPaints();
    }

    private void loadImage() {
        if (mImageFile.exists() == true) {
            if (getDrawable() == null) {
                if (mImageFile != null) {
                    PicassoOk.getPicasso(getContext()).load(mImageFile).into(this);
                }
            }
        }
    }

    private void initImageParameters() {
        float scaleFactor = ScreenUtils.getScaleFactor(getContext());
        mWidth = 852;
        mHeight = 801;
        int mAnimationType = 1;
        if (mImageFile != null && mImageFile.exists() == true) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(mImageFile.getAbsolutePath(), options);

            mWidth = options.outWidth;
            mHeight = options.outHeight;
            // String animationType = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ImageAssetsUtils.ON_BOARDING_BACKGROUND_ANIMATION_TYPE, "1", Context.MODE_PRIVATE);
        }
        mWidth *= scaleFactor;
        mHeight *= scaleFactor;
    }

    private void initPaints() {
        mWhitePaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mWhitePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        mWhitePaint.setColor(Color.parseColor("#ffffff"));

        mTextPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mTextPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        mTextPaint.setColor(Color.parseColor("#04a0e1"));
        mTextPaint.setTextSize((50f / 801f) * mHeight);
        setLayerType(LAYER_TYPE_SOFTWARE, mTextPaint);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        setMeasuredDimension(mWidth, mHeight);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (mImageFile.exists() == false) {

            float radius = (184.24f / 852f) * mWidth;
            float centerX = (471.61f / 852f) * mWidth;
            float centerY = (618.44f / 801f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

            radius = (184.24f / 852f) * mWidth;
            centerX = (381f / 852f) * mWidth;
            centerY = (182.5f / 801f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

            radius = (184.24f / 852f) * mWidth;
            centerX = (184f / 852f) * mWidth;
            centerY = (348.5f / 801f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

            radius = (184.24f / 852f) * mWidth;
            centerX = (242f / 852f) * mWidth;
            centerY = (484.5f / 801f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

            radius = (184.24f / 852f) * mWidth;
            centerX = (668f / 852f) * mWidth;
            centerY = (456.5f / 801f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

            radius = (184.24f / 852f) * mWidth;
            centerX = (656f / 852f) * mWidth;
            centerY = (301.5f / 801f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

            radius = (184.24f / 852f) * mWidth;
            centerX = (529f / 852f) * mWidth;
            centerY = (365.5f / 801f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

            String text = "Surprise!";
            drawCenter(canvas, mTextPaint, text);
        } else {
            loadImage();
        }
    }

    private void drawCenter(Canvas canvas, Paint paint, String text) {
        int cHeight = canvas.getClipBounds().height();
        int cWidth = canvas.getClipBounds().width();
        Rect r = new Rect();
        paint.setTextAlign(Paint.Align.LEFT);
        paint.getTextBounds(text, 0, text.length(), r);
        float x = cWidth / 2f - r.width() / 2f - r.left;
        float y = cHeight / 2f + r.height() / 2f - r.bottom;
        canvas.drawText(text, x, y, paint);
    }
}
