package com.kidoz.sdk.api.structure;

import android.graphics.Color;

import com.kidoz.sdk.api.general.enums.ContentType;

import org.json.JSONArray;

import java.io.Serializable;
import java.util.HashMap;


public class ContentItem implements Serializable
{

    private static final String DATA_KEY = "data";
    private static final String TITLE_KEY = "title";
    private static final String THUMB_KEY = "thumb";
    private static final String SEC_THUMB_KEY = "sec_thumb";
    private static final String ID_KEY = "id";
    private static final String PROMOTED_KEY = "promoted";
    private static final String LANG_KEY = "lang";
    private static final String CONTENT_TYPE_KEY = "type";
    private static final String ADVERTISER_KEY = "advertiser_id";
    private static final String BG_COLOR_KEY = "bg_color";
    private static final String IMAGE_RATIO_KEY = "img_ratio";

    private String mId;
    private String mThumb;
    public String mSecThumb;
    private ContentType mContentType;
    private String mData;
    private String mTiltle;
    private String mLang;
    private boolean mPromoted;
    private String mAdvertiserID;
    private int mRealViewIndex;


    // Inner variables
    private int[] mMainThumbSize;
    public float mMainThumbImageRation = 0.5f;
    private int mPalliteBgColor = Color.WHITE;
    private int mPalliteTextColor = Color.parseColor("#484848");

    public ContentItem()
    {
    }

    public ContentItem(JSONArray jsonArray, HashMap<String, Integer> keysMap)
    {
        if (jsonArray != null)
        {
            // Get item Id
            if (keysMap.containsKey(ID_KEY))
            {
                mId = jsonArray.optString(keysMap.get(ID_KEY), "");
            }

            // Get thumb url
            if (keysMap.containsKey(THUMB_KEY))
            {
                mThumb = jsonArray.optString(keysMap.get(THUMB_KEY), "");
                mThumb = com.kidoz.sdk.api.general.utils.Utils.fixUrlLink(mThumb);
                // getThumbSize();
            }

            // Get thumb url
            if (keysMap.containsKey(SEC_THUMB_KEY))
            {
                mSecThumb = jsonArray.optString(keysMap.get(SEC_THUMB_KEY), "");
                mSecThumb = com.kidoz.sdk.api.general.utils.Utils.fixUrlLink(mSecThumb);
            }

            // Get content type
            if (keysMap.containsKey(CONTENT_TYPE_KEY))
            {
                try
                {
                    int val = jsonArray.optInt(keysMap.get(CONTENT_TYPE_KEY), -1);
                    mContentType = ContentType.getTypeByValue(val);


                }
                catch (Exception e)
                {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog("Error parsing single content item Action : \n" + e.getMessage());
                    mContentType = ContentType.NONE;
                }
            }

            // Get data
            if (keysMap.containsKey(DATA_KEY))
            {
                mData = jsonArray.optString(keysMap.get(DATA_KEY), "");
            }

            // Get item title
            if (keysMap.containsKey(TITLE_KEY))
            {
                mTiltle = jsonArray.optString(keysMap.get(TITLE_KEY), "");
            }

            // Get item language
            if (keysMap.containsKey(LANG_KEY))
            {
                mLang = jsonArray.optString(keysMap.get(LANG_KEY), "");
            }

            // Get Advertiser id
            if (keysMap.containsKey(ADVERTISER_KEY))
            {
                mAdvertiserID = jsonArray.optString(keysMap.get(ADVERTISER_KEY), "0");
            }

            // Get id item promoted
            if (keysMap.containsKey(PROMOTED_KEY))
            {
                int val = jsonArray.optInt(keysMap.get(PROMOTED_KEY), 0);
                mPromoted = val == 1;
            }

            // Get background color
            if (keysMap.containsKey(BG_COLOR_KEY))
            {
                String color = jsonArray.optString(keysMap.get(BG_COLOR_KEY), "#ffffff");
                if (color != null)
                {
                    try
                    {
                        mPalliteBgColor = Color.parseColor(color);
                    }
                    catch (Exception e)
                    {
                    }
                }
            }

            if (mPalliteBgColor == Color.WHITE)
            {
                if (mContentType != null)
                {
                    try
                    {
                        if (mContentType == ContentType.EXTERNAL_BROWSER_URL || mContentType == ContentType.WEB_GAME_URL)
                        {
                            mPalliteBgColor = Color.parseColor("#b0d63a");
                        }
                        else if (mContentType == ContentType.WEBSITE_URL)
                        {
                            mPalliteBgColor = Color.parseColor("#f8a850");
                        }
                        else if (mContentType == ContentType.GOOGLE_PLAY_APPLICATION || mContentType == ContentType.PROMOTED_PLAY_APPLICATION)
                        {
                            mPalliteBgColor = Color.parseColor("#4aaed3");
                        }
                        else if (mContentType == ContentType.YOTUBE_VIDEO || mContentType == ContentType.VIMEO_VIDEO || mContentType == ContentType.STREAMING_VIDEO)
                        {
                            mPalliteBgColor = Color.parseColor("#f8de46");
                        }
                    }
                    catch (Exception e)
                    {
                    }
                }
            }

            // Get image ratio
            if (keysMap.containsKey(IMAGE_RATIO_KEY))
            {
                mMainThumbImageRation = (float) jsonArray.optDouble(keysMap.get(IMAGE_RATIO_KEY));
            }
        }
    }//end ContentItem

   /* private void getThumbSize() {
        String sizePrefix = "ImageSize_";

        if (mThumb.contains(sizePrefix) == true) {
            try {
                String[] dotSplitArray = mThumb.split("\\.");
                String stripedExtensionString = dotSplitArray[dotSplitArray.length - 2];
                int start = stripedExtensionString.indexOf(sizePrefix);
                if (start != -1) {
                    String sizeString = stripedExtensionString.substring(start + sizePrefix.length(), stripedExtensionString.length());
                    String[] values = sizeString.split("_");
                    mMainThumbSize = new int[2];
                    mMainThumbSize[0] = Integer.parseInt(values[0]);
                    mMainThumbSize[1] = Integer.parseInt(values[1]);
                    mMainThumbImageRation = (float) (mMainThumbSize[1]) / (float) (mMainThumbSize[0]);
                }
            } catch (Exception ex) {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog("Error trying to extract image size from WEBSITE_URL: \n" + mThumb + "\n " + ex.getMessage());
            }
        }
    }*/

    public int getPaliteBgColor()
    {
        return mPalliteBgColor;
    }

    public void setPaliteBgColor(int paliteBgColor)
    {
        //        this.mPalliteBgColor = paliteBgColor;
    }

    public int getPaliteTextColor()
    {
        return mPalliteTextColor;
    }

    public void setPaliteTextColor(int paliteTextColor)
    {
        this.mPalliteTextColor = paliteTextColor;
    }

    public float getMainThumbImageRatio()
    {
        return mMainThumbImageRation;
    }

    public int[] getMainThumbSize()
    {
        return mMainThumbSize;
    }

    public String getId()
    {
        return mId;
    }

    public String getThumb()
    {
        return mThumb;
    }

    public void setThumb(String thumb)
    {
        this.mThumb = thumb;
    }

    public ContentType getContentType()
    {
        return mContentType;
    }

    public String getSecThumb()
    {
        return mSecThumb;
    }

    public String getData()
    {
        return mData;
    }

    public void setData(String data)
    {
        this.mData = data;
    }

    public String getName()
    {
        return mTiltle;
    }

    public void setName(String name)
    {
        this.mTiltle = name;
    }

    public String getLang()
    {
        return mLang;
    }

    public boolean isPromoted()
    {
        return mPromoted;
    }

    public String getAdvertiserID()
    {
        return mAdvertiserID;
    }

    public void setContentType(ContentType contentType)
    {
        mContentType = contentType;
    }

    public int getRealViewIndex()
    {
        return mRealViewIndex;
    }

    public void setRealViewIndex(int viewIndex)
    {
        this.mRealViewIndex = viewIndex;
    }
}
