package com.kidoz.sdk.api.structure;

import android.graphics.Color;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;


/**
 * Created by orikam on 7/13/15.
 * Class that represent a ContentData received from the server
 */
public class ContentData implements Serializable {
    private static final String VIEW_ITEM_BG_COLOR_KEY = "viewItemBgColor";
    private static String VIEW_ITEM_CORENR_RADIUS_PX_KEY = "viewItemCorenrRadiusPx";
    private static String CONTAINER_VIEW_BG_COLOR_KEY = "containerViewBgColor";
    private static String HEADER_VIEW_BG_COLOR_KEY = "headerColor";
    private static String FOOTER_VIEW_BG_COLOR_KEY = "footerColor";
    private static String HEADER_TEXT_KEY = "headerText";
    private static String POWERED_BY_URL_KEY = "powerd_by_url";

    private static String DATA_KEY = "data";
    private static String CONTENT_ITEMS_KEY = "content_items";

    private ArrayList<ContentItem> mItems;
    public int mViewItemBgColor;
    public int mViewItemCorenrRadiusPx;
    public int mContainerViewBgColor;
    public int mHeaderViewBgColor;
    public int mFooterViewBgColor;
    public String mHeaderTextStr = "";
    public String mPowerByUrl = "";
    public String mBackgroundURL = "";

    private String mWidgetType = null;
    private String mStyleID = null;

    public boolean isHasContentToShow() {
        return mItems != null && mItems.isEmpty() == false;
    }

    public ArrayList<ContentItem> getContentDataItems() {
        return mItems;
    }


    public void decodeResponse(String data) {
        try {
            JSONObject contentData = new JSONObject(data);
            boolean isSuccess = contentData.optBoolean("success");

            if (isSuccess == true) {
                JSONObject genDataObj = contentData.optJSONObject(DATA_KEY);
                if (genDataObj != null) {
                    mViewItemBgColor = Color.parseColor(genDataObj.optString(VIEW_ITEM_BG_COLOR_KEY, "#ffffffff"));
                    mViewItemCorenrRadiusPx = genDataObj.optInt(VIEW_ITEM_CORENR_RADIUS_PX_KEY, 20);
                    mContainerViewBgColor = Color.parseColor(genDataObj.optString(CONTAINER_VIEW_BG_COLOR_KEY, "#ffffffff"));
                    mHeaderViewBgColor = Color.parseColor(genDataObj.optString(HEADER_VIEW_BG_COLOR_KEY, "#ffffffff"));
                    mFooterViewBgColor = Color.parseColor(genDataObj.optString(FOOTER_VIEW_BG_COLOR_KEY, "#ffffffff"));
                    mHeaderTextStr = genDataObj.optString(HEADER_TEXT_KEY, "More Cool Stuff");
                    mPowerByUrl = genDataObj.optString(POWERED_BY_URL_KEY, "");

                    if (genDataObj.has(CONTENT_ITEMS_KEY)) {
                        mItems = new ArrayList<ContentItem>();
                        JSONArray jsonArray = genDataObj.optJSONArray(CONTENT_ITEMS_KEY);
                        if (jsonArray != null && jsonArray.length() > 0) {
                            HashMap<String, Integer> keysMap = new LinkedHashMap<String, Integer>();
                            JSONArray keysArray = jsonArray.getJSONArray(0);
                            if (keysArray != null && keysArray.length() > 0) {
                                for (int i = 0; i < keysArray.length(); i++) {
                                    keysMap.put(keysArray.getString(i), i);
                                }
                            }

                            if (keysMap.isEmpty() == false) {
                                ContentItem item;
                                for (int i = 1; i < jsonArray.length(); i++) {
                                    try {
                                        item = new ContentItem(jsonArray.getJSONArray(i), keysMap);
                                        mItems.add(item);
                                    } catch (JSONException e) {
                                        com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog("Error parsing Content data item!");
                                    }
                                }
                            }
                        }

                        // We set the real view array index of the accepted content
                        for (int i = 0; i < mItems.size(); i++) {
                            mItems.get(i).setRealViewIndex(i);
                        }
                    }
                }
            }
        } catch (Exception e) {
            com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog("Error parsing Content data object!\n" + e.getMessage());
        }
    }


    public int getHeaderViewBgColor() {
        return mHeaderViewBgColor;
    }

    public int getContainerViewBgColor() {
        return mContainerViewBgColor;
    }

    public int getViewItemCorenrRadiusPx() {
        return mViewItemCorenrRadiusPx;
    }

    public int getViewItemBgColor() {
        return mViewItemBgColor;
    }

    public int getFooterViewBgColor() {
        return mFooterViewBgColor;
    }

    public String getHeaderTextStr() {
        return mHeaderTextStr;
    }

    public String getPowerByUrl() {
        return mPowerByUrl;
    }

    public String getSourceWidgetType() {
        return mWidgetType;
    }

    public void setWidgetType(String widgetType) {
        this.mWidgetType = widgetType;
    }

    public String getStyleID() {
        return mStyleID;
    }

    public void setStyleID(String styleID) {
        this.mStyleID = styleID;
    }

    public void setContentItems(ArrayList<ContentItem> contentItems)
    {
        mItems = contentItems;
    }

}
