package com.kidoz.sdk.api.general.utils;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Eugine on 9/30/2015.
 */
public class PropertiesObj
{

    private static final String CONFIG_VERSION = "configuration_version";
    private static final String IS_PARENTAL_LOCK = "is_parental_lock_activated";
    private static final String FEED_BUTTON_VIEW_URL = "btnUrl";
    private static final String FEED_BUTTON_ANIMATION_TYPE = "btnAnimation";
    private static final String PANEL_BUTTON_URL = "panelBtn";
    private static final String PANEL_BUTTON_CLOSE_URL = "panelBtnClose";
    private static final String PANEL_BUTTON_ANIMATION_TYPE = "panelBtnAnimation";
    private static final String PANEL_BACKGROUND_COLOR = "panelBgClr";
    private static final String SDK_STYLE_VERSION = "style";
    private static final String PANEL_BUTTON_SCALE_PERCENTAGE = "panelBtnScale";
    private static final String FAMILY_PANEL_ANIMATION_URL = "familyPanelAnimation";


    JSONObject mProperties = new JSONObject();

    public PropertiesObj(JSONObject data)
    {
        mProperties = data;
    }

    public JSONObject getData()
    {
        return mProperties;
    }

    public int getConfigVersion()
    {
        int result = -1;
        if (mProperties != null)
        {
            result = mProperties.optInt(CONFIG_VERSION, 1);
        }
        return result;
    }

    public boolean isParentalLockActive()
    {
        boolean result = false;
        if (mProperties != null)
        {
            result = mProperties.optBoolean(IS_PARENTAL_LOCK, false);
        }
        return result;
    }

    public String getFeedButtonUrl()
    {
        String result = null;
        if (mProperties != null)
        {
            result = mProperties.optString(FEED_BUTTON_VIEW_URL);
        }
        return result;
    }

    public String getPanelButtonUrl()
    {
        String result = null;
        if (mProperties != null)
        {
            result = mProperties.optString(PANEL_BUTTON_URL);
        }
        return result;
    }

    public String getFamilyPanelAnimationUrl()
    {
        String result = null;
        if (mProperties != null)
        {
            result = mProperties.optString(FAMILY_PANEL_ANIMATION_URL);
        }
        return result;
    }


    public String getPanelButtonCloseUrl()
    {
        String result = null;
        if (mProperties != null)
        {
            result = mProperties.optString(PANEL_BUTTON_CLOSE_URL);
        }
        return result;
    }

    public int getFeedButtonAnimationType()
    {
        int result = -1;
        if (mProperties != null)
        {
            result = mProperties.optInt(FEED_BUTTON_ANIMATION_TYPE, 0);
        }
        return result;
    }

    public int getPanelButtonAnimationType()
    {
        int result = -1;
        if (mProperties != null)
        {
            result = mProperties.optInt(PANEL_BUTTON_ANIMATION_TYPE, 0);
        }
        return result;
    }

    public String getPanelBackGroundColor()
    {
        String result = null;
        if (mProperties != null)
        {
            result = mProperties.optString(PANEL_BACKGROUND_COLOR, "#ffffff");
        }
        return result;
    }

    public double getPanelButtonScaleValue()
    {
        double result = 0.0;
        if (mProperties != null)
        {
            result = mProperties.optDouble(PANEL_BUTTON_SCALE_PERCENTAGE, 0.15f);
        }
        return result;
    }

    public int getSdkStyleVersion()
    {
        int result = -1;
        if (mProperties != null)
        {
            result = mProperties.optInt(SDK_STYLE_VERSION, 0);
        }
        return result;
    }

    public JSONObject getProperties()
    {
        return mProperties;
    }

    public void setConfigVersion(int version)
    {
        try
        {
            mProperties.put(CONFIG_VERSION, version);
        }
        catch (Exception ex)
        {

        }
    }

    // Update Configuration properties from other properties object (Updates all except the Configuration Version field)
    public void updateConfigFromData(PropertiesObj data)
    {
        try
        {
            if (data != null)
            {
                mProperties.put(FEED_BUTTON_ANIMATION_TYPE, data.getFeedButtonAnimationType());
                mProperties.put(FEED_BUTTON_VIEW_URL, data.getFeedButtonUrl());
                mProperties.put(IS_PARENTAL_LOCK, data.isParentalLockActive());
                mProperties.put(PANEL_BUTTON_ANIMATION_TYPE, data.getPanelButtonAnimationType());
                mProperties.put(PANEL_BUTTON_URL, data.getPanelButtonUrl());
                mProperties.put(FAMILY_PANEL_ANIMATION_URL, data.getFamilyPanelAnimationUrl());
                mProperties.put(PANEL_BUTTON_CLOSE_URL, data.getPanelButtonCloseUrl());
                mProperties.put(PANEL_BACKGROUND_COLOR, data.getPanelBackGroundColor());
                mProperties.put(SDK_STYLE_VERSION, data.getSdkStyleVersion());
                mProperties.put(PANEL_BUTTON_SCALE_PERCENTAGE, data.getPanelButtonScaleValue());
            }

        }
        catch (JSONException e)
        {
        }
    }
}
