package com.kidoz.sdk.api.general.enums;

import java.io.Serializable;

/**
 * Created by Eugine on 7/28/2015.
 */
public enum WidgetType implements Serializable
{
    WIDGET_TYPE_NONE(0),
    WIDGET_TYPE_FEED(1),
    WIDGET_TYPE_PANEL(2),
    WIDGET_TYPE_BANNER(3),
    WIDGET_TYPE_FLEXI_VIEW(4);

    private final int value;

    WidgetType(int value)
    {
        this.value = value;
    }

    public int getValue()
    {
        return value;
    }

    public String getStringValue()
    {
        return value + "";
    }

    public static WidgetType createFromString(String widgetTypeAsString)
    {
        WidgetType result = WIDGET_TYPE_NONE;
        if (widgetTypeAsString != null)
        {
            try
            {
                int widgetTypeAsNumber = Integer.parseInt(widgetTypeAsString);
                switch (widgetTypeAsNumber)
                {
                    case 1:
                    {
                        result = WIDGET_TYPE_FEED;
                        break;
                    }
                    case 2:
                    {
                        result = WIDGET_TYPE_PANEL;
                        break;
                    }
                    case 3:
                    {
                        result = WIDGET_TYPE_BANNER;
                        break;
                    }
                    case 4:
                    {
                        result = WIDGET_TYPE_FLEXI_VIEW;
                        break;
                    }
                }
            }
            catch (Exception ex)
            {

            }
        }
        return result;
    }
}
