package com.kidoz.sdk.api;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.interfaces.KidozPlayerEventHelper;
import com.kidoz.sdk.api.interfaces.KidozPlayerListener;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.ui_views.kidoz_banner.BaseBanner;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBanner1;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBanner2;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBanner3;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBannerListener;

import org.json.JSONObject;

import de.greenrobot.event.EventBus;

/**
 * Created by RonyBrosh on 12/8/2015.
 */
public class KidozBanner extends RelativeLayout
{
    public static final String TAG = KidozBanner.class.getSimpleName();

    private KidozBannerListener mKidozBannerListener;
    private BaseBanner mBaseBanner;
    protected boolean mIsWaitingToOpen = false;
    private boolean mIsViewShown = false;
    private boolean mIsSmartBanner;
    private KidozPlayerEventHelper mKidozPlayerEventHelper;

    public KidozBanner(Context context)
    {
        super(context);
        initView();
    }

    public KidozBanner(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView();
    }

    public KidozBanner(Context context, AttributeSet attrs, int defStyleAttr)
    {
        super(context, attrs, defStyleAttr);
        initView();
    }

    /**
     * Set kidoz players event listeners
     * Used for listening Open\Close and ect.. event of launch Player for single view
     *
     * @param  kidozPlayerListener event listener
     */
    public void setKidozPlayerListener(KidozPlayerListener kidozPlayerListener)
    {
        mKidozPlayerEventHelper = new KidozPlayerEventHelper(kidozPlayerListener, WidgetType.WIDGET_TYPE_BANNER);
    }

    public void setIsSmartBanner(boolean isSmartBanner)
    {
        mIsSmartBanner = isSmartBanner;
        if (mBaseBanner != null)
        {
            mBaseBanner.setIsSmartBanner(mIsSmartBanner);
        }
    }

    private void initView()
    {
        subscribeToSDK();
        // We check if Sdk nit successfully finished( Sdk Config data accepted)
        if (KidozSDK.isInitialised() == true)
        {
            validateAssets();
        }
    }

    private void subscribeToSDK()
    {
        EventBus.getDefault().register(this);
    }

    private void validateAssets()
    {
        SdkAPIManager.getSdkApiInstance(getContext()).getStyle(getContext(), WidgetType.WIDGET_TYPE_BANNER.getValue(), new ApiResultCallback<Boolean>() {
            @Override
            public void onServerResult(ResultData<?> result) {
                // If result success notify wrapper to build the banner.
                if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful() == true) {
                    if (result.getData() != null) {
                        boolean isAssetsReady = (Boolean) result.getData();
                        if (isAssetsReady == true) {
                            buildBanner();
                        } else {
                            onFailed();
                        }
                    }
                } else {
                    onFailed();
                }
            }

            @Override
            public void onFailed() {
            }
        });
    }

    private void buildBanner()
    {
        JSONObject jsonObject = DatabaseManager.getInstance(getContext()).getConfigTable().loadProperties(TAG);
        if (jsonObject != null)
        {
            String bannerType = jsonObject.optString(TAG);
            if (bannerType != null)
            {
                if (bannerType.equals(KidozBanner1.class.getSimpleName()))
                {
                    // This is the Eldad version
                    mBaseBanner = new KidozBanner1(getContext());
                    mBaseBanner.setProperties(jsonObject);
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
                    removeAllViews();
                    addView(mBaseBanner, params);
                }
                else if (bannerType.equals(KidozBanner2.class.getSimpleName()))
                {
                    // This is the Gai version
                    mBaseBanner = new KidozBanner2(getContext());
                    mBaseBanner.setProperties(jsonObject);
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
                    removeAllViews();
                    addView(mBaseBanner, params);
                }
                else if (bannerType.equals(KidozBanner3.class.getSimpleName()))
                {
                    // This is the Uri version
                    mBaseBanner = new KidozBanner3(getContext());
                    mBaseBanner.setProperties(jsonObject);
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
                    removeAllViews();
                    addView(mBaseBanner, params);
                }
                
                if (mKidozBannerListener != null)
                {
                    mBaseBanner.setKidozBannerListener(mKidozBannerListener);
                    mKidozBannerListener.onBannerReady();

                    mBaseBanner.requestFocus();
                    mBaseBanner.bringToFront();
                }
                if (mBaseBanner != null)
                {
                    mBaseBanner.setIsSmartBanner(mIsSmartBanner);
                }
                if (mIsWaitingToOpen == true)
                {
                    showBanner();
                }
            }
        }
    }

    /**
     * Show banner view
     */
    synchronized public void showBanner()
    {
        if (mIsViewShown == false)
        {
            mIsWaitingToOpen = true;
            if (mBaseBanner != null)
            {
                mIsViewShown = true;
                mBaseBanner.setKidozBannerListener(mKidozBannerListener);
                mBaseBanner.loadContent();
                mBaseBanner.showBanner();
            }
            if (mKidozPlayerEventHelper != null)
            {
                mKidozPlayerEventHelper.register();
            }
        }
    }

    /**
     * Hide banner view
     */
    public void hideBanner()
    {
        mIsWaitingToOpen = false;
        if (mBaseBanner != null)
        {
            mBaseBanner.setKidozBannerListener(mKidozBannerListener);
            mBaseBanner.hideBanner();
            mIsViewShown = false;
        }
    }

    /**
     * Set banner events listener
     *
     * @param kidozBannerListener events listener
     */
    public void setKidozBannerListener(KidozBannerListener kidozBannerListener)
    {
        mKidozBannerListener = kidozBannerListener;
        if (mBaseBanner != null)
        {
            mBaseBanner.setKidozBannerListener(mKidozBannerListener);
            if (mKidozBannerListener != null)
            {
                mKidozBannerListener.onBannerReady();
            }
        }
    }

    @Override
    protected void onDetachedFromWindow()
    {
        try
        {
            EventBus.getDefault().unregister(this);
        }
        catch (Exception e)
        {

        }

        if (mKidozPlayerEventHelper != null)
        {
            mKidozPlayerEventHelper.unRegister();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void onAttachedToWindow()
    {
        super.onAttachedToWindow();
        if (mKidozPlayerEventHelper != null)
        {
            mKidozPlayerEventHelper.register();
        }
    }

    public void onEvent(EventMessage event)
    {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK)
        {
            validateAssets();
            EventBus.getDefault().unregister(this);
        }
    }
}
