package com.kidoz.sdk.api;

import android.content.Context;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;

import java.util.ArrayList;


public class ContentLogicLoader {
    IOnContentDataReadyCallback mDataReadyCallback;
    private boolean mIsLoadContentIsInProgress;

    public ContentLogicLoader(IOnContentDataReadyCallback dataReadyCallback) {
        mDataReadyCallback = dataReadyCallback;
    }

    public void loadContent(final Context context, final String widgetType, final String styleId) {
        if (mIsLoadContentIsInProgress == false) {
            mIsLoadContentIsInProgress = true;
            SdkAPIManager.getSdkApiInstance(context).loadContent(context, styleId,widgetType, new ApiResultCallback<ContentData>() {
                @Override
                public void onServerResult(ResultData<?> result) {
                    if (result != null && result.getData() != null) {
                        ContentData contentData = (ContentData) result.getData();
                        contentData.setWidgetType(widgetType);
                        contentData.setStyleID(styleId);
                        int servedCounter = 0;
                        if (contentData != null) {
                            ArrayList<ContentItem> contentItems = contentData.getContentDataItems();
                            if (contentItems != null && contentItems.isEmpty() == false) {
                                for (ContentItem nextContentItem : contentItems) {
                                    if (nextContentItem.isPromoted() == true) {
                                        servedCounter++;
                                    }
                                }
                            }
                            EventManager.getInstance(context).LogEventWithIntField(context, widgetType, styleId, EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_IMPRESSION_SERVED, null, servedCounter, false);
                        }
                        if (contentData.isHasContentToShow()) {
                            if (mDataReadyCallback != null) {

                                mDataReadyCallback.onDataReady(contentData);
                            }
                        } else {
                            if (mDataReadyCallback != null) {
                                mDataReadyCallback.onLoadContentFailed();
                            }
                        }
                    } else {
                        if (mDataReadyCallback != null) {
                            mDataReadyCallback.onLoadContentFailed();
                        }
                    }
                    mIsLoadContentIsInProgress = false;
                }

                @Override
                public void onFailed() {
                    if (mDataReadyCallback != null) {
                        mDataReadyCallback.onLoadContentFailed();
                    }
                    mIsLoadContentIsInProgress = false;
                    //Toast.makeText(context, "No internet connection", Toast.LENGTH_LONG).show();
                }
            });
        }
    }


    protected void loadRefreshebleContent(WidgetType view_style) {
        // TODO to add future support for refreshable content
    }


    public interface IOnContentDataReadyCallback {
        void onDataReady(ContentData contentData);

        void onLoadContentFailed();
    }
}

