package com.kidoz.sdk.api.ui_views.panel_view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.ContentExecutionHandler;
import com.kidoz.sdk.api.ContentLogicLoader;
import com.kidoz.sdk.api.PanelView;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.AssetUtil;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;

import org.json.JSONObject;

/**
 * Created by Eugine on 12/8/2015.
 */
public class StandardPanelView extends AbstractPanelView {

    public static final String TAG = StandardPanelView.class.getSimpleName();

    private PanelSliderView mPanelSliderView;

    public StandardPanelView(Context context, JSONObject jsonObject) {
        super(context, jsonObject);
    }

    @Override
    protected void initInnerPanelContentView() {
        mPanelSliderView = new PanelSliderView(getContext());
        mPanelSliderView.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        mPanelSliderView.setBackgroundColor(mPanelBgColor);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mInnerContainer.addView(mPanelSliderView, params);

        PanelViewListener mPanelViewListener = new PanelViewListener() {
            @Override
            public void onItemClick(ContentItem contentItem, int position) {
                if (mAllowClickHandling) {
                    mAllowClickHandling = false;
                    ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId, position, true, false, new ContentExecutionHandler.IOnHandleClickListener() {
                        @Override
                        public void onRestoreClick() {
                            mAllowClickHandling = true;
                        }
                    });
                }
            }
        };
        mPanelSliderView.setPanelViewListener(mPanelViewListener);
    }


    protected void initContentLogicLoader() {
        mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback() {
            @Override
            public void onDataReady(ContentData contentData) {
                mPanelSliderView.showLoadingProgressView(false);
                if (contentData != null) {
                    mPanelSliderView.setContentData(contentData);
                }
            }

            @Override
            public void onLoadContentFailed() {

            }
        });
    }


    protected void createShadowLineBg() {
        int[] colors = new int[2];
        colors[0] = Color.parseColor("#dd000000");
        colors[1] = Color.TRANSPARENT;

        GradientDrawable shadow = null;

        switch (mPanelType) {
            case BOTTOM: {
                shadow = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, colors);
                break;
            }
            case TOP: {
                shadow = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, colors);
                break;
            }
            case LEFT: {
                shadow = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, colors);
                break;
            }
            case RIGHT: {
                shadow = new GradientDrawable(GradientDrawable.Orientation.RIGHT_LEFT, colors);
                break;
            }
        }


        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            mShadowLine.setBackground(shadow);
        } else {
            mShadowLine.setBackgroundDrawable(shadow);
        }
    }

    @Override
    protected void initShadowView() {

        mShadowLine = new LinearLayout(getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE));
        mContainer.addView(mShadowLine, params);
        mShadowLine.setAlpha(0.20f);
        mShadowLine.setVisibility(View.INVISIBLE);
    }

    @Override
    public void setPanelColor(int color) {
        super.setPanelColor(color);

        if (mPanelSliderView != null) {
            mPanelSliderView.setBackgroundColor(mPanelBgColor);
        }
    }

    @Override
    protected void onCollapsePanelAnimationEnded() {
        super.onCollapsePanelAnimationEnded();

        mShadowLine.setVisibility(View.INVISIBLE);
        mPanelSliderView.clearContent();
    }

    @Override
    protected void onExpandPanelAnimationStarted() {
        super.onExpandPanelAnimationStarted();

        mShadowLine.setVisibility(View.VISIBLE);
        mPanelSliderView.showLoadingProgressView(true);
        mContentLogicLoader.loadContent(getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), mStyleId);
    }

    @Override
    protected void initPanelViewsRules() {
        createShadowLineBg();

        RelativeLayout.LayoutParams containerParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        setLayoutParams(containerParams);

        RelativeLayout.LayoutParams innerContainerParams = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mInnerContainer.setLayoutParams(innerContainerParams);

        RelativeLayout.LayoutParams sliderParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mPanelSliderView.setLayoutParams(sliderParams);

        RelativeLayout.LayoutParams bottomBarParams = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mBottomBarContainer.setLayoutParams(bottomBarParams);

        RelativeLayout.LayoutParams handleParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mPanelHandle.setLayoutParams(handleParams);

        RelativeLayout.LayoutParams shadowParams = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE));
        mShadowLine.setLayoutParams(shadowParams);

        RelativeLayout.LayoutParams parentalLockParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mParentalLockButton.setLayoutParams(parentalLockParams);

        RelativeLayout.LayoutParams aboutKidozParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mAboutKidozButton.setLayoutParams(aboutKidozParams);

        int margin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 6);
        switch (mPanelType) {
            case LEFT: {
                mPanelSliderView.setPanelType(com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.LEFT);
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                innerContainerParams.width = LayoutParams.WRAP_CONTENT;
                innerContainerParams.height = LayoutParams.MATCH_PARENT;

                handleParams.addRule(RelativeLayout.RIGHT_OF, mInnerContainer.getId());

                aboutKidozParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                parentalLockParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                parentalLockParams.addRule(RelativeLayout.ALIGN_RIGHT, mPanelSliderView.getId());

                bottomBarParams.width = LayoutParams.WRAP_CONTENT;
                bottomBarParams.height = LayoutParams.WRAP_CONTENT;

                bottomBarParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                bottomBarParams.addRule(RelativeLayout.RIGHT_OF, mAboutKidozButton.getId());
                bottomBarParams.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());

                sliderParams.addRule(RelativeLayout.ABOVE, mBottomBarContainer.getId());

                shadowParams.addRule(RelativeLayout.RIGHT_OF, mInnerContainer.getId());
                shadowParams.width = Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE);
                shadowParams.height = LayoutParams.MATCH_PARENT;

                mPoweredByTextView.setVisibility(View.INVISIBLE);

                switch (mHandlePosition) {
                    case START: {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                        handleParams.topMargin = margin;
                        break;
                    }
                    case CENTER: {
                        handleParams.addRule(RelativeLayout.CENTER_VERTICAL);
                        break;
                    }
                    case END: {
                        handleParams.addRule(RelativeLayout.ALIGN_BOTTOM, mInnerContainer.getId());
                        handleParams.bottomMargin = margin;
                        break;
                    }
                }
                containerParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                break;
            }
            case TOP: {
                mPanelSliderView.setPanelType(com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.TOP);
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                innerContainerParams.width = LayoutParams.MATCH_PARENT;
                innerContainerParams.height = LayoutParams.WRAP_CONTENT;

                bottomBarParams.addRule(RelativeLayout.BELOW, mPanelSliderView.getId());
                aboutKidozParams.addRule(RelativeLayout.ALIGN_BOTTOM, mBottomBarContainer.getId());
                parentalLockParams.addRule(RelativeLayout.ALIGN_BOTTOM, mBottomBarContainer.getId());
                parentalLockParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, mBottomBarContainer.getId());

                bottomBarParams.addRule(RelativeLayout.RIGHT_OF, mAboutKidozButton.getId());
                bottomBarParams.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());

                handleParams.addRule(RelativeLayout.BELOW, mInnerContainer.getId());

                shadowParams.addRule(RelativeLayout.BELOW, mInnerContainer.getId());
                shadowParams.width = LayoutParams.MATCH_PARENT;
                shadowParams.height = Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE);

                mPoweredByTextView.setVisibility(View.VISIBLE);

                switch (mHandlePosition) {
                    case START: {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                        handleParams.leftMargin = margin;
                        break;
                    }
                    case CENTER: {
                        handleParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                        break;
                    }
                    case END: {
                        handleParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
                        handleParams.rightMargin = margin;
                        break;
                    }
                }

                containerParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                break;
            }
            case RIGHT: {
                mPanelSliderView.setPanelType(com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.RIGHT);
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                innerContainerParams.width = LayoutParams.WRAP_CONTENT;
                innerContainerParams.height = LayoutParams.MATCH_PARENT;

                aboutKidozParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                parentalLockParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                parentalLockParams.addRule(RelativeLayout.ALIGN_RIGHT, mPanelSliderView.getId());

                bottomBarParams.width = LayoutParams.WRAP_CONTENT;
                bottomBarParams.height = LayoutParams.WRAP_CONTENT;

                bottomBarParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                bottomBarParams.addRule(RelativeLayout.RIGHT_OF, mAboutKidozButton.getId());
                bottomBarParams.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());

                sliderParams.addRule(RelativeLayout.ABOVE, mBottomBarContainer.getId());

                shadowParams.addRule(RelativeLayout.LEFT_OF, mInnerContainer.getId());
                shadowParams.width = Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE);
                shadowParams.height = LayoutParams.MATCH_PARENT;

                handleParams.addRule(RelativeLayout.LEFT_OF, mInnerContainer.getId());

                mPoweredByTextView.setVisibility(View.INVISIBLE);

                switch (mHandlePosition) {
                    case START: {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                        handleParams.topMargin = margin;
                        break;
                    }
                    case CENTER: {
                        handleParams.addRule(RelativeLayout.CENTER_VERTICAL);
                        break;
                    }
                    case END: {
                        handleParams.addRule(RelativeLayout.ALIGN_BOTTOM, mInnerContainer.getId());
                        handleParams.bottomMargin = margin;
                        break;
                    }
                }

                containerParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                break;
            }
            case BOTTOM: {
                mPanelSliderView.setPanelType(com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE.BOTTOM);
                innerContainerParams.addRule(RelativeLayout.BELOW, mPanelHandle.getId());
                innerContainerParams.width = LayoutParams.MATCH_PARENT;
                innerContainerParams.height = LayoutParams.WRAP_CONTENT;

                shadowParams.addRule(RelativeLayout.ABOVE, mInnerContainer.getId());
                shadowParams.width = LayoutParams.MATCH_PARENT;
                shadowParams.height = Utils.dpTOpx(getContext(), DEFAULT_SHADOW_LINE_SIZE);

                bottomBarParams.addRule(RelativeLayout.BELOW, mPanelSliderView.getId());
                bottomBarParams.addRule(RelativeLayout.RIGHT_OF, mAboutKidozButton.getId());
                bottomBarParams.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());

                aboutKidozParams.addRule(RelativeLayout.ALIGN_BOTTOM, mBottomBarContainer.getId());
                parentalLockParams.addRule(RelativeLayout.ALIGN_BOTTOM, mBottomBarContainer.getId());
                parentalLockParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);

                mPoweredByTextView.setVisibility(View.VISIBLE);

                switch (mHandlePosition) {
                    case START: {
                        handleParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                        handleParams.leftMargin = margin;
                        break;
                    }
                    case CENTER: {
                        handleParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                        break;
                    }
                    case END: {
                        handleParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
                        handleParams.rightMargin = margin;
                        break;
                    }
                }

                containerParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                break;
            }
        }
    }


    /**
     * Compare new JSON to old JSON, save the updated JSON to database, delete old assets if needed and download new assets.
     *
     * @param context
     * @param jsonObject
     */
    public static boolean parsePanelData(Context context, JSONObject jsonObject) {
        boolean result = false;
        if (jsonObject != null) {
            try {
                // 1. Extract elements.
                jsonObject.put(PanelView.TAG, StandardPanelView.TAG);

                String buttonOpenView = jsonObject.optString(BTN_OPENED_URL);
                String buttonClosedView = jsonObject.optString(BTN_CLOSED_URL);

                // 2. Load old data from database
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(PanelView.TAG);

                // 3. Compare assets, download and save if necessary
                if (oldData != null) {
                    result = true;
                    String oldAssetURL = oldData.optString(BTN_OPENED_URL);
                    if (oldAssetURL == null || oldAssetURL.equals(buttonOpenView) == false || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, buttonOpenView);
                    }
                    oldAssetURL = oldData.optString(BTN_CLOSED_URL);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(buttonClosedView) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, buttonClosedView);
                    }

                } else {
                    result = AssetUtil.createAssetFile(context, buttonOpenView);
                    if (result == true) {
                        result = AssetUtil.createAssetFile(context, buttonClosedView);
                    }
                }
                // 4. Update database
                if (result == true) {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(PanelView.TAG, jsonObject);
                }
            } catch (Exception ex) {
                result = false;
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(PanelView.TAG, "Error when trying to parse kidoz PanelView properties" + ex.getMessage());
            }
        }
        return result;
    }
}
