package com.kidoz.sdk.api.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.IsEventRecord;

public class SdkReceiver extends BroadcastReceiver {
    private final String TAG = SdkReceiver.class.getSimpleName();

    @Override
    public void onReceive(Context context, Intent intent) {
        if (intent != null) {
            String action = intent.getAction();
            if (action != null) {
                if (action.equalsIgnoreCase(Intent.ACTION_PACKAGE_ADDED)) {
                    if (intent.getData() != null) {
                        String packageName = intent.getData().getSchemeSpecificPart();
                        if (packageName != null) {
                            com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("--------------------+++++++  INSTALL RECEIVER LAUNCHED ++++++ ------------------");
                            updateInstallEvent(context, packageName);
                        }
                    }
                }
            }
        }
    }


    private void updateInstallEvent(Context context, String packageName) {
        final int MAX_ACCEPTABLE_INSTALL_INTERVAL = 24 * 60 * 60 * 1000;  // 24 hours

        DatabaseManager databaseManager = DatabaseManager.getInstance(context);
        if (databaseManager != null) {
            IsEventRecord record = databaseManager.getIsEventTable().getRecord(packageName);
            if (record != null) {
                long setTime = -1;
                try {
                    setTime = Long.parseLong(record.getTimeStamp());
                } catch (NumberFormatException e) {
                    setTime = -1;
                }

                if (setTime != -1 && ((System.currentTimeMillis() - setTime) < MAX_ACCEPTABLE_INSTALL_INTERVAL)) {
                    // Send event
                    EventManager.getInstance(context).logSponsoredContentInstallEvent(context, record.getWidgetType(), record.getStyleId(), record.getPackageName(), record.getAdvertiserId(), record.getPackageName(), record.getPositionIndex(), false);
                    EventManager.getInstance(context).startEventsSync(context);

                    // Send event
                    if (SDKLogger.IS_DEBUG_MODE) {
                        com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("!!!!!!!! SEND ANALYTICS EVENT OF APPLICATION INSTALLED !!!!!!!");
                        com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("\ngetPackageName : " + record.getPackageName());
                        com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("\ngetTimeStamp : " + record.getTimeStamp());
                        com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("\ngetItemType : " + record.getContentType());
                        com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("\ngetLocationInFeed : " + record.getPositionIndex());
                        com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("\ngetApppName : " + record.getName());
                        com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("\ngetAdvertiser ID : " + record.getAdvertiserId());
                        com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("\ngetWidgetType : " + record.getWidgetType());
                        com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("\ngetStyleId : " + record.getStyleId());
                    }
                }
                databaseManager.getIsEventTable().deleteRecord(packageName);
            }
        }
    }
}
