package com.kidoz.sdk.api.interfaces;

import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;

import de.greenrobot.event.EventBus;

/**
 * Created by RonyBrosh on 2/2/2016.
 */
public class KidozPlayerEventHelper
{
    private KidozPlayerListener mKidozPlayerListener;
    private WidgetType mWidgetType;

    public KidozPlayerEventHelper(KidozPlayerListener kidozPlayerListener, WidgetType widgetType)
    {
        mKidozPlayerListener = kidozPlayerListener;
        mWidgetType = widgetType;
    }

    public void register()
    {
        if (EventBus.getDefault().isRegistered(this) == false)
        {
            EventBus.getDefault().register(this);
        }
    }

    public void unRegister()
    {
        if (EventBus.getDefault().isRegistered(this) == true)
        {
            EventBus.getDefault().unregister(this);
        }
    }

    public void onEvent(WidgetEventMessage event)
    {
        if (event != null && event.getWidgetType() == mWidgetType && mKidozPlayerListener != null)
        {
            switch (event.getMessageType())
            {
                case PLAYER_OPEN:
                {
                    mKidozPlayerListener.onPlayerOpen();
                    break;
                }
                case PLAYER_CLOSE:
                {
                    mKidozPlayerListener.onPlayerClose();
                    break;
                }
            }
        }
    }
}
