package com.kidoz.sdk.api;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.events.Event;
import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.AssetUtil;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.family_feed.FamilyFeedViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;
import com.kidoz.sdk.api.ui_views.one_item_view.AutoScrollViewPager;
import com.kidoz.sdk.api.ui_views.one_item_view.InfinitePagerAdapter;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;

import org.json.JSONObject;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by Eugine on 10/1/2015.
 */
public class FeedFamilyViewDialog extends BaseDialog {

    public static final String TAG = FeedFamilyViewDialog.class.getSimpleName();
    private final int AUTO_SCROLL_DELAY = 10000;

    private RelativeLayout mRootView;
    private RelativeLayout mViewContainer;
    private AutoScrollViewPager mViewPager;
    private FamilyFeedViewPagerAdapter mAdapter;
    private AssetView mNextButton;
    private AssetView mPreviousButton;
    private AssetView mAnimation;

    private AssetView mParentalLockButton;
    private AssetView mAboutButton;
    private AssetView mExitButton;

    private TextView mKidozLabelTextView;
    private LoadingProgressView mLoadingProgressView;
    private HashMap<String, Integer> mSponsoredContentDisplayed = new HashMap<String, Integer>();
    private ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;
    ArrayList<ContentItem> content;
    protected JSONObject mProperties;

    private ContentData mContentData = null;
    // Close button click listener
    private View.OnClickListener mCloseBtnClickListener = null;
    private IOnFeedViewEventListener mOnInterstitialViewEventListener;
    private boolean mAllowClickHandling = true;
    private boolean mIsAutomaticInvocation = false;

    private String mStyleId = null;


    public FeedFamilyViewDialog(Context context, IOnFeedViewEventListener listener, boolean automatic, JSONObject properties) {
        super(context, android.R.style.Theme_Translucent_NoTitleBar_Fullscreen);

        mProperties = properties;
        mStyleId = mProperties.optString(STYLE_ID);

        mIsAutomaticInvocation = automatic;
        mOnInterstitialViewEventListener = listener;
        initDialog();
    }

    private void initDialog() {
        initDialogBehaviour();

        // Create the view hierarchy
        initRootView();
        initViewContainer();
        initViewPager();
        initLoadingProgressView();
        initNextAndPreviousButtons();
        initAnimation();

        initParentalLockButton();
        initAboutKidozButton();
        initExitButton();

        initKidozText();

        // Apply layout params
        applayViewContainerParams();
        applyViewPagerLayoutParams();
        applyNextButtonLayoutParams();
        applyPreviousButtonLayoutParams();
        applyAnimationLayoutParams();
        applyLoadingViewLayoutParams();
        showLoadingProgressView(true);
    }

    private void initViewContainer() {
        mViewContainer = new RelativeLayout(getContext());
        mRootView.addView(mViewContainer);
    }

    private void initLoadingProgressView() {
        mLoadingProgressView = new LoadingProgressView(getContext());
        mLoadingProgressView.setVisibility(View.GONE);

        LinearLayout layout = new LinearLayout(getContext());
        layout.setGravity(Gravity.CENTER);
        layout.addView(mLoadingProgressView);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        params.addRule(RelativeLayout.ALIGN_LEFT, mViewPager.getId());
        params.addRule(RelativeLayout.ALIGN_TOP, mViewPager.getId());
        params.addRule(RelativeLayout.ALIGN_RIGHT, mViewPager.getId());
        params.addRule(RelativeLayout.ALIGN_BOTTOM, mViewPager.getId());
        mViewContainer.addView(layout, params);
    }

    private void applayViewContainerParams() {
        int width = ScreenUtils.getScreenSize(getContext(), true);
        int height = ScreenUtils.getScreenSize(getContext(), false);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
        params.addRule(RelativeLayout.CENTER_IN_PARENT);
        if (ScreenUtils.getIsTablet(getContext()) == false) {
            // This is a phone
            if (getContext().getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT) {
                params.width = width - ScreenUtils.getStatusBarHeight(getContext());
                params.height = params.width;
            } else {
                params.width = height - ScreenUtils.getStatusBarHeight(getContext());
                params.height = params.width;
            }
        } else {
            // This is a tablet
            if (getContext().getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT) {
                params.width = width - ScreenUtils.getStatusBarHeight(getContext()) - ScreenUtils.getNavigationBarHeight(getContext());
                params.height = params.width;
            } else {
                params.width = height - ScreenUtils.getStatusBarHeight(getContext()) - ScreenUtils.getNavigationBarHeight(getContext());
                params.height = params.width;
            }
        }
        mViewContainer.setLayoutParams(params);
    }

    private void applyLoadingViewLayoutParams() {
        int containerWidth = mViewContainer.getLayoutParams().width;
        mLoadingProgressView.setCircleWidth(containerWidth * 0.008f);
        int loadingViewSize = (int) (containerWidth * 0.15f);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(loadingViewSize, loadingViewSize);
        mLoadingProgressView.setLayoutParams(params);
    }

    private void initKidozText() {
        mKidozLabelTextView = new TextView(getContext());
        mKidozLabelTextView.setGravity(Gravity.CENTER);
        float tabletSize = com.kidoz.sdk.api.general.utils.Utils.spTOpx(getContext(), 10);
        float phoneSize = com.kidoz.sdk.api.general.utils.Utils.spTOpx(getContext(), 4);
        float textSize = ScreenUtils.getIsTablet(getContext()) ? tabletSize : phoneSize;
        mKidozLabelTextView.setTextSize(textSize);
        int margin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 5);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.leftMargin = margin;
        params.rightMargin = margin;
        params.bottomMargin = margin;
        params.addRule(RelativeLayout.RIGHT_OF, mAboutButton.getId());
        params.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        mRootView.addView(mKidozLabelTextView, params);

        try {
            mKidozLabelTextView.setText(mProperties.optString(LABEL_TEXT));
            mKidozLabelTextView.setTextColor(Color.parseColor(mProperties.optString(LABEL_COLOR).trim()));
        } catch (Exception ex) {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to load label: " + ex.getMessage());
        }
    }

    private void initNextAndPreviousButtons() {
        mNextButton = new AssetView(getContext());
        mNextButton.setScaleType(ImageView.ScaleType.FIT_XY);
        mNextButton.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        String clickAnimation = mProperties.optString(NEXT_BUTTON_ANIMATION);
        if (clickAnimation != null) {
            if (clickAnimation.equals(GenAnimator.PRESS_LEFT) == true) {
                mNextButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        mNextButton.setClickable(false);
                        GenAnimator.playPressLeftAnimation(mNextButton, new Animator.AnimatorListener() {
                            @Override
                            public void onAnimationStart(Animator animation) {

                            }

                            @Override
                            public void onAnimationEnd(Animator animation) {
                                mNextButton.setClickable(true);
                                mViewPager.setCurrentItem(mViewPager.getCurrentItem() + 1);
                            }

                            @Override
                            public void onAnimationCancel(Animator animation) {

                            }

                            @Override
                            public void onAnimationRepeat(Animator animation) {

                            }
                        });
                    }
                });
            } else if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true) {
                mNextButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        mNextButton.setClickable(false);
                        GenAnimator.clickItemAnimation(mNextButton, 150, new GenAnimator.ViewAnimationListener() {
                            @Override
                            public void onAnimationEnd() {
                                mNextButton.setClickable(true);
                                mViewPager.setCurrentItem(mViewPager.getCurrentItem() + 1);
                            }

                            @Override
                            public void onAnimationStart() {

                            }
                        });
                    }
                });
            }
        }

        mViewContainer.addView(mNextButton);
        mNextButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(NEXT_BUTTON)), new AssetView.IOnAssetLoadedListener() {
            @Override
            public void onAssetLoaded(boolean successfull) {
                openDialog();
            }


        });


        mPreviousButton = new AssetView(getContext());
        mPreviousButton.setScaleType(ImageView.ScaleType.FIT_XY);
        mPreviousButton.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        clickAnimation = mProperties.optString(PREVIOUS_BUTTON_ANIMATION);
        if (clickAnimation != null) {
            if (clickAnimation.equals(GenAnimator.PRESS_RIGHT) == true) {
                mPreviousButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        mPreviousButton.setClickable(false);
                        GenAnimator.playPressRightAnimation(mPreviousButton, new Animator.AnimatorListener() {
                            @Override
                            public void onAnimationStart(Animator animation) {
                            }

                            @Override
                            public void onAnimationEnd(Animator animation) {
                                mPreviousButton.setClickable(true);
                                mViewPager.setCurrentItem(mViewPager.getCurrentItem() - 1);
                            }

                            @Override
                            public void onAnimationCancel(Animator animation) {
                            }

                            @Override
                            public void onAnimationRepeat(Animator animation) {
                            }
                        });
                    }
                });
            } else if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true) {
                mPreviousButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        mPreviousButton.setClickable(false);
                        GenAnimator.clickItemAnimation(mPreviousButton, 150, new GenAnimator.ViewAnimationListener() {
                            @Override
                            public void onAnimationEnd() {
                                mPreviousButton.setClickable(true);
                                mViewPager.setCurrentItem(mViewPager.getCurrentItem() - 1);
                            }

                            @Override
                            public void onAnimationStart() {

                            }
                        });
                    }
                });
            }
        }
        mViewContainer.addView(mPreviousButton);
        mPreviousButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(PREVIOUS_BUTTON)), new AssetView.IOnAssetLoadedListener() {
            @Override
            public void onAssetLoaded(boolean successfull) {
                openDialog();
            }
        });
    }

    private void initAnimation() {
        mAnimation = new AssetView(getContext());
        mAnimation.setScaleType(ImageView.ScaleType.FIT_XY);
        mAnimation.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        mViewContainer.addView(mAnimation);
        mAnimation.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(PROMOTION_ANIMATION)), new AssetView.IOnAssetLoadedListener() {
            @Override
            public void onAssetLoaded(boolean successfull) {
                openDialog();
            }
        });
    }

    private void initExitButton() {
        mExitButton = new AssetView(getContext());
        mExitButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mExitButton.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        String clickAnimation = mProperties.optString(X_BUTTON_ANIMATION);
        if (clickAnimation != null) {
            if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true) {
                mExitButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        mExitButton.setClickable(false);
                        GenAnimator.clickItemAnimation(mExitButton, 150, new GenAnimator.ViewAnimationListener() {
                            @Override
                            public void onAnimationEnd() {
                                mExitButton.setClickable(true);
                                closeDialog();
                            }

                            @Override
                            public void onAnimationStart() {

                            }
                        });
                    }
                });
            }
        }
        int width = ScreenUtils.getScreenSize(getContext(), true) - (ScreenUtils.getStatusBarHeight(getContext()) + ScreenUtils.getNavigationBarHeight(getContext()));
        int height = ScreenUtils.getScreenSize(getContext(), false) - (ScreenUtils.getStatusBarHeight(getContext()) + ScreenUtils.getNavigationBarHeight(getContext()));
        int relevantSize = Math.max(width, height);
        File imageFile = AssetUtil.getAssetFile(getContext(), mProperties.optString(X_BUTTON));
        if (imageFile.exists()) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(imageFile.getAbsolutePath(), options);

            int[] imageDimensions = ScreenUtils.getScaledDimension(options.outWidth, options.outHeight, (int) (relevantSize * 0.08f), (int) (relevantSize * 0.08f));
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(imageDimensions[0], imageDimensions[1]);
            params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
            params.addRule(RelativeLayout.ALIGN_PARENT_TOP);
            mRootView.addView(mExitButton, params);
            mExitButton.loadAsset(imageFile, new AssetView.IOnAssetLoadedListener() {
                @Override
                public void onAssetLoaded(boolean successfull) {
                    openDialog();
                }
            });
        }
    }

    private void initDialogBehaviour() {
        setCancelable(false);
        setCanceledOnTouchOutside(false);
    }

    private void initRootView() {
        mRootView = new RelativeLayout(getContext());
        mRootView.setBackgroundColor(Color.parseColor("#CC261304"));
        ViewGroup.MarginLayoutParams params = new ViewGroup.MarginLayoutParams(ViewGroup.MarginLayoutParams.MATCH_PARENT, ViewGroup.MarginLayoutParams.MATCH_PARENT);
        setContentView(mRootView, params);
    }

    private void initParentalLockButton() {
        mParentalLockButton = new AssetView(getContext());
        mParentalLockButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mParentalLockButton.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        String clickAnimation = mProperties.optString(LOCK_ANIMATION);
        if (clickAnimation != null) {
            if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true) {
                mParentalLockButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        mParentalLockButton.setClickable(false);
                        GenAnimator.clickItemAnimation(mParentalLockButton, 150, new GenAnimator.ViewAnimationListener() {
                            @Override
                            public void onAnimationEnd() {
                                mParentalLockButton.setClickable(true);
                                if (ParentalLockDialog.getIsCanShowDialog(getContext()) == true) {
                                    int[] popLocation = new int[2];
                                    popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                                    popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                                    ParentalLockDialog parentalLockDialog = new ParentalLockDialog(getContext(), false, popLocation);
                                    parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                                        @Override
                                        public void onDismiss(DialogInterface dialog) {
                                            //Refresh the parental lock icon
                                            updateLockIcon();
                                        }
                                    });
                                    parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener() {
                                        @Override
                                        public void onPasswordEntered(boolean isPasswordCorrect) {
                                            updateLockIcon();
                                        }
                                    });
                                    parentalLockDialog.show();
                                }
                            }

                            @Override
                            public void onAnimationStart() {

                            }
                        });
                    }
                });
            }
        }

        int width = ScreenUtils.getScreenSize(getContext(), true) - (ScreenUtils.getStatusBarHeight(getContext()) + ScreenUtils.getNavigationBarHeight(getContext()));
        int height = ScreenUtils.getScreenSize(getContext(), false) - (ScreenUtils.getStatusBarHeight(getContext()) + ScreenUtils.getNavigationBarHeight(getContext()));
        int relevantSize = Math.max(width, height);

        File imageFile = AssetUtil.getAssetFile(getContext(), mProperties.optString(LOCK_ACTIVE));
        if (imageFile.exists()) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(imageFile.getAbsolutePath(), options);
            int[] imageDimensions = ScreenUtils.getScaledDimension(options.outWidth, options.outHeight, (int) (relevantSize * 0.08f), (int) (relevantSize * 0.08f));

            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(imageDimensions[0], imageDimensions[1]);
            params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
            params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
            mRootView.addView(mParentalLockButton, params);

            updateLockIcon();
        }
    }

    private void updateLockIcon() {
        try {
            boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
            if (isLockActive == true) {
                mParentalLockButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(LOCK_ACTIVE)), new AssetView.IOnAssetLoadedListener() {
                    @Override
                    public void onAssetLoaded(boolean successfull) {
                        openDialog();
                    }
                });
            } else {
                mParentalLockButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(LOCK_NOT_ACTIVE)), new AssetView.IOnAssetLoadedListener() {
                    @Override
                    public void onAssetLoaded(boolean successfull) {
                        openDialog();
                    }
                });
            }
        } catch (Exception ex) {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to load parental lock image: " + ex.getMessage());
        }
    }

    private void initAboutKidozButton() {
        mAboutButton = new AssetView(getContext());
        mAboutButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mAboutButton.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());

        String clickAnimation = mProperties.optString(ABOUT_KIDOZ_ANIMATION);
        if (clickAnimation != null) {
            if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true) {
                mAboutButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        mAboutButton.setClickable(false);
                        GenAnimator.clickItemAnimation(mAboutButton, 150, new GenAnimator.ViewAnimationListener() {
                            @Override
                            public void onAnimationEnd() {
                                mAboutButton.setClickable(true);
                                int[] popLocation = new int[2];
                                popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                                popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                                AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(getContext(), popLocation);
                                aboutKidozDialog.openDialog();
                            }

                            @Override
                            public void onAnimationStart() {

                            }
                        });
                    }
                });
            }
        }

        int width = ScreenUtils.getScreenSize(getContext(), true) - (ScreenUtils.getStatusBarHeight(getContext()) + ScreenUtils.getNavigationBarHeight(getContext()));
        int height = ScreenUtils.getScreenSize(getContext(), false) - (ScreenUtils.getStatusBarHeight(getContext()) + ScreenUtils.getNavigationBarHeight(getContext()));
        int relevantSize = Math.max(width, height);

        File imageFile = AssetUtil.getAssetFile(getContext(), mProperties.optString(ABOUT_KIDOZ));
        if (imageFile.exists()) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(imageFile.getAbsolutePath(), options);

            int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 10, getContext().getResources().getDisplayMetrics());
            int[] imageDimensions = ScreenUtils.getScaledDimension(options.outWidth, options.outHeight, (int) (relevantSize * 0.06f), (int) (relevantSize * 0.06f));
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(imageDimensions[0], imageDimensions[1]);
            params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
            params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
            params.leftMargin = margin;
            params.bottomMargin = margin;
            mRootView.addView(mAboutButton, params);

            mAboutButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(ABOUT_KIDOZ)), new AssetView.IOnAssetLoadedListener() {
                @Override
                public void onAssetLoaded(boolean successfull) {
                    openDialog();
                }
            });
        }
    }

    private void initViewPager() {
        int cornerRadius = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 6);
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(Color.parseColor("#cccccc"));
        gradientDrawable.setCornerRadius(cornerRadius);

        mViewPager = new AutoScrollViewPager(getContext());
        if (Build.VERSION.SDK_INT >= 16) {
            mViewPager.setBackground(gradientDrawable);
        } else {
            mViewPager.setBackgroundDrawable(gradientDrawable);
        }

        mViewPager.setInterval(AUTO_SCROLL_DELAY);
        mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                sendImpressionLog(position % mAdapter.getCount());
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
        mViewPager.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        int margin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 6);
        mViewPager.setPageMargin(margin);
        mViewContainer.addView(mViewPager);

        mViewPagerItemClickListener = new ItemViewPagerAdapter.ViewPagerItemClickListener() {
            @Override
            public void onClickEnd(ContentItem contentItem, int position) {
                if (mAllowClickHandling) {
                    mAllowClickHandling = false;
                    ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, WidgetType.WIDGET_TYPE_FEED.getStringValue(), mStyleId, position, true, false, new ContentExecutionHandler.IOnHandleClickListener() {
                        @Override
                        public void onRestoreClick() {
                            mAllowClickHandling = true;
                        }
                    });


                }
            }
        };
    }

    private void sendImpressionLog(int position) {
        ContentItem contentItem = mAdapter.getContentItem(position);
        if (contentItem != null && contentItem.isPromoted() == true) {
            if (mSponsoredContentDisplayed != null) {
                if (mSponsoredContentDisplayed.containsKey(contentItem.getId()) == false) {
                    mSponsoredContentDisplayed.put(contentItem.getId(), position);
                    EventManager.getInstance(getContext()).logSponsoredContentImpressionEvent(getContext(), WidgetType.WIDGET_TYPE_FEED.getStringValue(), mStyleId, EventParameters.ACTION_IMPRESSION, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position, false);
                }
            }
        }
    }

    private void applyViewPagerLayoutParams() {
        int horizontalMargin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 20);
        int bottomlMargin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 24);
        int containerWidth = mViewContainer.getLayoutParams().width;
        int viewWidth = containerWidth - horizontalMargin * 2;
        int viewHeight = (int) (viewWidth * 3f / 4f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(viewWidth, viewHeight);
        params.addRule(RelativeLayout.CENTER_HORIZONTAL);
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        params.bottomMargin = bottomlMargin;
        mViewPager.setLayoutParams(params);
    }

    private void applyAnimationLayoutParams() {
        int containerWidth = mViewContainer.getLayoutParams().width;
        int viewWidth = containerWidth;
        int viewHeight;
        if (ScreenUtils.getIsTablet(getContext()) == false) {
            // On phone the ratio seems to be more accurate this way.
            viewHeight = (int) (containerWidth * 0.366f);
        } else {
            // On tablet the ratio seems to be more accurate this way.
            viewHeight = (int) (containerWidth * 0.357f);
        }

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(viewWidth, viewHeight);
        params.addRule(RelativeLayout.ALIGN_PARENT_TOP);
        mAnimation.setLayoutParams(params);
    }

    private void applyNextButtonLayoutParams() {
        int containerWidth = mViewContainer.getLayoutParams().width;
        int viewWidth = (int) (containerWidth * 0.17f);
        int viewHeight = (int) (containerWidth * 0.25f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(viewWidth, viewHeight);
        params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        params.topMargin = (int) (containerWidth * 0.43f);
        mNextButton.setLayoutParams(params);
    }

    private void applyPreviousButtonLayoutParams() {
        int containerWidth = mViewContainer.getLayoutParams().width;
        int viewWidth = (int) (containerWidth * 0.17f);
        int viewHeight = (int) (containerWidth * 0.25f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(viewWidth, viewHeight);
        params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
        params.topMargin = (int) (containerWidth * 0.43f);
        mPreviousButton.setLayoutParams(params);
    }

    private void setContent(ArrayList<ContentItem> content) {
        this.content = content;
        mSponsoredContentDisplayed.clear();

        mAdapter = new FamilyFeedViewPagerAdapter(getContext(), true);
        mAdapter.setViewPagerItemClickListener(mViewPagerItemClickListener);
        mAdapter.setContent(content);
        PagerAdapter wrappedAdapter = new InfinitePagerAdapter(mAdapter);
        mViewPager.setAdapter(wrappedAdapter);
        mViewPager.startAutoScroll(AUTO_SCROLL_DELAY);

        if (content != null && content.isEmpty() == false) {
            mViewPager.setCurrentItem(0);
            sendImpressionLog(0);
        }
        //SdkSoundManager.playSound(getContext(), SoundAssetsUtils.getSoundAssetFile(getContext(), SoundAssetsUtils.SOUND_ASSET_TYPE.FAMILY_PANEL_VIEW).getAbsolutePath());
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // Init back button listener
        setOnKeyListener(new OnKeyListener() {
            @Override
            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                boolean result = true;
                if (event.getAction() == KeyEvent.ACTION_DOWN) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {

                    }
                }
                return result;
            }
        });
    }

    protected void setContentData(ContentData contentData) {
        mContentData = contentData;
        setContent(mContentData.getContentDataItems());
        showLoadingProgressView(false);
    }

    /**
     * Set on close button click listener
     *
     * @param clickListenr click listener
     */
    protected void setOnCloseButtonClickListener(View.OnClickListener clickListenr) {
        mCloseBtnClickListener = clickListenr;
    }


    @Override
    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();

        return bundle;
    }


    @Override
    public void closeDialog() {
        mIsWaitingToOpen = false;
        mContentData = null;
        super.closeDialog();
    }

    @Override
    public void openDialog() {
        mIsWaitingToOpen = true;
        if (KidozSDK.isInitialised()) {
            if (isShowing() == false && mIsWaitingToOpen == true && getIsCanOpen() == true) {
                super.openDialog();
                Event event = new Event();
                if (mIsAutomaticInvocation) {
                    event.addParameterToJsonObject(EventParameters.LABEL_VIEW_OPEN_TYPE, EventParameters.AUTOMATIC_OPEN);
                } else {
                    event.addParameterToJsonObject(EventParameters.LABEL_VIEW_OPEN_TYPE, EventParameters.MANUAL_OPEN);
                }
                EventManager.getInstance(mCallingActivity).logEvent(mCallingActivity, WidgetType.WIDGET_TYPE_FEED.getStringValue(), mStyleId, EventManager.LOG_CRITICAL_LEVEL, event, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, EventParameters.FEED_VIEW, false);
            }
        }
    }

    public void setOnInterstitialViewEventListener(IOnFeedViewEventListener onInterstitialViewEventListener) {
        if (onInterstitialViewEventListener != null) {
            mOnInterstitialViewEventListener = onInterstitialViewEventListener;
        }
    }

    @Override
    public void onDetachedFromWindow() {

        getMyHandlerInstance().removeCallbacksAndMessages(null);

        if (mViewPager != null) {
            mViewPager.stopAutoScroll();
        }

        super.onDetachedFromWindow();

        // Restore previous orientation
        restoreUserOriginalOrientation();
    }

    @Override
    protected void onDialogWindowVisibilityChange(boolean isVisible) {
        super.onDialogWindowVisibilityChange(isVisible);

        if (isVisible == false) {
            EventManager.getInstance(getContext()).startEventsSync(getContext());
        }
        mAllowClickHandling = true;

        if (mViewPager != null) {
            if (isVisible) {
                mViewPager.startAutoScroll();
            } else {
                mViewPager.stopAutoScroll();
            }
        }
    }

    @Override
    protected void onDialogFocusChange(boolean isVisible) {
        super.onDialogFocusChange(isVisible);

        if(isVisible) {
            mAllowClickHandling = true;
        }else {
            mAllowClickHandling = false;
        }
    }

    @Override
    protected void onDialogOrientationChange(boolean isPortrait) {
        super.onDialogOrientationChange(isPortrait);
    }

    private void refreshContentAdapter() {
        mViewPager.setVisibility(View.INVISIBLE);
        getMyHandlerInstance().postDelayed(new Runnable() {
            @Override
            public void run() {
                mAdapter.notifyDataSetChanged();
                mViewPager.setVisibility(View.VISIBLE);
            }
        }, 300);
    }

    @Override
    public boolean getIsCanOpen() {
        boolean result = false;
        if (mParentalLockButton != null && mAboutButton != null && mExitButton != null && mAnimation != null && mNextButton != null && mPreviousButton != null) {
            result = mParentalLockButton.getIsAssetLoaded() && mAboutButton.getIsAssetLoaded() && mExitButton.getIsAssetLoaded() && mAnimation.getIsAssetLoaded() && mNextButton.getIsAssetLoaded() && mPreviousButton.getIsAssetLoaded();

        }
        return result;
    }


    private void showLoadingProgressView(boolean show) {
        if (show) {
            mLoadingProgressView.setVisibility(View.VISIBLE);
            mLoadingProgressView.startLoadingAnimation();
        } else {
            mLoadingProgressView.stopLoadingAnimation();
            mLoadingProgressView.setVisibility(View.GONE);
        }
    }

    // Parsing related.
    public static final String STYLE_ID = "style_id";
    public static final String FEED_BUTTON = "feedButton";
    public static final String FEED_BUTTON_SCALE = "feedButtonScale";
    public static final String ABOUT_KIDOZ = "aboutKidoz";
    public static final String ABOUT_KIDOZ_ANIMATION = "aboutKidozAnimation";
    public static final String LOCK_ACTIVE = "parentalLockActive";
    public static final String LOCK_NOT_ACTIVE = "parentalLockNotActive";
    public static final String LOCK_ANIMATION = "parentalLockAnimation";
    public static final String BACKGROUND_IMAGE = "bgImage";
    public static final String NEXT_BUTTON = "nextBtn";
    public static final String NEXT_BUTTON_ANIMATION = "nextBtnAnimation";
    public static final String PREVIOUS_BUTTON = "previousBtn";
    public static final String PREVIOUS_BUTTON_ANIMATION = "previousBtnAnimation";
    public static final String PROMOTION_ANIMATION = "animationUrl";
    public static final String LABEL_TEXT = "labelText";
    public static final String LABEL_COLOR = "labelColor";
    public static final String X_BUTTON = "xBtn";
    public static final String X_BUTTON_ANIMATION = "XBtnAnimation";

    public static boolean parseFamilyFeed(Context context, JSONObject jsonObject) {
        boolean result = false;
        if (jsonObject != null) {
            try {
                // 1. Extract elements.
                jsonObject.put(FeedView.TAG, FeedFamilyViewDialog.class.getSimpleName());

                String feedButton = jsonObject.optString(FEED_BUTTON);

                // About KIDOZ button contains image click animation and image ratio
                String aboutKidozButton = jsonObject.optString(ABOUT_KIDOZ);
                String aboutKidozButtonAnimation = jsonObject.optString(ABOUT_KIDOZ_ANIMATION);

                // Parental lock contains 2 states: active and not active, click animation and image ratio
                String parentalLockActive = jsonObject.optString(LOCK_ACTIVE);
                String parentalLockNotActive = jsonObject.optString(LOCK_NOT_ACTIVE);
                String parentalLockAnimation = jsonObject.optString(LOCK_ANIMATION);

                // Background image
                String backgroundImage = jsonObject.optString(BACKGROUND_IMAGE);

                // Next button contain ration and click animation
                String nexthButton = jsonObject.optString(NEXT_BUTTON);
                String nextButtonAnimation = jsonObject.optString(NEXT_BUTTON_ANIMATION);

                // Previous button contain ration and click animation
                String previousButton = jsonObject.optString(PREVIOUS_BUTTON);
                String previousButtonAnimation = jsonObject.optString(PREVIOUS_BUTTON_ANIMATION);

                // Promotion animation
                String animationURL = jsonObject.optString(PROMOTION_ANIMATION);

                // Promotions label contains text and color
                String kidozLabelText = jsonObject.optString(LABEL_TEXT);
                String kidozLabelColor = jsonObject.optString(LABEL_COLOR);

                // Promotions label contains text and color
                String xButton = jsonObject.optString(X_BUTTON);
                String xButtonAnimation = jsonObject.optString(X_BUTTON_ANIMATION);

                // 2. Load old data from database
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(FeedView.TAG);

                // 3. Compare assets, download and save if necessary
                if (oldData != null) {
                    result = true;
                    String oldAssetURL = oldData.optString(LOCK_ACTIVE);
                    if (oldAssetURL == null || oldAssetURL.equals(parentalLockActive) == false || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, parentalLockActive);
                    }
                    oldAssetURL = oldData.optString(LOCK_NOT_ACTIVE);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(parentalLockNotActive) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, parentalLockNotActive);
                    }
                    oldAssetURL = oldData.optString(PROMOTION_ANIMATION);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(animationURL) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, animationURL);
                    }
                    oldAssetURL = oldData.optString(NEXT_BUTTON);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(nexthButton) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, nexthButton);
                    }
                    oldAssetURL = oldData.optString(PREVIOUS_BUTTON);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(previousButton) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, previousButton);
                    }
                    oldAssetURL = oldData.optString(ABOUT_KIDOZ);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(aboutKidozButton) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, aboutKidozButton);
                    }
                    oldAssetURL = oldData.optString(BACKGROUND_IMAGE);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(backgroundImage) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, backgroundImage);
                    }
                    oldAssetURL = oldData.optString(X_BUTTON);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(xButton) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, xButton);
                    }
                    oldAssetURL = oldData.optString(FEED_BUTTON);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(feedButton) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, feedButton);
                    }
                } else {
                    result = AssetUtil.createAssetFile(context, parentalLockActive);
                    if (result == true) {
                        result = AssetUtil.createAssetFile(context, parentalLockNotActive);
                    }
                    if (result == true) {
                        result = AssetUtil.createAssetFile(context, animationURL);
                    }
                    if (result == true) {
                        result = AssetUtil.createAssetFile(context, nexthButton);
                    }
                    if (result == true) {
                        result = AssetUtil.createAssetFile(context, previousButton);
                    }
                    if (result == true) {
                        result = AssetUtil.createAssetFile(context, aboutKidozButton);
                    }
                    if (result == true) {
                        result = AssetUtil.createAssetFile(context, backgroundImage);
                    }
                    if (result == true) {
                        result = AssetUtil.createAssetFile(context, xButton);
                    }
                    if (result == true) {
                        result = AssetUtil.createAssetFile(context, feedButton);
                    }
                }
                // 4. Update database
                if (result == true) {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(FeedView.TAG, jsonObject);
                }
            } catch (Exception ex) {
                result = false;
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(KidozBanner.TAG, "Error when trying to parse family feed properties: " + ex.getMessage());
            }
        }
        return result;
    }
}
