package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Point;
import android.view.View;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.custom_drawables.DefaultPanelDrawable;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;

import java.io.File;

/**
 * Created by Eugine on 12/10/2015.
 */
class PanelHandle extends RelativeLayout {

    public enum PANEL_HANDLE_VIEW_STATE {
        OPENED, CLOSED
    }

    private static final float DEFAULT_HANDLE_SCALE_SIZE = 0.15f;
    private AssetView mOpenAssetView;
    private AssetView mCloseAssetView;
    private RelativeLayout.LayoutParams mInnerOpenBtnLayParams;
    private RelativeLayout.LayoutParams mInnerCloseBtnLayParams;

    private DefaultPanelDrawable mCloseDefaultDrawable;
    private DefaultPanelDrawable mOpenedDefaultDrawable;

    private int mHandleSize = 0;
    private PANEL_TYPE mPanelType;
    private int mAnimType = 1;
    private int mColor = Color.WHITE;

    private IOnPanelHandleClickListener mClickListener;
    private PANEL_HANDLE_VIEW_STATE mPanelHandleViewState;

    public PanelHandle(Context context, PANEL_TYPE panelType, int animationType, int size, IOnPanelHandleClickListener handleClickListener) {
        super(context);
        mHandleSize = size;
        mPanelType = panelType;
        mClickListener = handleClickListener;
        mAnimType = animationType;
        initHandle();
    }

    private void initHandle() {

        if (mHandleSize == 0) {
            Point point = Utils.getScreenSize(getContext());
            mHandleSize = (int) (Math.min(point.x, point.y) * DEFAULT_HANDLE_SCALE_SIZE);
        }

        mInnerOpenBtnLayParams = new LayoutParams(mHandleSize, mHandleSize);
        mInnerCloseBtnLayParams = new LayoutParams(mHandleSize, mHandleSize);

        mOpenAssetView = new AssetView(getContext());
        mOpenAssetView.setVisibility(View.INVISIBLE);
        mCloseAssetView = new AssetView(getContext());
        mCloseAssetView.setVisibility(View.INVISIBLE);

        addView(mOpenAssetView, mInnerOpenBtnLayParams);
        addView(mCloseAssetView, mInnerCloseBtnLayParams);

        setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                playHandleClickAnimation(v);
            }
        });
    }


    public void loadAssets(File openedViewAsset, final File closedViewAsset, final IonPanelHandlePreparedListener listener) {

        mCloseDefaultDrawable = new DefaultPanelDrawable(getContext(), mPanelType, DefaultPanelDrawable.PanelDrawableType.CLOSED_VIEW);
        mOpenedDefaultDrawable = new DefaultPanelDrawable(getContext(), mPanelType, DefaultPanelDrawable.PanelDrawableType.OPENED_VIEW);

        mCloseDefaultDrawable.setBaseColor(mColor);
        mOpenedDefaultDrawable.setBaseColor(mColor);

        if (openedViewAsset != null) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(openedViewAsset.getAbsolutePath(), options);
            if (options.outHeight != 0 && options.outWidth != 0) {
                float ratio = options.outHeight / ((float) options.outWidth);
                int size = (int) (mHandleSize * ratio);
                if (size != 0) {
                    mInnerOpenBtnLayParams.height = size;
                }
            }
        }

        if (closedViewAsset != null) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(closedViewAsset.getAbsolutePath(), options);
            if (options.outHeight != 0 && options.outWidth != 0) {
                float ratio = options.outHeight / ((float) options.outWidth);
                int size = (int) (mHandleSize * ratio);
                if (size != 0) {
                    mInnerCloseBtnLayParams.height = size;
                }
            }
        }

        mOpenAssetView.loadAsset(openedViewAsset, mCloseDefaultDrawable, new AssetView.IOnAssetLoadedListener() {
            @Override
            public void onAssetLoaded(boolean successfull) {
                mCloseAssetView.loadAsset(closedViewAsset, mOpenedDefaultDrawable, new AssetView.IOnAssetLoadedListener() {
                    @Override
                    public void onAssetLoaded(boolean successfull) {
                        listener.onPanelPrepared();
                    }
                });
            }
        });
    }


    public void setBaseColor(int baseColor) {
        mColor = baseColor;
        if (mCloseDefaultDrawable != null && mOpenedDefaultDrawable != null) {
            mCloseDefaultDrawable.setBaseColor(baseColor);
            mOpenedDefaultDrawable.setBaseColor(baseColor);
        }
        mOpenAssetView.postInvalidate();
        mCloseAssetView.postInvalidate();
    }


    public void setPanelType(PANEL_TYPE panelType) {
        mPanelType = panelType;
        if (mCloseDefaultDrawable != null && mOpenedDefaultDrawable != null) {
            mOpenedDefaultDrawable.setPanelType(mPanelType);
            mCloseDefaultDrawable.setPanelType(mPanelType);
        }
        mOpenAssetView.postInvalidate();
        mCloseAssetView.postInvalidate();

       /* mInnerCloseBtnLayParams = new RelativeLayout.LayoutParams(mHandleSize, mCloseSize);
        mInnerOpenBtnLayParams = new RelativeLayout.LayoutParams(mHandleSize, mOpenSize);

        switch (mPanelType) {
            case BOTTOM: {

                mInnerCloseBtnLayParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                mInnerOpenBtnLayParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                break;
            }
            case TOP: {

                mInnerOpenBtnLayParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                mInnerOpenBtnLayParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                break;
            }
            case LEFT: {
                mInnerOpenBtnLayParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                mInnerOpenBtnLayParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                break;
            }
            case RIGHT: {
                mInnerOpenBtnLayParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                mInnerOpenBtnLayParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                break;
            }
        }

        mOpenAssetView.setLayoutParams(mInnerOpenBtnLayParams);
        mCloseAssetView.setLayoutParams(mInnerCloseBtnLayParams);*/
    }


    public interface IOnPanelHandleClickListener {
        public void onHandleClick();
    }


    public void setPanelButtonState(PANEL_HANDLE_VIEW_STATE panelHandleState) {
        mPanelHandleViewState = panelHandleState;

        switch (mPanelHandleViewState) {
            case CLOSED: {
                mOpenAssetView.setVisibility(View.VISIBLE);
                mCloseAssetView.setVisibility(View.INVISIBLE);
                break;
            }

            case OPENED: {
                mOpenAssetView.setVisibility(View.INVISIBLE);
                mCloseAssetView.setVisibility(View.VISIBLE);
                break;
            }
        }
        postInvalidate();
    }

    private void playHandleClickAnimation(View v) {
        switch (mAnimType) {
            case 1: {
                GenAnimator.playPanelButtonClickAnimation(v, mPanelType, new Animator.AnimatorListener() {
                    @Override
                    public void onAnimationStart(Animator animation) {
                    }

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        if (mClickListener != null) {
                            mClickListener.onHandleClick();
                        }
                    }

                    @Override
                    public void onAnimationCancel(Animator animation) {
                    }

                    @Override
                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                break;
            }
            default: {
                GenAnimator.playPanelButtonClickAnimation(v, mPanelType, new Animator.AnimatorListener() {
                    @Override
                    public void onAnimationStart(Animator animation) {
                    }

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        if (mClickListener != null) {
                            mClickListener.onHandleClick();
                        }
                    }

                    @Override
                    public void onAnimationCancel(Animator animation) {
                    }

                    @Override
                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                break;
            }
        }
    }


    public interface IonPanelHandlePreparedListener {
        void onPanelPrepared();
    }
}
