package com.kidoz.sdk.api.ui_views.kidoz_banner;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.ContentExecutionHandler;
import com.kidoz.sdk.api.ContentLogicLoader;
import com.kidoz.sdk.api.KidozBanner;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.AssetUtil;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SdkSoundManager;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.one_item_view.AutoScrollViewPager;
import com.kidoz.sdk.api.ui_views.one_item_view.InfinitePagerAdapter;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;

import org.json.JSONObject;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

/**
 * Created by RonyBrosh on 12/7/2015.
 */
public class KidozBanner2 extends BaseBanner
{
    private final String TAG = KidozBanner2.class.getSimpleName();
    private final int AUTO_SCROLL_DELAY = 10000;

    private RelativeLayout mContainer;
    private RelativeLayout mKidozRelatedContainer;
    private RelativeLayout mActualyBannerRelatedContainer;
    private AssetView mParentalLockButton;
    private AssetView mAboutButton;
    private AssetView mNextButton;
    private AssetView mPreviousButton;
    private AssetView mGifView;

    private AutoScrollViewPager mViewPager;
    private BannerViewPagerAdapter mAdapter;
    private TextView mKidozLabelTextView;
    private TextView mAppNameTextView;
    private HashMap<String, Integer> mSponsoredContentDisplayed = new HashMap<String, Integer>();
    private ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;

    private ContentLogicLoader mContentLogicLoader;
    private Utils.StaticHandler mStaticHandler;

    private AnimationHandler mAnimationHandler;
    private WalkAndPushAnimationHandler mWalkAndPushAnimationHandler;
    private String mStyleID;

    public KidozBanner2(Context context)
    {
        super(context);
    }

    public void setProperties(JSONObject properties)
    {
        mProperties = properties;
        initView();
    }

    @Override
    public void initView()
    {
        super.initView();
        initSoundManager();
        mStyleID = mProperties.optString(STYLE_ID);
        try
        {
            if (mIsOverrideUser == true)
            {
                mIsSmartBanner = mProperties.optBoolean(IS_SMART_BANNER, false);
            }
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to load is smart flag: " + ex.getMessage());
        }
        initContainer();
        initKidozContainer();
        initActualyBannerRelatedContainer();
        initAboutKidozButton();
        initParentalLockButton();
        initKidozText();
        //        initNextButton();
        initViewPager();
        initAnimation();
        initContentLogicLoader();
        initAppNameTextView();
        initWalkAndPushAnimationHandler();
        hideBanner();

        applyContainerParams();
        applyParentalLockParams();
        applyKidozLabelParams();
        applyAboutButtonParams();
        applyActualBannerContainerParams();
        applyAnimationParams();
        //        applyNextButtonsParams();
        //        applyPreviousButtonsParams();
        applyViewPagerParams();
        applyAppNameParams();
    }

    private void initSoundManager()
    {
        File soundFile = AssetUtil.getAssetFile(getContext(), mProperties.optString(POP_SOUND));
        if (soundFile != null)
        {
            SdkSoundManager.preloadSound(soundFile.getAbsolutePath());
        }
    }

    private void initThumbnailAnimation()
    {
        if (mAnimationHandler == null)
        {
            mAnimationHandler = new AnimationHandler(mActualyBannerRelatedContainer);
        }
    }

    private void initWalkAndPushAnimationHandler()
    {
        mWalkAndPushAnimationHandler = new WalkAndPushAnimationHandler(AssetUtil.getAssetFile(getContext(), mProperties.optString(POP_SOUND)), mGifView, mViewPager);
    }

    @Override
    public void loadContent()
    {
        super.loadContent();
        mContentLogicLoader.loadContent(getContext(), WidgetType.WIDGET_TYPE_BANNER.getStringValue(), mStyleID);
    }

    private void initKidozContainer()
    {
        mKidozRelatedContainer = new RelativeLayout(getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
        params.topMargin = (int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2, getResources().getDisplayMetrics()));
        params.bottomMargin = (int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2, getResources().getDisplayMetrics()));
        params.leftMargin = (int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2, getResources().getDisplayMetrics()));
        mContainer.addView(mKidozRelatedContainer, params);
    }

    private void initActualyBannerRelatedContainer()
    {
        mActualyBannerRelatedContainer = new RelativeLayout(getContext());
        mActualyBannerRelatedContainer.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());

        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_1, "#39b0c5")), Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_2, "#39b0c5"))});
        gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 10f, getResources().getDisplayMetrics())));
        if (Build.VERSION.SDK_INT >= 16)
        {
            mActualyBannerRelatedContainer.setBackground(gradientDrawable);
        }
        else
        {
            mActualyBannerRelatedContainer.setBackgroundDrawable(gradientDrawable);
        }
        float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 200, getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 46, getResources().getDisplayMetrics());

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int) width, (int) height);
        params.addRule(RelativeLayout.CENTER_IN_PARENT);
        mContainer.addView(mActualyBannerRelatedContainer, params);
        mActualyBannerRelatedContainer.setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(final View v)
            {
                v.setClickable(false);
                GenAnimator.animateLongDurationClick(v, 100, new GenAnimator.ViewAnimationListener()
                {
                    @Override
                    public void onAnimationEnd()
                    {
                        v.setClickable(true);
                        if (mViewPager != null && mAdapter != null && mAdapter.isAdapterEmpty() == false)
                        {
                            int pos = mViewPager.getCurrentItem() % mAdapter.getCount();
                            if (pos < mAdapter.getCount())
                            {
                                handleClick(mAdapter.getContentItem(pos), pos);
                            }
                        }
                    }

                    @Override
                    public void onAnimationStart()
                    {

                    }
                });
            }
        });
        //        mActualyBannerRelatedContainer.setOnTouchListener(new OnTouchListener()
        //        {
        //            @Override
        //            public boolean onTouch(View view, MotionEvent motionEvent)
        //            {
        //                if (mViewPager != null && mAdapter != null && mAdapter.isAdapterEmpty() == false)
        //                {
        //                    int pos = mViewPager.getCurrentItem() % mAdapter.getCount();
        //                    if (pos < mAdapter.getCount())
        //                    {
        //                        handleClick(mAdapter.getContentItem(pos), pos);
        //                    }
        //                }
        //
        //                return true;
        //            }
        //        });
    }

    private void initAboutKidozButton()
    {
        mAboutButton = new AssetView(getContext());
        mAboutButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mAboutButton.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());

        String clickAnimation = mProperties.optString(ABOUT_KIDOZ_ANIMATION);
        if (clickAnimation != null)
        {
            if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true)
            {
                mAboutButton.setOnClickListener(new OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        mAboutButton.setClickable(false);
                        GenAnimator.clickItemAnimation(mAboutButton, 150, new GenAnimator.ViewAnimationListener()
                        {
                            @Override
                            public void onAnimationEnd()
                            {
                                mAboutButton.setClickable(true);
                                int[] popLocation = new int[2];
                                popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                                popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                                AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(getContext(), popLocation);
                                aboutKidozDialog.openDialog();
                            }

                            @Override
                            public void onAnimationStart()
                            {

                            }
                        });
                    }
                });
            }
        }

        int padding = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 10, getResources().getDisplayMetrics());
        mAboutButton.setPadding(padding, padding, padding, 0);


        float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int) width, (int) height);
        params.addRule(RelativeLayout.CENTER_HORIZONTAL);
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);

        mKidozRelatedContainer.addView(mAboutButton, params);
        mAboutButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(ABOUT_KIDOZ)), new AssetView.IOnAssetLoadedListener()
        {
            @Override
            public void onAssetLoaded(boolean successfull)
            {
                autoOpen();
            }
        });
    }

    private void initAnimation()
    {
        mGifView = new AssetView(getContext());
        mGifView.setScaleType(ImageView.ScaleType.FIT_END);
        float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 135, getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int) width, (int) height);
        params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
        params.leftMargin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 15, getResources().getDisplayMetrics());
        mActualyBannerRelatedContainer.addView(mGifView, params);

        mGifView.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(PROMOTION_ANIMATION)), new AssetView.IOnAssetLoadedListener()
        {
            @Override
            public void onAssetLoaded(boolean successfull)
            {
                autoOpen();
            }
        });
    }


    private void initNextButton()
    {
        mNextButton = new AssetView(getContext());
        mNextButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        mNextButton.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());

        float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
        float margin = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int) width, (int) height);
        params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        params.rightMargin = (int) margin;
        mActualyBannerRelatedContainer.addView(mNextButton, params);

        String clickAnimation = mProperties.optString(NEXT_BUTTON_ANIMATION);
        if (clickAnimation != null)
        {
            if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true)
            {
                mNextButton.setOnClickListener(new OnClickListener()
                {
                    @Override
                    public void onClick(View v)
                    {
                        mNextButton.setClickable(false);
                        SdkAnimationsUtils.animateClick(mNextButton, new Animator.AnimatorListener()
                        {
                            @Override
                            public void onAnimationStart(Animator animation)
                            {

                            }

                            @Override
                            public void onAnimationEnd(Animator animation)
                            {
                                mNextButton.setClickable(true);
                                mViewPager.setCurrentItem(mViewPager.getCurrentItem() + 1);
                            }

                            @Override
                            public void onAnimationCancel(Animator animation)
                            {

                            }

                            @Override
                            public void onAnimationRepeat(Animator animation)
                            {

                            }
                        });
                    }
                });
            }
        }

        mNextButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(NEXT_BUTTON)), new AssetView.IOnAssetLoadedListener()
        {
            @Override
            public void onAssetLoaded(boolean successfull)
            {
                autoOpen();
            }
        });


        mPreviousButton = new AssetView(getContext());
        mPreviousButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        mPreviousButton.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        params = new RelativeLayout.LayoutParams((int) width, (int) height);
        params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
        params.leftMargin = (int) margin;
        mActualyBannerRelatedContainer.addView(mPreviousButton, params);

        clickAnimation = mProperties.optString(PREVIOUS_BUTTON_ANIMATION);
        if (clickAnimation != null)
        {
            if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true)
            {
                mPreviousButton.setOnClickListener(new OnClickListener()
                {
                    @Override
                    public void onClick(View v)
                    {
                        mPreviousButton.setClickable(false);
                        SdkAnimationsUtils.animateClick(mPreviousButton, new Animator.AnimatorListener()
                        {
                            @Override
                            public void onAnimationStart(Animator animation)
                            {

                            }

                            @Override
                            public void onAnimationEnd(Animator animation)
                            {
                                mPreviousButton.setClickable(true);
                                mViewPager.setCurrentItem(mViewPager.getCurrentItem() - 1);
                            }

                            @Override
                            public void onAnimationCancel(Animator animation)
                            {

                            }

                            @Override
                            public void onAnimationRepeat(Animator animation)
                            {

                            }
                        });
                    }
                });
            }
        }
        mPreviousButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(PREVIOUS_BUTTON)), new AssetView.IOnAssetLoadedListener()
        {
            @Override
            public void onAssetLoaded(boolean successfull)
            {
                autoOpen();
            }
        });
    }

    private void initContentLogicLoader()
    {
        mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback()
        {
            @Override
            public void onDataReady(ContentData contentData)
            {
                if (contentData != null)
                {
                    setContent(contentData.getContentDataItems());
                    initThumbnailAnimation();
                    startHandlers();
                }
            }

            @Override
            public void onLoadContentFailed()
            {
                if (mKidozBannerListener != null)
                {
                    mKidozBannerListener.onBannerContentLoadFailed();
                }
            }
        });
    }

    private void initContainer()
    {
        mContainer = new RelativeLayout(getContext());
        try
        {
            GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor(mProperties.optString(BACKGROUND_GRADIENT_COLOR_1, "#ffffff").trim()), Color.parseColor(mProperties.optString(BACKGROUND_GRADIENT_COLOR_2, "#ffffff").trim())});
            if (Build.VERSION.SDK_INT >= 16)
            {
                mContainer.setBackground(gradientDrawable);
            }
            else
            {
                mContainer.setBackgroundDrawable(gradientDrawable);
            }

        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to initContainer: " + ex.getMessage());
        }
        mContainer.setOnTouchListener(new OnTouchListener()
        {
            @Override
            public boolean onTouch(View view, MotionEvent motionEvent)
            {
                return true;
            }
        });

        float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 320, getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int) width, (int) height);
        addView(mContainer, params);
    }

    private void initParentalLockButton()
    {
        mParentalLockButton = new AssetView(getContext());
        mParentalLockButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mParentalLockButton.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        String clickAnimation = mProperties.optString(LOCK_ANIMATION);
        if (clickAnimation != null)
        {
            if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true)
            {
                mParentalLockButton.setOnClickListener(new OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        mParentalLockButton.setClickable(false);
                        GenAnimator.clickItemAnimation(mParentalLockButton, 150, new GenAnimator.ViewAnimationListener()
                        {
                            @Override
                            public void onAnimationEnd()
                            {
                                mParentalLockButton.setClickable(true);
                                if (ParentalLockDialog.getIsCanShowDialog(getContext()) == true)
                                {
                                    int[] popLocation = new int[2];
                                    popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                                    popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                                    ParentalLockDialog parentalLockDialog = new ParentalLockDialog(getContext(), false, popLocation);
                                    parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener()
                                    {
                                        @Override
                                        public void onDismiss(DialogInterface dialog)
                                        {
                                            //Refresh the parental lock icon
                                            updateLockIcon();
                                        }
                                    });
                                    parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener()
                                    {
                                        @Override
                                        public void onPasswordEntered(boolean isPasswordCorrect)
                                        {
                                            updateLockIcon();
                                        }
                                    });
                                    parentalLockDialog.show();
                                }
                            }

                            @Override
                            public void onAnimationStart()
                            {

                            }
                        });
                    }
                });
            }
        }

        int padding = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 10, getResources().getDisplayMetrics());
        mParentalLockButton.setPadding(padding, padding, padding, padding);
        float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int) width, (int) height);
        params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        mContainer.addView(mParentalLockButton, params);

        updateLockIcon();
    }

    private void updateLockIcon()
    {
        try
        {
            boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
            if (isLockActive == true)
            {
                mParentalLockButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(LOCK_ACTIVE)), new AssetView.IOnAssetLoadedListener()
                {
                    @Override
                    public void onAssetLoaded(boolean successfull)
                    {
                        autoOpen();
                    }
                });
            }
            else
            {
                mParentalLockButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(LOCK_NOT_ACTIVE)), new AssetView.IOnAssetLoadedListener()
                {
                    @Override
                    public void onAssetLoaded(boolean successfull)
                    {
                        autoOpen();
                    }
                });
            }
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to load parental lock image: " + ex.getMessage());
        }
    }

    private void initKidozText()
    {
        mKidozLabelTextView = new TextView(getContext());
        mKidozLabelTextView.setTextColor(Color.parseColor(mProperties.optString(LABEL_COLOR).trim()));
        mKidozLabelTextView.setShadowLayer(20f, 0f, 0f, Color.parseColor("#80000000"));
        mKidozLabelTextView.setText(mProperties.optString(LABEL_TEXT));
        mKidozLabelTextView.setEllipsize(TextUtils.TruncateAt.END);
        mKidozLabelTextView.setGravity(Gravity.CENTER);
        mKidozLabelTextView.setTextSize(TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, 2.2f, getResources().getDisplayMetrics()));
        mKidozLabelTextView.setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(View view)
            {
                mAboutButton.performClick();
            }
        });
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.CENTER_HORIZONTAL);
        params.addRule(RelativeLayout.ALIGN_PARENT_TOP);
        mKidozRelatedContainer.addView(mKidozLabelTextView, params);
    }

    private void initAppNameTextView()
    {
        mAppNameTextView = new TextView(getContext());
        mAppNameTextView.setTextColor(Color.parseColor(mProperties.optString(APP_NAME_COLOR, "#ffffff").trim()));
        mAppNameTextView.setShadowLayer(20f, 0f, 0f, Color.parseColor("#80000000"));
        mAppNameTextView.setGravity(Gravity.CENTER);
        mAppNameTextView.setEllipsize(TextUtils.TruncateAt.END);
        mAppNameTextView.setTextSize(TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, 2.2f, getResources().getDisplayMetrics()));
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.CENTER_HORIZONTAL);
        params.addRule(RelativeLayout.ALIGN_PARENT_TOP);
        mContainer.addView(mAppNameTextView, params);
    }

    private void initViewPager()
    {
        mViewPager = new AutoScrollViewPager(getContext());

        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.WHITE, Color.WHITE});
        gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 4f, getResources().getDisplayMetrics())));
        if (Build.VERSION.SDK_INT >= 16)
        {
            mViewPager.setBackground(gradientDrawable);
        }
        else
        {
            mViewPager.setBackgroundDrawable(gradientDrawable);
        }
        mViewPager.setInterval(AUTO_SCROLL_DELAY);
        mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener()
        {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels)
            {

            }

            @Override
            public void onPageSelected(int position)
            {
                sendImpressionLog(position % mAdapter.getCount());
                setAppName(mAdapter.getContentItem(position % mAdapter.getCount()));
            }

            @Override
            public void onPageScrollStateChanged(int state)
            {

            }
        });
        mViewPager.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        int margin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 1);
        mViewPager.setPadding(margin, margin, margin, margin);

        margin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 6);
        mViewPager.setPageMargin(margin);

        float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 44, getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 44, getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int) width, (int) height);
        params.addRule(RelativeLayout.CENTER_IN_PARENT);
        mActualyBannerRelatedContainer.addView(mViewPager, params);

        mViewPagerItemClickListener = new ItemViewPagerAdapter.ViewPagerItemClickListener()
        {
            @Override
            public void onClickEnd(ContentItem contentItem, int position)
            {
                handleClick(contentItem, position);
            }
        };
    }


    private void handleClick(ContentItem contentItem, int position)
    {
        if (contentItem != null && mAllowClickHandling)
        {
            mAllowClickHandling = false;
            ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, WidgetType.WIDGET_TYPE_BANNER.getStringValue(), mStyleID, position, true, false, new ContentExecutionHandler.IOnHandleClickListener()
            {
                @Override
                public void onRestoreClick()
                {
                    mAllowClickHandling = true;
                }
            });
        }
    }


    @Override
    protected void onWindowVisibilityChanged(int visibility)
    {
        super.onWindowVisibilityChanged(visibility);
        if (mViewPager != null)
        {
            if (visibility == VISIBLE)
            {
                startHandlers();
            }
            else
            {
                stopHandlers();
            }
        }
    }

    private void sendImpressionLog(int position)
    {
        ContentItem contentItem = mAdapter.getContentItem(position);
        if (contentItem != null && contentItem.isPromoted() == true)
        {
            if (mSponsoredContentDisplayed != null)
            {
                if (mSponsoredContentDisplayed.containsKey(contentItem.getId()) == false)
                {
                    mSponsoredContentDisplayed.put(contentItem.getId(), position);
                    EventManager.getInstance(getContext()).logSponsoredContentImpressionEvent(getContext(), WidgetType.WIDGET_TYPE_BANNER.getStringValue(), mStyleID, EventParameters.ACTION_IMPRESSION, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position, false);
                }
            }
        }
    }

    private void setContent(ArrayList<ContentItem> content)
    {
        mSponsoredContentDisplayed.clear();

        mAdapter = new BannerViewPagerAdapter(getContext(), true);
        mAdapter.setViewPagerItemClickListener(mViewPagerItemClickListener);
        mAdapter.setContent(content);
        PagerAdapter wrappedAdapter = new InfinitePagerAdapter(mAdapter);
        mViewPager.setAdapter(wrappedAdapter);
        mViewPager.startAutoScroll(AUTO_SCROLL_DELAY);

        if (content != null && content.isEmpty() == false)
        {
            mViewPager.setCurrentItem(0);
            sendImpressionLog(0);
            setAppName(content.get(0));
        }
    }

    @Override
    public boolean getIsCanOpen()
    {
        boolean result = false;
        if (mParentalLockButton != null && mAboutButton != null && mGifView != null)
        {
            result = mParentalLockButton.getIsAssetLoaded() && mAboutButton.getIsAssetLoaded() && mGifView.getIsAssetLoaded();

        }
        return result;
    }

    @Override
    public void showBanner()
    {
        super.showBanner();
        if (getVisibility() != View.VISIBLE && getIsCanOpen() == true)
        {
            GenAnimator.fade(true, this, 400, null);
            setVisibility(View.VISIBLE);
            if (mKidozBannerListener != null)
            {
                mKidozBannerListener.onBannerShow();
            }

            if (mViewPager != null)
            {
                if (mAdapter != null && mAdapter.isAdapterEmpty() == false)
                {
                    startHandlers();
                }
                else
                {
                    stopHandlers();
                }
            }
            sendActionWidgetViewImpression();
        }
    }

    @Override
    public void hideBanner()
    {
        super.hideBanner();
        setVisibility(View.GONE);
        if (mKidozBannerListener != null)
        {
            mKidozBannerListener.onBannerHide();
        }
        stopHandlers();
    }

    @Override
    protected void autoOpen()
    {
        if (mIsWaitingToOpen == true && getIsCanOpen() == true)
        {
            showBanner();
        }
    }


    public static final String BACKGROUND_GRADIENT_COLOR_1 = "bgGradientColor1";
    public static final String BACKGROUND_GRADIENT_COLOR_2 = "bgGradientColor2";
    public static final String BACKGROUND_COLOR = "bgColor";
    public static final String LOCK_ACTIVE = "parentalLockActive";
    public static final String LOCK_NOT_ACTIVE = "parentalLockNotActive";
    public static final String LOCK_ANIMATION = "parentalLockAnimation";
    public static final String ABOUT_KIDOZ = "aboutKidoz";
    public static final String ABOUT_KIDOZ_ANIMATION = "aboutKidozAnimation";
    public static final String NEXT_BUTTON = "nextBtn";
    public static final String NEXT_BUTTON_ANIMATION = "nextBtnAnimation";
    public static final String PREVIOUS_BUTTON = "previousBtn";
    public static final String PREVIOUS_BUTTON_ANIMATION = "previousBtnAnimation";
    public static final String PROMOTION_ANIMATION = "animationUrl";
    public static final String PROMOTION_ANIMATION_RATIO = "animationRatio_WH";
    public static final String CONTENT_BACKGROUND_1 = "contentBackground1";
    public static final String CONTENT_BACKGROUND_2 = "contentBackground2";
    public static final String CONTENT_BACKGROUND_STROKE_COLOR = "contentBackgroundStrokeColor";
    public static final String LABEL_TEXT = "labelText";
    public static final String LABEL_COLOR = "labelColor";
    public static final String APP_NAME_COLOR = "appNameColor";
    public static final String IS_SMART_BANNER = "isSmartBanner";
    public static final String POP_SOUND = "banner2PopSound";

    /**
     * Compare new JSON to old JSON, save the updated JSON to database, delete old assets if needed and download new assets.
     *
     * @param context
     * @param jsonObject
     */
    public static boolean parseKidozBanner(Context context, JSONObject jsonObject)
    {
        boolean result = false;
        if (jsonObject != null)
        {
            try
            {
                // 1. Extract elements.
                jsonObject.put(KidozBanner.TAG, KidozBanner2.class.getSimpleName());

                // View background based on 2 colors gradient
                String backgroundColor = jsonObject.optString(BACKGROUND_COLOR);

                // Parental lock contains 2 states: active and not active, click animation and image ratio
                String parentalLockActive = jsonObject.optString(LOCK_ACTIVE);
                String parentalLockNotActive = jsonObject.optString(LOCK_NOT_ACTIVE);
                String parentalLockAnimation = jsonObject.optString(LOCK_ANIMATION);

                // About KIDOZ button contains image click animation and image ratio
                String aboutKidozButton = jsonObject.optString(ABOUT_KIDOZ);
                String aboutKidozButtonAnimation = jsonObject.optString(ABOUT_KIDOZ_ANIMATION);

                // Next button contain ration and click animation
                String nexthButton = jsonObject.optString(NEXT_BUTTON);
                String nextButtonAnimation = jsonObject.optString(NEXT_BUTTON_ANIMATION);

                // Previous button contain ration and click animation
                String previousButton = jsonObject.optString(PREVIOUS_BUTTON);
                String previousButtonAnimation = jsonObject.optString(PREVIOUS_BUTTON_ANIMATION);

                // Promotion animation
                String animationURL = jsonObject.optString(PROMOTION_ANIMATION);

                // Promotions label contains text and color
                String kidozLabelText = jsonObject.optString(LABEL_TEXT);
                String kidozLabelColor = jsonObject.optString(LABEL_COLOR);

                // Pop sound
                String popSoundURL = jsonObject.optString(POP_SOUND);


                // 2. Load old data from database
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(KidozBanner.TAG);

                // 3. Compare assets, download and save if necessary
                if (oldData != null)
                {
                    result = true;
                    String oldAssetURL = oldData.optString(LOCK_ACTIVE);
                    if (oldAssetURL == null || oldAssetURL.equals(parentalLockActive) == false || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false)
                    {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, parentalLockActive);
                    }
                    oldAssetURL = oldData.optString(LOCK_NOT_ACTIVE);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(parentalLockNotActive) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false)
                    {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, parentalLockNotActive);
                    }
                    oldAssetURL = oldData.optString(PROMOTION_ANIMATION);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(animationURL) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false)
                    {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, animationURL);
                    }
                    oldAssetURL = oldData.optString(POP_SOUND);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(popSoundURL) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false)
                    {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, popSoundURL);
                    }
                    oldAssetURL = oldData.optString(NEXT_BUTTON);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(nexthButton) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false)
                    {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, nexthButton);
                    }
                    oldAssetURL = oldData.optString(PREVIOUS_BUTTON);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(previousButton) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false)
                    {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, previousButton);
                    }
                    oldAssetURL = oldData.optString(ABOUT_KIDOZ);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(aboutKidozButton) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false)
                    {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, aboutKidozButton);
                    }
                }
                else
                {
                    result = AssetUtil.createAssetFile(context, parentalLockActive);
                    if (result == true)
                    {
                        result = AssetUtil.createAssetFile(context, parentalLockNotActive);
                    }
                    if (result == true)
                    {
                        result = AssetUtil.createAssetFile(context, animationURL);
                    }
                    if (result == true)
                    {
                        result = AssetUtil.createAssetFile(context, nexthButton);
                    }
                    if (result == true)
                    {
                        result = AssetUtil.createAssetFile(context, previousButton);
                    }
                    if (result == true)
                    {
                        result = AssetUtil.createAssetFile(context, aboutKidozButton);
                    }
                    if (result == true)
                    {
                        result = AssetUtil.createAssetFile(context, popSoundURL);
                    }
                }
                // 4. Update database
                if (result == true)
                {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(KidozBanner.TAG, jsonObject);
                }
            }
            catch (Exception ex)
            {
                result = false;
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(KidozBanner.TAG, "Error when trying to parse kidoz banner2 properties: " + ex.getMessage());
            }
        }
        return result;
    }


    @Override
    protected void onDetachedFromWindow()
    {
        stopHandlers();
        super.onDetachedFromWindow();
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);

        applyContainerParams();
        applyParentalLockParams();
        applyKidozLabelParams();
        applyAboutButtonParams();
        applyActualBannerContainerParams();
        applyAnimationParams();
        //        applyNextButtonsParams();
        //        applyPreviousButtonsParams();
        applyViewPagerParams();
        applyAppNameParams();
        if (mAdapter != null)
        {
            mAdapter.notifyDataSetChanged();
        }
        stopHandlers();
        startHandlers();
    }

    @Override
    public void setIsSmartBanner(boolean isSmartBanner)
    {
        super.setIsSmartBanner(isSmartBanner);
        try
        {
            if (mIsOverrideUser == true)
            {
                mIsSmartBanner = mProperties.optBoolean(IS_SMART_BANNER);
            }
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to load is smart flag: " + ex.getMessage());
        }
        applyContainerParams();
        applyParentalLockParams();
        applyKidozLabelParams();
        applyAboutButtonParams();
        applyActualBannerContainerParams();
        applyAnimationParams();
        //        applyNextButtonsParams();
        //        applyPreviousButtonsParams();
        applyViewPagerParams();
        applyAppNameParams();
    }

    private void applyContainerParams()
    {
        if (mIsSmartBanner == true)
        {
            mContainer.getLayoutParams().width = RelativeLayout.LayoutParams.MATCH_PARENT;
            int screenHeightDP = getContext().getResources().getConfiguration().screenHeightDp;
            int height;
            if (screenHeightDP <= 400)
            {
                height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 32, getResources().getDisplayMetrics());

            }
            else if (screenHeightDP > 400 && screenHeightDP <= 720)
            {
                height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
            }
            else
            {
                height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 90, getResources().getDisplayMetrics());
            }
            mContainer.getLayoutParams().height = height;
        }
        else
        {
            mContainer.getLayoutParams().width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 320, getResources().getDisplayMetrics());
            mContainer.getLayoutParams().height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
        }
    }

    private void applyParentalLockParams()
    {
        if (mIsSmartBanner == true)
        {
            int screenHeightDP = getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400)
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                    int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.addRule(RelativeLayout.CENTER_VERTICAL);
                    params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                    params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 20, getResources().getDisplayMetrics());
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 20, getResources().getDisplayMetrics());
                    params.rightMargin = margin;
                    mParentalLockButton.setPadding(0, 0, 0, 0);
                    mParentalLockButton.setLayoutParams(params);
                }
                else
                {
                    // Tablet
                }
            }
            else if (screenHeightDP > 400 && screenHeightDP <= 720)
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                    int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 10, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.addRule(RelativeLayout.CENTER_VERTICAL);
                    params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                    params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                    params.rightMargin = margin;
                    mParentalLockButton.setPadding(0, 0, 0, 0);
                    mParentalLockButton.setLayoutParams(params);
                }
                else
                {
                    // Tablet
                    int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 10, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.addRule(RelativeLayout.CENTER_VERTICAL);
                    params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                    params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                    params.rightMargin = margin;
                    mParentalLockButton.setPadding(0, 0, 0, 0);
                    mParentalLockButton.setLayoutParams(params);
                }
            }
            else
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                }
                else
                {
                    // Tablet
                    int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 10, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.addRule(RelativeLayout.CENTER_VERTICAL);
                    params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                    params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 60, getResources().getDisplayMetrics());
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 60, getResources().getDisplayMetrics());
                    params.rightMargin = margin;
                    mParentalLockButton.setPadding(0, 0, 0, 0);
                    mParentalLockButton.setLayoutParams(params);
                }
            }
        }
        else
        {
            if (ScreenUtils.getIsTablet(getContext()) == false)
            {
                // Phone
                int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                params.addRule(RelativeLayout.CENTER_VERTICAL);
                params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                params.rightMargin = margin;
                mParentalLockButton.setPadding(0, 0, 0, 0);
                mParentalLockButton.setLayoutParams(params);
            }
            else
            {
                // Tablet
                int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                params.addRule(RelativeLayout.CENTER_VERTICAL);
                params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                params.rightMargin = margin;
                mParentalLockButton.setPadding(0, 0, 0, 0);
                mParentalLockButton.setLayoutParams(params);
            }
        }
    }

    private void applyKidozLabelParams()
    {
        if (mIsSmartBanner == true)
        {
            int screenHeightDP = getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400)
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                    int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
                    params.addRule(RelativeLayout.RIGHT_OF, mAboutButton.getId());
                    params.addRule(RelativeLayout.CENTER_VERTICAL);
                    params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 80, getResources().getDisplayMetrics());
                    params.leftMargin = margin;
                    mKidozLabelTextView.setTextSize(TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, 3.5f, getResources().getDisplayMetrics()));
                    mKidozLabelTextView.setSingleLine(false);
                    mKidozLabelTextView.setMinLines(2);
                    mKidozLabelTextView.setMaxLines(2);
                    mKidozLabelTextView.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
                    mKidozLabelTextView.setLayoutParams(params);
                }
                else
                {
                    // Tablet
                }
            }
            else if (screenHeightDP > 400 && screenHeightDP <= 720)
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                    int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2, getResources().getDisplayMetrics());
                    int width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
                    params.width = width;
                    params.addRule(RelativeLayout.BELOW, mAboutButton.getId());
                    params.addRule(RelativeLayout.CENTER_HORIZONTAL);
                    params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                    params.topMargin = -margin;
                    mKidozLabelTextView.setTextSize(TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, 2.5f, getResources().getDisplayMetrics()));
                    mKidozLabelTextView.setSingleLine(false);
                    mKidozLabelTextView.setMinLines(1);
                    mKidozLabelTextView.setMaxLines(2);
                    mKidozLabelTextView.setGravity(Gravity.TOP | Gravity.CENTER_HORIZONTAL);
                    mKidozLabelTextView.setLayoutParams(params);
                }
                else
                {
                    // Tablet
                    int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 10, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
                    params.addRule(RelativeLayout.RIGHT_OF, mAboutButton.getId());
                    params.addRule(RelativeLayout.CENTER_VERTICAL);
                    params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 120, getResources().getDisplayMetrics());
                    params.leftMargin = margin;
                    mKidozLabelTextView.setTextSize(TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, 8f, getResources().getDisplayMetrics()));
                    mKidozLabelTextView.setSingleLine(false);
                    mKidozLabelTextView.setMinLines(1);
                    mKidozLabelTextView.setMaxLines(2);
                    mKidozLabelTextView.setGravity(Gravity.TOP | Gravity.LEFT);
                    mKidozLabelTextView.setLayoutParams(params);
                }
            }
            else
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                }
                else
                {
                    // Tablet
                    int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 10, getResources().getDisplayMetrics());
                    int width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 100, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
                    params.width = width;
                    params.addRule(RelativeLayout.BELOW, mAboutButton.getId());
                    params.addRule(RelativeLayout.CENTER_HORIZONTAL);
                    params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                    params.topMargin = -margin;
                    mKidozLabelTextView.setTextSize(TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, 7f, getResources().getDisplayMetrics()));
                    mKidozLabelTextView.setSingleLine(false);
                    mKidozLabelTextView.setMinLines(1);
                    mKidozLabelTextView.setMaxLines(2);
                    mKidozLabelTextView.setGravity(Gravity.TOP | Gravity.CENTER_HORIZONTAL);
                    mKidozLabelTextView.setLayoutParams(params);
                }
            }
        }
        else
        {
            if (ScreenUtils.getIsTablet(getContext()) == false)
            {
                // Phone
                int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2, getResources().getDisplayMetrics());
                int width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
                params.width = width;
                params.addRule(RelativeLayout.BELOW, mAboutButton.getId());
                params.addRule(RelativeLayout.CENTER_HORIZONTAL);
                params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                params.topMargin = -margin;
                mKidozLabelTextView.setTextSize(TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, 2.5f, getResources().getDisplayMetrics()));
                mKidozLabelTextView.setSingleLine(false);
                mKidozLabelTextView.setMinLines(1);
                mKidozLabelTextView.setMaxLines(2);
                mKidozLabelTextView.setGravity(Gravity.TOP | Gravity.CENTER_HORIZONTAL);
                mKidozLabelTextView.setLayoutParams(params);
            }
            else
            {
                // Tablet
                int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2, getResources().getDisplayMetrics());
                int width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
                params.width = width;
                params.addRule(RelativeLayout.BELOW, mAboutButton.getId());
                params.addRule(RelativeLayout.CENTER_HORIZONTAL);
                params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                params.topMargin = -margin;
                mKidozLabelTextView.setTextSize(TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, 3.5f, getResources().getDisplayMetrics()));
                mKidozLabelTextView.setSingleLine(false);
                mKidozLabelTextView.setMinLines(1);
                mKidozLabelTextView.setMaxLines(2);
                mKidozLabelTextView.setGravity(Gravity.TOP | Gravity.CENTER_HORIZONTAL);
                mKidozLabelTextView.setLayoutParams(params);
            }
        }
    }

    private void applyAboutButtonParams()
    {
        if (mIsSmartBanner == true)
        {
            int screenHeightDP = getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400)
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                    int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    mAboutButton.setPadding(0, 0, 0, 0);
                    params.addRule(RelativeLayout.CENTER_VERTICAL);
                    params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                    params.leftMargin = margin;
                    mAboutButton.setLayoutParams(params);
                }
                else
                {
                    // Tablet

                }
            }
            else if (screenHeightDP > 400 && screenHeightDP <= 720)
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    mAboutButton.setPadding(0, 0, 0, 0);
                    params.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                    params.addRule(RelativeLayout.CENTER_HORIZONTAL);
                    params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                    mAboutButton.setLayoutParams(params);
                }
                else
                {
                    // Tablet
                    int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                    params.leftMargin = margin;
                    params.addRule(RelativeLayout.CENTER_VERTICAL);
                    mAboutButton.setPadding(0, 0, 0, 0);
                    mAboutButton.setLayoutParams(params);
                }
            }
            else
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                }
                else
                {
                    // Tablet
                    int padding = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 10, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 70, getResources().getDisplayMetrics());
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 70, getResources().getDisplayMetrics());
                    params.addRule(RelativeLayout.CENTER_HORIZONTAL);
                    params.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                    params.topMargin = -padding;
                    mAboutButton.setPadding(padding, 0, padding, 0);
                    mAboutButton.setLayoutParams(params);
                }
            }
        }
        else
        {
            if (ScreenUtils.getIsTablet(getContext()) == false)
            {
                // Phone
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                mAboutButton.setPadding(0, 0, 0, 0);
                params.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                params.addRule(RelativeLayout.CENTER_HORIZONTAL);
                params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                mAboutButton.setLayoutParams(params);
            }
            else
            {
                // Tablet
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                mAboutButton.setPadding(0, 0, 0, 0);
                params.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                params.addRule(RelativeLayout.CENTER_HORIZONTAL);
                params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                mAboutButton.setLayoutParams(params);
            }
        }
    }

    private void applyActualBannerContainerParams()
    {
        if (mIsSmartBanner == true)
        {
            int screenHeightDP = getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400)
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                    int strokeSize = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 32, getResources().getDisplayMetrics());
                    params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 280, getResources().getDisplayMetrics());
                    params.addRule(RelativeLayout.CENTER_IN_PARENT);
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_1, "#39b0c5")), Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_2, "#39b0c5"))});
                    gradientDrawable.setStroke(strokeSize, Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_STROKE_COLOR, "#ffffff")));
                    gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2f, getResources().getDisplayMetrics())));
                    if (Build.VERSION.SDK_INT >= 16)
                    {
                        mActualyBannerRelatedContainer.setBackground(gradientDrawable);
                    }
                    else
                    {
                        mActualyBannerRelatedContainer.setBackgroundDrawable(gradientDrawable);
                    }
                    mActualyBannerRelatedContainer.setLayoutParams(params);
                    mActualyBannerRelatedContainer.setPadding(strokeSize, strokeSize, strokeSize, strokeSize);
                }
                else
                {
                    // Tablet
                }
            }
            else if (screenHeightDP > 400 && screenHeightDP <= 720)
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                    int strokeSize = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                    params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 200, getResources().getDisplayMetrics());
                    params.addRule(RelativeLayout.CENTER_IN_PARENT);
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_1, "#39b0c5")), Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_2, "#39b0c5"))});
                    gradientDrawable.setStroke(strokeSize, Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_STROKE_COLOR, "#ffffff")));
                    gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2f, getResources().getDisplayMetrics())));
                    if (Build.VERSION.SDK_INT >= 16)
                    {
                        mActualyBannerRelatedContainer.setBackground(gradientDrawable);
                    }
                    else
                    {
                        mActualyBannerRelatedContainer.setBackgroundDrawable(gradientDrawable);
                    }
                    mActualyBannerRelatedContainer.setLayoutParams(params);
                    mActualyBannerRelatedContainer.setPadding(strokeSize, strokeSize, strokeSize, strokeSize);
                }
                else
                {
                    // Tablet
                    int strokeSize = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                    params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 430, getResources().getDisplayMetrics());
                    params.addRule(RelativeLayout.CENTER_IN_PARENT);
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_1, "#39b0c5")), Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_2, "#39b0c5"))});
                    gradientDrawable.setStroke(strokeSize, Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_STROKE_COLOR, "#ffffff")));
                    gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2f, getResources().getDisplayMetrics())));
                    if (Build.VERSION.SDK_INT >= 16)
                    {
                        mActualyBannerRelatedContainer.setBackground(gradientDrawable);
                    }
                    else
                    {
                        mActualyBannerRelatedContainer.setBackgroundDrawable(gradientDrawable);
                    }
                    mActualyBannerRelatedContainer.setLayoutParams(params);
                    mActualyBannerRelatedContainer.setPadding(strokeSize, strokeSize, strokeSize, strokeSize);
                }
            }
            else
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                }
                else
                {
                    // Tablet
                    int strokeSize = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 90, getResources().getDisplayMetrics());
                    params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 310, getResources().getDisplayMetrics());
                    params.addRule(RelativeLayout.CENTER_IN_PARENT);
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_1, "#39b0c5")), Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_2, "#39b0c5"))});
                    gradientDrawable.setStroke(strokeSize, Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_STROKE_COLOR, "#ffffff")));
                    gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2f, getResources().getDisplayMetrics())));
                    if (Build.VERSION.SDK_INT >= 16)
                    {
                        mActualyBannerRelatedContainer.setBackground(gradientDrawable);
                    }
                    else
                    {
                        mActualyBannerRelatedContainer.setBackgroundDrawable(gradientDrawable);
                    }
                    mActualyBannerRelatedContainer.setLayoutParams(params);
                    mActualyBannerRelatedContainer.setPadding(strokeSize, strokeSize, strokeSize, strokeSize);
                }
            }
        }
        else
        {
            if (ScreenUtils.getIsTablet(getContext()) == false)
            {
                // Phone
                int strokeSize = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2, getResources().getDisplayMetrics());
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 170, getResources().getDisplayMetrics());
                params.addRule(RelativeLayout.CENTER_IN_PARENT);
                GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_1, "#39b0c5")), Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_2, "#39b0c5"))});
                gradientDrawable.setStroke(strokeSize, Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_STROKE_COLOR, "#ffffff")));
                gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2f, getResources().getDisplayMetrics())));
                if (Build.VERSION.SDK_INT >= 16)
                {
                    mActualyBannerRelatedContainer.setBackground(gradientDrawable);
                }
                else
                {
                    mActualyBannerRelatedContainer.setBackgroundDrawable(gradientDrawable);
                }
                mActualyBannerRelatedContainer.setLayoutParams(params);
                mActualyBannerRelatedContainer.setPadding(strokeSize, strokeSize, strokeSize, strokeSize);
            }
            else
            {
                // Tablet
                int strokeSize = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2, getResources().getDisplayMetrics());
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                params.width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 180, getResources().getDisplayMetrics());
                params.addRule(RelativeLayout.CENTER_IN_PARENT);
                GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_1, "#39b0c5")), Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_2, "#39b0c5"))});
                gradientDrawable.setStroke(strokeSize, Color.parseColor(mProperties.optString(CONTENT_BACKGROUND_STROKE_COLOR, "#ffffff")));
                gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2f, getResources().getDisplayMetrics())));
                if (Build.VERSION.SDK_INT >= 16)
                {
                    mActualyBannerRelatedContainer.setBackground(gradientDrawable);
                }
                else
                {
                    mActualyBannerRelatedContainer.setBackgroundDrawable(gradientDrawable);
                }
                mActualyBannerRelatedContainer.setLayoutParams(params);
                mActualyBannerRelatedContainer.setPadding(strokeSize, strokeSize, strokeSize, strokeSize);
            }
        }
    }

    private void applyAnimationParams()
    {
        float animationRatio = (float) mProperties.optDouble(PROMOTION_ANIMATION_RATIO, 0.6f);
        if (mIsSmartBanner == true)
        {
            int screenHeightDP = getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400)
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.addRule(ALIGN_PARENT_LEFT);
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 32, getResources().getDisplayMetrics());
                    params.width = (int) (animationRatio * params.height);
                    mGifView.setLayoutParams(params);
                    mWalkAndPushAnimationHandler.setDistance(params.width, mActualyBannerRelatedContainer.getLayoutParams().width);
                }
                else
                {
                    // Tablet
                }
            }
            else if (screenHeightDP > 400 && screenHeightDP <= 720)
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.addRule(ALIGN_PARENT_LEFT);
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                    params.width = (int) (animationRatio * params.height);
                    mGifView.setLayoutParams(params);
                    mWalkAndPushAnimationHandler.setDistance(params.width, mActualyBannerRelatedContainer.getLayoutParams().width);
                }
                else
                {
                    // Tablet
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.addRule(ALIGN_PARENT_LEFT);
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                    params.width = (int) (animationRatio * params.height);
                    mGifView.setLayoutParams(params);
                    mWalkAndPushAnimationHandler.setDistance(params.width, mActualyBannerRelatedContainer.getLayoutParams().width);
                }
            }
            else
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                }
                else
                {
                    // Tablet
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.addRule(ALIGN_PARENT_LEFT);
                    params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 90, getResources().getDisplayMetrics());
                    params.width = (int) (animationRatio * params.height);
                    mGifView.setLayoutParams(params);
                    mWalkAndPushAnimationHandler.setDistance(params.width, mActualyBannerRelatedContainer.getLayoutParams().width);
                }
            }
        }
        else
        {
            if (ScreenUtils.getIsTablet(getContext()) == false)
            {
                // Phone
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                params.addRule(ALIGN_PARENT_LEFT);
                params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                params.width = (int) (animationRatio * params.height);
                mGifView.setLayoutParams(params);
                mWalkAndPushAnimationHandler.setDistance(params.width, mActualyBannerRelatedContainer.getLayoutParams().width);
            }
            else
            {
                // Tablet
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                params.addRule(ALIGN_PARENT_LEFT);
                params.height = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                params.width = (int) (animationRatio * params.height);
                mGifView.setLayoutParams(params);
                mWalkAndPushAnimationHandler.setDistance(params.width, mActualyBannerRelatedContainer.getLayoutParams().width);
            }
        }
    }

    private void applyNextButtonsParams()
    {
        if (mIsSmartBanner == true)
        {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
            params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);

            int screenHeightDP = getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400)
            {
                float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 12, getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 32, getResources().getDisplayMetrics());
                float margin = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());

                params.rightMargin = (int) (margin);
                params.width = (int) (width);
                params.height = (int) (height);
            }
            else if (screenHeightDP > 400 && screenHeightDP <= 720)
            {
                float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                float margin = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());

                params.rightMargin = (int) (margin);
                params.width = (int) (width);
                params.height = (int) (height);
            }
            else
            {
                float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 70, getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 90, getResources().getDisplayMetrics());
                float margin = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());

                params.rightMargin = (int) (margin);
                params.width = (int) (width);
                params.height = (int) (height);
            }
            mNextButton.setLayoutParams(params);
        }
    }

    private void applyPreviousButtonsParams()
    {
        if (mIsSmartBanner == true)
        {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
            params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);

            int screenHeightDP = getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400)
            {
                float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 12, getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 32, getResources().getDisplayMetrics());
                float margin = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());

                params.leftMargin = (int) (margin);
                params.width = (int) (width);
                params.height = (int) (height);
            }
            else if (screenHeightDP > 400 && screenHeightDP <= 720)
            {
                float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
                float margin = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());

                params.leftMargin = (int) (margin);
                params.width = (int) (width);
                params.height = (int) (height);
            }
            else
            {
                float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 70, getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 90, getResources().getDisplayMetrics());
                float margin = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());

                params.leftMargin = (int) (margin);
                params.width = (int) (width);
                params.height = (int) (height);
            }
            mPreviousButton.setLayoutParams(params);
        }
    }

    private void applyViewPagerParams()
    {
        if (mIsSmartBanner == true)
        {
            int screenHeightDP = getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400)
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                    float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 28, getResources().getDisplayMetrics());
                    float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 28, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int) width, (int) height);
                    params.addRule(RelativeLayout.CENTER_VERTICAL);
                    params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                    mViewPager.setLayoutParams(params);
                    if (mAdapter != null)
                    {
                        mAdapter.setContainerHeight((int) height);
                    }
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.WHITE, Color.WHITE});
                    gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2f, getResources().getDisplayMetrics())));
                    if (Build.VERSION.SDK_INT >= 16)
                    {
                        mViewPager.setBackground(gradientDrawable);
                    }
                    else
                    {
                        mViewPager.setBackgroundDrawable(gradientDrawable);
                    }
                }
                else
                {
                    // Tablet
                }
            }
            else if (screenHeightDP > 400 && screenHeightDP <= 720)
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                    float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 46, getResources().getDisplayMetrics());
                    float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 46, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int) width, (int) height);
                    params.addRule(RelativeLayout.CENTER_VERTICAL);
                    params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                    mViewPager.setLayoutParams(params);
                    if (mAdapter != null)
                    {
                        mAdapter.setContainerHeight((int) height);
                    }
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.WHITE, Color.WHITE});
                    gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2f, getResources().getDisplayMetrics())));
                    if (Build.VERSION.SDK_INT >= 16)
                    {
                        mViewPager.setBackground(gradientDrawable);
                    }
                    else
                    {
                        mViewPager.setBackgroundDrawable(gradientDrawable);
                    }
                }
                else
                {
                    // Tablet
                    float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 46, getResources().getDisplayMetrics());
                    float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 46, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int) width, (int) height);
                    params.addRule(RelativeLayout.CENTER_VERTICAL);
                    params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                    mViewPager.setLayoutParams(params);
                    if (mAdapter != null)
                    {
                        mAdapter.setContainerHeight((int) height);
                    }
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.WHITE, Color.WHITE});
                    gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2f, getResources().getDisplayMetrics())));
                    if (Build.VERSION.SDK_INT >= 16)
                    {
                        mViewPager.setBackground(gradientDrawable);
                    }
                    else
                    {
                        mViewPager.setBackgroundDrawable(gradientDrawable);
                    }
                }
            }
            else
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                }
                else
                {
                    // Tablet
                    float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 86, getResources().getDisplayMetrics());
                    float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 86, getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int) width, (int) height);
                    params.addRule(RelativeLayout.CENTER_VERTICAL);
                    params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                    mViewPager.setLayoutParams(params);
                    if (mAdapter != null)
                    {
                        mAdapter.setContainerHeight((int) height);
                    }
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.WHITE, Color.WHITE});
                    gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2f, getResources().getDisplayMetrics())));
                    if (Build.VERSION.SDK_INT >= 16)
                    {
                        mViewPager.setBackground(gradientDrawable);
                    }
                    else
                    {
                        mViewPager.setBackgroundDrawable(gradientDrawable);
                    }
                }
            }
        }
        else
        {
            if (ScreenUtils.getIsTablet(getContext()) == false)
            {
                // Phone
                float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 46, getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 46, getResources().getDisplayMetrics());
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int) width, (int) height);
                params.addRule(RelativeLayout.CENTER_VERTICAL);
                params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                mViewPager.setLayoutParams(params);
                if (mAdapter != null)
                {
                    mAdapter.setContainerHeight((int) height);
                }
                GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.WHITE, Color.WHITE});
                gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2f, getResources().getDisplayMetrics())));
                if (Build.VERSION.SDK_INT >= 16)
                {
                    mViewPager.setBackground(gradientDrawable);
                }
                else
                {
                    mViewPager.setBackgroundDrawable(gradientDrawable);
                }
            }
            else
            {
                // Tablet
                float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 46, getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 46, getResources().getDisplayMetrics());
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int) width, (int) height);
                params.addRule(RelativeLayout.CENTER_VERTICAL);
                params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                mViewPager.setLayoutParams(params);
                if (mAdapter != null)
                {
                    mAdapter.setContainerHeight((int) height);
                }
                GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.WHITE, Color.WHITE});
                gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2f, getResources().getDisplayMetrics())));
                if (Build.VERSION.SDK_INT >= 16)
                {
                    mViewPager.setBackground(gradientDrawable);
                }
                else
                {
                    mViewPager.setBackgroundDrawable(gradientDrawable);
                }
            }
        }
    }

    private void applyAppNameParams()
    {
        mAppNameTextView.setVisibility(GONE);
        if (mIsSmartBanner == true)
        {
            int screenHeightDP = getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400)
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
                    params.leftMargin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());
                    params.rightMargin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 5, getResources().getDisplayMetrics());
                    params.addRule(RelativeLayout.RIGHT_OF, mActualyBannerRelatedContainer.getId());
                    params.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());
                    params.addRule(RelativeLayout.CENTER_VERTICAL);
                    mAppNameTextView.setLayoutParams(params);
                    mAppNameTextView.setPadding(0, 0, 0, 0);
                    mAppNameTextView.setTextSize(TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, 3.5f, getResources().getDisplayMetrics()));
                    mAppNameTextView.setSingleLine(false);
                    mAppNameTextView.setGravity(Gravity.CENTER);
                    mAppNameTextView.setMinLines(1);
                    mAppNameTextView.setMaxLines(2);
                    mAppNameTextView.setVisibility(VISIBLE);
                }
                else
                {
                    //Tablet
                }
            }
            else if (screenHeightDP > 400 && screenHeightDP <= 720)
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                }
                else
                {
                    //Tablet
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
                    params.leftMargin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 10, getResources().getDisplayMetrics());
                    params.rightMargin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 10, getResources().getDisplayMetrics());
                    params.addRule(RelativeLayout.RIGHT_OF, mActualyBannerRelatedContainer.getId());
                    params.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());
                    params.addRule(RelativeLayout.CENTER_VERTICAL);
                    mAppNameTextView.setLayoutParams(params);
                    mAppNameTextView.setPadding(0, 0, 0, 0);
                    mAppNameTextView.setTextSize(TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, 8f, getResources().getDisplayMetrics()));
                    mAppNameTextView.setSingleLine(false);
                    mAppNameTextView.setGravity(Gravity.CENTER);
                    mAppNameTextView.setMinLines(1);
                    mAppNameTextView.setMaxLines(2);
                    mAppNameTextView.setVisibility(VISIBLE);
                }
            }
            else
            {
                if (ScreenUtils.getIsTablet(getContext()) == false)
                {
                    // Phone
                }
                else
                {
                    //Tablet
                }
            }
        }
    }

    private void setAppName(final ContentItem contentItem)
    {
        mAppNameTextView.setText(null);
        if (contentItem != null && contentItem.getName() != null)
        {
            GenAnimator.fade(false, mAppNameTextView, 150, new Animator.AnimatorListener()
            {
                @Override
                public void onAnimationStart(Animator animation)
                {

                }

                @Override
                public void onAnimationEnd(Animator animation)
                {
                    mAppNameTextView.setText(contentItem.getName());
                    GenAnimator.fade(true, mAppNameTextView, 200, null);
                }

                @Override
                public void onAnimationCancel(Animator animation)
                {

                }

                @Override
                public void onAnimationRepeat(Animator animation)
                {

                }
            });
        }
    }

    private static class AnimationHandler extends Handler
    {
        private final WeakReference<View> mAnimateableViewReference;
        private boolean mIsIgnoringMessages;
        private Random mRandom;
        private AnimatorSet mAnimatorSet;

        public AnimationHandler(View animateableView)
        {
            mAnimateableViewReference = new WeakReference<View>(animateableView);
            mRandom = new Random();
            mIsIgnoringMessages = false;
        }

        @Override
        public void handleMessage(Message msg)
        {
            super.handleMessage(msg);
            mIsIgnoringMessages = false;
            mAnimatorSet = GenAnimator.animateLongDurationClick(mAnimateableViewReference.get(), 150, new GenAnimator.ViewAnimationListener()
            {
                @Override
                public void onAnimationEnd()
                {
                    if (mIsIgnoringMessages == false)
                    {
                        sendEmptyMessageDelayed(0, getDelay());
                    }
                }

                @Override
                public void onAnimationStart()
                {

                }
            });
        }

        public void cancel()
        {
            mIsIgnoringMessages = true;
            if (mAnimatorSet != null)
            {
                mAnimatorSet.cancel();
            }
            removeMessages(0);
            removeCallbacks(null);
        }

        public long getDelay()
        {
            return mRandom.nextInt(2000) + 2000;
        }
    }

    private static class WalkAndPushAnimationHandler extends Handler
    {
        private final WeakReference<View> mAnimateableViewReference;
        private final WeakReference<View> mAnimateableViewReference2;
        private File mPopSoundFile;
        private boolean mIsIgnoringMessages;
        private int mDistance;
        private int mStartDistance;
        private AnimatorSet mAnimatorSet;

        public WalkAndPushAnimationHandler(File popSoundFile, View animateableView, View animateableView2)
        {
            mAnimateableViewReference = new WeakReference<View>(animateableView);
            mAnimateableViewReference2 = new WeakReference<View>(animateableView2);
            mIsIgnoringMessages = false;
            mPopSoundFile = popSoundFile;
        }

        @Override
        public void handleMessage(Message msg)
        {
            super.handleMessage(msg);
            mIsIgnoringMessages = false;
            GenAnimator.animateWalking(mAnimateableViewReference2.get(), (int) (mDistance * mDistance * 0.035f), 0, mDistance + mStartDistance, null);
            mAnimatorSet = GenAnimator.animateWalking(mAnimateableViewReference.get(), (int) (mDistance * mDistance * 0.035f), -mStartDistance, mDistance, new GenAnimator.ViewAnimationListener()
            {
                @Override
                public void onAnimationEnd()
                {
                    if (mIsIgnoringMessages == false)
                    {
                        if (mAnimateableViewReference2 != null)
                        {
                            View view = mAnimateableViewReference2.get();
                            if (view != null)
                            {
                                view.setTranslationX(0f);
                                GenAnimator.playGrowAnimation(view, 300, 0, new DecelerateInterpolator(), null);
                                if (mPopSoundFile != null)
                                {
                                    SdkSoundManager.playSound(view.getContext(), mPopSoundFile.getAbsolutePath());
                                }
                            }
                        }
                        sendEmptyMessageDelayed(0, 4000);
                    }
                }

                @Override
                public void onAnimationStart()
                {

                }
            });

        }

        public void cancel()
        {
            mIsIgnoringMessages = true;
            if (mAnimatorSet != null)
            {
                mAnimatorSet.cancel();
            }
            removeMessages(0);
            removeCallbacks(null);
        }

        public void setDistance(int startDistance, int distance)
        {
            mStartDistance = startDistance;
            mDistance = distance;
        }
    }


    private void startHandlers()
    {
        stopHandlers();
        if (mViewPager != null && mGifView != null)
        {
            mGifView.setVisibility(View.INVISIBLE);
            mViewPager.setVisibility(View.INVISIBLE);
        }

        getMyHandlerInstance().postDelayed(new Runnable()
        {
            @Override
            public void run()
            {
                if (mViewPager != null)
                {
                    mViewPager.startAutoScroll();
                }

                if (mAnimationHandler != null)
                {
                    mAnimationHandler.sendEmptyMessageDelayed(0, mAnimationHandler.getDelay());
                }

                if (mWalkAndPushAnimationHandler != null)
                {
                    mWalkAndPushAnimationHandler.sendEmptyMessage(0);
                }
                if (mViewPager != null && mGifView != null)
                {
                    mGifView.setVisibility(View.VISIBLE);
                    mViewPager.setVisibility(View.VISIBLE);
                }
            }
        }, 300);
    }

    private void stopHandlers()
    {
        if (mViewPager != null && mGifView != null)
        {
            mGifView.setVisibility(View.INVISIBLE);
            mViewPager.setVisibility(View.INVISIBLE);
        }

        getMyHandlerInstance().removeMessages(0);
        getMyHandlerInstance().removeCallbacks(null);

        if (mViewPager != null)
        {
            mViewPager.stopAutoScroll();
        }

        if (mAnimationHandler != null)
        {
            mAnimationHandler.cancel();
        }

        if (mWalkAndPushAnimationHandler != null)
        {
            mWalkAndPushAnimationHandler.cancel();
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus)
    {
        super.onWindowFocusChanged(hasWindowFocus);
        if (mViewPager != null)
        {
            if (hasWindowFocus == true)
            {
                startHandlers();
            }
            else
            {
                stopHandlers();
            }
        }
    }
}
