package com.kidoz.sdk.api.players.web_player;

import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.view.View;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.structure.ContentItem;

/**
 * Created by Eugine on 10/1/2015.
 */
public class WebPlayerDialog extends BaseDialog {

    private static final String TAG = WebPlayerDialog.class.getSimpleName();

    private static final int WEB_PLAYER_RESOURCE_ID = 1;

    private static final String CONTENT_ITEM_SAVE_STATE_KEY = "CONTENT_ITEM_SAVE_STATE_KEY_WP";
    private static final String WEB_PLAYER_TYPE_SAVE_STATE_KEY = "WEB_PLAYER_TYPE_SAVE_STATE_KEY_WP";
    private static final String ORIENTATION_STATE_SAVE_STATE_KEY = "ORIENTATION_STATE_SAVE_STATE_KEY_WP";
    private static final String EVENT_ID_STATE_SAVE_STATE_KEY = "EVENT_ID_STATE_SAVE_STATE_KEY_WP";
    private static final String ORIENTATION_MODIFY_SAVE_STATE_KEY = "ORIENTATION_MODIFY_SAVE_STATE_KEY_WP";

    private ContentItem mContentItem;
    private WebPlayerType mWebPlayerType;
    private WebPlayerView mWebPlayerView;

   // private long mEventID;
    private boolean mAllowOrientationModify = false;

    private String mWidgetType = null;
    private String mStyleId = null;

    public WebPlayerDialog(Context context, ContentItem contentItem, String widgetType, String styleId, WebPlayerType webPlayerType, boolean allowOrientationModification) {
        super(context, android.R.style.Theme_Black_NoTitleBar_Fullscreen);
        setCancelable(true);

        mContentItem = contentItem;
        mWebPlayerType = webPlayerType;
        mAllowOrientationModify = allowOrientationModification;
        mWidgetType = widgetType;
        mStyleId = styleId;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (savedInstanceState != null) {
            mAllowOrientationModify = savedInstanceState.getBoolean(ORIENTATION_MODIFY_SAVE_STATE_KEY);
        }

        if (mAllowOrientationModify) {
            if (savedInstanceState != null && savedInstanceState.containsKey(ORIENTATION_STATE_SAVE_STATE_KEY)) {
                mCurrentOrientationState = savedInstanceState.getInt(ORIENTATION_STATE_SAVE_STATE_KEY);
            } else {
                if (mCallingActivity != null && mCallingActivity.isFinishing() == false) {
                    mCurrentOrientationState = mCallingActivity.getResources().getConfiguration().orientation;
                    mCallingActivity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
                }
            }
        }

        if (savedInstanceState != null) {
            if (savedInstanceState.containsKey(CONTENT_ITEM_SAVE_STATE_KEY)) {
                mContentItem = (ContentItem) savedInstanceState.getSerializable(CONTENT_ITEM_SAVE_STATE_KEY);
            }
            mWebPlayerType = (WebPlayerType) savedInstanceState.getSerializable(WEB_PLAYER_TYPE_SAVE_STATE_KEY);
           // mEventID = savedInstanceState.getLong(EVENT_ID_STATE_SAVE_STATE_KEY);
        }

        mWebPlayerView = new WebPlayerView(mCallingActivity, mWebPlayerType, mWidgetType);
        if (mContentItem != null) {
            mWebPlayerView.loadWebUrl(mContentItem.getData(), mContentItem.getId(), mContentItem.getName());
        }

        mWebPlayerView.setOnCloseButtonClickListenr(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                closeDialog();
            }
        });

        mWebPlayerView.setOnRemoveViewRequestListener(new WebPlayerView.IOnRemoveViewRequestListener() {
            @Override
            public void onRemoveView() {
                closeDialog();
            }
        });

        setContentView(mWebPlayerView);

        setOnDismissListener(new OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {

            }
        });
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();
        if (bundle != null) {
            bundle.putSerializable(CONTENT_ITEM_SAVE_STATE_KEY, mContentItem);
            bundle.putSerializable(WEB_PLAYER_TYPE_SAVE_STATE_KEY, mWebPlayerType);
            bundle.putSerializable(ORIENTATION_STATE_SAVE_STATE_KEY, mCurrentOrientationState);
            //bundle.putSerializable(EVENT_ID_STATE_SAVE_STATE_KEY, mEventID);
            bundle.putBoolean(ORIENTATION_MODIFY_SAVE_STATE_KEY, mAllowOrientationModify);
        }
        return bundle;
    }

    @Override
    public void closeDialog() {
        super.closeDialog();

    }

    @Override
    public void openDialog() {
        super.openDialog();

        String activityName = "";
        String action = "";
        switch (mWebPlayerType) {
            case EXTERNAL_LINK:
                activityName = "Web Player External Link";
                action = EventParameters.ACTION_EXTERNAL_LINK_VIEW;
                break;
            case ONLINE_GAME:
                activityName = "Web Player Online Game";
                action = EventParameters.ACTION_GAME_VIEW;
                break;
            case WEB_BROWSER:
                activityName = "Web Player Web Browser";
                action = EventParameters.ACTION_WEBSITE_VIEW;
                break;
        }
        //mEventID = EventManager.getInstance(getContext()).activityStart(this.getContext(), mWidgetType, mStyleId, EventManager.LOG_CRITICAL_LEVEL, activityName, false);
        EventManager.getInstance(getContext()).logEventWithDuration(this.getContext(), mWidgetType, mStyleId, EventManager.LOG_NORMAL_LEVEL, WEB_PLAYER_RESOURCE_ID, EventManager.LOG_CLOSE_RESOURCE_LEVEL, EventParameters.CATEGORY_WEB_PLAYER, action, mContentItem.getName(), mContentItem.getId(), false);
    }


    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (mWebPlayerView != null) {
            try {
                mWebPlayerView.releseAndcloseView();
            } catch (Exception ex) {
                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, "Error when trying to onDetach: " + ex.getMessage());
            }
        }

        // Restore previous orientation
        if (mAllowOrientationModify) {
            restoreUserOriginalOrientation();
        }

        //EventManager.getInstance(getContext()).activityEnd(getContext(), mWidgetType, mStyleId, EventManager.LOG_CRITICAL_LEVEL, mEventID, false);
        EventManager.getInstance(getContext()).logEventWithDurationEnd(getContext(), mWidgetType, mStyleId, WEB_PLAYER_RESOURCE_ID, false);
    }
}
