/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kidoz.sdk.api.general.custom_views.CustomCardView;

import android.content.Context;

/**
 * Interface for platform specific CardView implementations.
 */
interface KidozCardViewImpl {
    void initialize(KidozCardViewDelegate cardView, Context context, int backgroundColor, float radius,
                    float elevation, float maxElevation);

    void setRadius(KidozCardViewDelegate cardView, float radius);

    float getRadius(KidozCardViewDelegate cardView);

    void setElevation(KidozCardViewDelegate cardView, float elevation);

    float getElevation(KidozCardViewDelegate cardView);

    void initStatic();

    void setMaxElevation(KidozCardViewDelegate cardView, float maxElevation);

    float getMaxElevation(KidozCardViewDelegate cardView);

    float getMinWidth(KidozCardViewDelegate cardView);

    float getMinHeight(KidozCardViewDelegate cardView);

    void updatePadding(KidozCardViewDelegate cardView);

    void onCompatPaddingChanged(KidozCardViewDelegate cardView);

    void onPreventCornerOverlapChanged(KidozCardViewDelegate cardView);

    void setBackgroundColor(KidozCardViewDelegate cardView, int color);
}
