package com.kidoz.sdk.api.ui_views.kidoz_banner;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Looper;
import android.os.Message;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.ContentExecutionHandler;
import com.kidoz.sdk.api.ContentLogicLoader;
import com.kidoz.sdk.api.KidozBanner;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.AssetUtil;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.one_item_view.AutoScrollViewPager;
import com.kidoz.sdk.api.ui_views.one_item_view.InfinitePagerAdapter;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by RonyBrosh on 12/7/2015.
 */
public class KidozBanner3 extends BaseBanner {
    private final String TAG = KidozBanner3.class.getSimpleName();
    private final int AUTO_SCROLL_DELAY = 10000;

    private RelativeLayout mContainer;
    private RelativeLayout mKidozRelatedContainer;
    private AssetView mParentalLockButton;
    private AssetView mInstallButton;
    private AssetView mNextButton;
    private AutoScrollViewPager mViewPager;
    private BannerViewPagerAdapter mAdapter;
    private TextView mKidozLabelTextView;
    private HashMap<String, Integer> mSponsoredContentDisplayed = new HashMap<String, Integer>();
    private ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;

    private ContentLogicLoader mContentLogicLoader;
    private Utils.StaticHandler mStaticHandler;
    private boolean mAllowClickHandle = true;

    private String mStyleId;

    public KidozBanner3(Context context) {
        super(context);
    }

    public void setProperties(JSONObject properties) {
        mProperties = properties;
        initView();
    }

    @Override
    public void initView() {
        super.initView();
        mStyleId = mProperties.optString(STYLE_ID);

        initContainer();
        initKidozContainer();
        initParentalLockButton();
        initViewPager();
        initNextButton();
        initInstallButton();
        initKidozText();

        initContentLogicLoader();

        hideBanner();
    }

    @Override
    public void loadContent() {
        super.loadContent();
        mContentLogicLoader.loadContent(getContext(), WidgetType.WIDGET_TYPE_BANNER.getStringValue(), mStyleId);
    }

    private void initKidozContainer() {
        mKidozRelatedContainer = new RelativeLayout(getContext());
        LayoutParams params = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.MATCH_PARENT);
        params.addRule(RelativeLayout.CENTER_IN_PARENT);
        mContainer.addView(mKidozRelatedContainer, params);
    }


    private void initInstallButton() {
        mInstallButton = new AssetView(getContext());
        mInstallButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mInstallButton.setId(Utils.generateViewId());

        String lockClickAnimation = mProperties.optString(INSTALL_BUTTON_ANIMATION);
        if (lockClickAnimation != null) {
            if (lockClickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true) {
                mInstallButton.setOnClickListener(new OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        mInstallButton.setClickable(false);
                        GenAnimator.clickItemAnimation(mInstallButton, 150, new GenAnimator.ViewAnimationListener() {
                            @Override
                            public void onAnimationEnd() {
                                /*mInstallButton.setClickable(true);
                                try {
                                    View currentView = mViewPager.findViewWithTag("BannerThumbnailNumber_" + String.valueOf(mViewPager.getCurrentItem()));
                                    if (currentView != null) {
                                        currentView.performClick();
                                    }
                                } catch (Exception ex) {
                                    SDKLogger.printErrorLog(TAG, "Error when trying to click banner: " + ex.getMessage());
                                }*/
                                mInstallButton.setClickable(true);
                                if(mViewPager != null && mAdapter != null && mAdapter.isAdapterEmpty() == false) {
                                    int pos =  mViewPager.getCurrentItem() % mAdapter.getCount();
                                    if(pos < mAdapter.getCount()) {
                                        handleClick(mAdapter.getContentItem(pos), pos);
                                    }
                                }
                            }

                            @Override
                            public void onAnimationStart() {

                            }
                        });
                    }
                });
            }
        }

        float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 130, getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 30, getResources().getDisplayMetrics());
        LayoutParams params = new LayoutParams((int) width, (int) height);
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        params.addRule(RelativeLayout.RIGHT_OF, mViewPager.getId());
        params.bottomMargin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2, getResources().getDisplayMetrics());
        params.leftMargin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 3, getResources().getDisplayMetrics());

        mKidozRelatedContainer.addView(mInstallButton, params);
        mInstallButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(INSTALL_BUTTON)), new AssetView.IOnAssetLoadedListener() {
            @Override
            public void onAssetLoaded() {
                autoOpen();
            }
        });
    }

    private void initNextButton() {
        mNextButton = new AssetView(getContext());
        mNextButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        mNextButton.setId(Utils.generateViewId());

        float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
        LayoutParams params = new LayoutParams((int) width, (int) height);
        params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        mNextButton.setLayoutParams(params);
        mContainer.addView(mNextButton, params);
        String lockClickAnimation = mProperties.optString(REFRESH_BUTTON_ANIMATION);
        if (lockClickAnimation != null) {
            if (lockClickAnimation.equals(GenAnimator.PRESS_TOP) == true) {
                mNextButton.setOnClickListener(new OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        mNextButton.setClickable(false);
                        GenAnimator.playPressTopAnimation(mNextButton, new Animator.AnimatorListener() {
                            @Override
                            public void onAnimationStart(Animator animation) {

                            }

                            @Override
                            public void onAnimationEnd(Animator animation) {
                                mNextButton.setClickable(true);
                                mViewPager.setCurrentItem(mViewPager.getCurrentItem() + 1);
                            }

                            @Override
                            public void onAnimationCancel(Animator animation) {

                            }

                            @Override
                            public void onAnimationRepeat(Animator animation) {

                            }
                        });
                    }
                });
            }
        }
        mNextButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(REFRESH_BUTTON)), new AssetView.IOnAssetLoadedListener() {
            @Override
            public void onAssetLoaded() {
                autoOpen();
            }
        });
    }

    private void initContentLogicLoader() {
        mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback() {
            @Override
            public void onDataReady(ContentData contentData) {
                if (contentData != null) {
                    setContent(contentData.getContentDataItems());
                    if (mKidozBannerListener != null) {
                        mKidozBannerListener.onBannerContentLoaded();
                    }
                }
            }

            @Override
            public void onLoadContentFailed() {
                if (mKidozBannerListener != null) {
                    mKidozBannerListener.onBannerContentLoadFailed();
                }
            }
        });
    }

    private void initContainer() {
        mContainer = new RelativeLayout(getContext());
        mContainer.setBackgroundColor(Color.TRANSPARENT);
        mContainer.setOnTouchListener(new OnTouchListener() {
            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                return true;
            }
        });
        float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 320, getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());

        LayoutParams params = new LayoutParams((int) width, (int) height);
        addView(mContainer, params);

        AssetView backgroundImage;
        backgroundImage = new AssetView(getContext());
        backgroundImage.setScaleType(ImageView.ScaleType.FIT_XY);
        params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
        mContainer.addView(backgroundImage, params);
        backgroundImage.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(BACKGROUND_IMAGE)), new AssetView.IOnAssetLoadedListener() {
            @Override
            public void onAssetLoaded() {
                autoOpen();
            }
        });
    }

    private void initParentalLockButton() {
        mParentalLockButton = new AssetView(getContext());
        mParentalLockButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        mParentalLockButton.setId(Utils.generateViewId());
        String lockClickAnimation = mProperties.optString(LOCK_ANIMATION);
        if (lockClickAnimation != null) {
            if (lockClickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true) {
                mParentalLockButton.setOnClickListener(new OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        mParentalLockButton.setClickable(false);
                        GenAnimator.clickItemAnimation(mParentalLockButton, 150, new GenAnimator.ViewAnimationListener() {
                            @Override
                            public void onAnimationEnd() {
                                mParentalLockButton.setClickable(true);
                                if (ParentalLockDialog.getIsCanShowDialog(getContext()) == true) {
                                    int[] popLocation = new int[2];
                                    popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                                    popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                                    ParentalLockDialog parentalLockDialog = new ParentalLockDialog(getContext(), false, popLocation);
                                    parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                                        @Override
                                        public void onDismiss(DialogInterface dialog) {
                                            //Refresh the parental lock icon
                                            updateLockIcon();
                                        }
                                    });
                                    parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener() {
                                        @Override
                                        public void onPasswordEntered(boolean isPasswordCorrect) {
                                            updateLockIcon();
                                        }
                                    });
                                    parentalLockDialog.show();
                                }
                            }

                            @Override
                            public void onAnimationStart() {

                            }
                        });
                    }
                });
            }
        }

        int padding = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 10, getResources().getDisplayMetrics());
        mParentalLockButton.setPadding(padding, padding, padding, padding);
        float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, getResources().getDisplayMetrics());
        LayoutParams params = new LayoutParams((int) width, (int) height);
        params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
        mContainer.addView(mParentalLockButton, params);

        updateLockIcon();
    }

    private void updateLockIcon() {
        try {
            boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
            if (isLockActive == true) {
                mParentalLockButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(LOCK_ACTIVE)), new AssetView.IOnAssetLoadedListener() {
                    @Override
                    public void onAssetLoaded() {
                        autoOpen();
                    }
                });
            } else {
                mParentalLockButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(LOCK_NOT_ACTIVE)), new AssetView.IOnAssetLoadedListener() {
                    @Override
                    public void onAssetLoaded() {
                        autoOpen();
                    }
                });
            }
        } catch (Exception ex) {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to load parental lock image: " + ex.getMessage());
        }
    }

    private void initKidozText() {
        mKidozLabelTextView = new TextView(getContext());
        mKidozLabelTextView.setTextColor(Color.parseColor(mProperties.optString(LABEL_COLOR)));
        mKidozLabelTextView.setShadowLayer(20f, 0f, 0f, Color.parseColor("#80666666"));
        mKidozLabelTextView.setText(mProperties.optString(LABEL_TEXT));
        mKidozLabelTextView.setGravity(Gravity.CENTER);
        mKidozLabelTextView.setTextSize(TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, 2.8f, getResources().getDisplayMetrics()));
        mKidozLabelTextView.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                mInstallButton.performClick();
            }
        });


        LayoutParams params = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.ALIGN_LEFT, mInstallButton.getId());
        params.addRule(RelativeLayout.ALIGN_RIGHT, mInstallButton.getId());
        params.addRule(RelativeLayout.ABOVE, mInstallButton.getId());
        float margin = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 3, getResources().getDisplayMetrics());

        params.bottomMargin = (int) margin;
        mKidozRelatedContainer.addView(mKidozLabelTextView, params);

    }

    private void initViewPager() {
        mViewPager = new AutoScrollViewPager(getContext());

        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.WHITE, Color.WHITE});
        gradientDrawable.setCornerRadius((int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 4f, getResources().getDisplayMetrics())));

        mViewPager.setBackgroundColor(Color.TRANSPARENT);
        mViewPager.setInterval(AUTO_SCROLL_DELAY);
        mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                sendImpressionLog(position % mAdapter.getCount());
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
        mViewPager.setId(Utils.generateViewId());
        int margin = Utils.dpTOpx(getContext(), 1);
        mViewPager.setPadding(margin, margin, margin, margin);

        margin = Utils.dpTOpx(getContext(), 6);
        mViewPager.setPageMargin(margin);


        float width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 48, getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 48, getResources().getDisplayMetrics());
        LayoutParams params = new LayoutParams((int) width, (int) height);
        params.addRule(RelativeLayout.CENTER_VERTICAL);
        mKidozRelatedContainer.addView(mViewPager, params);

        mViewPagerItemClickListener = new ItemViewPagerAdapter.ViewPagerItemClickListener() {
            @Override
            public void onClickEnd(ContentItem contentItem, int position) {
                handleClick(contentItem, position);
            }
        };
    }

    private void handleClick(ContentItem contentItem, int position) {
        if (contentItem != null && contentItem.isPromoted() && mAllowClickHandle) {
            ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, WidgetType.WIDGET_TYPE_BANNER.getStringValue(), mStyleId, position, true, true);
            mAllowClickHandle = false;

            getMyHandlerInstance().removeCallbacksAndMessages(null);
            getMyHandlerInstance().postDelayed(new Runnable() {
                @Override
                public void run() {
                    try {
                        mAllowClickHandle = true;
                        EventManager.getInstance(getContext()).clearAllTempStoredEvents();
                    } catch (Exception e) {
                    }
                }
            }, 3000);
        } else {
            ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, WidgetType.WIDGET_TYPE_BANNER.getStringValue(), mStyleId, position, true, false);
        }
    }


    private Utils.StaticHandler getMyHandlerInstance() {
        if (mStaticHandler == null) {
            mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper()) {
                @Override
                public void handleMessage(Message message) {
                    // This is where you do your work in the UI thread.
                    // Your worker tells you in the message what to do.
                }
            };
        }
        return mStaticHandler;
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);

        getMyHandlerInstance().removeCallbacksAndMessages(null);

        if (visibility == View.VISIBLE) {
            mAllowClickHandle = true;
        } else if (visibility == View.GONE || visibility == View.INVISIBLE) {
            EventManager.getInstance(getContext()).logAllTempStoredEvents(getContext());
            EventManager.getInstance(getContext()).startEventsSync(getContext());

            mAllowClickHandle = true;
        }
    }

    private void sendImpressionLog(int position) {
        ContentItem contentItem = mAdapter.getContentItem(position);
        if (contentItem != null && contentItem.isPromoted() == true) {
            if (mSponsoredContentDisplayed != null) {
                if (mSponsoredContentDisplayed.containsKey(contentItem.getId()) == false) {
                    mSponsoredContentDisplayed.put(contentItem.getId(), position);
                    EventManager.getInstance(getContext()).logSponsoredContentImpressionEvent(getContext(), WidgetType.WIDGET_TYPE_BANNER.getStringValue(), mStyleId, EventParameters.ACTION_IMPRESSION, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position, false);
                }
            }
        }
    }

    private void setContent(ArrayList<ContentItem> content) {
        mSponsoredContentDisplayed.clear();

        mAdapter = new BannerViewPagerAdapter(false);
        mAdapter.setViewPagerItemClickListener(mViewPagerItemClickListener);
        mAdapter.setContent(content);
        PagerAdapter wrappedAdapter = new InfinitePagerAdapter(mAdapter);
        mViewPager.setAdapter(wrappedAdapter);
        mViewPager.startAutoScroll(AUTO_SCROLL_DELAY);

        if (content != null && content.isEmpty() == false) {
            mViewPager.setCurrentItem(0);
            sendImpressionLog(0);
        }
    }

    @Override
    public boolean getIsCanOpen() {
        boolean result = false;
        if (mParentalLockButton != null && mInstallButton != null && mNextButton != null) {
            result = mParentalLockButton.getIsAssetLoaded() && mInstallButton.getIsAssetLoaded() && mNextButton.getIsAssetLoaded();

        }
        return result;
    }

    @Override
    public void showBanner() {
        super.showBanner();
        if (getVisibility() != View.VISIBLE && getIsCanOpen() == true) {
            GenAnimator.fade(true, this, 400, null);
            setVisibility(View.VISIBLE);
            if (mKidozBannerListener != null) {
                mKidozBannerListener.onBannerShow();
            }

            if (mViewPager != null) {
                if (mAdapter != null && mAdapter.isAdapterEmpty() == false) {
                    mViewPager.startAutoScroll();
                } else {
                    mViewPager.stopAutoScroll();
                }
            }

            sendActionWidgetImpression();
        }
    }

    @Override
    public void hideBanner() {
        super.hideBanner();
        setVisibility(View.GONE);
        if (mKidozBannerListener != null) {
            mKidozBannerListener.onBannerHide();
        }

        if (mViewPager != null) {
            mViewPager.stopAutoScroll();
        }
    }

    @Override
    protected void autoOpen() {
        if (mIsWaitingToOpen == true && getIsCanOpen() == true) {
            showBanner();
        }
    }

    public static final String BACKGROUND_IMAGE = "bgImage";
    public static final String LABEL_TEXT = "labelText";
    public static final String LABEL_COLOR = "labelColor";
    public static final String INSTALL_BUTTON = "installBtn";
    public static final String INSTALL_BUTTON_ANIMATION = "installBtnAnimation";
    public static final String REFRESH_BUTTON = "refreshBtn";
    public static final String REFRESH_BUTTON_ANIMATION = "refreshBtnAnimation";
    public static final String LOCK_ACTIVE = "parentalLockActive";
    public static final String LOCK_NOT_ACTIVE = "parentalLockNotActive";
    public static final String LOCK_ANIMATION = "parentalLockAnimation";


    /**
     * Compare new JSON to old JSON, save the updated JSON to database, delete old assets if needed and download new assets.
     *
     * @param context
     * @param jsonObject
     */
    public static boolean parseKidozBanner(Context context, JSONObject jsonObject) {
        boolean result = false;
        if (jsonObject != null) {
            try {
                // 1. Extract elements.
                jsonObject.put(KidozBanner.TAG, KidozBanner3.class.getSimpleName());

                String backgroundImage = jsonObject.optString(BACKGROUND_IMAGE);

                String parentalLockActive = jsonObject.optString(LOCK_ACTIVE);
                String parentalLockNotActive = jsonObject.optString(LOCK_NOT_ACTIVE);

                String refreshButton = jsonObject.optString(REFRESH_BUTTON);

                String installButton = jsonObject.optString(INSTALL_BUTTON);


                // 2. Load old data from database
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(KidozBanner.TAG);

                // 3. Compare assets, download and save if necessary
                if (oldData != null) {
                    result = true;
                    String oldAssetURL = oldData.optString(LOCK_ACTIVE);
                    if (oldAssetURL == null || oldAssetURL.equals(parentalLockActive) == false || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, parentalLockActive);
                    }
                    oldAssetURL = oldData.optString(LOCK_NOT_ACTIVE);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(parentalLockNotActive) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, parentalLockNotActive);
                    }
                    oldAssetURL = oldData.optString(BACKGROUND_IMAGE);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(backgroundImage) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, backgroundImage);
                    }
                    oldAssetURL = oldData.optString(REFRESH_BUTTON);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(refreshButton) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, refreshButton);
                    }
                    oldAssetURL = oldData.optString(INSTALL_BUTTON);
                    if (result == true && (oldAssetURL == null || oldAssetURL.equals(installButton) == false) || AssetUtil.getAssetFile(context, oldAssetURL).exists() == false) {
                        AssetUtil.deleteAssetFile(context, oldAssetURL);
                        result = AssetUtil.createAssetFile(context, installButton);
                    }
                } else {
                    result = AssetUtil.createAssetFile(context, parentalLockActive);
                    if (result == true) {
                        result = AssetUtil.createAssetFile(context, parentalLockNotActive);
                    }
                    if (result == true) {
                        result = AssetUtil.createAssetFile(context, refreshButton);
                    }
                    if (result == true) {
                        result = AssetUtil.createAssetFile(context, installButton);
                    }
                    if (result == true) {
                        result = AssetUtil.createAssetFile(context, backgroundImage);
                    }
                }
                // 4. Update database
                if (result == true) {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(KidozBanner.TAG, jsonObject);
                }
            } catch (Exception ex) {
                result = false;
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(KidozBanner.TAG, "Error when trying to parse kidoz banner3: " + ex.getMessage());
            }
        }
        return result;
    }


    @Override
    protected void onDetachedFromWindow() {

        if (mViewPager != null) {
            mViewPager.stopAutoScroll();
        }

        super.onDetachedFromWindow();
    }
}
