package com.kidoz.sdk.api.ui_views.kidoz_banner;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.widget.FrameLayout;
import android.widget.ImageView;

import java.util.Random;

/**
 * Created by f.laurent on 21/11/13.
 */
public class KenBurnsView extends FrameLayout
{
    public KenBurnsView(Context context)
    {
        super(context);
        mImageViews = new ImageView[1];
        mImageViews[0] = new ImageView(getContext());
        mImageViews[0].setScaleType(ImageView.ScaleType.CENTER_CROP);
        mImageViews[0].setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        ViewPropertyAnimator propertyAnimator = mImageViews[0].animate();
        propertyAnimator.scaleX(mFromScale).scaleY(mFromScale).setDuration(0);
        //        propertyAnimator.start();
        addView(mImageViews[0]);
    }

    public KenBurnsView(Context context, AttributeSet attrs)
    {
        super(context, attrs);

    }

    public KenBurnsView(Context context, AttributeSet attrs, int defStyle)
    {
        super(context, attrs, defStyle);

    }

    private static final String TAG = "KenBurnsView";

    private final Handler mHandler = new Handler();
    private int[] mResourceIds;
    private ImageView[] mImageViews;
    private int mActiveImageIndex = -1;

    private final Random random = new Random();
    private int mSwapMs = 1500;// 8000;
    private int mFadeInOutMs = 400;

    private float maxScaleFactor = 1.2F;
    private float minScaleFactor = 1.0F;

    float mFromScale = 1.5F;
    float mFromTranslationX;
    float mFromTranslationY;

    private Runnable mSwapImageRunnable = new Runnable()
    {
        @Override
        public void run()
        {
            swapImage();
            //            mHandler.postDelayed(mSwapImageRunnable, mSwapMs - mFadeInOutMs * 2);
            mHandler.postDelayed(mSwapImageRunnable, mSwapMs);
        }
    };

    public void setResourceIds(int... resourceIds)
    {
        mResourceIds = resourceIds;
        fillImageViews();
    }

    public void setBitmap(Bitmap bitmap)
    {
        fillImageViewsWithBitmaps(bitmap);
    }

    private void swapImage()
    {
        animate(mImageViews[0]);

        // if (mActiveImageIndex == -1)
        // {
        // mActiveImageIndex = 1;
        // animate(mImageViews[mActiveImageIndex]);
        // return;
        // }
        //
        // int inactiveIndex = mActiveImageIndex;
        // mActiveImageIndex = (1 + mActiveImageIndex) % mImageViews.length;
        //
        // final ImageView activeImageView = mImageViews[mActiveImageIndex];
        // activeImageView.setAlpha(0.0f);
        // ImageView inactiveImageView = mImageViews[inactiveIndex];
        //
        // animate(activeImageView);
        //
        // AnimatorSet animatorSet = new AnimatorSet();
        // animatorSet.setDuration(mFadeInOutMs);
        // animatorSet.playTogether(ObjectAnimator.ofFloat(inactiveImageView, "alpha", 1.0f, 0.0f), ObjectAnimator.ofFloat(activeImageView, "alpha", 0.0f, 1.0f));
        // animatorSet.start();
    }

    private void start(View view, long duration, float fromScale, float toScale, float fromTranslationX, float fromTranslationY, float toTranslationX, float toTranslationY)
    {
        ViewPropertyAnimator propertyAnimator = view.animate();
        propertyAnimator.translationX(toTranslationX).translationY(toTranslationY).scaleX(toScale).scaleY(toScale).setDuration(duration);
        //        propertyAnimator.start();
    }

    private float pickScale()
    {
        return this.minScaleFactor + this.random.nextFloat() * (this.maxScaleFactor - this.minScaleFactor);
    }

    private float pickTranslation(int value, float ratio)
    {
        return value * (ratio - 1.0f) * (this.random.nextFloat() - 0.5f);
    }

    public void animate(View view)
    {
        // float fromScale = pickScale();

        // float fromTranslationX = pickTranslation(view.getWidth(), fromScale);
        // float fromTranslationY = pickTranslation(view.getHeight(), fromScale);
        float toScale = pickScale();
        float toTranslationX = pickTranslation(view.getWidth(), toScale);
        float toTranslationY = pickTranslation(view.getHeight(), toScale);
        start(view, this.mSwapMs, mFromScale, toScale, mFromTranslationX, mFromTranslationY, toTranslationX, toTranslationY);
        mFromScale = toScale;
        mFromTranslationX = toTranslationX;
        mFromTranslationY = toTranslationY;
    }

    @Override
    protected void onAttachedToWindow()
    {
        super.onAttachedToWindow();
        // startKenBurnsAnimation();
    }

    @Override
    protected void onDetachedFromWindow()
    {
        super.onDetachedFromWindow();
        mHandler.removeCallbacks(mSwapImageRunnable);
    }

    public void startKenBurnsAnimation()
    {
        mHandler.post(mSwapImageRunnable);
    }

    //    @Override
    //    protected void onFinishInflate()
    //    {
    //        super.onFinishInflate();
    //
    //        mImageViews = new ImageView[1];
    //        mImageViews[0] = new ImageView(getContext());
    //        mImageViews[0].setScaleType(ImageView.ScaleType.CENTER_CROP);
    //        mImageViews[0].setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
    //        ViewPropertyAnimator propertyAnimator = mImageViews[0].animate();
    //        propertyAnimator.scaleX(mFromScale).scaleY(mFromScale).setDuration(0);
    //        propertyAnimator.start();
    //    }

    private void fillImageViews()
    {
        for (int i = 0; i < mImageViews.length; i++)
        {
            mImageViews[i].setImageResource(mResourceIds[i]);
        }
    }

    private void fillImageViewsWithBitmaps(Bitmap bitmap)
    {
        mImageViews[0].setImageBitmap(bitmap);

        // for (int i = 0; i < mImageViews.length; i++)
        // {
        // mImageViews[i].setImageBitmap(bitmap);
        // }
    }

    public ImageView getImageView()
    {
        return mImageViews[0];
    }
}
