package com.kidoz.sdk.api.ui_views.kidoz_banner;

import android.content.Context;
import android.view.View;
import android.widget.RelativeLayout;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.enums.WidgetType;

import org.json.JSONObject;

/**
 * Created by RonyBrosh on 12/13/2015.
 */
public class BaseBanner extends RelativeLayout
{
    public static final String STYLE_ID = "style_id";

    protected KidozBannerListener mKidozBannerListener;
    protected JSONObject mProperties;
    protected boolean mIsWaitingToOpen = false;

    protected String mStyleId;

    public BaseBanner(Context context)
    {
        super(context);
    }

    public void setKidozBannerListener(KidozBannerListener kidozBannerListener)
    {
        mKidozBannerListener = kidozBannerListener;
    }

    public void setProperties(JSONObject properties)
    {
        mProperties = properties;
        if(mProperties != null) {
            mStyleId = mProperties.optString(STYLE_ID,null);
        }
        initView();
    }

    protected void initView()
    {

    }

    public void loadContent()
    {

    }

    protected boolean getIsCanOpen()
    {
        return false;
    }

    public void showBanner()
    {
        mIsWaitingToOpen = true;

    }

    protected void sendActionWidgetImpression() {
        EventManager.getInstance(getContext()).logEvent(getContext(), WidgetType.WIDGET_TYPE_BANNER.getStringValue(), mStyleId, EventManager.LOG_CRITICAL_LEVEL, null, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, EventParameters.LABEL_BANNER_VIEW, false);
    }

    public void hideBanner()
    {

    }

    protected void autoOpen()
    {

    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();

        if (isInEditMode() == false && KidozSDK.isInitialised()) {
            EventManager.getInstance(getContext()).logEvent(getContext(), WidgetType.WIDGET_TYPE_FEED.getStringValue(), mStyleId, EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SDK, EventParameters.ACTION_BANNER_VIEW, EventParameters.LABEL_BANNER_VIEW, false);
        }
    }


    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (KidozSDK.isInitialised()) {
            if (!isInEditMode() && (visibility == View.GONE || visibility == View.INVISIBLE)) {
                EventManager.getInstance(getContext()).startEventsSync(getContext());
            }
        }
    }
}
