package com.kidoz.sdk.api.ui_views.kidoz_banner;

import android.animation.Animator;
import android.support.v4.view.PagerAdapter;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.kidoz.sdk.api.general.assets_handling.SoundAssetsUtils;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SdkSoundManager;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.picasso_related.RoundedTransformation;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.squareup.imagelib.Callback;

import java.util.ArrayList;

/**
 * Created by roni on 11/18/2015.
 */
public class BannerViewPagerAdapter extends PagerAdapter
{
    private ArrayList<ContentItem> mContent;
    private ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;
    private boolean mIsCanClick;
    private boolean mIsImageCropped;

    public BannerViewPagerAdapter(boolean isImageCropped)
    {
        mContent = new ArrayList<ContentItem>();
        mIsCanClick = true;
        mIsImageCropped = isImageCropped;
    }

    public void setViewPagerItemClickListener(ItemViewPagerAdapter.ViewPagerItemClickListener viewPagerItemClickListener)
    {
        mViewPagerItemClickListener = viewPagerItemClickListener;
    }

    @Override
    public int getCount()
    {
        int result = 0;
        if (mContent != null)
        {
            result = mContent.size();
        }
        return result;
    }

    public void setContent(ArrayList<ContentItem> content)
    {
        mContent = content;
        notifyDataSetChanged();
    }

    @Override
    public Object instantiateItem(ViewGroup container, final int position)
    {
        final ContentItem contentItem = mContent.get(position);
        ImageView imageView = new ImageView(container.getContext());
        if (mIsImageCropped == true)
        {
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        }
        else
        {
            imageView.setScaleType(ImageView.ScaleType.FIT_XY);
        }
        imageView.setDuplicateParentStateEnabled(true);
        int size = (int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 40f, container.getContext().getResources().getDisplayMetrics()));

        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(size, size);
        imageView.setLayoutParams(params);
        imageView.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View view)
            {
                if (mIsCanClick == true)
                {
                    SdkSoundManager.playSound(view.getContext(), SoundAssetsUtils.getSoundAssetFile(view.getContext(), SoundAssetsUtils.SOUND_ASSET_TYPE.ITEM_CLICK).getAbsolutePath());
                    mIsCanClick = false;
                    SdkAnimationsUtils.animateClick(view, new Animator.AnimatorListener()
                    {
                        @Override
                        public void onAnimationStart(Animator animation)
                        {
                        }

                        @Override
                        public void onAnimationEnd(Animator animation)
                        {
                            mViewPagerItemClickListener.onClickEnd(contentItem, position);
                            mIsCanClick = true;
                        }

                        @Override
                        public void onAnimationCancel(Animator animation)
                        {

                        }

                        @Override
                        public void onAnimationRepeat(Animator animation)
                        {

                        }
                    }, 50, 100);
                }
            }
        });
        if (contentItem != null && contentItem.getThumb() != null && !contentItem.getThumb().equals(""))
        {
            int round = (int) (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 4f, container.getContext().getResources().getDisplayMetrics()));
            PicassoOk.getPicasso(container.getContext()).load(contentItem.getThumb()).transform(new RoundedTransformation(round, 0)).into(imageView, new Callback()
            {
                @Override
                public void onSuccess()
                {
                }

                @Override
                public void onError()
                {
                }
            });
        }
        container.addView(imageView);
        imageView.setTag("BannerThumbnailNumber_" + String.valueOf(position));
        return imageView;
    }

    @Override
    public boolean isViewFromObject(View view, Object object)
    {
        return view == object;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object)
    {
        container.removeView((ImageView) object);
    }

    public ContentItem getContentItem(int position)
    {
        ContentItem result = null;
        if (mContent != null && mContent.size() > position)
        {
            result = mContent.get(position);
        }
        return result;
    }


    public boolean isAdapterEmpty() {
        return mContent.isEmpty();
    }
}
