package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import android.widget.ImageView;

import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;

import java.io.File;

/**
 * Created by roni on 9/24/2015.
 */
public class ParentalLockButton extends ImageView {
    private final String TAG = ParentalLockButton.class.getSimpleName();

    private boolean mIsLockActive;
    private boolean mIsImageFilesExist;
    private boolean mIsLockStateChanged;

    private File mLockActiveImageFile;
    private File mLockUnActiveImageFile;
    private int mWidth;
    private int mHeight;
    private int mAnimationType;

    private Paint mWhitePaint;
    private Paint mBluePaint;
    private Paint mOrangePaint;
    private RectF mRectF;
    private RectF mLockOpenRectF;

    private ParentalLockButtonListener mParentalLockButtonListener;

    public ParentalLockButton(Context context, File lockActiveImage, File lockUnActiveImage, ParentalLockButtonListener parentalLockButtonListener) {
        super(context);
        mParentalLockButtonListener = parentalLockButtonListener;
        mLockActiveImageFile = lockActiveImage;
        mLockUnActiveImageFile = lockUnActiveImage;
        setScaleType(ScaleType.FIT_XY);
        initView();
    }

    private void initView() {

        mIsImageFilesExist = ((mLockActiveImageFile != null && mLockActiveImageFile.exists() == true) && (mLockActiveImageFile != null && mLockUnActiveImageFile.exists() == true));

        initImageParameters();
        initPaints();
        initRectF();
        initOnClickAnimation();
    }

    private void initOnClickAnimation() {
        setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                if (mParentalLockButtonListener != null) {
                    mParentalLockButtonListener.onClickStarted();
                }

                switch (mAnimationType) {
                    case 1: {
                        GenAnimator.playStandUpAnimation(view, new Animator.AnimatorListener() {
                            @Override
                            public void onAnimationStart(Animator animation) {

                            }

                            @Override
                            public void onAnimationEnd(Animator animation) {
                                if (mParentalLockButtonListener != null) {
                                    mParentalLockButtonListener.onClickEnd();
                                }
                            }

                            @Override
                            public void onAnimationCancel(Animator animation) {

                            }

                            @Override
                            public void onAnimationRepeat(Animator animation) {

                            }
                        });
                        break;
                    }
                }
            }
        });
    }

    private void loadImage() {
        if (getDrawable() == null || mIsLockStateChanged == true) {
            mIsLockStateChanged = false;
            if (mIsLockActive == true) {
                if (mLockActiveImageFile != null && mLockActiveImageFile.exists() == true) {
                    PicassoOk.getPicasso(getContext()).load(mLockActiveImageFile).into(this);
                }
            } else {
                if (mLockUnActiveImageFile != null && mLockUnActiveImageFile.exists() == true) {
                    PicassoOk.getPicasso(getContext()).load(mLockUnActiveImageFile).into(this);
                }
            }
        }
    }

    private void initImageParameters() {
        float mScaleFactor = ScreenUtils.getScaleFactor(getContext());
        mWidth = 178;
        mHeight = 128;
        mAnimationType = 1;
        if (mIsImageFilesExist) {

            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(mLockActiveImageFile.getAbsolutePath(), options);

            mWidth = options.outWidth;
            mHeight = options.outHeight;
            // String animationType = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ImageAssetsUtils.LOCK_ACTIVE_BUTTON_ANIMATION_TYPE, "1", Context.MODE_PRIVATE);
        }
        mWidth *= mScaleFactor;
        mHeight *= mScaleFactor;
    }

    private void initPaints() {
        mWhitePaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mWhitePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        mWhitePaint.setColor(Color.parseColor("#ffffff"));

        mBluePaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mBluePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        mBluePaint.setColor(Color.parseColor("#04a0e1"));

        mOrangePaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mOrangePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        mOrangePaint.setColor(Color.parseColor("#e59024"));

        setLayerType(LAYER_TYPE_SOFTWARE, mWhitePaint);
    }

    private void initRectF() {
        float left = (63f / 178f) * mWidth;
        float top = (64f / 136f) * mHeight;
        float right = (102f / 178f) * mWidth;
        float bottom = (93f / 136f) * mHeight;
        mRectF = new RectF(left, top, right, bottom);

        left = (92f / 178f) * mWidth;
        top = (53f / 136f) * mHeight;
        right = (107f / 178f) * mWidth;
        bottom = (68f / 136f) * mHeight;
        mLockOpenRectF = new RectF(left, top, right, bottom);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        setMeasuredDimension(mWidth, mHeight);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        if (mIsImageFilesExist == false) {
            // Draw left line
            float left = (19f / 178f) * mWidth;
            float top = (0f / 136f) * mHeight;
            float right = (21f / 178f) * mWidth;
            float bottom = (87f / 136f) * mHeight;
            canvas.drawRect(left, top, right, bottom, mWhitePaint);

            // Draw right line
            left = (149f / 178f) * mWidth;
            top = (0f / 136f) * mHeight;
            right = (151f / 178f) * mWidth;
            bottom = (62f / 136f) * mHeight;
            canvas.drawRect(left, top, right, bottom, mWhitePaint);

            // Draw bottom right circle
            float radius = (42f / 136f) * mHeight;
            float centerX = (136f / 178f) * mWidth;
            float centerY = (94f / 136f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

            // Draw the bottom left circle
            radius = (26f / 136f) * mHeight;
            centerX = (26f / 178f) * mWidth;
            centerY = (110f / 136f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

            // Draw the background circle
            radius = (49.4f / 136f) * mHeight;
            centerX = (75.5f / 178f) * mWidth;
            centerY = (74.5f / 136f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

            // Draw the background rectangle
            left = (29f / 178f) * mWidth;
            top = (109f / 136f) * mHeight;
            right = (140f / 178f) * mWidth;
            bottom = (136f / 136f) * mHeight;
            canvas.drawRect(left, top, right, bottom, mWhitePaint);

            // Draw the lock circle
            mWhitePaint.setShadowLayer(2.0f, 0.0f, 3.0f, 0xFF7c7c7c);
            radius = (42f / 136f) * mHeight;
            centerX = (82f / 178f) * mWidth;
            centerY = (72f / 136f) * mHeight;
            canvas.save();
            canvas.rotate(-45f, centerX, centerY);
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);
            mWhitePaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0x00000000);
            canvas.restore();

            if (mIsLockActive == true) {
                // Draw the active lock circle
                radius = (16.5f / 136f) * mHeight;
                centerX = (82.5f / 178f) * mWidth;
                centerY = (60.5f / 136f) * mHeight;
                canvas.drawCircle(centerX, centerY, radius, mBluePaint);

                // Draw the inner active lock circle
                radius = (9.2f / 136f) * mHeight;
                centerX = (82.5f / 178f) * mWidth;
                centerY = (60.5f / 136f) * mHeight;
                canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

                // Erase the middle of the lock circle
                left = (73f / 178f) * mWidth;
                top = (62f / 136f) * mHeight;
                right = (91f / 178f) * mWidth;
                bottom = (80f / 136f) * mHeight;
                canvas.drawRect(left, top, right, bottom, mWhitePaint);
            } else {
                // Draw the un active lock circle
                radius = (16.5f / 136f) * mHeight;
                centerX = (82.5f / 178f) * mWidth;
                centerY = (60.5f / 136f) * mHeight;
                canvas.drawCircle(centerX, centerY, radius, mOrangePaint);

                // Draw the inner active lock circle
                radius = (9.2f / 136f) * mHeight;
                centerX = (82.5f / 178f) * mWidth;
                centerY = (60.5f / 136f) * mHeight;
                canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

                // Erase the an arc of the un active circle
                left = (73f / 178f) * mWidth;
                top = (62f / 136f) * mHeight;
                right = (91f / 178f) * mWidth;
                bottom = (80f / 136f) * mHeight;
                canvas.drawRect(left, top, right, bottom, mWhitePaint);

                // Erase the middle of the lock circle
                centerX = (99.5f / 178f) * mWidth;
                centerY = (60.5f / 136f) * mHeight;
                canvas.save();
                canvas.rotate(-45f, centerX, centerY);
                canvas.drawRect(mLockOpenRectF, mWhitePaint);
                canvas.restore();
            }

            // Draw the lock base shape
            radius = (4f / 178f) * mWidth;
            canvas.drawRoundRect(mRectF, radius, radius, mBluePaint);

            // Draw the lock key hole white icon circle
            radius = (4.5f / 136f) * mHeight;
            centerX = (82.5f / 178f) * mWidth;
            centerY = (75.5f / 136f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

            // Draw the lock key hole white icon rectangle
            left = (81f / 178f) * mWidth;
            top = (78f / 136f) * mHeight;
            right = (84f / 178f) * mWidth;
            bottom = (87f / 136f) * mHeight;
            canvas.drawRect(left, top, right, bottom, mWhitePaint);
        } else {
            loadImage();
        }
    }

    public interface ParentalLockButtonListener {
        void onClickStarted();

        void onClickEnd();
    }

    public void setIsLockActive(boolean isLockActive) {
        mIsLockStateChanged = true;
        mIsLockActive = isLockActive;
        invalidate();
    }
}
