package com.kidoz.sdk.api.ui_views;


import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.FeedViewDialog;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.AssetUtil;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;

import org.json.JSONObject;

import java.io.File;

/**
 * Created by User on 16/07/2015.
 */
public class FeedFullView extends FrameLayout {
    private ContentPanelView mContentPanelView;
    private ContentData mContentData;

    private KidozTopBar mKidozTopBar;
    private KidozBottomBar mKidozBottomBar;

    // Close button click listener
    private OnClickListener mCloseBtnClickListener = null;
    private JSONObject mPropertiesObject;

    public FeedFullView(Context context, JSONObject propertiesObject) {
        super(context);
        mPropertiesObject = propertiesObject;
        initView();
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog("HERE", ">>>>FeedFullVeiw: onConfigurationChanged");
    }

    private void initView() {
        //Create container view.
        RelativeLayout containerLayout = new RelativeLayout(getContext());
        containerLayout.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

        String startColor = "#98e0ff";
        String centerColor = "#e0e4ed";
        String endColor = "#98e0ff";

        if (mPropertiesObject != null) {
            startColor = mPropertiesObject.optString(FeedViewDialog.CONTENT_MAIN_BACKGROUND_COLOR_START, "#98e0ff");
            centerColor = mPropertiesObject.optString(FeedViewDialog.CONTENT_MAIN_BACKGROUND_COLOR_CENTER, "#e0e4ed");
            endColor = mPropertiesObject.optString(FeedViewDialog.CONTENT_MAIN_BACKGROUND_COLOR_END, "#98e0ff");
        }

        GradientDrawable gradientDrawable = new GradientDrawable(
                GradientDrawable.Orientation.TOP_BOTTOM,
                new int[]{Color.parseColor(startColor), Color.parseColor(centerColor), Color.parseColor(endColor)}
        );

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            containerLayout.setBackground(gradientDrawable);
        } else {
            containerLayout.setBackgroundDrawable(gradientDrawable);
        }

        // Create header to container.

        mKidozTopBar = new KidozTopBar(getContext(), false, WidgetType.WIDGET_TYPE_FEED.getStringValue(), mPropertiesObject);
        mKidozTopBar.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        mKidozTopBar.setTitle("More Cool Stuff");
        mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener() {
            @Override
            public void onExitClicked(View view) {
                if (mCloseBtnClickListener != null) {
                    mCloseBtnClickListener.onClick(null);
                }
            }

        });
        mKidozTopBar.showParentalLockIcon(true);

        // Create footer to container.

        File imageBg = null;
        if (mPropertiesObject != null) {
            imageBg = AssetUtil.getAssetFile(getContext(), mPropertiesObject.optString(FeedViewDialog.BOTTOM_BAR_BACKGROUND, ""));
        }

        mKidozBottomBar = new KidozBottomBar(getContext(), imageBg);
        mKidozBottomBar.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());

        //Create main feed view. Content panel view
        mContentPanelView = new ContentPanelView(getContext(), ContentPanelView.LayoutViewType.STAGGERED);
        Point point = com.kidoz.sdk.api.general.utils.Utils.getScreenSize(getContext());
        int paddingBottom = (int) (Math.max(point.x, point.y) * KidozBottomBar.BACKGROUND_RATIO);
        int paddingTop = (int) (Math.max(point.x, point.y) * KidozTopBar.BACKGROUND_RATIO);
        mContentPanelView.getInnerRecyclerView().setPadding(0, paddingTop, 0, paddingBottom);
        mContentPanelView.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        // Add main view.
        containerLayout.addView(mContentPanelView, params);

        // Add top bar.
        params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        containerLayout.addView(mKidozTopBar, params);

        // Add botom bar.
        params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        containerLayout.addView(mKidozBottomBar, params);

        addView(containerLayout, new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT));
        initOnBoardingCloud();
    }

    public void setContentDataAndRefresh(ContentData contentData) {
        mContentData = contentData;
        // set biew styling
        applyViewStyling();
        if (mContentData != null) {
            String alreadyBoardedKey = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), OnBoardingView.ON_BOARDING_SHARED_PREFERENCES_KEY);
            if (alreadyBoardedKey == null) {
                SharedPreferencesUtils.saveSharedPreferencesData(getContext(), OnBoardingView.ON_BOARDING_SHARED_PREFERENCES_KEY, OnBoardingView.ON_BOARDING_SHARED_PREFERENCES_KEY);
                postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        mContentPanelView.addDataAndRefreshView(mContentData);
                    }
                }, 3200);
            } else {
                mContentPanelView.addDataAndRefreshView(mContentData);
            }
        }
    }

    /**
     * Apply view customization settings recieved from the server
     */
    private void applyViewStyling() {
        if (mContentData != null) {

            mContentPanelView.setRoundingCorenrsValue(mContentData.getViewItemCorenrRadiusPx());
        }
    }

    /**
     * Set on close button click listener
     *
     * @param clickListenr click listener
     */
    public void setOnCloseButtonClickListenr(OnClickListener clickListenr) {
        mCloseBtnClickListener = clickListenr;
        if (mKidozBottomBar != null) {
            mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener() {
                @Override
                public void onExitClicked(View view) {
                    if (mCloseBtnClickListener != null) {
                        mCloseBtnClickListener.onClick(null);
                    }
                }
            });
        }
    }

    /**
     * Set on content item click listener
     *
     * @param listener click listener
     */
    public void setOnContentItemClickListener(ContentPanelView.IOnContentItemClickListener listener) {
        if (mContentPanelView != null) {
            mContentPanelView.setOnContentItemClickListener(listener);
        }
    }

    private void initOnBoardingCloud() {
        String alreadyBoardedKey = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), OnBoardingView.ON_BOARDING_SHARED_PREFERENCES_KEY + "2");
        if (alreadyBoardedKey == null) {
            SharedPreferencesUtils.saveSharedPreferencesData(getContext(), OnBoardingView.ON_BOARDING_SHARED_PREFERENCES_KEY + "2", OnBoardingView.ON_BOARDING_SHARED_PREFERENCES_KEY);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);

            File file = null;
            if (mPropertiesObject != null) {
                file = AssetUtil.getAssetFile(getContext(), mPropertiesObject.optString(FeedViewDialog.ON_BOARDING_CLOUD, ""));
            }

            final OnBoardingView onBoardingView = new OnBoardingView(getContext(), file);
            addView(onBoardingView, params);

            Utils.setOnGlobalLayoutFinishListener(this, new Utils.OnGlobalLayoutFinishedListener() {
                @Override
                public void onLayoutFinished() {
                    onBoardingView.animateView(new OnBoardingView.OnBoardingCloudInterface() {
                        @Override
                        public void onFinished() {
                            removeView(onBoardingView);
                        }
                    });
                }
            });
        }
    }

    public KidozBottomBar getViewBottomBar() {
        return mKidozBottomBar;
    }

    /**
     * Show loading progress view
     */
    public void showLoadingProgressView(boolean show) {
        if (mContentPanelView != null) {
            mContentPanelView.showLoadingProgressView(show);
        }
    }

    /**
     * Check if view has contetn to show
     *
     * @return true/false
     */
    public boolean isViewEmpty() {
        return mContentData != null && mContentData.getContentDataItems().isEmpty();
    }
}


