package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Point;
import android.view.View;

import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.custom_drawables.DefaultPanelDrawable;
import com.kidoz.sdk.api.ui_views.parental_lock.StyleableButtonView;

/**
 * Created by Eugine on 11/8/2015.
 */
public class PanelStyleableButtonView extends StyleableButtonView
{

    private static final float DEFAULT_BUTTON_SIZE = 0.15f; // Size as percentage of the smallest betwen width and height

    private PanelButtonListener mPanelButtonListener;
    private PANEL_TYPE mPanelType;
    private int mAnimationType;

    private DefaultPanelDrawable mBtnClosedDefaultDrawable;
    private DefaultPanelDrawable mBtnOpenedDefaultDrawable;

    private PANEL_BUTTON_STATE mPanelButtonState;

    public enum PANEL_BUTTON_STATE
    {
        OPENED, CLOSED
    }

    public PanelStyleableButtonView(Context context, PANEL_TYPE panelType, PanelButtonListener panelButtonListener)
    {
        super(context);
        mPanelButtonListener = panelButtonListener;
        mPanelType = panelType;
        init();
    }

    private void init()
    {
        mAnimationType = 1;
        initOnClickAnimation();
    }

    private void initOnClickAnimation()
    {
        setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(View view)
            {
                if (mPanelButtonListener != null)
                {
                    mPanelButtonListener.onClickStarted();
                }

                switch (mAnimationType)
                {
                    case 1:
                    {
                        GenAnimator.playPanelButtonClickAnimation(view, mPanelType, new Animator.AnimatorListener()
                        {
                            @Override
                            public void onAnimationStart(Animator animation)
                            {

                            }

                            @Override
                            public void onAnimationEnd(Animator animation)
                            {
                                if (mPanelButtonListener != null)
                                {
                                    mPanelButtonListener.onClickEnd();
                                }
                            }

                            @Override
                            public void onAnimationCancel(Animator animation)
                            {

                            }

                            @Override
                            public void onAnimationRepeat(Animator animation)
                            {

                            }
                        });
                        break;
                    }
                }
            }
        });
    }

    public interface PanelButtonListener
    {
        void onClickStarted();

        void onClickEnd();
    }


    public void loadPanelButtonStyle(String url_main, DefaultPanelDrawable defaultImageDrawable_main, String url_secondary, DefaultPanelDrawable defaultImageDrawable_secondary)
    {
        mBtnClosedDefaultDrawable = defaultImageDrawable_main;
        mBtnOpenedDefaultDrawable = defaultImageDrawable_secondary;

        Point screenSize = Utils.getScreenSize(getContext());
        int size = Math.min(screenSize.x, screenSize.y);
        float percentageSize = DEFAULT_BUTTON_SIZE;
        PropertiesObj appConfig = DatabaseManager.getInstance(getContext()).getConfigTable().loadAppProperties();
        if (appConfig != null)
        {
            percentageSize = (float) appConfig.getPanelButtonScaleValue();
            if (percentageSize < 0.02)
            {
                percentageSize = DEFAULT_BUTTON_SIZE;
            }
        }
        size = (int) (size * percentageSize);

        loadButtonStyle(size, url_main, defaultImageDrawable_main, url_secondary, defaultImageDrawable_secondary, "pnlBtn");
    }

    public void setPanelType(PANEL_TYPE panelType)
    {
        mPanelType = panelType;
        if (mBtnClosedDefaultDrawable != null && mBtnOpenedDefaultDrawable != null)
        {
            mBtnClosedDefaultDrawable.setPanelType(panelType);
            mBtnOpenedDefaultDrawable.setPanelType(panelType);
        }
        mImageView1.postInvalidate();
        mImageView2.postInvalidate();
    }

    public void setBaseColor(int baseColor)
    {
        if (mBtnClosedDefaultDrawable != null && mBtnOpenedDefaultDrawable != null)
        {
            mBtnClosedDefaultDrawable.setBaseColor(baseColor);
            mBtnOpenedDefaultDrawable.setBaseColor(baseColor);
        }
        mImageView1.postInvalidate();
        mImageView2.postInvalidate();
    }

    public void setPanelButtonState(PANEL_BUTTON_STATE panelButtonState)
    {
        mPanelButtonState = panelButtonState;
        switch (panelButtonState)
        {
            case CLOSED:
            {
                showButtonState(ButtonState.FIRST);
                break;
            }

            case OPENED:
            {
                showButtonState(ButtonState.SECOND);
                break;
            }
        }
        postInvalidate();
    }
}
