package com.kidoz.sdk.api.ui_views.one_item_view;

import android.animation.Animator;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.assets_handling.SoundAssetsUtils;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SdkSoundManager;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.parental_lock.StyleableButtonView;

import java.util.ArrayList;
import java.util.HashMap;


public class OneItemView extends RelativeLayout
{
    private final int AUTO_SCROLL_DELAY = 10000;
    private final String TAG = OneItemView.class.getSimpleName();
    private final float BUTTON_DISABLE_ALPHA = 0.3f;
    private final int BUTTON_WIDTH = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 30);
    private StyleableButtonView mNextButton;
    private StyleableButtonView mGifView;
    private AutoScrollViewPager mViewPager;
    private ItemViewPagerAdapter mAdapter;
    private int mViewPagerWidth;
    private int mViewPagerHeight;
    private HashMap<String, Integer> mSponsoredContentDisplayed = new HashMap<String, Integer>();
    private ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;
    private Handler mHandler;

    private final int NUMBER_OF_ANIMATION_LOADING_TRIES = 7;
    private int mLoadAnimationTriesCounter;

    public OneItemView(Context context)
    {
        super(context);
        initView();
    }

    private void initView()
    {
        float SCALE_FACTOR = ScreenUtils.getScaleFactor(getContext());
        mViewPagerWidth = (int) (517f * SCALE_FACTOR);
        mViewPagerHeight = (int) (402f * SCALE_FACTOR);
        mHandler = new Handler(Looper.getMainLooper());
        initNextButton();
        initViewPager();
        initAnimationView();
    }

    private void initAnimationView()
    {
        mGifView = new StyleableButtonView(getContext());
        mGifView.setImageViewScaleType(ImageView.ScaleType.FIT_END);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(mViewPagerWidth, mViewPagerHeight);
        addView(mGifView, params);
        loadAnimation();

        mGifView.setOnTouchListener(new OnTouchListener()
        {
            @Override
            public boolean onTouch(View v, MotionEvent event)
            {
                return true;
            }
        });
    }

    private void loadAnimation()
    {
        PropertiesObj appConfig = DatabaseManager.getInstance(getContext()).getConfigTable().loadAppProperties();
        if (appConfig != null)
        {
            if (mGifView != null)
            {
                mGifView.loadButtonStyle(mViewPagerWidth, appConfig.getFamilyPanelAnimationUrl(), null, "FamilyPanelAnimation");
            }
        }
        else
        {
            if (mLoadAnimationTriesCounter < NUMBER_OF_ANIMATION_LOADING_TRIES)
            {
                mHandler.postDelayed(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        mLoadAnimationTriesCounter++;
                        loadAnimation();
                    }
                }, 1000);

            }
        }
    }

    private void initViewPager()
    {
        mViewPager = new AutoScrollViewPager(getContext());
        mViewPager.setInterval(AUTO_SCROLL_DELAY);
        mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener()
        {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels)
            {

            }

            @Override
            public void onPageSelected(int position)
            {
                sendImpressionLog(position % mAdapter.getCount());
                mViewPager.startAutoScroll(AUTO_SCROLL_DELAY);
            }

            @Override
            public void onPageScrollStateChanged(int state)
            {

            }
        });
        mViewPager.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        int margin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 6);
        mViewPager.setPageMargin(margin);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(mViewPagerWidth, mViewPagerHeight);
        addView(mViewPager, params);
    }

    private void initNextButton()
    {
        mNextButton = new StyleableButtonView(getContext());
        mNextButton.setImageViewScaleType(ImageView.ScaleType.FIT_CENTER);
        mNextButton.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        addView(mNextButton, params);
        mNextButton.setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                mNextButton.setClickable(false);
                SdkAnimationsUtils.animateClick(mNextButton, new Animator.AnimatorListener()
                {
                    @Override
                    public void onAnimationStart(Animator animation)
                    {

                    }

                    @Override
                    public void onAnimationEnd(Animator animation)
                    {
                        mNextButton.setClickable(true);
                        mViewPager.setCurrentItem(mViewPager.getCurrentItem() + 1);
                    }

                    @Override
                    public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
            }
        });
        mNextButton.loadButtonStyle(BUTTON_WIDTH, "https://s3.amazonaws.com/kidoz.test.bucket/next_btn.png", null, "NextButton");
    }

    private void sendImpressionLog(int position)
    {
        ContentItem contentItem = mAdapter.getContentItem(position);
        if (contentItem != null && contentItem.isPromoted() == true)
        {
            if (mSponsoredContentDisplayed != null)
            {
                if (mSponsoredContentDisplayed.containsKey(contentItem.getId()) == false)
                {
                    mSponsoredContentDisplayed.put(contentItem.getId(), position);
                    EventManager.getInstance(getContext()).logSponsoredContentImpressionEvent(getContext(), WidgetType.WIDGET_TYPE_FAMILY_PANEL, EventParameters.ACTION_IMPRESSION, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position, false);
                }
            }
        }
    }

    public void fixParams()
    {
        int margin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 6);

        RelativeLayout.LayoutParams viewPagerParams = new RelativeLayout.LayoutParams(mViewPagerWidth, mViewPagerHeight);
        RelativeLayout.LayoutParams nextButtonParams = new RelativeLayout.LayoutParams(BUTTON_WIDTH, (int) (mViewPagerHeight * 0.87f));
        RelativeLayout.LayoutParams animationParams = new RelativeLayout.LayoutParams(mViewPagerWidth, mViewPagerHeight);

        mViewPager.setLayoutParams(viewPagerParams);
        mNextButton.setLayoutParams(nextButtonParams);
        animationParams.rightMargin = -2 * margin;
        mGifView.setLayoutParams(animationParams);
        getLayoutParams().width = (mViewPagerWidth * 2) + BUTTON_WIDTH;
        getLayoutParams().height = mViewPagerHeight + (margin * 2);
        setPadding(0, margin, 0, margin);
        nextButtonParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        viewPagerParams.addRule(RelativeLayout.LEFT_OF, mNextButton.getId());
        animationParams.addRule(RelativeLayout.LEFT_OF, mViewPager.getId());
    }

    public void setViewPagerItemClickListener(ItemViewPagerAdapter.ViewPagerItemClickListener viewPagerItemClickListener)
    {
        mViewPagerItemClickListener = viewPagerItemClickListener;
    }

    public void setContent(ArrayList<ContentItem> content, PANEL_TYPE panelType)
    {
        mSponsoredContentDisplayed.clear();

        mAdapter = new ItemViewPagerAdapter();
        mAdapter.setViewPagerItemClickListener(mViewPagerItemClickListener);
        mAdapter.setContent(content, panelType);
        PagerAdapter wrappedAdapter = new InfinitePagerAdapter(mAdapter);
        mViewPager.setAdapter(wrappedAdapter);
        mViewPager.startAutoScroll(AUTO_SCROLL_DELAY);

        SdkSoundManager.playSound(getContext(), SoundAssetsUtils.getSoundAssetFile(getContext(), SoundAssetsUtils.SOUND_ASSET_TYPE.FAMILY_PANEL_VIEW).getAbsolutePath());
    }
}
