package com.kidoz.sdk.api.ui_views.custom_drawables;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;

/**
 * Created by Eugine on 9/30/2015.
 */
public class KidozLogoDrawable extends Drawable {

    private static final float CIRCLE_RADIUS_SIZE_RATIO = 0.16f;

    private static final float CIRCLE_FIRST_LEVEL_VERTICAL_RATIO = 0.35f;

    private static final float CIRCLE_SECOND_LEVEL_VERTICAL_RATIO = 0.45f;
    private static final float CIRCLE_SECOND_LEVEL_HORIZONTAL_RATIO = 0.30f;

    private static final float CIRCLE_THIRD_LEVEL_VERTICAL_RATIO = 0.62f;
    private static final float CIRCLE_THIRD_LEVEL_HORIZONTAL_RATIO = 0.31f;

    private static final float CIRCLE_FOURTH_LEVEL_VETICAL_RATIO = CIRCLE_THIRD_LEVEL_VERTICAL_RATIO - 0.04f;

    private Paint mLogoPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
    private RectF mRectF = new RectF();

    private int mWidth;
    private int mHeight;

    private float mDefaultBgRadius;
    private int mDefaultBgColor = Color.WHITE;

    public KidozLogoDrawable() {
        initRectF();
    }

    private void initRectF() {
        mLogoPaint.setDither(true);
    }

    @Override
    public void draw(Canvas canvas) {

        mLogoPaint.setColor(Color.parseColor("#ffffff"));

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            canvas.drawRoundRect(0, 0, mWidth, mHeight, mDefaultBgRadius, mDefaultBgRadius, mLogoPaint);
        } else {
            canvas.drawRoundRect(mRectF, mDefaultBgRadius, mDefaultBgRadius, mLogoPaint);
        }

        float radius = CIRCLE_RADIUS_SIZE_RATIO * mWidth;

        // Draw the yellow circle
        mLogoPaint.setColor(Color.parseColor("#f8de46"));
        canvas.drawCircle(mWidth / 2, CIRCLE_FIRST_LEVEL_VERTICAL_RATIO * mHeight, radius, mLogoPaint);

        // Draw the orange circle
        mLogoPaint.setColor(Color.parseColor("#f5f8a850"));
        canvas.drawCircle(CIRCLE_THIRD_LEVEL_HORIZONTAL_RATIO * mWidth, CIRCLE_THIRD_LEVEL_VERTICAL_RATIO * mHeight, radius, mLogoPaint);

        // Draw the green circle
        mLogoPaint.setColor(Color.parseColor("#f5b0d63a"));
        canvas.drawCircle(mWidth - CIRCLE_THIRD_LEVEL_HORIZONTAL_RATIO * mWidth, CIRCLE_THIRD_LEVEL_VERTICAL_RATIO * mHeight, radius, mLogoPaint);

        // Draw the orange circle
        mLogoPaint.setColor(Color.parseColor("#e13333"));
        canvas.drawCircle(CIRCLE_SECOND_LEVEL_HORIZONTAL_RATIO * mWidth, CIRCLE_SECOND_LEVEL_VERTICAL_RATIO * mHeight, radius, mLogoPaint);

        // Draw the blue circle
        mLogoPaint.setColor(Color.parseColor("#4aaed3"));
        canvas.drawCircle(mWidth - CIRCLE_SECOND_LEVEL_HORIZONTAL_RATIO * mWidth, CIRCLE_SECOND_LEVEL_VERTICAL_RATIO * mHeight, radius, mLogoPaint);

        // Draw the white circle
        mLogoPaint.setColor(Color.parseColor("#ffffff"));
        canvas.drawCircle(mWidth / 2, CIRCLE_FOURTH_LEVEL_VETICAL_RATIO * mHeight, radius, mLogoPaint);
    }

    @Override
    public void setAlpha(int alpha) {
        mLogoPaint.setAlpha(alpha);
    }

    @Override
    public void setColorFilter(ColorFilter cf) {
        mLogoPaint.setColorFilter(cf);
    }

    @Override
    public int getOpacity() {
        return PixelFormat.TRANSLUCENT;
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);

        mWidth = bounds.width();
        mHeight = bounds.height();

        mRectF = new RectF(0, 0, mWidth, mHeight);
        mDefaultBgRadius = 0.10f * mWidth;
    }
}
