package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;

/**
 * Created by roni on 7/26/2015.
 */
public class KidozTopBar extends RelativeLayout
{
    public static final String BACKGROUND_COLOR = "BACKGROUND_COLOR";

    public static final float BACKGROUND_RATIO = 118f / 1920f;
    private KidozTopBarListener mKidozTopBarListener;

    private boolean mIsParentalLockVisible;
    private boolean mIsClicksBlocked;

    private TitleView mTitleView;
    private ExitButton mExitButton;
    private ParentalLockButton mParentalLockButton;

    public KidozTopBar(Context context, boolean isUseBackButton)
    {
        super(context);
        initView(isUseBackButton);
    }

    public KidozTopBar(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView(false);
    }

    private void initView(boolean isUseBackButton)
    {
        initRootView();
        addBackground();
        initExitButton(isUseBackButton);
        initLockButton();
        initTitle();
    }

    private void initRootView()
    {
        setOnTouchListener(new OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                return mIsClicksBlocked;
            }
        });

        Utils.setOnGlobalLayoutFinishListener(this, new Utils.OnGlobalLayoutFinishedListener() {
            @Override
            public void onLayoutFinished() {
                mParentalLockButton.setVisibility(View.INVISIBLE);
                if (mIsParentalLockVisible) {
                    mParentalLockButton.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            GenAnimator.playDropAnimation(mParentalLockButton, new Animator.AnimatorListener() {
                                @Override
                                public void onAnimationStart(Animator animation) {
                                    mParentalLockButton.setVisibility(View.VISIBLE);
                                }

                                @Override
                                public void onAnimationEnd(Animator animation) {
                                    mParentalLockButton.setVisibility(View.VISIBLE);
                                }

                                @Override
                                public void onAnimationCancel(Animator animation) {

                                }

                                @Override
                                public void onAnimationRepeat(Animator animation) {

                                }
                            });
                        }
                    }, 320);
                }
                mExitButton.setVisibility(View.INVISIBLE);
                mExitButton.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        GenAnimator.playDropAnimation(mExitButton, new Animator.AnimatorListener() {
                            @Override
                            public void onAnimationStart(Animator animation) {
                                mExitButton.setVisibility(View.VISIBLE);
                            }

                            @Override
                            public void onAnimationEnd(Animator animation) {
                                mExitButton.setVisibility(View.VISIBLE);
                            }

                            @Override
                            public void onAnimationCancel(Animator animation) {

                            }

                            @Override
                            public void onAnimationRepeat(Animator animation) {

                            }
                        });
                    }
                }, 240);
            }
        });
    }

    private void addBackground()
    {
        float height = 118f;
        float scaleFactor = ScreenUtils.getScaleFactor(getContext());
        String color = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), BACKGROUND_COLOR, "#04a0e1", Context.MODE_PRIVATE);
        View view = new View(getContext());
        view.setBackgroundColor(Color.parseColor(color));
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, (int) (height * scaleFactor));
        addView(view, params);
    }

    private void initTitle()
    {
        mTitleView = new TitleView(getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        addView(mTitleView, params);
    }


    private void initLockButton()
    {
        mIsParentalLockVisible = true;
        mParentalLockButton = new ParentalLockButton(getContext(), new ParentalLockButton.ParentalLockButtonListener()
        {
            @Override public void onClickStarted()
            {

            }

            @Override public void onClickEnd()
            {
                if (mIsClicksBlocked == false)
                {
                    mIsClicksBlocked = true;
                    int lockStatus = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? 0 : 1;
                    EventManager.getInstance(getContext()).LogEventWithIntField(getContext(), WidgetType.WIDGET_TYPE_NONE, EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_PARENTAL_LOCK, EventParameters.ACTION_CLICK, EventParameters.LABEL_PARENTAL_LOCK_BUTTON, lockStatus,false);
                    if (ParentalLockDialog.getIsCanShowDialog(getContext()) == true)
                    {
                        int[] popLocation = new int[2];
                        popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * ParentalLockDialog.PIVOT_X_FACTOR);
                        popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * ParentalLockDialog.PIVOT_Y_FACTOR);
                        ParentalLockDialog parentalLockDialog = new ParentalLockDialog(getContext(), false, popLocation);
                        parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener()
                        {
                            @Override public void onDismiss(DialogInterface dialog)
                            {
                                mIsClicksBlocked = false;
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
                                mParentalLockButton.setIsLockActive(isLockActive);
                            }
                        });
                        parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener()
                        {
                            @Override public void onPasswordEntered(boolean isPasswordCorrect)
                            {
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
                                mParentalLockButton.setIsLockActive(isLockActive);
                            }
                        });
                        parentalLockDialog.show();
                    }
                    else
                    {
                        mIsClicksBlocked = false;
                    }
                }
            }
        });
        mParentalLockButton.setId(Utils.generateViewId());
        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
        mParentalLockButton.setIsLockActive(isLockActive);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.LEFT_OF, mExitButton.getId());
        params.rightMargin = (int) (5f * ScreenUtils.getScaleFactor(getContext()));
        addView(mParentalLockButton, params);
    }

    private void initExitButton(boolean isUseBackButton)
    {
        mExitButton = new ExitButton(getContext(), new ExitButton.ExitButtonListener()
        {
            @Override public void onClickStarted()
            {

            }

            @Override public void onClickEnd()
            {
                if (mIsClicksBlocked == false)
                {
                    mIsClicksBlocked = true;
                    EventManager.getInstance(getContext()).logEvent(getContext(), WidgetType.WIDGET_TYPE_NONE, EventManager.LOG_NORMAL_LEVEL, null, EventParameters.CATEGORY_SDK, EventParameters.ACTION_CLICK, EventParameters.LABEL_BACK_BUTTON, false);
                    if (mKidozTopBarListener != null)
                    {
                        mKidozTopBarListener.onExitClicked(null);
                    }
                }
            }
        }, isUseBackButton);
        mExitButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        params.rightMargin = (int) (5f * ScreenUtils.getScaleFactor(getContext()));
        addView(mExitButton, params);
    }

    public void setKidozTopBarListener(KidozTopBarListener kidozTopBarListener)
    {
        mKidozTopBarListener = kidozTopBarListener;
    }

    public void setTitle(String title)
    {
        if (mTitleView != null)
        {
            mTitleView.setTitle(title);
            invalidate();
        }
    }

    public void setTopBarBackgroundColor(int color)
    {

    }

    public interface KidozTopBarListener
    {
        void onExitClicked(View view);
    }


    private static int getTitleTextSizeByScreenLayout(Context context)
    {
        int size = 20;
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        screenLayout &= Configuration.SCREENLAYOUT_SIZE_MASK;

        switch (screenLayout)
        {
            case Configuration.SCREENLAYOUT_SIZE_SMALL:
            {
                size = 18;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_NORMAL:
            {
                size = 21;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_LARGE:
            {
                size = 26;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_XLARGE:
            {
                size = 30;
                break;
            }
        }
        return size;
    }

    public void showParentalLockIcon(boolean show)
    {
        mIsParentalLockVisible = show;
        if (mIsParentalLockVisible)
        {
            mParentalLockButton.setVisibility(View.VISIBLE);
        }
        else
        {
            mParentalLockButton.setVisibility(View.INVISIBLE);
        }
    }

    @Override protected void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation == Configuration.ORIENTATION_PORTRAIT)
        {
            clearAnimation();
            setTranslationY(0f);
        }
    }
}
