package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Point;
import android.net.Uri;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.events.DeviceUtils;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.KidozWebView;
import com.kidoz.sdk.api.ui_views.custom_drawables.XViewDrawable;

/**
 * Created by Eugine on 7/27/2015.
 */
public class KidozBottomBar extends RelativeLayout {
    public static final float BACKGROUND_RATIO = 118f / 1920f;
    private Utils.StaticHandler mStaticHandler;
    private AboutKidozWebViewContainer mAboutKidozContainer;
    private int[] mAboutKidozPivot;
    private boolean mIsOrientationPortrait;
    private KidozWebView mKidozWebView;
    private boolean mIsNeedToCloseWebViewOnClick = true;


    public KidozBottomBar(Context context) {
        super(context);
        initView();
    }

    public KidozBottomBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView();
    }

    private void initView() {
        mIsOrientationPortrait = getContext().getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT ? true : false;
        initBackground();
        initPromotedByKidozTextView();
        initAboutKidoz();
    }

    private void initAboutKidoz() {
        // 1. Init about kidoz button
        int screenMaxSize = Math.min(ScreenUtils.getScreenSize(getContext(), true), (ScreenUtils.getScreenSize(getContext(), false)));
        float MARGIN = 50 / 1080f;
        AboutKidozView aboutKidozView = new AboutKidozView(getContext());
        aboutKidozView.setId(Utils.generateViewId());
        aboutKidozView.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                int[] popLocation = new int[2];
                popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(getContext(), popLocation);
                aboutKidozDialog.openDialog();
                //                mIsNeedToCloseWebViewOnClick = true;
                //                mAboutKidozContainer.setVisibility(View.VISIBLE);
                //                GenAnimator.playPopInFromRightBottom(mAboutKidozContainer, mAboutKidozPivot, new Animator.AnimatorListener()
                //                {
                //                    @Override public void onAnimationStart(Animator animation)
                //                    {
                //                        mAboutKidozContainer.setVisibility(View.VISIBLE);
                //
                //                    }
                //
                //                    @Override public void onAnimationEnd(Animator animation)
                //                    {
                //                        mAboutKidozContainer.requestLayout();
                //                    }
                //
                //                    @Override public void onAnimationCancel(Animator animation)
                //                    {
                //
                //                    }
                //
                //                    @Override public void onAnimationRepeat(Animator animation)
                //                    {
                //
                //                    }
                //                });
            }
        });
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        params.rightMargin = (int) (screenMaxSize * MARGIN);
        params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        addView(aboutKidozView, params);

        // 1.5 Init about kidoz button parameters
        mAboutKidozPivot = new int[2];
        mAboutKidozPivot[0] = aboutKidozView.getLayoutParams().width / 2;
        mAboutKidozPivot[1] = aboutKidozView.getLayoutParams().height;

        // 2. Init webview
        mKidozWebView = new KidozWebView(getContext());
        mKidozWebView.getSettings().setUseWideViewPort(true);
        mKidozWebView.getSettings().setLoadWithOverviewMode(true);
        mKidozWebView.getSettings().setSupportZoom(false);
        mKidozWebView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                mIsNeedToCloseWebViewOnClick = false;
                mKidozWebView.setWebViewClient(new WebViewClient() {
                    @Override
                    public boolean shouldOverrideUrlLoading(WebView view, String url) {
                        boolean result = true;
                        if (url.startsWith("mailto:")) {
                            Intent mailIntent = new Intent(Intent.ACTION_SENDTO, Uri.parse(url));
                            getContext().startActivity(mailIntent);
                        } else {
                            Intent linkIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                            getContext().startActivity(linkIntent);
                        }
                        return true;
                    }
                });
                return true;
            }
        });
        mKidozWebView.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                boolean result = false;
                if (event.getAction() == MotionEvent.ACTION_UP) {
                    getMyHandlerInstance().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            if (mIsNeedToCloseWebViewOnClick == true && mAboutKidozContainer.getVisibility() == View.VISIBLE) {
                                hideAboutView();
                            }
                            mIsNeedToCloseWebViewOnClick = true;
                        }
                    }, 150);
                } else {
                    if (event.getAction() == MotionEvent.ACTION_MOVE) {
                        mIsNeedToCloseWebViewOnClick = false;
                    }
                    if (mIsOrientationPortrait == true) {
                        result = (event.getAction() == MotionEvent.ACTION_MOVE);
                    }
                }
                return result;
            }
        });
        mKidozWebView.setLongClickable(true);
        mKidozWebView.setOnLongClickListener(new OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                return true;
            }
        });
        mKidozWebView.setVerticalScrollBarEnabled(false);
        mKidozWebView.setHorizontalScrollBarEnabled(false);
        mKidozWebView.loadUrl("http://kidoz.net/v3policy/");

        // 3. Init web view container and add webview
        mAboutKidozContainer = new AboutKidozWebViewContainer(getContext());
        mAboutKidozContainer.setVisibility(View.INVISIBLE);
        mAboutKidozContainer.addView(mKidozWebView, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT));

        Point point = DeviceUtils.getScreenSize(getContext());
        int size = Math.min(point.x, point.y);
        size = (int) (size * 0.058);

        XViewDrawable xViewDrawable = new XViewDrawable(getContext(), Color.parseColor("#04a0e1"));
        xViewDrawable.setBounds(0, 0, size, size);
        ImageView closeImageView = new ImageView(getContext());
        closeImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        closeImageView.setImageDrawable(xViewDrawable);

        closeImageView.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 100, new GenAnimator.ViewAnimationListener() {
                    @Override
                    public void onAnimationEnd() {
                        hideAboutView();
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });

        RelativeLayout.LayoutParams relParams = new RelativeLayout.LayoutParams(size, size);
        relParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        relParams.setMargins(0, Utils.dpTOpx(getContext(), 5), Utils.dpTOpx(getContext(), 5), 0);
        mAboutKidozContainer.addView(closeImageView, relParams);

        RelativeLayout.LayoutParams webViewContainerParams = new RelativeLayout.LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        webViewContainerParams.addRule(RelativeLayout.ALIGN_RIGHT, aboutKidozView.getId());
        webViewContainerParams.addRule(RelativeLayout.ALIGN_BOTTOM, aboutKidozView.getId());
        webViewContainerParams.leftMargin = (int) (screenMaxSize * MARGIN);
        addView(mAboutKidozContainer, webViewContainerParams);
    }

    /**
     * Hide about view
     */
    public void hideAboutView() {
        GenAnimator.playPopOutToRightBottom(mAboutKidozContainer, mAboutKidozPivot, new Animator.AnimatorListener() {
            @Override
            public void onAnimationStart(Animator animation) {
            }

            @Override
            public void onAnimationEnd(Animator animation) {
                mAboutKidozContainer.setVisibility(View.INVISIBLE);
                mKidozWebView.goBack();
            }

            @Override
            public void onAnimationCancel(Animator animation) {
                mAboutKidozContainer.setVisibility(View.INVISIBLE);
            }

            @Override
            public void onAnimationRepeat(Animator animation) {

            }
        });
    }

    /**
     * Get is about view visible
     *
     * @return is visible
     */
    public boolean isAboutViewVisible() {
        return mAboutKidozContainer.getVisibility() == View.VISIBLE;
    }

    private void initBackground() {
        BottomBarView bottomBarView = new BottomBarView(getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        params.addRule(RelativeLayout.CENTER_HORIZONTAL);
        addView(bottomBarView, params);
    }

    private void initPromotedByKidozTextView() {
        TextView textView = new TextView(getContext());
        textView.setText("Promoted content by KIDOZ");
        textView.setTextSize(14f);
        textView.setSingleLine(true);
        textView.setGravity(Gravity.CENTER);
        textView.setTextColor(Color.WHITE);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        params.addRule(RelativeLayout.CENTER_HORIZONTAL);
        addView(textView, params);
    }

    public void setBackgroundURI() {
        //        if (mViewBackground != null)
        //        {
        //            mViewBackground.setImageURI(Utils.prepareCorrectUri(R.drawable.bottom_bar_background));
        //        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        mIsOrientationPortrait = getContext().getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT ? true : false;
        mKidozWebView.scrollTo(0, 0);
    }

    /**
     * Get handler instance
     */
    private Utils.StaticHandler getMyHandlerInstance() {
        if (mStaticHandler == null) {
            mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper()) {
                @Override
                public void handleMessage(Message message) {
                    // This is where you do your work in the UI thread.
                    // Your worker tells you in the message what to do.
                }
            };
        }
        return mStaticHandler;
    }
}
