package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.widget.ImageView;

import com.kidoz.sdk.api.general.assets_handling.ImageAssetsUtils;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;

import java.io.File;

/**
 * Created by roni on 9/24/2015.
 */
public class BottomBarView extends ImageView
{
    private final String TAG = BottomBarView.class.getSimpleName();

    private File mImageFile;
    private int mWidth;
    private int mHeight;
    private Paint mPaint;

    public BottomBarView(Context context)
    {
        super(context);
        setScaleType(ScaleType.FIT_XY);
        initView();
    }

    private void initView()
    {
        initImageFile();
        initImageParameters();
        initPaints();
    }

    private void initImageFile()
    {
        mImageFile = ImageAssetsUtils.getAssetFile(getContext(), ImageAssetsUtils.APP_ASSET_TYPE.BOTTOM_BAR);
    }

    private void loadImage()
    {
        if (mImageFile.exists() == true)
        {
            if (getDrawable() == null)
            {
                if(mImageFile != null) {
                    PicassoOk.getPicasso(getContext()).load(mImageFile).into(this);
                }
            }
        }
    }

    private void initImageParameters()
    {
        float mScaleFactor = ScreenUtils.getScaleFactor(getContext());
        mWidth = 3069;
        mHeight = 118;
        if (mImageFile != null && mImageFile.exists() == true)
        {
            String width = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ImageAssetsUtils.BOTTOM_BAR_WIDTH, "3069", Context.MODE_PRIVATE);
            String height = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ImageAssetsUtils.BOTTOM_BAR_HEIGHT, "118", Context.MODE_PRIVATE);

            try
            {
                mWidth = Integer.parseInt(width);
                mHeight = Integer.parseInt(height);
            }
            catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to init image parameters: " + ex.getMessage());
            }
        }
        mWidth *= mScaleFactor;
        mHeight *= mScaleFactor;
    }

    private void initPaints()
    {
        mPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mPaint.setStyle(Paint.Style.FILL_AND_STROKE);

        setLayerType(LAYER_TYPE_SOFTWARE, mPaint);
    }

    @Override protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec)
    {
        setMeasuredDimension(mWidth, mHeight);
    }

    @Override protected void onDraw(Canvas canvas)
    {
        super.onDraw(canvas);
        if (mImageFile.exists() == false)
        {
            // Draw first background circle
            float radius = (774.69f / 1920f) * mWidth;
            float centerX = (411.41f / 1920f) * mWidth;
            float centerY = (793.69f / 118f) * mHeight;
            mPaint.setColor(Color.parseColor("#94bc18"));
            canvas.drawCircle(centerX, centerY, radius, mPaint);

            // Draw second background circle
            radius = (927.51f / 1920f) * mWidth;
            centerX = (1500.2f / 1920f) * mWidth;
            centerY = (946.52f / 118f) * mHeight;
            mPaint.setColor(Color.parseColor("#94bc18"));
            canvas.drawCircle(centerX, centerY, radius, mPaint);

            // Draw first foreground circle
            radius = (527f / 1920f) * mWidth;
            centerX = (-50f / 1920f) * mWidth;
            centerY = (527f / 118f) * mHeight;
            mPaint.setColor(Color.parseColor("#a9d817"));
            canvas.drawCircle(centerX, centerY, radius, mPaint);

            // Draw second foreground circle
            radius = (921.88f / 1920f) * mWidth;
            centerX = (921.88f / 1920f) * mWidth;
            centerY = (921.88f / 118f) * mHeight;
            mPaint.setColor(Color.parseColor("#a9d817"));
            canvas.drawCircle(centerX, centerY, radius, mPaint);

            // Draw third foreground circle
            radius = (1043.47f / 1920f) * mWidth;
            centerX = (2015.03f / 1920f) * mWidth;
            centerY = (1043.45f / 118f) * mHeight;
            mPaint.setColor(Color.parseColor("#a9d817"));
            canvas.drawCircle(centerX, centerY, radius, mPaint);
        }
        else
        {
            loadImage();
        }
    }
}
