package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.TypedValue;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.sdk.api.general.utils.ScreenUtils;

/**
 * Created by roni on 9/30/2015.
 */
public class AboutKidozView extends RelativeLayout
{
    private final String TAG = AboutKidozView.class.getSimpleName();
    private int mWidth;
    private int mHeight;
    private Paint mLogoPaint;
    private RectF mRectF;

    public AboutKidozView(Context context)
    {
        super(context);
        initView();
    }

    private void initView()
    {
        setWillNotDraw(false);
        initImageParameters();
        initPaints();
        initRectF();
        initTitle();
    }


    private void initTitle()
    {
        float TEXT_SIZE = 20f / 136f;
        TextView title = new TextView(getContext());
        title.setSingleLine(true);
        title.setTextColor(Color.parseColor("#04a0e1"));
        title.setTextSize(TypedValue.COMPLEX_UNIT_PX, (int) (TEXT_SIZE * mHeight));
        title.setEllipsize(TextUtils.TruncateAt.END);
        title.setShadowLayer(2.0f, 1, 1, Color.parseColor("#666666"));
        title.setTypeface(null, Typeface.BOLD);
        title.setText("KIDOZ");
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        addView(title, params);
    }

    private void initRectF()
    {
        float left = 0f / 105f * mWidth;
        float top = 0f / 136f * mHeight;
        float right = 105f / 105f * mWidth;
        float bottom = 25f / 136f * mHeight;
        mRectF = new RectF(left, top, right, bottom);
    }

    private void initImageParameters()
    {
        float scaleFactor = ScreenUtils.getScaleFactor(getContext());
        mWidth = (int) (154f * scaleFactor);
        mHeight = (int) (200f * scaleFactor);
    }

    private void initPaints()
    {
        mLogoPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mLogoPaint.setStyle(Paint.Style.FILL_AND_STROKE);

        setLayerType(LAYER_TYPE_SOFTWARE, mLogoPaint);
    }

    @Override protected void onLayout(boolean changed, int l, int t, int r, int b)
    {
        float TEXT_WIDTH = 105f / 105f;
        float MARGIN_LEFT = 23f / 105f;
        float MARGIN_TOP = 80f / 136f;
        getChildAt(0).layout((int) (MARGIN_LEFT * mWidth), (int) (MARGIN_TOP * mHeight), (int) (TEXT_WIDTH * mWidth), getMeasuredHeight());
    }

    @Override protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec)
    {
        setMeasuredDimension(mWidth, mHeight);
    }

    @Override protected void onDraw(Canvas canvas)
    {
        super.onDraw(canvas);

        // Draw the background white rectangle
        float left = 0f / 105f * mWidth;
        float top = 13f / 136f * mHeight;
        float right = 105f / 105f * mWidth;
        float bottom = 136f / 136f * mHeight;
        mLogoPaint.setColor(Color.parseColor("#ffffff"));
        canvas.drawRect(left, top, right, bottom, mLogoPaint);

        // Draw the rounded top background white rectangle
        float radius = (12f / 105f) * mWidth;
        canvas.drawRoundRect(mRectF, radius, radius, mLogoPaint);

        // Draw the yellow circle
        radius = (19.5f / 105f) * mWidth;
        float centerX = (52.5f / 105f) * mWidth;
        float centerY = (30.5f / 136f) * mHeight;
        mLogoPaint.setColor(Color.parseColor("#f8de46"));
        canvas.drawCircle(centerX, centerY, radius, mLogoPaint);

        // Draw the red circle
        radius = (16.5f / 105f) * mWidth;
        centerX = (30.5f / 105f) * mWidth;
        centerY = (58.5f / 136f) * mHeight;
        mLogoPaint.setColor(Color.parseColor("#e13333"));
        canvas.drawCircle(centerX, centerY, radius, mLogoPaint);

        // Draw the blue circle
        radius = (16.5f / 105f) * mWidth;
        centerX = (73.5f / 105f) * mWidth;
        centerY = (58.5f / 136f) * mHeight;
        mLogoPaint.setColor(Color.parseColor("#4aaed3"));
        canvas.drawCircle(centerX, centerY, radius, mLogoPaint);

        // Draw the orange circle
        radius = (16.5f / 105f) * mWidth;
        centerX = (30.5f / 105f) * mWidth;
        centerY = (38.5f / 136f) * mHeight;
        mLogoPaint.setColor(Color.parseColor("#e6f8a850"));
        canvas.drawCircle(centerX, centerY, radius, mLogoPaint);

        // Draw the green circle
        radius = (16.5f / 105f) * mWidth;
        centerX = (73.5f / 105f) * mWidth;
        centerY = (38.5f / 136f) * mHeight;
        mLogoPaint.setColor(Color.parseColor("#e6b0d63a"));
        canvas.drawCircle(centerX, centerY, radius, mLogoPaint);

        // Draw the white circle
        radius = (16.5f / 105f) * mWidth;
        centerX = (52.5f / 105f) * mWidth;
        centerY = (57f / 136f) * mHeight;
        mLogoPaint.setColor(Color.parseColor("#ffffff"));
        canvas.drawCircle(centerX, centerY, radius, mLogoPaint);
    }
}
