package com.kidoz.sdk.api.server_connect;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.os.AsyncTask;
import android.os.AsyncTask.Status;
import android.os.Build;
import android.util.Log;

import com.kidoz.events.DeviceUtils;
import com.kidoz.sdk.api.general.assets_handling.ImageAssetsUtils;
import com.kidoz.sdk.api.general.assets_handling.SoundAssetsUtils;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.structure.ContentData;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;

import org.json.JSONObject;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map.Entry;

@SuppressLint("NewApi")
class BaseAPIManager extends BaseConnectionClient {
    private static final String TAG = BaseAPIManager.class.getSimpleName();
    private HashMap<SdkRequestType, RequestAsyncTask> runningTaskList = new HashMap<SdkRequestType, RequestAsyncTask>();
    private HashMap<String, StyleAsyncTaskLoader> mStyleLoadingTasks = new HashMap<String, StyleAsyncTaskLoader>();

    /**
     * Launch specific API request
     */
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    protected void startServerConnection(Context context, CONNECTION_TYPE type, SdkRequestType requestType, ContentValues contentValues, int numOfReconnecsOnFail, ApiResultCallback<?> resultCallback, boolean devLog,boolean removePrevRequest) {
        if(removePrevRequest) {
            try {
                if (runningTaskList.containsKey(requestType)) {
                    if (runningTaskList.get(requestType) != null) {
                        RequestAsyncTask task = runningTaskList.get(requestType);
                        if (task.getStatus() != Status.FINISHED) {
                            task.cancel(true);
                            task.closeCurrentConnection();
                        } else {
                            runningTaskList.remove(requestType);
                        }
                    }
                }
            } catch (Exception ex) {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, " \n Unable to finish Running Request asyncTask ! \n\n " + ex.getMessage());
            }
        }


        RequestAsyncTask requestAsyncTask = new RequestAsyncTask(context, type, requestType, contentValues, numOfReconnecsOnFail, resultCallback, devLog);
        runningTaskList.put(requestType, requestAsyncTask);

        if (Build.VERSION.SDK_INT < 11) {
            requestAsyncTask.execute();
        } else {
            requestAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        }
    }


    /**
     * Cancel all running task
     */
    public void cancelAllRunningRequests() {
        for (Entry<SdkRequestType, RequestAsyncTask> entry : runningTaskList.entrySet()) {
            RequestAsyncTask asyncTask = entry.getValue();
            if (asyncTask != null) {
                if (asyncTask.getStatus() == Status.RUNNING && asyncTask.getStatus() == Status.PENDING) {
                    asyncTask.cancel(true);
                    asyncTask.closeCurrentConnection();
                }
            }
        }
        runningTaskList.clear();
    }


    /**
     * Background Async Task executor for HTTP server requests
     */
    class RequestAsyncTask extends AsyncTask<Void, Void, ResultData<?>> {

        private CONNECTION_TYPE restRequestType = CONNECTION_TYPE.POST;
        private ApiResultCallback<?> mResultCallback;
        private int numOfReconnectionsOnFail = 0;
        private SdkRequestType sdkRequestType;
        private ContentValues mContentValues;
        private Call mCall;
        private Context mContext;
        private boolean mDeveloperLogging = false;

        public RequestAsyncTask(Context context, CONNECTION_TYPE type, SdkRequestType requestType, ContentValues contentValues, int numOfReconnecsOnFail, ApiResultCallback<?> resultCallback, boolean devLog) {
            mContext = context;
            restRequestType = type;
            sdkRequestType = requestType;
            mContentValues = contentValues;
            mResultCallback = resultCallback;
            restRequestType = type;
            numOfReconnectionsOnFail = numOfReconnecsOnFail;
            mDeveloperLogging = devLog;
        }

        @Override
        protected ResultData<?> doInBackground(Void... params) {
            String dataResponce = null;
            ResultData<?> webServiceResult = null;

            int mReconnectionTries = 0;
            if (!isCancelled()) {
                Response response = null;
                while (mReconnectionTries <= numOfReconnectionsOnFail) // make reconnection tries
                {
                    mReconnectionTries = mReconnectionTries + 1;
                    if (!isCancelled()) {
                        try {
                            if (restRequestType == CONNECTION_TYPE.POST) {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printPostRequestDebugLog(MAIN_SERVER_URL, mContentValues, sdkRequestType.name());
                                mCall = makePostConnection(MAIN_SERVER_URL, mContentValues, sdkRequestType.name());
                                if (mCall != null) {
                                    response = mCall.execute();
                                }
                            } else {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printGetRequestDebugLog(MAIN_SERVER_URL, mContentValues, sdkRequestType.name());
                                mCall = makeGetConnection(MAIN_SERVER_URL, mContentValues, sdkRequestType.name());
                                if (mCall != null) {
                                    response = mCall.execute();
                                }
                            }
                        } catch (Exception e) {
                            if (sdkRequestType != null) {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n IO Exception On [" + sdkRequestType.name() + "] request! \n" + e.getMessage());
                            }
                        }
                    } else {
                        break;
                    }

                    if (response != null) {
                        if (!isCancelled()) {
                            if (response.isSuccessful()) {
                                try {
                                    com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(" \n Successful connection ! , Code :  " + response.code());
                                    dataResponce = StreamToStringConverter.readStream(new BufferedInputStream(response.body().byteStream()), this, true);
                                    break;
                                } catch (Exception e) {
                                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Unable to convertByte Stream to String! : \n\n" + e.getMessage());
                                }
                            } else {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Server connectivity Error!  Code : " + response.code());
                            }
                        } else {
                            break;
                        }
                    }
                    try {
                        if (!isCancelled()) {
                            Thread.sleep(300 * mReconnectionTries * 2);
                        } else {
                            break;
                        }
                    } catch (Exception e) {
                        break;
                    }
                }
            }

            // Print server responce string before parsing data responce
            if (sdkRequestType != null) {
                com.kidoz.sdk.api.general.utils.SDKLogger.printResponse(dataResponce, sdkRequestType.name());
            }

            if (isCancelled()) {
                return null;
            }

            if (dataResponce != null) {
                if (!isCancelled()) {
                    if (mContext != null) {
                        try {
                            webServiceResult = parseWebServiceResponce(mContext, sdkRequestType, dataResponce, mDeveloperLogging);
                        } catch (Exception ex) {
                            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to parse service response: " + ex.getMessage());
                        }
                    }
                }
                return webServiceResult;
            } else {
                return null;
            }
        }

        @Override
        protected void onPostExecute(ResultData<?> result) {
            if (!isCancelled()) {
                if (result == null) {
                    if (mResultCallback != null) {
                        mResultCallback.onFailed();
                    }
                } else {
                    if (mResultCallback != null) {
                        mResultCallback.onServerResult(result);
                    }
                }
            }
            runningTaskList.remove(sdkRequestType);
        }

        @Override
        protected void onCancelled() {
            super.onCancelled();
            if (sdkRequestType != null && runningTaskList != null) {
                runningTaskList.remove(sdkRequestType);
            }
        }

        public void closeCurrentConnection() {
            if (mCall != null) {
                if (mCall.isCanceled() == false) {
                    mCall.cancel();
                }
            }
        }

        public String getRequestTag() {
            return sdkRequestType.name();
        }
    }

    /**
     * Handle the paesing of web service requests
     */
    private ResultData<?> parseWebServiceResponce(Context context, SdkRequestType sdkRequestType, String dataResponce, boolean devLog) {

        ResultData<?> webServiceResult = null;
        if (sdkRequestType != null && context != null) {
            switch (sdkRequestType) {
                //Parsers
                case LOAD_SDK_CONTENT: {
                    ContentData contentData = new ContentData();
                    contentData.decodeResponse(dataResponce);
                    ResultData<ContentData> resultData = new ResultData<ContentData>();
                    resultData.setData(contentData);
                    webServiceResult = resultData;

                    if (devLog) {
                        if (contentData.getContentDataItems() == null) {
                            Log.d(SDKLogger.GENERAL_TAG, "Error : Unable to get FeedView data!");
                        } else if (contentData.getContentDataItems().isEmpty()) {
                            Log.d(SDKLogger.GENERAL_TAG, "Error : FeedView data list is Empty !");
                        } else {
                            Log.d(SDKLogger.GENERAL_TAG, "Success : Received " + contentData.getContentDataItems() + "FeedView data items!");
                        }
                    }

                    break;
                }
                case VALIDATE_SDK: {
                    try {
                        ResponseStatus responseStatus = new ResponseStatus(dataResponce);
                        ResultData<PropertiesObj> resultData = new ResultData<PropertiesObj>();
                        resultData.setResponseStatus(responseStatus);
                        if (responseStatus.getIsSuccessful() == true) {
                            JSONObject jSONObject = new JSONObject(dataResponce);
                            PropertiesObj propertiesObj = new PropertiesObj(jSONObject.optJSONObject("data"));
                            resultData.setData(propertiesObj);
                        }
                        webServiceResult = resultData;
                    } catch (Exception ex) {
                        com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to parse validate SDK: " + ex.getMessage());
                    }
                    break;
                }
                case GET_SDK_RESOURCES: {
                    try {
                        com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>dataResponce = \n" + dataResponce);
                        ResponseStatus responseStatus = new ResponseStatus(dataResponce);
                        ResultData<Boolean> resultData = new ResultData<Boolean>();
                        resultData.setResponseStatus(responseStatus);
                        if (responseStatus.getIsSuccessful() == true) {
                            com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Get SDK assets");
                            boolean isImagesAssetsSynced;
                            String isAssetsSyncedFlag = SharedPreferencesUtils.loadSharedPreferencesData(context, ImageAssetsUtils.IMAGE_ASSETS_SYNCED_FLAG);
                            if (isAssetsSyncedFlag == null) {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Downloading image assets");
                                isImagesAssetsSynced = ImageAssetsUtils.parseAssets(context, dataResponce);
                                if (isImagesAssetsSynced == true) {
                                    com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>All image assets downloaded");
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, ImageAssetsUtils.IMAGE_ASSETS_SYNCED_FLAG, ImageAssetsUtils.IMAGE_ASSETS_SYNCED_FLAG);
                                } else {
                                    com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Not all image assets downloaded");
                                }
                            } else {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Image assets already downloaded");
                                isImagesAssetsSynced = true;
                            }

                            boolean isParentalLockAssetsSynced;
                            String isParentalLockAssetsSyncedFlag = SharedPreferencesUtils.loadSharedPreferencesData(context, ImageAssetsUtils.PARENTAL_LOCK_ASSETS_SYNCED_FLAG);
                            if (isParentalLockAssetsSyncedFlag == null) {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Downloading parental lock assets");
                                isParentalLockAssetsSynced = ImageAssetsUtils.parseLockIcons(context, dataResponce);
                                if (isParentalLockAssetsSynced == true) {
                                    com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>All parental lock assets downloaded");
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, ImageAssetsUtils.PARENTAL_LOCK_ASSETS_SYNCED_FLAG, ImageAssetsUtils.PARENTAL_LOCK_ASSETS_SYNCED_FLAG);
                                } else {
                                    com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Not all parental lock assets downloaded");
                                }
                            } else {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Parental lock assets already downloaded");
                                isParentalLockAssetsSynced = true;
                            }

                            boolean isSoundsAssetsSynced;
                            String isSoundsAssetsSyncedFlag = SharedPreferencesUtils.loadSharedPreferencesData(context, SoundAssetsUtils.SOUND_ASSETS_SYNCED_FLAG);
                            if (isSoundsAssetsSyncedFlag == null) {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Downloading sound assets");
                                isSoundsAssetsSynced = SoundAssetsUtils.parseSounds(context, dataResponce);
                                if (isSoundsAssetsSynced == true) {
                                    com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>All sound assets downloaded");
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, SoundAssetsUtils.SOUND_ASSETS_SYNCED_FLAG, SoundAssetsUtils.SOUND_ASSETS_SYNCED_FLAG);
                                } else {
                                    com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Not all sound assets downloaded");
                                }
                            } else {
                                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Sound assets already downloaded");
                                isSoundsAssetsSynced = true;
                            }

                            resultData.setData(isImagesAssetsSynced == true && isParentalLockAssetsSynced == true && isSoundsAssetsSynced == true);
                        }
                        webServiceResult = resultData;
                    } catch (Exception ex) {
                        com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to parse get SDK resources: " + ex.getMessage());
                    }
                    break;
                }
            }
        }

        return webServiceResult;
    }


    /**
     * Cancel all running task
     *
     * @param requestType type
     */
    public void cancelRequest(SdkRequestType requestType) {
        if (runningTaskList.containsKey(requestType)) {
            if (runningTaskList.get(requestType) != null && runningTaskList.get(requestType).getStatus() != Status.FINISHED) {
                runningTaskList.get(requestType).cancel(true);
                runningTaskList.get(requestType).closeCurrentConnection();
            }
        }
    }

    /**
     * Load gif Image
     */
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    public void loadButtonStyle(Context context, String url, String defaultFileName, String newStyleFileName, String tag, IOnButtonStyleCallback drawableCallback,boolean removePrevRequest) {

        if(removePrevRequest) {
            try {
                if (mStyleLoadingTasks.containsKey(tag)) {
                    if (mStyleLoadingTasks.get(tag) != null) {
                        StyleAsyncTaskLoader task = mStyleLoadingTasks.get(tag);
                        if (task.getStatus() != Status.FINISHED) {
                            task.cancel(true);
                            task.closeCurrentConnection();
                        } else {
                            mStyleLoadingTasks.remove(tag);
                        }
                    }
                }
            } catch (Exception ex) {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, " \n Unable to finish gif image loading task asyncTask ! \n\n " + ex.getMessage());
            }
        }

        StyleAsyncTaskLoader requestAsyncTask = new StyleAsyncTaskLoader(context, url,defaultFileName,newStyleFileName, tag, drawableCallback);
        mStyleLoadingTasks.put(tag, requestAsyncTask);

        if (Build.VERSION.SDK_INT < 11) {
            requestAsyncTask.execute();
        } else {
            requestAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        }
    }

    /**
     * Cancel gif loading request task
     *
     * @param tag type
     */
    public void cancelStyleLoadingRequest(String tag) {
        if (mStyleLoadingTasks.containsKey(tag)) {
            if (mStyleLoadingTasks.get(tag) != null && mStyleLoadingTasks.get(tag).getStatus() != Status.FINISHED) {
                mStyleLoadingTasks.get(tag).cancel(true);
                mStyleLoadingTasks.get(tag).closeCurrentConnection();
            }
        }
    }

    /**
     * Background Async Task executor for loading gif image animations
     */
    class StyleAsyncTaskLoader extends AsyncTask<Void, Void, File> {

        private Call mCall;

        private IOnButtonStyleCallback mFileLoaderCallback;
        private Context mContext;
        private String mTag;
        private String mUrl;
        private String mRealFileName;
        private String mLocalStyleFileName;

        public StyleAsyncTaskLoader(Context context, String url, String realFileName, String localStyleFileName, String tag, IOnButtonStyleCallback drawableCallback) {

            mFileLoaderCallback = drawableCallback;
            mContext = context;
            mTag = tag;
            mUrl = url;
            mRealFileName = realFileName;
            mLocalStyleFileName = localStyleFileName;
        }

        @Override
        protected File doInBackground(Void... params) {

            File localStyleFilePath = null;

            if (!isCancelled()) {
                // Get temp folder sd card path
                File filePath = DeviceUtils.getInnerStoragePathIfPosible(mContext);
                if (filePath != null) {
                    // Create file path
                    localStyleFilePath = new File(filePath, mLocalStyleFileName);

                    if (isCancelled() == false) {
                        // We check if file already exists and if its the same file currently on the server
                        // the file is downloaded with default file name not to ruin the currently running flow
                        // and replaced with the inner used file on the next enter to the app
                        if (localStyleFilePath.exists() == true) {
                            // Delete any previous version of the file (Done to avoid  corrupted files)
                            File tempAnimFile = new File(filePath, mRealFileName);
                            if (tempAnimFile.exists() && tempAnimFile.length() == 0) {
                                tempAnimFile.delete();
                            }

                            InputStream inputStream = null;
                            try {
                                Response response = null;
                                mCall = BaseConnectionClient.getImageStream(mUrl, mTag);
                                response = mCall.execute();
                                inputStream = response.body().byteStream();
                                // Get the server file size and check it against currently used
                                if (response.isSuccessful() == true && inputStream != null) {
                                    long savedFileSize = localStyleFilePath.length();
                                    long newFileSize = -1;
                                    String fileSize = response.header("content-length");
                                    if (fileSize != null) {
                                        try {
                                            newFileSize = Long.parseLong(fileSize);
                                        } catch (NumberFormatException e) {
                                            newFileSize = -1;
                                        }
                                    }

                                    //In case its not the same file the old one will be replaced. and the new one will be loaded next launch.
                                    if (newFileSize != -1 && newFileSize != savedFileSize) {
                                        if (tempAnimFile.exists() ){
                                            tempAnimFile.delete();
                                        }

                                        tempAnimFile.createNewFile();
                                        loadImageAndSaveToSd(inputStream, tempAnimFile);
                                    }
                                }
                            } catch (IOException e) {
                                SDKLogger.printErrorLog(" \n Failed to load gif image for the server ! : \n\n");
                            } finally {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    } catch (IOException e) {
                                    }
                                }
                            }

                        } else { // Download the custom style file if not exists
                            InputStream inputStream = null;
                            try {
                                Response response = null;
                                mCall = BaseConnectionClient.getImageStream(mUrl, mTag);
                                response = mCall.execute();
                                inputStream = response.body().byteStream();
                                if (response.isSuccessful() == true && inputStream != null) {
                                    // Load image and save it to sd card
                                    localStyleFilePath.createNewFile();
                                    loadImageAndSaveToSd(inputStream, localStyleFilePath);
                                }
                            } catch (IOException e) {
                                SDKLogger.printErrorLog(" \n Failed to load gif image for the server ! : \n\n");
                            } finally {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    } catch (IOException e) {
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return localStyleFilePath;
        }

        @Override
        protected void onPostExecute(File imagePath) {
            super.onPostExecute(imagePath);

            if (mFileLoaderCallback != null) {
                mFileLoaderCallback.onImageLoaded(imagePath);
            }
        }


        /**
         * Download image and save to SD card
         */
        public void loadImageAndSaveToSd(InputStream inputStream, File filePath) {
            try {
                OutputStream output = new FileOutputStream(filePath);
                try {
                    byte[] buffer = new byte[4096];
                    int bytesRead = 0;
                    while ((bytesRead = inputStream.read(buffer, 0, buffer.length)) >= 0) {
                        output.write(buffer, 0, bytesRead);
                    }
                } finally {
                    output.close();
                }
            } catch (IOException e) {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(" \n Failed to read Gif image input stream !: \n\n" + e.getMessage());
            } finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    } catch (IOException e) {
                    }
                }
            }
        }

        @Override
        protected void onCancelled() {
            super.onCancelled();
        }

        public void closeCurrentConnection() {
            if (mCall != null) {
                if (mCall.isCanceled() == false) {
                    mCall.cancel();
                }
            }
        }
    }
}
