package com.kidoz.sdk.api.general.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by roni on 7/26/2015.
 */
public class YouTubeUtils
{
    private static final String TAG = YouTubeUtils.class.getSimpleName();
    private static final String YOUTUBE_INDICATOR = "youtube.com";
    private static final String YOUTUBE_URL_VIDEOID_REGULAR_EXPRESSIONS = "^.*((youtu.be" + "\\/)" + "|(v\\/)|(\\/u\\/w\\/)|(embed\\/)|(watch\\?))\\??v?=?([^#\\&\\?]*).*";
    private static final String YOUTUBE_VIDEOID_REGULAR_EXPRESSIONS = "^[a-zA-Z0-9]*$";

    /**
     * Extract youtube video from the string
     */
    public static String extractYouTubeVideoIDString(String videoURL)
    {
        String videoId = null;

        if (videoURL.contains(YOUTUBE_INDICATOR) == true)
        {
            Pattern pattern = Pattern.compile(YOUTUBE_URL_VIDEOID_REGULAR_EXPRESSIONS);
            Matcher matcher = pattern.matcher(videoURL);

            if (matcher.matches())
            {
                String groupIndex1 = matcher.group(7);
                if (groupIndex1 != null && groupIndex1.length() == 11)
                {
                    videoId = groupIndex1;
                }
            }

			/*
             * while (matcher.find()) { try { videoId = matcher.group(0); } catch (Exception ex) { if (ex != null) AppLogger.printErrorLog("Error when trying to extract video id: " + ex.getMessage());
			 * } }
			 */

        }
        else
        {
            if (videoURL.matches(YOUTUBE_VIDEOID_REGULAR_EXPRESSIONS))
            {
                videoId = videoURL;
            }
        }
        com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>> Next Video WEBSITE_URL = " + videoURL);
        com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>> Next Video ID = " + videoId);
        return videoId;
    }
}
