package com.kidoz.sdk.api.general.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import com.kidoz.sdk.api.general.utils.PropertiesObj;

import org.json.JSONObject;

import java.util.Iterator;

public class ConfigurationTable extends BaseTable
{
    private final String TAG = ConfigurationTable.class.getName();

    public static final String TABLE_NAME = "PropertiesTable";
    private static final String COLUMN_PROPERTY_KEY = "COLUMN_PROPERTY_KEY";
    private static final String COLUMN_PROPERTY_VALUE = "COLUMN_PROPERTY_VALUE";

    public ConfigurationTable(DatabaseManager databaseManager, Object mSyncObjectect)
    {
        super(databaseManager, mSyncObjectect);
    }

    public static synchronized void onCreate(SQLiteDatabase database)
    {
        if (database != null)
        {
            String CREATE_TABLE_STATEMENT = "CREATE TABLE " + TABLE_NAME + "(" + COLUMN_PROPERTY_KEY + " TEXT PRIMARY KEY ," + COLUMN_PROPERTY_VALUE + " TEXT)";
            database.execSQL(CREATE_TABLE_STATEMENT);
        }
    }

    public static synchronized void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion)
    {
        if (database != null && newVersion > oldVersion)
        {

        }
    }


    /**
     * Save new app properties to databas
     *
     * @param propertiesObj
     */
    public synchronized void insertAppProperties(PropertiesObj propertiesObj)
    {
        if (mDBmanager != null && propertiesObj != null && propertiesObj.getProperties() != null && propertiesObj.getProperties().length() > 0)
        {
            synchronized (mSyncObject)
            {
                int rowsCount = 0;
                int rowID = -1;
                SQLiteDatabase database = mDBmanager.openDatabase();
                database.beginTransaction();
                try
                {
                    ContentValues values = new ContentValues();
                    JSONObject jsonObject = propertiesObj.getProperties();
                    Iterator<String> it = jsonObject.keys();

                    while (it.hasNext())
                    {
                        String key = it.next();
                        values.put(COLUMN_PROPERTY_KEY, key);
                        values.put(COLUMN_PROPERTY_VALUE, jsonObject.getString(key));

                        rowID = (int) database.insertWithOnConflict(TABLE_NAME, null, values, SQLiteDatabase.CONFLICT_REPLACE);
                        if (rowID != -1)
                        {
                            rowsCount++;
                        }
                    }

                    database.setTransactionSuccessful();
                }
                catch (Exception ex)
                {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to insert app properties : " + ex.getMessage());
                }
                finally
                {
                    database.endTransaction();
                    mDBmanager.closeDatabase();
                }
                printDBLog(DBactionType.INSERT, "insertAppProperties", TABLE_NAME, rowsCount);
            }
        }
    }


    /**
     * Save new app properties to database
     *
     * @param propertiesObj
     */
    public synchronized void insertAppPropertiesAsync(final PropertiesObj propertiesObj)
    {
        new Thread(new Runnable()
        {
            @Override
            public void run()
            {
                insertAppProperties(propertiesObj);
            }
        }).start();
    }

    /**
     * Load current app properties for this session
     *
     * @return ParentData
     */
    public synchronized PropertiesObj loadAppProperties()
    {
        PropertiesObj serverPropertiesObj = null;
        if (mDBmanager != null)
        {
            synchronized (mSyncObject)
            {
                int rowsCount = 0;
                SQLiteDatabase database = mDBmanager.openDatabase();

                try
                {
                    Cursor cursor = database.query(TABLE_NAME, null, null, null, null, null, null);
                    if (cursor != null && cursor.getCount() > 0)
                    {
                        JSONObject jsonObject = new JSONObject();
                        cursor.moveToFirst();
                        do
                        {
                            jsonObject.put(cursor.getString(cursor.getColumnIndex(COLUMN_PROPERTY_KEY)), cursor.getString(cursor.getColumnIndex(COLUMN_PROPERTY_VALUE)));
                        } while (cursor.moveToNext());

                        cursor.close();

                        serverPropertiesObj = new PropertiesObj(jsonObject);
                    }
                }
                catch (Exception e)
                {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to load app properties: " + e.getMessage());
                }
                finally
                {

                    mDBmanager.closeDatabase();
                }
                printDBLog(DBactionType.LOAD, "loadAppProperties", TABLE_NAME, rowsCount);
            }
        }
        return serverPropertiesObj;
    }

   /* public synchronized String deleteProperty(String propertyKey)
    {
        String result = null;
        synchronized (mSyncObject)
        {
            if (propertyKey != null)
            {
                int rowsCount = 0;
                int rowID = -1;
                SQLiteDatabase database = mDBmanager.openDatabase();
                database.beginTransaction();
                try
                {
                    String selection = COLUMN_PROPERTY_NAME + "=?";
                    String[] selectionArgs = new String[]{propertyKey};
                    rowID = database.delete(TABLE_NAME, selection, selectionArgs);
                    if (rowID != -1)
                    {
                        rowsCount = rowID;
                    }
                    database.setTransactionSuccessful();
                }
                catch (Exception ex)
                {
                    AppLogger.printErrorLog(TAG, "Error when trying to delete property: " + ex.getMessage());
                }
                finally
                {
                    database.endTransaction();
                    mDBmanager.closeDatabase();
                }
                printDBLog(DBactionType.DELETE, "deleteProperty", TABLE_NAME, rowsCount);

            }
        }
        return result;
    }*/

    /**
     * This method delete the entire table of properties.
     */
    public synchronized void deleteProperties()
    {
        if (mDBmanager != null)
        {
            clearTable(TABLE_NAME);
        }
    }
}
