package com.kidoz.sdk.api.general.assets_handling;

import android.content.Context;

import com.kidoz.sdk.api.server_connect.BaseConnectionClient;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.File;
import java.util.HashMap;

/**
 * Created by roni on 10/12/2015.
 */
public class SoundAssetsUtils
{
    private static final String TAG = SoundAssetsUtils.class.getSimpleName();
    public static final String SOUND_ASSETS_SYNCED_FLAG = "SOUND_ASSETS_SYNCED_FLAG";
    private static final String DATA = "data";
    private static final String SOUNDS = "sounds";

    public static boolean parseSounds(Context context, String dataResponse)
    {
        boolean result = false;
        if (dataResponse != null)
        {
            try
            {
                JSONObject rootObject = new JSONObject(dataResponse);
                JSONObject data = rootObject.optJSONObject(DATA);
                if (data != null)
                {
                    JSONArray soundsArray = data.optJSONArray(SOUNDS);
                    if (soundsArray != null)
                    {
                        HashMap<String, Integer> keysHashMap = new HashMap<String, Integer>();
                        JSONArray keysJSONArray = soundsArray.getJSONArray(0);
                        // 1. Extract the object keys.
                        for (int keyIndex = 0; keyIndex < keysJSONArray.length(); keyIndex++)
                        {
                            keysHashMap.put(keysJSONArray.getString(keyIndex), keyIndex);
                        }
                        // 2. Extract the objects using the keys above.
                        JSONArray parentalLockConfiguration = new JSONArray();
                        for (int soundIndex = 1; soundIndex < soundsArray.length(); soundIndex++)
                        {
                            result = false;
                            JSONArray nextJSONArray = soundsArray.getJSONArray(soundIndex);
                            String action = nextJSONArray.getString(keysHashMap.get("action"));
                            String soundURL = nextJSONArray.getString(keysHashMap.get("soundURL"));
                            if (action.equals("ItemClick") == true)
                            {
                                result = BaseConnectionClient.downloadAndSaveFile(soundURL, getSoundAssetFile(context, SOUND_ASSET_TYPE.ITEM_CLICK));
                            }
                            else if (action.equals("FamilyPanelView") == true)
                            {
                                result = BaseConnectionClient.downloadAndSaveFile(soundURL, getSoundAssetFile(context, SOUND_ASSET_TYPE.FAMILY_PANEL_VIEW));
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to parse lock icons: " + ex.getMessage());
            }
        }
        return result;
    }

    public static File getSoundAssetFile(Context context, SOUND_ASSET_TYPE soundAssetType)
    {
        File result = null;
        if (soundAssetType != null)
        {
            File directory = context.getFilesDir();
            switch (soundAssetType)
            {
                case ITEM_CLICK:
                {
                    result = new File(directory, "ItemClick.mp3");
                    break;
                }
                case FAMILY_PANEL_VIEW:
                {
                    result = new File(directory, "FamilyPanelView.mp3");
                    break;
                }
            }
        }
        return result;
    }

    public enum SOUND_ASSET_TYPE
    {
        ITEM_CLICK, FAMILY_PANEL_VIEW
    }
}
