package com.kidoz.sdk.api.general.assets_handling;

import android.content.Context;

import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.server_connect.BaseConnectionClient;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

/**
 * Created by roni on 10/1/2015.
 */
public class ImageAssetsUtils
{
    private static final String TAG = ImageAssetsUtils.class.getSimpleName();
    public static final String IMAGE_ASSETS_SYNCED_FLAG = "IMAGE_ASSETS_SYNCED_FLAG";
    public static final String PARENTAL_LOCK_ASSETS_SYNCED_FLAG = "PARENTAL_LOCK_ASSETS_SYNCED_FLAG";

    private static final String DATA = "data";
    private static final String ASSETS = "assets";
    private static final String ASSET_NAME = "name";
    private static final String IMAGE_URL = "imageURL";
    private static final String IMAGE_WIDTH = "width";
    private static final String IMAGE_HEIGHT = "height";
    private static final String ANIMATION_TYPE = "animationType";
    private static final String LOCK_ICONS = "lock_icons";

    private static final String BACK_BUTTON = "backButton";
    public static final String BACK_BUTTON_WIDTH = "BACK_BUTTON_WIDTH";
    public static final String BACK_BUTTON_HEIGHT = "BACK_BUTTON_HEIGHT";
    public static final String BACK_BUTTON_ANIMATION_TYPE = "BACK_BUTTON_ANIMATION_TYPE";

    private static final String EXIT_BUTTON = "exitButton";
    public static final String EXIT_BUTTON_WIDTH = "EXIT_BUTTON_WIDTH";
    public static final String EXIT_BUTTON_HEIGHT = "EXIT_BUTTON_HEIGHT";
    public static final String EXIT_BUTTON_ANIMATION_TYPE = "EXIT_BUTTON_ANIMATION_TYPE";

    private static final String LOCK_ACTIVE_BUTTON = "lockActiveButton";
    public static final String LOCK_ACTIVE_BUTTON_WIDTH = "LOCK_ACTIVE_BUTTON_WIDTH";
    public static final String LOCK_ACTIVE_BUTTON_HEIGHT = "LOCK_ACTIVE_BUTTON_HEIGHT";
    public static final String LOCK_ACTIVE_BUTTON_ANIMATION_TYPE = "LOCK_ACTIVE_BUTTON_ANIMATION_TYPE";

    private static final String LOCK_NOT_ACTIVE_BUTTON = "lockNotActiveButton";
    public static final String LOCK_NOT_ACTIVE_BUTTON_WIDTH = "LOCK_NOT_ACTIVE_BUTTON_WIDTH";
    public static final String LOCK_NOT_ACTIVE_BUTTON_HEIGHT = "LOCK_NOT_ACTIVE_BUTTON_HEIGHT";
    public static final String LOCK_NOT_ACTIVE_BUTTON_ANIMATION_TYPE = "LOCK_NOT_ACTIVE_BUTTON_ANIMATION_TYPE";

    private static final String ON_BOARDING_BACKGROUND = "onBoardingBackground";
    public static final String ON_BOARDING_BACKGROUND_WIDTH = "ON_BOARDING_BACKGROUND_WIDTH";
    public static final String ON_BOARDING_BACKGROUND_HEIGHT = "ON_BOARDING_BACKGROUND_HEIGHT";
    public static final String ON_BOARDING_BACKGROUND_ANIMATION_TYPE = "LOCK_NOT_ACTIVE_BUTTON_ANIMATION_TYPE";

    private static final String TOP_BAR_TITLE = "topBarTitleBackground";
    public static final String TOP_BAR_TITLE_WIDTH = "TOP_BAR_TITLE_WIDTH";
    public static final String TOP_BAR_TITLE_HEIGHT = "TOP_BAR_TITLE_HEIGHT";

    private static final String BOTTOM_BAR = "bottomBarBackground";
    public static final String BOTTOM_BAR_WIDTH = "BOTTOM_BAR_WIDTH";
    public static final String BOTTOM_BAR_HEIGHT = "BOTTOM_BAR_HEIGHT";

    public static final String LOCK_ICON_PREFIX = "LockIcon_";

    private static final String PANEL_BUTTON = "panelButton";
    public static final String PANEL_BUTTON_WIDTH = "PANEL_BUTTON_WIDTH";
    public static final String PANEL_BUTTON_HEIGHT = "PANEL_BUTTON_HEIGHT";
    public static final String PANEL_BUTTON_ANIMATION = "PANEL_BUTTON_ANIMATION";

    private static final String PROMOTED_INDICATION = "promotedIndicator";
    public static final String PROMOTED_INDICATION_WIDTH = "PROMOTED_INDICATION_WIDTH";
    public static final String PROMOTED_INDICATION_HEIGHT = "PROMOTED_INDICATION_HEIGHT";

    public static boolean parseAssets(Context context, String dataResponse)
    {
        boolean result = false;
        if (dataResponse != null)
        {
            try
            {
                JSONObject rootObject = new JSONObject(dataResponse);
                JSONObject data = rootObject.optJSONObject(DATA);
                if (data != null)
                {
                    JSONArray assets = data.optJSONArray(ASSETS);
                    if (assets != null)
                    {
                        HashMap<String, Integer> keysHashMap = new HashMap<String, Integer>();
                        JSONArray keysJSONArray = assets.getJSONArray(0);

                        // 1. Extract the object keys.
                        for (int keyIndex = 0; keyIndex < keysJSONArray.length(); keyIndex++)
                        {
                            keysHashMap.put(keysJSONArray.getString(keyIndex), keyIndex);
                        }

                        // 2. Extract the objects using the keys above.
                        for (int assetIndex = 1; assetIndex < assets.length(); assetIndex++)
                        {
                            result = false;
                            JSONArray nextJSONArray = assets.getJSONArray(assetIndex);
                            String assetName = nextJSONArray.getString(keysHashMap.get(ASSET_NAME));
                            String imageURL = nextJSONArray.getString(keysHashMap.get(IMAGE_URL));
                            String imageWidth = nextJSONArray.getString(keysHashMap.get(IMAGE_WIDTH));
                            String imageHeight = nextJSONArray.getString(keysHashMap.get(IMAGE_HEIGHT));
                            String animationType = nextJSONArray.getString(keysHashMap.get(ANIMATION_TYPE));
                            if (assetName.equals(BACK_BUTTON) == true)
                            {
                                if (BaseConnectionClient.downloadAndSaveFile(imageURL, getAssetFile(context, APP_ASSET_TYPE.BACK_BUTTON)) == true)
                                {
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, BACK_BUTTON_WIDTH, imageWidth, Context.MODE_PRIVATE);
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, BACK_BUTTON_HEIGHT, imageHeight, Context.MODE_PRIVATE);
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, BACK_BUTTON_ANIMATION_TYPE, animationType, Context.MODE_PRIVATE);
                                    result = true;
                                }
                            }
                            else if (assetName.equals(EXIT_BUTTON) == true)
                            {
                                if (BaseConnectionClient.downloadAndSaveFile(imageURL, getAssetFile(context, APP_ASSET_TYPE.EXIT_BUTTON)) == true)
                                {
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, EXIT_BUTTON_WIDTH, imageWidth, Context.MODE_PRIVATE);
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, EXIT_BUTTON_HEIGHT, imageHeight, Context.MODE_PRIVATE);
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, EXIT_BUTTON_ANIMATION_TYPE, animationType, Context.MODE_PRIVATE);
                                    result = true;
                                }
                            }
                            else if (assetName.equals(LOCK_ACTIVE_BUTTON) == true)
                            {
                                if (BaseConnectionClient.downloadAndSaveFile(imageURL, getAssetFile(context, APP_ASSET_TYPE.LOCK_ACTIVE_BUTTON)) == true)
                                {
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, LOCK_ACTIVE_BUTTON_WIDTH, imageWidth, Context.MODE_PRIVATE);
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, LOCK_ACTIVE_BUTTON_HEIGHT, imageHeight, Context.MODE_PRIVATE);
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, LOCK_ACTIVE_BUTTON_ANIMATION_TYPE, animationType, Context.MODE_PRIVATE);
                                    result = true;
                                }
                            }
                            else if (assetName.equals(LOCK_NOT_ACTIVE_BUTTON) == true)
                            {
                                if (BaseConnectionClient.downloadAndSaveFile(imageURL, getAssetFile(context, APP_ASSET_TYPE.LOCK_NOT_ACTIVE_BUTTON)) == true)
                                {
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, LOCK_NOT_ACTIVE_BUTTON_WIDTH, imageWidth, Context.MODE_PRIVATE);
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, LOCK_NOT_ACTIVE_BUTTON_HEIGHT, imageHeight, Context.MODE_PRIVATE);
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, LOCK_NOT_ACTIVE_BUTTON_ANIMATION_TYPE, animationType, Context.MODE_PRIVATE);
                                    result = true;
                                }
                            }
                            else if (assetName.equals(ON_BOARDING_BACKGROUND) == true)
                            {
                                if (BaseConnectionClient.downloadAndSaveFile(imageURL, getAssetFile(context, APP_ASSET_TYPE.ON_BOARDING_BACKGROUND)) == true)
                                {
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, ON_BOARDING_BACKGROUND_WIDTH, imageWidth, Context.MODE_PRIVATE);
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, ON_BOARDING_BACKGROUND_HEIGHT, imageHeight, Context.MODE_PRIVATE);
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, ON_BOARDING_BACKGROUND_ANIMATION_TYPE, animationType, Context.MODE_PRIVATE);
                                    result = true;
                                }
                            }
                            else if (assetName.equals(TOP_BAR_TITLE) == true)
                            {
                                if (BaseConnectionClient.downloadAndSaveFile(imageURL, getAssetFile(context, APP_ASSET_TYPE.TOP_BAR_TITLE)) == true)
                                {
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, TOP_BAR_TITLE_WIDTH, imageWidth, Context.MODE_PRIVATE);
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, TOP_BAR_TITLE_HEIGHT, imageHeight, Context.MODE_PRIVATE);
                                    result = true;
                                }
                            }
                            else if (assetName.equals(BOTTOM_BAR) == true)
                            {
                                if (BaseConnectionClient.downloadAndSaveFile(imageURL, getAssetFile(context, APP_ASSET_TYPE.BOTTOM_BAR)) == true)
                                {
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, BOTTOM_BAR_WIDTH, imageWidth, Context.MODE_PRIVATE);
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, BOTTOM_BAR_HEIGHT, imageHeight, Context.MODE_PRIVATE);
                                    result = true;
                                }
                            }
                            else if (assetName.equals(PROMOTED_INDICATION) == true)
                            {
                                if (BaseConnectionClient.downloadAndSaveFile(imageURL, getAssetFile(context, APP_ASSET_TYPE.PROMOTED_INDICATION)) == true)
                                {
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, PROMOTED_INDICATION_WIDTH, imageWidth, Context.MODE_PRIVATE);
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, PROMOTED_INDICATION_HEIGHT, imageHeight, Context.MODE_PRIVATE);
                                    result = true;
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to parse assets: " + ex.getMessage());
            }
        }
        return result;
    }

    public static boolean parseLockIcons(Context context, String dataResponse)
    {
        boolean result = false;
        if (dataResponse != null)
        {
            try
            {
                JSONObject rootObject = new JSONObject(dataResponse);
                JSONObject data = rootObject.optJSONObject(DATA);
                if (data != null)
                {
                    JSONArray lockIcons = data.optJSONArray(LOCK_ICONS);
                    if (lockIcons != null)
                    {
                        HashMap<String, Integer> keysHashMap = new HashMap<String, Integer>();
                        JSONArray keysJSONArray = lockIcons.getJSONArray(0);
                        // 1. Extract the object keys.
                        for (int keyIndex = 0; keyIndex < keysJSONArray.length(); keyIndex++)
                        {
                            keysHashMap.put(keysJSONArray.getString(keyIndex), keyIndex);
                        }
                        // 2. Extract the objects using the keys above.
                        JSONArray parentalLockConfiguration = new JSONArray();
                        for (int lockIconIndex = 1; lockIconIndex < lockIcons.length(); lockIconIndex++)
                        {
                            result = false;
                            JSONArray nextJSONArray = lockIcons.getJSONArray(lockIconIndex);
                            String iconName = nextJSONArray.getString(keysHashMap.get("name"));
                            String imageURL = nextJSONArray.getString(keysHashMap.get("icon"));
                            File directory = context.getFilesDir();
                            File nextIconFile = new File(directory, LOCK_ICON_PREFIX + iconName + ".png");
                            boolean isDownloaded = BaseConnectionClient.downloadAndSaveFile(imageURL, nextIconFile);
                            if (isDownloaded == true)
                            {
                                result = true;
                                JSONObject nextJSONObject = new JSONObject();
                                nextJSONObject.put("LockIconURL", imageURL);
                                nextJSONObject.put("LockIconName", iconName);
                                nextJSONObject.put("LockIconOnFS", LOCK_ICON_PREFIX + iconName + ".png");
                                parentalLockConfiguration.put(nextJSONObject);
                                PicassoOk.getPicasso(context).load(LOCK_ICON_PREFIX + iconName + ".png").fetch();
                            }
                            com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, "Download next lock icon: " + iconName + " = " + Boolean.toString(isDownloaded));
                        }
                        saveParentalLockConfigurationFile(context, parentalLockConfiguration);
                    }
                }
            }
            catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to parse lock icons: " + ex.getMessage());
            }
        }
        return result;
    }

    private static void saveParentalLockConfigurationFile(Context context, JSONArray jSONArray)
    {
        String configurationFileName = "ConfigurationFile";
        try
        {
            File dir = context.getFilesDir();
            File file = new File(dir, configurationFileName);
            if (file.exists() == true)
            {
                file.delete();
            }

            FileOutputStream fileOutputStream = context.openFileOutput(configurationFileName, Context.MODE_PRIVATE);
            fileOutputStream.write(jSONArray.toString().getBytes());
            fileOutputStream.close();
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to create configuration file: " + ex.getMessage());
        }
    }

    public static File getAssetFile(Context context, APP_ASSET_TYPE appAssetType)
    {
        File result = null;
        if (appAssetType != null)
        {
            File directory = context.getFilesDir();
            switch (appAssetType)
            {
                case EXIT_BUTTON:
                {
                    result = new File(directory, "ExitButton.png");
                    break;
                }
                case BACK_BUTTON:
                {
                    result = new File(directory, "BackButton.png");
                    break;
                }
                case LOCK_ACTIVE_BUTTON:
                {
                    result = new File(directory, "LockActiveButton.png");
                    break;
                }
                case LOCK_NOT_ACTIVE_BUTTON:
                {
                    result = new File(directory, "LockNotActiveButton.png");
                    break;
                }
                case TOP_BAR_TITLE:
                {
                    result = new File(directory, "TitleBackground.png");
                    break;
                }
                case ON_BOARDING_BACKGROUND:
                {
                    result = new File(directory, "OnBoardingBackground.png");
                    break;
                }
                case BOTTOM_BAR:
                {
                    result = new File(directory, "BottomBar.png");
                    break;
                }
                case PANEL_BUTTON_PARENTAL_LOCK:
                {
                    result = new File(directory, "PanelButtonParentalLock.png");
                    break;
                }
                case PANEL_BUTTON_ABOUT_KIDOZ:
                {
                    result = new File(directory, "PanelButtonAboutKidoz.png");
                    break;
                }
                case PANEL_BUTTON_EXIT:
                {
                    result = new File(directory, "PanelButtonExit.png");
                    break;
                }
                case PANEL_BUTTON_HANDLE:
                {
                    result = new File(directory, "PanelButtonHandle.png");
                    break;
                }
                case PROMOTED_INDICATION:
                {
                    result = new File(directory, "PromotedIndication.png");
                    break;
                }
            }
        }
        return result;
    }

    public static JSONArray loadParentalLockConfigurationFile(Context context)
    {
        JSONArray result = null;
        String configurationFileName = "ConfigurationFile";
        StringBuilder stringBuffer = new StringBuilder();
        try
        {
            FileInputStream fileInputStream = context.openFileInput(configurationFileName);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String nextLine = bufferedReader.readLine();
            while (nextLine != null)
            {
                stringBuffer.append(nextLine);
                nextLine = bufferedReader.readLine();
            }
            inputStreamReader.close();
            result = new JSONArray(stringBuffer.toString());
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to load configuration file: " + ex.getMessage());
        }
        return result;
    }

    public enum APP_ASSET_TYPE
    {
        PROMOTED_INDICATION, PANEL_BUTTON_HANDLE, PANEL_BUTTON_PARENTAL_LOCK, PANEL_BUTTON_EXIT, PANEL_BUTTON_ABOUT_KIDOZ, EXIT_BUTTON, BACK_BUTTON, LOCK_ACTIVE_BUTTON, LOCK_NOT_ACTIVE_BUTTON, TOP_BAR_TITLE, ON_BOARDING_BACKGROUND, BOTTOM_BAR
    }
}
