package com.kidoz.sdk.api.dialogs;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.kidoz.events.DeviceUtils;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.KidozWebView;
import com.kidoz.sdk.api.ui_views.AboutKidozWebViewContainer;
import com.kidoz.sdk.api.ui_views.custom_drawables.XViewDrawable;

/**
 * Created by roni on 10/11/2015.
 */
public class AboutKidozDialog extends BaseDialog
{
    private final String TAG = AboutKidozDialog.class.getSimpleName();

    private RelativeLayout mRootView;
    private AboutKidozWebViewContainer mContainer;
    private KidozCardView mKidozCardView;
    private int[] mPopLocation;

    public AboutKidozDialog(Context context, int[] popLocation)
    {
        super(context, android.R.style.Theme_Translucent);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.requestWindowFeature(Window.FEATURE_NO_TITLE);
        WindowManager.LayoutParams windowParams = getWindow().getAttributes();
        windowParams.dimAmount = 0.7f;
        getWindow().setAttributes(windowParams);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
        mPopLocation = popLocation;
    }

    @Override protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        initDialog();

        setContentView(mRootView);
    }

    private void initDialog()
    {
        initRootView();
        initBackgroundkidozCardView();
        initWebView();
        initCloseButton();
        prepareSize();
    }

    private void initCloseButton()
    {
        Point point = DeviceUtils.getScreenSize(getContext());
        int size = Math.min(point.x, point.y);
        size = (int) (size * 0.058);

        XViewDrawable xViewDrawable = new XViewDrawable(getContext(), Color.parseColor("#04a0e1"));
        final ImageView closeImageView = new ImageView(getContext());
        closeImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        closeImageView.setImageDrawable(xViewDrawable);

        closeImageView.setOnClickListener(new View.OnClickListener()
        {
            @Override public void onClick(View v)
            {
                GenAnimator.clickItemAnimation(v, 100, new GenAnimator.ViewAnimationListener()
                {
                    @Override public void onAnimationEnd()
                    {
                        dismiss();
                    }

                    @Override public void onAnimationStart()
                    {

                    }
                });
            }
        });
        RelativeLayout.LayoutParams relParams = new RelativeLayout.LayoutParams(size, size);
        relParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        relParams.setMargins(0, Utils.dpTOpx(getContext(), 5), Utils.dpTOpx(getContext(), 5), 0);
        mContainer.addView(closeImageView, relParams);

        RelativeLayout closeButtonContainer = new RelativeLayout(getContext());
        closeButtonContainer.setOnClickListener(new View.OnClickListener()
        {
            @Override public void onClick(View v)
            {
                closeImageView.performClick();
            }
        });
        closeButtonContainer.setBackgroundColor(Color.TRANSPARENT);
        KidozCardView.LayoutParams containerParams = new KidozCardView.LayoutParams(Utils.dpTOpx(getContext(), 55), Utils.dpTOpx(getContext(), 55));
        containerParams.gravity = Gravity.RIGHT;
        mKidozCardView.addView(closeButtonContainer, containerParams);
    }

    private void initRootView()
    {
        mRootView = new RelativeLayout(getContext());
    }

    private void initBackgroundkidozCardView()
    {
        mKidozCardView = new KidozCardView(getContext());
        mKidozCardView.setCardBackgroundColor(Color.parseColor("#ffffff"));

        mKidozCardView.setRadius(Utils.dpTOpx(getContext(), 4));
        int padding = Utils.dpTOpx(getContext(), 10);
        mKidozCardView.setPadding(padding, padding, padding, padding);

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.setMargins(padding, padding, padding, padding);
        params.addRule(RelativeLayout.CENTER_IN_PARENT);
        mRootView.addView(mKidozCardView, params);

        mContainer = new AboutKidozWebViewContainer(getContext());
        mKidozCardView.addView(mContainer, new KidozCardView.LayoutParams(KidozCardView.LayoutParams.MATCH_PARENT, KidozCardView.LayoutParams.MATCH_PARENT));
    }

    private void prepareSize()
    {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) mKidozCardView.getLayoutParams();
        if (getContext().getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT)
        {
            if (ScreenUtils.getIsTablet(getContext()) == false)
            {
                // Phone portrait
                params.width = (int) (0.8f * Math.min(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false)));
                params.height = (int) (0.5f * Math.max(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false)));
            }
            else
            {
                // Tablet portrait
                params.width = (int) (0.8f * Math.min(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false)));
                params.height = (int) (0.5f * Math.max(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false)));
            }
        }
        else
        {
            if (ScreenUtils.getIsTablet(getContext()) == false)
            {
                // Phone landscape
                params.width = (int) (0.8f * Math.max(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false)));
                params.height = RelativeLayout.LayoutParams.WRAP_CONTENT;//(int) (0.9f * Math.min(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false)));
            }
            else
            {
                // Tablet landscape
                params.width = (int) (0.7f * Math.max(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false)));
                params.height = (int) (0.7f * Math.min(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false)));
            }
        }
    }

    private void initWebView()
    {
        KidozWebView mKidozWebView = new KidozWebView(getContext());
        mKidozWebView.getSettings().setUseWideViewPort(true);
        mKidozWebView.getSettings().setLoadWithOverviewMode(true);
        mKidozWebView.getSettings().setSupportZoom(false);
        mKidozWebView.setWebViewClient(new WebViewClient()
        {
            @Override public boolean shouldOverrideUrlLoading(WebView view, String url)
            {
                boolean result = true;
                if (url.startsWith("mailto:"))
                {
                    Intent mailIntent = new Intent(Intent.ACTION_SENDTO, Uri.parse(url));
                    getContext().startActivity(mailIntent);
                }
                else
                {
                    Intent linkIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                    getContext().startActivity(linkIntent);
                }
                return true;
            }
        });
        mKidozWebView.setOnTouchListener(new View.OnTouchListener()
        {
            @Override public boolean onTouch(View v, MotionEvent event)
            {
                return false;
            }
        });
        mKidozWebView.setLongClickable(true);
        mKidozWebView.setOnLongClickListener(new View.OnLongClickListener()
        {
            @Override public boolean onLongClick(View v)
            {
                return true;
            }
        });
        mKidozWebView.setVerticalScrollBarEnabled(false);
        mKidozWebView.setHorizontalScrollBarEnabled(false);
        mKidozWebView.loadUrl("http://kidoz.net/v3policy/");
        mContainer.addView(mKidozWebView, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT));
    }


    @Override public void show()
    {
        super.show();
        mKidozCardView.setVisibility(View.INVISIBLE);
        Utils.setOnGlobalLayoutFinishListener(mKidozCardView, new Utils.OnGlobalLayoutFinishedListener()
        {
            @Override public void onLayoutFinished()
            {
                if (mPopLocation != null)
                {
                    GenAnimator.playPopInFromRightTop(mKidozCardView, mPopLocation, new Animator.AnimatorListener()
                    {
                        @Override public void onAnimationStart(Animator animation)
                        {
                            mKidozCardView.setVisibility(View.VISIBLE);
                        }

                        @Override public void onAnimationEnd(Animator animation)
                        {
                        }

                        @Override public void onAnimationCancel(Animator animation)
                        {

                        }

                        @Override public void onAnimationRepeat(Animator animation)
                        {

                        }
                    });
                }
                else
                {
                    mKidozCardView.setVisibility(View.VISIBLE);
                }
            }
        });
    }

    @Override public void dismiss()
    {
        if (mPopLocation != null)
        {
            GenAnimator.playPopOutToRightTop(mKidozCardView, mPopLocation, new Animator.AnimatorListener()
            {
                @Override public void onAnimationStart(Animator animation)
                {

                }

                @Override public void onAnimationEnd(Animator animation)
                {
                    AboutKidozDialog.super.dismiss();
                }

                @Override public void onAnimationCancel(Animator animation)
                {

                }

                @Override public void onAnimationRepeat(Animator animation)
                {

                }
            });
        }
        else
        {
            AboutKidozDialog.super.dismiss();
        }
    }

    @Override protected void onDialogOrientationChange(boolean isPortrait)
    {
        super.onDialogOrientationChange(isPortrait);
        prepareSize();
    }
}
