package com.kidoz.sdk.api;

import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;

import com.kidoz.events.Event;
import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.ContentPanelView;
import com.kidoz.sdk.api.ui_views.FeedFullView;

/**
 * Created by Eugine on 10/1/2015.
 */
class FeedViewDialog extends BaseDialog {
    private static final String SAVE_DATA_INSTANCE_KEY = "SAVE_DATA_INSTANCE_KEY_FV";
    private static final String SAVE_ORIGINAL_ORIENTATION_KEY = "SAVE_ORIGINAL_ORIENTATION_KEY_FV";

    private FeedFullView mFeedFullVeiw;
    private ContentData mContentData = null;
    // Close button click listener
    private View.OnClickListener mCloseBtnClickListener = null;

    private IOnFeedViewEventListener mOnInterstitialViewEventListener;
    private boolean mAllowClickHandle = true;
    private boolean mIsAutomaticInvocation = false;

    public FeedViewDialog(Context context, IOnFeedViewEventListener listener,boolean automatic) {
        super(context, android.R.style.Theme_Black_NoTitleBar_Fullscreen);
        mIsAutomaticInvocation = automatic;
        mOnInterstitialViewEventListener = listener;
        setCancelable(false);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // Init back button listener
        setOnKeyListener(new DialogInterface.OnKeyListener() {
            @Override
            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                boolean result = true;
                if (event.getAction() == KeyEvent.ACTION_DOWN) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                        if (mFeedFullVeiw != null && mFeedFullVeiw.getViewBottomBar().isAboutViewVisible()) {
                            mFeedFullVeiw.getViewBottomBar().hideAboutView();
                        } else {
                            if (mOnInterstitialViewEventListener != null) {
                                mOnInterstitialViewEventListener.onDismissView();
                            }
                            EventManager.getInstance(getContext()).clearAllTempStoredEvents();
                            closeDialog();
                        }
                    }
                }
                return result;
            }
        });

        if (savedInstanceState != null && savedInstanceState.containsKey(SAVE_ORIGINAL_ORIENTATION_KEY)) {
            mCurrentOrientationState = savedInstanceState.getInt(SAVE_ORIGINAL_ORIENTATION_KEY);
        } else {
            mCurrentOrientationState = mCallingActivity.getResources().getConfiguration().orientation;
            mCallingActivity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
        }

        // Restore current view state data in case the fragment was destroyed due to going offscreen
        if (mContentData == null && savedInstanceState != null && savedInstanceState.containsKey(SAVE_DATA_INSTANCE_KEY)) {
            mContentData = (ContentData) savedInstanceState.get(SAVE_DATA_INSTANCE_KEY);
        }

        mFeedFullVeiw = new FeedFullView(mCallingActivity);
        mFeedFullVeiw.setOnContentItemClickListener(new ContentPanelView.IOnContentItemClickListener() {
            @Override
            public void onItemClick(ContentItem contentItem, int postion) {
                if (contentItem != null && contentItem.getContentType() != null && contentItem.getContentType() != ContentType.NONE) {
                    // Handle content item click

                    if (contentItem.isPromoted() && mAllowClickHandle) {
                        ContentExecutionHandler.handleContentItemClick(mCallingActivity, contentItem, WidgetType.WIDGET_TYPE_FEED, postion, false, true);
                        mAllowClickHandle = false;
                    } else {
                        ContentExecutionHandler.handleContentItemClick(mCallingActivity, contentItem, WidgetType.WIDGET_TYPE_FEED, postion, false, false);
                    }
                }
            }
        });

        mFeedFullVeiw.setOnCloseButtonClickListenr(mCloseBtnClickListener);
        mFeedFullVeiw.setContentDataAndRefresh(mContentData);

        setContentView(mFeedFullVeiw);
        mFeedFullVeiw.showLoadingProgressView(true);
    }

    protected void setContentData(ContentData contentData) {
        mContentData = contentData;
        if (mFeedFullVeiw != null) {
            mFeedFullVeiw.showLoadingProgressView(false);
            mFeedFullVeiw.setContentDataAndRefresh(mContentData);
        }
    }

    /**
     * Set on close button click listener
     *
     * @param clickListenr click listener
     */
    protected void setOnCloseButtonClickListener(View.OnClickListener clickListenr) {
        mCloseBtnClickListener = clickListenr;
        if (mFeedFullVeiw != null) {
            mFeedFullVeiw.setOnCloseButtonClickListenr(mCloseBtnClickListener);
        }
    }


    @Override
    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();
        if (mContentData != null && bundle != null) {
            bundle.putSerializable(SAVE_DATA_INSTANCE_KEY, mContentData);
            bundle.putInt(SAVE_ORIGINAL_ORIENTATION_KEY, mCurrentOrientationState);
        }
        return bundle;
    }


    @Override
    public void closeDialog() {

        mContentData = null;
        super.closeDialog();
    }

    @Override
    public void openDialog() {
        if (KidozSDK.isInitialised()) {
            super.openDialog();

            Event event = new Event();
            if(mIsAutomaticInvocation) {
                event.addParameterToJsonObject(EventParameters.LABEL_VIEW_OPEN_TYPE, EventParameters.AUTOMATIC_OPEN);
            }else {
                event.addParameterToJsonObject(EventParameters.LABEL_VIEW_OPEN_TYPE, EventParameters.MANUAL_OPEN);
            }

            EventManager.getInstance(mCallingActivity).logEvent(mCallingActivity, WidgetType.WIDGET_TYPE_FEED, EventManager.LOG_CRITICAL_LEVEL,
                    event, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, EventParameters.FEED_VIEW, false);

        }
    }

    public void setOnInterstitialViewEventListener(IOnFeedViewEventListener onInterstitialViewEventListener) {
        if (onInterstitialViewEventListener != null) {
            mOnInterstitialViewEventListener = onInterstitialViewEventListener;
        }
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();

        // Restore previous orientation
        restoreUserOriginalOrientation();
    }

    @Override
    protected void onDialogWindowVisibilityChange(boolean isVisible) {
        super.onDialogWindowVisibilityChange(isVisible);
        if (isVisible == true) {
            mAllowClickHandle = true;
        } else {
            if (EventManager.getInstance(getContext()).logAllTempStoredEvents(getContext())) {
                EventManager.getInstance(getContext()).startEventsSync(getContext(), 1000);
            }
            mAllowClickHandle = true;
        }
    }


}
