package com.kidoz.sdk.api;


import android.app.Activity;
import android.content.Context;
import android.view.View;

import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;

public class FeedView {
    private static final String TAG = FeedView.class.getSimpleName();

    private Builder mBuilder;

    private FeedViewDialog mFeedViewDialog;
    protected ContentLogicLoader mContentLogicLoader;

    protected IOnFeedViewEventListener mOnInterstitialViewEventListener;
    protected boolean mIsAutomaticInvocation = false;
    /**
     * Flag used to check ,is Pre load or Post load the content data
     */
    protected boolean mIsPostLoadData = false;

    protected FeedView(Builder builder) {
        mBuilder = builder;
        initContentLogicLoader();
    }


    /**
     * Initiate  content loader logic ,that handles all the logic for loading content
     **/
    private void initContentLogicLoader() {
        if(KidozSDK.isInitialised()) {
            mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback() {
                @Override
                public void onDataReady(ContentData contentData) {
                    mFeedViewDialog.setContentData(contentData);

                    if (mIsPostLoadData == false) {
                        if (mOnInterstitialViewEventListener != null) {
                            mOnInterstitialViewEventListener.onReadyToShow();
                        }
                    }
                }
            });
        }
    }

    /**
     * Show feed interstitial view (Will be shown <b>After</b> content data is ready)
     **/
   /* public void showView() {
        mIsPostLoadData = false;
        mContentLogicLoader.loadContent(mBuilder.mContext, WidgetType.WIDGET_TYPE_FEED);
    }*/

    /**
     * Show feed interstitial view (Will be shown <b>Before</b> content data is ready)
     **/
    public void showView() {
        if(KidozSDK.isInitialised()) {
            mIsAutomaticInvocation = true;
            mIsPostLoadData = true;

            if (mOnInterstitialViewEventListener != null) {
                mOnInterstitialViewEventListener.onReadyToShow();
            }

            openSimpleDialog();
        }
    }

    /**
     * Create and open simple (Not fragment based) Dialog view
     */
    protected void openSimpleDialog() {
        if (mBuilder.mContext != null && mBuilder.mContext instanceof Activity) {
            mFeedViewDialog = new FeedViewDialog(mBuilder.mContext, mOnInterstitialViewEventListener,mIsAutomaticInvocation);
            assignCloseButtonClickListener();
            mFeedViewDialog.openDialog();

            mContentLogicLoader.loadContent(mBuilder.mContext, WidgetType.WIDGET_TYPE_FEED);
        }
    }


    private void assignCloseButtonClickListener() {
        mFeedViewDialog.setOnCloseButtonClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismissView();
                EventManager.getInstance(mBuilder.mContext).clearAllTempStoredEvents();
            }
        });
    }

    /**
     * Dismiss view
     **/
    public void dismissView() {
        if (mFeedViewDialog != null) {
            mFeedViewDialog.closeDialog();
        }

        if (mOnInterstitialViewEventListener != null) {
            mOnInterstitialViewEventListener.onDismissView();
        }
    }

    /**
     * Set on view event listener
     *
     * @param listener
     **/
    public void setOnFeedViewEventListener(IOnFeedViewEventListener listener) {
        mOnInterstitialViewEventListener = listener;
        if (mFeedViewDialog != null) {
            mFeedViewDialog.setOnInterstitialViewEventListener(mOnInterstitialViewEventListener);
        }
    }

    /**
     * Builder class that handles view initiation
     **/
    public static class Builder {
        private Context mContext;

        public Builder(Context context) {
            mContext = context;
        }

        public FeedView build() {
            return new FeedView(this);
        }
    }

    /**
     * On configuration change for correct flow of orientation change on open view
     **/
    public void onConfigurationChange() {
        if (mFeedViewDialog != null) {
            assignCloseButtonClickListener();
        }
    }
}
