package com.kidoz.sdk.api;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.events.Event;
import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.interfaces.IOnPanelViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.custom_drawables.DefaultPanelDrawable;
import com.kidoz.sdk.api.ui_views.custom_drawables.ShadowView;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.one_item_view.OneItemView;
import com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.panel_view.PanelButton;
import com.kidoz.sdk.api.ui_views.panel_view.PanelStyleableButtonView;


public class FamilyPanelView extends RelativeLayout {

    private static final int BUTTON_STYLE_RESOURCE_NOT_READY_REPEAT_COUNT = 7;
    private static final int DEFAULT_PANEL_BG_COLOR = Color.WHITE;

    private final String TAG = FamilyPanelView.class.getSimpleName();

    private PANEL_TYPE mPanelType;
    private com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION mHandlePosition;

    private RelativeLayout mRootView;
    private RelativeLayout mContainer;
    private RelativeLayout mInnerContainer;
    private ContentLogicLoader mContentLogicLoader;
    private PanelStyleableButtonView mHandleButton;
    private PanelButton mParentalLockButton;
    private PanelButton mAboutKidozButton;
    private RelativeLayout mCustomUserHandleButton;
    private TextView mPoweredByTextView;
    private ShadowView mShadowView;
    private RelativeLayout mBottomBarContainer;
    private OneItemView mOneItemView;
    private IOnPanelViewEventListener mIOnPanelViewEventListener;
    private boolean mIsOpen;
    private boolean mIsAnimationRunning;
    private boolean mIsClicksBlocked;
    private boolean mAllowClickHandle = true;
    private boolean mIsCustomHandleSet = false;

    private int mPanelBgColor = DEFAULT_PANEL_BG_COLOR;

    private Utils.StaticHandler mStaticHandler;
    private Utils.StaticHandler mUiLoaderStaticHandler;

    private int mNotReadyRepeatCount = 0;

    public FamilyPanelView(Context context) {
        super(context);
        initView();
    }

    public FamilyPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView();
    }

    public FamilyPanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView();
    }

    private void initView() {
        if(KidozSDK.isInitialised()) {
            initPanelTypeAndHandlePosition();
            initRootView();
            initContainer();
            initHandleButton();
            initOneItemView();
            initParentalLockButton();
            initAboutKidozkButton();
            initBottomTitleBar();
            initPanelViewsRules();
            initContentLogicLoader();
            preparePanel();


            mInnerContainer.setOnTouchListener(new OnTouchListener() {
                @Override
                public boolean onTouch(View view, MotionEvent motionEvent) {
                    return true;
                }
            });
        }
    }

    private void initRootView() {
        mRootView = new RelativeLayout(getContext());
        mRootView.setBackgroundColor(Color.TRANSPARENT);
        LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
        addView(mRootView, params);
    }

    private void initContainer() {
        mContainer = new RelativeLayout(getContext());
        mContainer.setBackgroundColor(Color.TRANSPARENT);

        mContainer.setId(Utils.generateViewId());
        LayoutParams params = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        mRootView.addView(mContainer, params);

        initShadowLineView();

        mInnerContainer = new RelativeLayout(getContext());
        mInnerContainer.setId(Utils.generateViewId());
        mInnerContainer.setBackgroundColor(Color.WHITE);

        params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
        mContainer.addView(mInnerContainer, params);
    }

    private void initHandleButton() {
        mHandleButton = new PanelStyleableButtonView(getContext(), mPanelType, new PanelStyleableButtonView.PanelButtonListener() {
            @Override
            public void onClickStarted() {

            }

            @Override
            public void onClickEnd() {
                toggleAnimation();
            }
        });

        // Default handle button
        mHandleButton.setId(Utils.generateViewId());
        LayoutParams params = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        mContainer.addView(mHandleButton, params);

        // User defined custom handle button
        mCustomUserHandleButton = new RelativeLayout(getContext());
        mCustomUserHandleButton.setId(Utils.generateViewId());
        params = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        mContainer.addView(mCustomUserHandleButton, params);
        mCustomUserHandleButton.setVisibility(View.INVISIBLE);

        loadButtonStyleView();
    }

    private void initBottomTitleBar() {

        mBottomBarContainer = new RelativeLayout(getContext());
        mBottomBarContainer.setBackgroundColor(mPanelBgColor);
        mBottomBarContainer.setId(Utils.generateViewId());
        LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
        mInnerContainer.addView(mBottomBarContainer, params);

        mPoweredByTextView = new TextView(getContext());
        mPoweredByTextView.setText("Recommended Content by KIDOZ");
        mPoweredByTextView.setTextColor(Color.WHITE);
        mPoweredByTextView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 12);
        mPoweredByTextView.setLines(1);
        mPoweredByTextView.setEllipsize(TextUtils.TruncateAt.END);
        mPoweredByTextView.setGravity(Gravity.CENTER);

        params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
        params.setMargins(Utils.dpTOpx(getContext(), 4), Utils.dpTOpx(getContext(), 5), Utils.dpTOpx(getContext(), 4), Utils.dpTOpx(getContext(), 5));
        params.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());
        params.addRule(RelativeLayout.RIGHT_OF, mAboutKidozButton.getId());
        mBottomBarContainer.addView(mPoweredByTextView, params);
    }

    private void initParentalLockButton() {
        mParentalLockButton = new PanelButton(getContext(), PANEL_TYPE.BOTTOM, com.kidoz.sdk.api.ui_views.panel_view.PANEL_BUTTON_TYPE.PARENTAL_LOCK, new PanelButton.PanelButtonListener() {
            @Override
            public void onClickStarted() {

            }

            @Override
            public void onClickEnd() {
                if (mIsClicksBlocked == false) {
                    mIsClicksBlocked = true;
                    if (ParentalLockDialog.getIsCanShowDialog(getContext()) == true) {
                        int[] popLocation = new int[2];
                        popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                        popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                        ParentalLockDialog parentalLockDialog = new ParentalLockDialog(getContext(), false, popLocation);
                        parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                            @Override
                            public void onDismiss(DialogInterface dialog) {
                                //Refresh the parental lock icon
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
                                mParentalLockButton.setIsLockActive(isLockActive);
                                mIsClicksBlocked = false;
                            }
                        });
                        parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener() {
                            @Override
                            public void onPasswordEntered(boolean isPasswordCorrect) {
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
                                mParentalLockButton.setIsLockActive(isLockActive);
                            }
                        });
                        parentalLockDialog.show();
                    } else {
                        mIsClicksBlocked = false;
                    }
                }
            }
        });
        mParentalLockButton.setId(Utils.generateViewId());
        LayoutParams params = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        mParentalLockButton.setRoundedCornerDirection(PanelButton.RoundedCornerDirection.LEFT);
        mInnerContainer.addView(mParentalLockButton, params);
        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
        mParentalLockButton.setIsLockActive(isLockActive);
    }

    private void initAboutKidozkButton() {
        mAboutKidozButton = new PanelButton(getContext(), PANEL_TYPE.BOTTOM, com.kidoz.sdk.api.ui_views.panel_view.PANEL_BUTTON_TYPE.ABOUT_KIDOZ, new PanelButton.PanelButtonListener() {
            @Override
            public void onClickStarted() {

            }

            @Override
            public void onClickEnd() {
                int[] popLocation = new int[2];
                popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(getContext(), popLocation);
                aboutKidozDialog.openDialog();
            }
        });
        mAboutKidozButton.setId(Utils.generateViewId());
        mAboutKidozButton.setRoundedCornerDirection(PanelButton.RoundedCornerDirection.RIGHT);
        LayoutParams params = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        mInnerContainer.addView(mAboutKidozButton, params);

    }

    private void initShadowLineView() {
        mShadowView = new ShadowView(getContext());
        LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
        mContainer.addView(mShadowView, params);
    }

    private void setFamilyColorAndShape(PANEL_TYPE panelType, HANDLE_POSITION handePosition, int color) {
        GradientDrawable shape = new GradientDrawable();
        shape.setColor(color);

        float cornerRadius = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 4);
        switch (panelType) {
            case TOP: {
                switch (handePosition) {
                    case CENTER: {
                        shape.setCornerRadii(new float[]{0, 0, 0, 0, cornerRadius, cornerRadius, cornerRadius, cornerRadius});
                        break;
                    }
                    case END: {
                        shape.setCornerRadii(new float[]{0, 0, 0, 0, 0, 0, cornerRadius, cornerRadius});
                        break;
                    }
                    default: {
                        shape.setCornerRadii(new float[]{0, 0, 0, 0, cornerRadius, cornerRadius, 0, 0});
                        break;
                    }
                }
                break;
            }
            default: {
                switch (handePosition) {
                    case CENTER: {
                        shape.setCornerRadii(new float[]{cornerRadius, cornerRadius, cornerRadius, cornerRadius, 0, 0, 0, 0});
                        break;
                    }
                    case END: {
                        shape.setCornerRadii(new float[]{cornerRadius, cornerRadius, 0, 0, 0, 0, 0, 0});
                        break;
                    }
                    default: {
                        shape.setCornerRadii(new float[]{0, 0, cornerRadius, cornerRadius, 0, 0, 0, 0});
                        break;
                    }
                }
                break;
            }
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            mInnerContainer.setBackground(shape);
        } else {
            mInnerContainer.setBackgroundDrawable(shape);
        }
    }

    private void initOneItemView() {
        mOneItemView = new OneItemView(getContext());
        mOneItemView.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mInnerContainer.addView(mOneItemView, params);

        mOneItemView.setViewPagerItemClickListener(new ItemViewPagerAdapter.ViewPagerItemClickListener() {
            @Override
            public void onClickEnd(ContentItem contentItem, int position) {
                if (contentItem.isPromoted() && mAllowClickHandle) {
                    ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, WidgetType.WIDGET_TYPE_FAMILY_PANEL, position, true, true);
                    mAllowClickHandle = false;

                    getMyHandlerInstance().removeCallbacksAndMessages(null);
                    getMyHandlerInstance().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                mAllowClickHandle = true;
                                EventManager.getInstance(getContext()).clearAllTempStoredEvents();
                            } catch (Exception e) {
                            }
                        }
                    }, 3000);
                } else {
                    ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, WidgetType.WIDGET_TYPE_FAMILY_PANEL, position, true, false);
                }
            }
        });
    }

    private void preparePanel() {
        mIsOpen = true;
        mIsAnimationRunning = true;
        Utils.setOnGlobalLayoutFinishListener(mRootView, new Utils.OnGlobalLayoutFinishedListener() {
            @Override
            public void onLayoutFinished() {
                GenAnimator.playShrinkAnimation(mHandleButton, 0, null);
                GenAnimator.closePanelView(mContainer, 0, mInnerContainer, mPanelType, new Animator.AnimatorListener() {
                    @Override
                    public void onAnimationStart(Animator animation) {
                        GenAnimator.animateHandleClose(mHandleButton, null);
                    }

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        mHandleButton.setPanelButtonState(PanelStyleableButtonView.PANEL_BUTTON_STATE.CLOSED);
                        GenAnimator.playGrowAnimation(mHandleButton, 350, 500, new Animator.AnimatorListener() {
                            @Override
                            public void onAnimationStart(Animator animation) {
                            }

                            @Override
                            public void onAnimationEnd(Animator animation) {
                                mIsOpen = false;
                                mIsAnimationRunning = false;
                                if (mIOnPanelViewEventListener != null) {
                                    mIOnPanelViewEventListener.onPanelReady();
                                }
                            }

                            @Override
                            public void onAnimationCancel(Animator animation) {

                            }

                            @Override
                            public void onAnimationRepeat(Animator animation) {

                            }
                        });
                    }

                    @Override
                    public void onAnimationCancel(Animator animation) {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation) {

                    }
                });
            }
        });
        applyPanelMainBgColor();
    }

    private void initPanelTypeAndHandlePosition() {
        mPanelType = PANEL_TYPE.BOTTOM;
        mHandlePosition = com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION.START;
        if (Build.VERSION.SDK_INT >= 16) {
            int gravity = getGravity();
            switch (gravity) {
                case Gravity.TOP: {
                    mPanelType = PANEL_TYPE.TOP;
                    break;
                }
                default: {
                    mPanelType = PANEL_TYPE.BOTTOM;
                    break;
                }
            }
        }
    }

    private void initPanelViewsRules() {
        RelativeLayout.LayoutParams containerParams = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mContainer.setLayoutParams(containerParams);

        // 1. Set inner container params.
        // Inner container width is the width of the content view pager + animation view + next button.
        // Inner container height is 2 times the view pager margin + view pager height.
        int viewPagerWidth = (int) (517f * ScreenUtils.getScaleFactor(getContext()));
        int viewPagerMargin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 6);
        int button = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 30);
        int innerContainerWidth = (viewPagerWidth * 2) + button;
        int innerContainerHeight = viewPagerWidth + (viewPagerMargin * 2);
        RelativeLayout.LayoutParams innerContainerParams = new RelativeLayout.LayoutParams(innerContainerWidth, innerContainerHeight);
        mInnerContainer.setLayoutParams(innerContainerParams);

        // 2. Fix one item view params.
        mOneItemView.fixParams();

        // 3. Set bottom container params and.
        RelativeLayout.LayoutParams bottomBarParams = new RelativeLayout.LayoutParams(innerContainerWidth, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mBottomBarContainer.setLayoutParams(bottomBarParams);

        RelativeLayout.LayoutParams parentalLockParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mParentalLockButton.setLayoutParams(parentalLockParams);

        RelativeLayout.LayoutParams aboutKidozParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mAboutKidozButton.setLayoutParams(aboutKidozParams);

        // 4. Fix bottom container views rules.
        bottomBarParams.addRule(RelativeLayout.BELOW, mOneItemView.getId());
        bottomBarParams.addRule(RelativeLayout.RIGHT_OF, mAboutKidozButton.getId());
        bottomBarParams.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());

        aboutKidozParams.addRule(RelativeLayout.ALIGN_BOTTOM, mBottomBarContainer.getId());

        parentalLockParams.addRule(RelativeLayout.ALIGN_BOTTOM, mBottomBarContainer.getId());
        parentalLockParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);

        // 5. Set shadow view params.
        RelativeLayout.LayoutParams shadowParams = new RelativeLayout.LayoutParams(innerContainerWidth, innerContainerHeight);
        mShadowView.setLayoutParams(shadowParams);
        shadowParams.addRule(RelativeLayout.ALIGN_LEFT, mInnerContainer.getId());
        shadowParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
        shadowParams.addRule(RelativeLayout.ALIGN_TOP, mInnerContainer.getId());
        shadowParams.addRule(RelativeLayout.ALIGN_BOTTOM, mInnerContainer.getId());

        // 6. Set handle params.
        RelativeLayout.LayoutParams handleParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mHandleButton.setLayoutParams(handleParams);

        RelativeLayout.LayoutParams customHandleParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mCustomUserHandleButton.setLayoutParams(customHandleParams);

        // 7. Set init visibility of shadow and KIDOZ label.
        mPoweredByTextView.setVisibility(View.VISIBLE);
        mShadowView.setVisibility(View.INVISIBLE);

        // 8. Fix rules.
        int shadowMargin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 10);
        switch (mPanelType) {
            case TOP: {
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                handleParams.addRule(RelativeLayout.BELOW, mInnerContainer.getId());
                customHandleParams.addRule(RelativeLayout.BELOW, mInnerContainer.getId());
                shadowParams.bottomMargin = -shadowMargin;
                break;
            }
            default: {
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                handleParams.addRule(RelativeLayout.ABOVE, mInnerContainer.getId());
                customHandleParams.addRule(RelativeLayout.ABOVE, mInnerContainer.getId());
                shadowParams.topMargin = -shadowMargin;
                break;
            }

        }

        int margin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 6);
        switch (mHandlePosition) {
            case CENTER: {
                handleParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                customHandleParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                innerContainerParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
                shadowParams.leftMargin = -shadowMargin;
                shadowParams.rightMargin = -shadowMargin;
                break;
            }
            case END: {
                handleParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
                customHandleParams.addRule(RelativeLayout.ALIGN_RIGHT, mInnerContainer.getId());
                handleParams.rightMargin = margin;
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                shadowParams.leftMargin = -shadowMargin;
                break;
            }
            default: {
                handleParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                customHandleParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                handleParams.leftMargin = margin;
                innerContainerParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                shadowParams.rightMargin = -shadowMargin;
                break;
            }
        }

        mShadowView.setConfiguration(mPanelType, mHandlePosition);
    }

    private void initContentLogicLoader() {
        mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback() {
            @Override
            public void onDataReady(ContentData contentData) {
                if (contentData != null) {
                    mOneItemView.setContent(contentData.getContentDataItems(), mPanelType);
                }
            }
        });
    }

    private void toggleAnimation() {
        if (mIsOpen == true) {
            collapsePanelView();
        } else {
            applyPanelMainBgColor();
            expandPanelViewInternal(false);
        }
    }

    /**
     * Collapse panel view
     */
    public void collapsePanelView() {
        if(KidozSDK.isInitialised()) {
            if (mIsAnimationRunning == false && mIsOpen == true) {
                GenAnimator.closePanelView(mContainer, 200, mInnerContainer, mPanelType, new Animator.AnimatorListener() {
                    @Override
                    public void onAnimationStart(Animator animation) {
                        if (mIsCustomHandleSet == false) {
                            GenAnimator.animateHandleClose(mHandleButton, null);
                        }
                    }

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        mShadowView.setVisibility(View.INVISIBLE);
                        if (mIsCustomHandleSet == false) {
                            mHandleButton.setPanelButtonState(PanelStyleableButtonView.PANEL_BUTTON_STATE.CLOSED);
                        }
                        mIsOpen = false;
                        mIsAnimationRunning = false;
                        if (mIOnPanelViewEventListener != null) {
                            mIOnPanelViewEventListener.onPanelViewCollapsed();
                        }
                    }

                    @Override
                    public void onAnimationCancel(Animator animation) {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation) {

                    }
                });
            }
        }
    }

    /**
     * Expand (Open) Panel view
     */
    public void expandPanelView() {
        if(KidozSDK.isInitialised()) {
            expandPanelViewInternal(true);
        }
    }

    /**
     * Expand (Open) Panel view
     */
    private void expandPanelViewInternal(boolean byUserAction) {
        if (mIsAnimationRunning == false && mIsOpen == false) {
            // Send log
            Event event = new Event();
            if (byUserAction) {
                event.addParameterToJsonObject(EventParameters.LABEL_VIEW_OPEN_TYPE, EventParameters.MANUAL_OPEN);
            } else {
                event.addParameterToJsonObject(EventParameters.LABEL_VIEW_OPEN_TYPE, EventParameters.AUTOMATIC_OPEN);
            }
            EventManager.getInstance(getContext()).logEvent(getContext(), WidgetType.WIDGET_TYPE_FAMILY_PANEL, EventManager.LOG_CRITICAL_LEVEL, event, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, EventParameters.PANEL_VIEW, false);

            //Refresh the parental lock icon
            boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
            mParentalLockButton.setIsLockActive(isLockActive);

            GenAnimator.openPanelView(mContainer, mContainer, mPanelType, new Animator.AnimatorListener() {
                @Override
                public void onAnimationStart(Animator animation) {
                    mShadowView.setVisibility(View.VISIBLE);
                    if (mIsCustomHandleSet == false) {
                        GenAnimator.animateHandleOpen(mHandleButton, null);
                    }

                    mContentLogicLoader.loadContent(getContext(), WidgetType.WIDGET_TYPE_FAMILY_PANEL);
                }

                @Override
                public void onAnimationEnd(Animator animation) {
                    if (mIsCustomHandleSet == false) {
                        mHandleButton.setPanelButtonState(PanelStyleableButtonView.PANEL_BUTTON_STATE.OPENED);
                    }
                    mIsOpen = true;
                    mIsAnimationRunning = false;

                    if (mIOnPanelViewEventListener != null) {
                        mIOnPanelViewEventListener.onPanelViewExpanded();
                    }
                }

                @Override
                public void onAnimationCancel(Animator animation) {

                }

                @Override
                public void onAnimationRepeat(Animator animation) {

                }
            });
        }
    }

    /**
     * Set panel view configuration
     *
     * @param panelType      panel view type (Possible values <code> PANEL_TYPE.TOP, PANEL_TYPE.BOTTOM, PANEL_TYPE.LEFT ,PANEL_TYPE.RIGHT </code>
     * @param handlePosition handle position  (Possible values <code> HANDLE_POSITION.START, HANDLE_POSITION.CENTER, HANDLE_POSITION.END </code>
     */
    public void setPanelConfiguration(PANEL_TYPE panelType, com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION handlePosition) {
        if(KidozSDK.isInitialised()) {
            setPanelConfiguration(panelType, handlePosition, null);
        }
    }

    /**
     * Set panel view configuration
     *
     * @param panelType      panel view type (Possible values <code> PANEL_TYPE.TOP, PANEL_TYPE.BOTTOM, PANEL_TYPE.LEFT ,PANEL_TYPE.RIGHT </code>
     * @param handlePosition handle position  (Possible values <code> HANDLE_POSITION.START, HANDLE_POSITION.CENTER, HANDLE_POSITION.END </code>
     * @param customHandle   user defined custom handle iew
     */
    public void setPanelConfiguration(PANEL_TYPE panelType, com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION handlePosition, View customHandle) {
        if(KidozSDK.isInitialised()) {
            mPanelType = panelType;
            mHandlePosition = handlePosition;
            mHandleButton.setPanelType(mPanelType);
            mParentalLockButton.setPanelType(PANEL_TYPE.BOTTOM);
            mAboutKidozButton.setPanelType(PANEL_TYPE.BOTTOM);
            if (customHandle != null) {
                LayoutParams relLayParams = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                mCustomUserHandleButton.setVisibility(View.VISIBLE);
                mCustomUserHandleButton.addView(customHandle, relLayParams);
                mIsCustomHandleSet = true;
                mHandleButton.setVisibility(View.INVISIBLE);
            } else {
                mCustomUserHandleButton.removeAllViews();
                mCustomUserHandleButton.setVisibility(View.GONE);
                mIsCustomHandleSet = false;
                mHandleButton.setVisibility(View.VISIBLE);
            }

            initPanelViewsRules();
        }
    }

    /**
     * Set panel events listener
     *
     * @param iOnPanelViewEventListener listener
     */
    public void setOnPanelViewEventListener(IOnPanelViewEventListener iOnPanelViewEventListener) {
        mIOnPanelViewEventListener = iOnPanelViewEventListener;
    }

    /**
     * Get panel view state
     *
     * @return is panel expanded pr closed
     */
    public boolean getIsPanelViewExpanded() {
        return mIsOpen;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();

        if (!isInEditMode() && KidozSDK.isInitialised()) {
            EventManager.getInstance(getContext()).logEvent(getContext(), WidgetType.WIDGET_TYPE_FAMILY_PANEL, EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SDK, EventParameters.ACTION_BUTTON_VIEW, EventParameters.LABEL_PANEL_BUTTON_VIEW, false);
            EventManager.getInstance(getContext()).startEventsSync(getContext(), 1500);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        getUiHandlerInstance().removeCallbacksAndMessages(null);
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);

        getMyHandlerInstance().removeCallbacksAndMessages(null);

        if(KidozSDK.isInitialised()) {
            if (visibility == View.VISIBLE) {
                mAllowClickHandle = true;
            } else if (!isInEditMode() && (visibility == View.GONE || visibility == View.INVISIBLE)) {
                if (EventManager.getInstance(getContext()).logAllTempStoredEvents(getContext())) {
                    EventManager.getInstance(getContext()).startEventsSync(getContext(), 1000);
                }
                mAllowClickHandle = true;
            }
        }
    }

    /**
     * Load Panel button style view define on server
     */
    private void loadButtonStyleView() {
        PropertiesObj appConfig = DatabaseManager.getInstance(getContext()).getConfigTable().loadAppProperties();
        if (appConfig != null) {
            if (mHandleButton != null && mIsCustomHandleSet == false) {
                mHandleButton.loadPanelButtonStyle(appConfig.getPanelButtonUrl(), new DefaultPanelDrawable(getContext(), mPanelType, DefaultPanelDrawable.PanelDrawableType.CLOSED_VIEW), appConfig.getPanelButtonCloseUrl(), new DefaultPanelDrawable(getContext(), mPanelType, DefaultPanelDrawable.PanelDrawableType.OPENED_VIEW));
            }
        } else {
            if (mNotReadyRepeatCount < BUTTON_STYLE_RESOURCE_NOT_READY_REPEAT_COUNT && mIsCustomHandleSet == false) {
                getUiHandlerInstance().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        mNotReadyRepeatCount++;
                        loadButtonStyleView();
                    }
                }, 1200);
            }
        }
    }

    private void applyPanelMainBgColor() {

        if (mPanelBgColor == Color.WHITE) {
            PropertiesObj appConfig = DatabaseManager.getInstance(getContext()).getConfigTable().loadAppProperties();
            if (appConfig != null) {
                if (appConfig.getPanelBackGroundColor() != null) {
                    try {
                        mPanelBgColor = Color.parseColor(appConfig.getPanelBackGroundColor());
                    } catch (Exception e) {
                    }
                }

            }
        }

        setPanelColor(mPanelBgColor);
    }


    /**
     * Set panel color
     *
     * @param color
     */
    public void setPanelColor(int color) {
        if(KidozSDK.isInitialised()) {
            mPanelBgColor = color;

            if (mParentalLockButton != null) {
                mParentalLockButton.setBaseColor(mPanelBgColor);
            }

            if (mAboutKidozButton != null) {
                mAboutKidozButton.setBaseColor(mPanelBgColor);
            }

            if (mBottomBarContainer != null) {
                mBottomBarContainer.setBackgroundColor(mPanelBgColor);
            }

            if (mInnerContainer != null) {
                setFamilyColorAndShape(mPanelType, mHandlePosition, mPanelBgColor);
            }

            if (mHandleButton != null && mIsCustomHandleSet == false) {
                mHandleButton.setBaseColor(mPanelBgColor);
            }
        }
    }

    /**
     * Get handler instance
     */
    private Utils.StaticHandler getMyHandlerInstance() {
        if (mStaticHandler == null) {
            mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper()) {
                @Override
                public void handleMessage(Message message) {
                    // This is where you do your work in the UI thread.
                    // Your worker tells you in the message what to do.
                }
            };
        }
        return mStaticHandler;
    }

    /**
     * Get handler instance
     */
    private Utils.StaticHandler getUiHandlerInstance() {
        if (mUiLoaderStaticHandler == null) {
            mUiLoaderStaticHandler = new Utils.StaticHandler(Looper.getMainLooper()) {
                @Override
                public void handleMessage(Message message) {
                    // This is where you do your work in the UI thread.
                    // Your worker tells you in the message what to do.
                }
            };
        }
        return mUiLoaderStaticHandler;
    }
}
