package com.kidoz.sdk.api;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.players.FullScreenViewDialog;
import com.kidoz.sdk.api.players.web_player.WebPlayerDialog;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.structure.IsEventRecord;

import java.util.List;


public class ContentExecutionHandler
{
    public static final String TAG = ContentExecutionHandler.class.getSimpleName();
    public static final int CLICK_REGULATION_TIME_FRAME = 1600;
    // Used to control and prevent double clicking on content item
    public static long mLastClickActionTimeStamp = 0;

    /**
     * @param contentItem
     */
    public static void handleContentItemClick(final Context context, final ContentItem contentItem, final WidgetType widgetType, final int position, final boolean allowModifyOrientation, final boolean storeLogEventForLaterSending)
    {
        if(System.currentTimeMillis() - mLastClickActionTimeStamp > CLICK_REGULATION_TIME_FRAME) {
            switch (contentItem.getContentType())
            {
                case GOOGLE_PLAY_APPLICATION:
                {
                    checkForParentalLock(context, new IonParentalLockStatusListener()
                    {
                        @Override public void onLockActive(boolean isPasswordCorrect)
                        {
                            if (isPasswordCorrect == true)
                            {
                                onGooglePlayApp(context, contentItem, widgetType, position, storeLogEventForLaterSending);
                            }
                            else
                            {
                                EventManager.getInstance(context).logEvent(context, widgetType, EventManager.LOG_NORMAL_LEVEL, null, EventParameters.CATEGORY_SDK, EventParameters.ACTION_PARENTAL_INCORRECT_PASSWORD, contentItem.getId(), storeLogEventForLaterSending);
                            }
                        }

                        @Override public void onLockNotActive()
                        {
                            onGooglePlayApp(context, contentItem, widgetType, position, storeLogEventForLaterSending);
                        }
                    });

                    break;
                }

                case PROMOTED_PLAY_APPLICATION:
                {
                    if (context != null && contentItem != null)
                    {
                        checkForParentalLock(context, new IonParentalLockStatusListener()
                        {
                            @Override public void onLockActive(boolean isPasswordCorrect)
                            {
                                if (isPasswordCorrect == true)
                                {
                                    onPromotedAppItemClick(context, contentItem, widgetType, position, allowModifyOrientation, storeLogEventForLaterSending);

                                    // Store click app event in the local data base
                                    IsEventRecord isEventRecord = new IsEventRecord();
                                    isEventRecord.setPackageName(contentItem.getId());
                                    isEventRecord.setContentType(contentItem.getContentType().toString());
                                    isEventRecord.setName(contentItem.getName());
                                    isEventRecord.setPositionIndex(position);
                                    isEventRecord.setAdvertiserId(contentItem.getAdvertiserID());
                                    isEventRecord.setTimeStamp(System.currentTimeMillis() + "");
                                    DatabaseManager.getInstance(context).getIsEventTable().insertRecord(isEventRecord);
                                }
                                else
                                {
                                    EventManager.getInstance(context).logEvent(context, widgetType, EventManager.LOG_NORMAL_LEVEL, null, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_PARENTAL_INCORRECT_PASSWORD, contentItem.getId(), storeLogEventForLaterSending);
                                }
                            }

                            @Override public void onLockNotActive()
                            {
                                onPromotedAppItemClick(context, contentItem, widgetType, position, allowModifyOrientation, storeLogEventForLaterSending);

                                // Store click app event in the local data base
                                IsEventRecord isEventRecord = new IsEventRecord();
                                isEventRecord.setPackageName(contentItem.getId());
                                isEventRecord.setContentType(contentItem.getContentType().toString());
                                isEventRecord.setName(contentItem.getName());
                                isEventRecord.setPositionIndex(position);
                                isEventRecord.setAdvertiserId(contentItem.getAdvertiserID());
                                isEventRecord.setTimeStamp(System.currentTimeMillis() + "");
                                DatabaseManager.getInstance(context).getIsEventTable().insertRecord(isEventRecord);
                            }
                        });
                    }

                    break;
                }

                case WEB_GAME_URL:
                {

                    onlineGameItemClick(context, contentItem, widgetType, position, allowModifyOrientation, storeLogEventForLaterSending);
                    break;
                }

                case WEBSITE_URL:
                {

                    onUrlItemClick(context, contentItem, widgetType, position, allowModifyOrientation, storeLogEventForLaterSending);
                    break;
                }

                case YOTUBE_VIDEO:
                {
                    //                if (context != null && contentItem != null)
                    //                {
                    //                    EventManager.getInstance().logEvent(context,EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_VIDEO_PLAYER, EventParameters.ACTION_VIDEO_PLAY, contentItem.getName());
                    //                }
                }

                case STREAMING_VIDEO:
                {
                    onYouTubeVideolItemClick(context, contentItem, widgetType, position, allowModifyOrientation, storeLogEventForLaterSending);
                    break;
                }

                case EXTERNAL_BROWSER_URL:
                {
                    if (contentItem.isPromoted())
                    {
                        checkForParentalLock(context, new IonParentalLockStatusListener()
                        {
                            @Override public void onLockActive(boolean isPasswordCorrect)
                            {
                                if (isPasswordCorrect == true)
                                {
                                    onExternalLinkItemClick(context, contentItem, widgetType, position, storeLogEventForLaterSending);
                                }
                                else
                                {
                                    EventManager.getInstance(context).logEvent(context, widgetType, EventManager.LOG_NORMAL_LEVEL, null, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_PARENTAL_INCORRECT_PASSWORD, contentItem.getId(), storeLogEventForLaterSending);
                                }
                            }

                            @Override public void onLockNotActive()
                            {
                                onExternalLinkItemClick(context, contentItem, widgetType, position, storeLogEventForLaterSending);
                            }
                        });
                    }
                    else
                    {
                        onExternalLinkItemClick(context, contentItem, widgetType, position, storeLogEventForLaterSending);
                    }
                }
            }
            mLastClickActionTimeStamp = System.currentTimeMillis();
        }
    }


    /**
     * Handle click on application type
     *
     * @param contentItem
     */
    protected static void onPromotedAppItemClick(Context context, ContentItem contentItem, WidgetType widgetType, int position, boolean allowModifyOrientation, boolean storeLogEventLaterSending)
    {
        if (contentItem != null && contentItem.getData() != null && contentItem.getData().contains("market://") || contentItem.getData().contains("play.google.com"))
        {
            try
            {
                String googlePlayMarketURL = "market://details?id=" + contentItem.getId();
                String[] urlPazzel = contentItem.getData().split(contentItem.getId());
                if (urlPazzel != null && urlPazzel.length > 1)
                {
                    googlePlayMarketURL += urlPazzel[1];
                }

                Intent intent = new Intent(Intent.ACTION_VIEW);
                intent.setData(Uri.parse(googlePlayMarketURL));
                final List<ResolveInfo> availableIntents = context.getPackageManager().queryIntentActivities(intent, 0);
                if (availableIntents == null || availableIntents.isEmpty() == true)
                {
                    onUrlItemClick(context, contentItem, widgetType, position, allowModifyOrientation, storeLogEventLaterSending);
                }
                else
                {
                    context.startActivity(intent);
                }
            }
            catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to open google play for promoted app: \n" + ex.getMessage());
            }
//            try
            //            {
            //                /*Intent intent = new Intent(Intent.ACTION_VIEW);
            //                ComponentName comp = new ComponentName("com.android.vending", "com.google.android.finsky.activities.LaunchUrlHandlerActivity"); // package name and activity
            //                intent.setComponent(comp);
            //                intent.setData(Uri.parse(contentItem.getData()));
            //                //intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            //                //intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK);
            //                context.startActivity(intent);*/
            //
            //                Intent intent = new Intent(Intent.ACTION_VIEW);
            //                intent.setData(Uri.parse(contentItem.getData()));
            //                // find all applications able to handle our rateIntent
            //                final List<ResolveInfo> otherApps = context.getPackageManager().queryIntentActivities(intent, 0);
            //
            //                EventManager.getInstance(context).logSponsoredContentClickEvent(context, widgetType, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position, storeLogEventLaterSending); //todo: ask Rony
            //
            //                for (ResolveInfo otherApp : otherApps)
            //                {
            //                    // look for Google Play application
            //                    if (otherApp.activityInfo.applicationInfo.packageName.equals("com.android.vending"))
            //                    {
            //                        if (otherApp.activityInfo.applicationInfo.packageName.equals("com.android.vending"))
            //                        {
            //
            //                            ActivityInfo otherAppActivity = otherApp.activityInfo;
            //                            ComponentName componentName = new ComponentName(otherAppActivity.applicationInfo.packageName, otherAppActivity.name);
            //                            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_RESET_TASK_IF_NEEDED);
            //                            intent.setComponent(componentName);
            //                            context.startActivity(intent);
            //                            break;
            //                        }
            //                    }
            //
            //                }
            //            }
            //            catch (Exception ex)
            //            {
            //                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to open google play for promoted app: \n" + ex.getMessage());
            //            }
        }
        else
        {
            onUrlItemClick(context, contentItem, widgetType, position, allowModifyOrientation, storeLogEventLaterSending);
        }
    }


    /**
     * Handle click on google play application type
     *
     * @param contentItem
     */
    protected static void onGooglePlayApp(Context context, ContentItem contentItem, WidgetType widgetType, int position, boolean storeLogEventLaterSending)
    {
        // Google account exists ,Lounch Google Play Store
        EventManager.getInstance(context).logClickEvent(context, widgetType, EventParameters.ACTION_FEED_ITEM_CLICK, EventParameters.LABEL_CONTENT_TYPE_GOOGLE_PLAY_APP, contentItem.getId(), position, storeLogEventLaterSending);

        Intent googlePlayIntent = new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + contentItem.getId()));
        googlePlayIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        googlePlayIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK);
        context.startActivity(googlePlayIntent);
    }

    /**
     * Handle click on content type Online game
     *
     * @param contentItem
     */
    protected static void onlineGameItemClick(Context context, ContentItem contentItem, WidgetType widgetType, int position, boolean allowModifyOrientation, boolean storeLogEventLaterSending)
    {
        EventManager.getInstance(context).logClickEvent(context, widgetType, EventParameters.ACTION_FEED_ITEM_CLICK, EventParameters.LABEL_CONTENT_TYPE_ONLINE_GAME, contentItem.getId(), position, storeLogEventLaterSending);

        WebPlayerDialog webPlayerDialog = new WebPlayerDialog(context, contentItem, widgetType, WebPlayerType.ONLINE_GAME, allowModifyOrientation);
        webPlayerDialog.openDialog();

       /* Intent webPlayerActivity = new Intent(context, WebPlayerActivity.class);
        webPlayerActivity.putExtra(WebPlayerActivity.EXTRA_CONTENT_ITEM_KEY, contentItem);
        webPlayerActivity.putExtra(WebPlayerActivity.EXTRA_WEB_PLAYER_TYPE_KEY, WebPlayerType.ONLINE_GAME);
        context.startActivity(webPlayerActivity);*/
    }

    /**
     * Handle click on content type Url game
     *
     * @param contentItem
     */
    protected static void onUrlItemClick(Context context, ContentItem contentItem, WidgetType widgetType, int position, boolean allowModifyOrientation, boolean storeLogEventLaterSending)
    {
        EventManager.getInstance(context).logClickEvent(context, widgetType, EventParameters.ACTION_FEED_ITEM_CLICK, EventParameters.LABEL_CONTENT_TYPE_URL, contentItem.getId(), position, storeLogEventLaterSending);

        WebPlayerType webPlayerType = WebPlayerType.WEB_BROWSER;
        if (contentItem != null && contentItem.getContentType() == ContentType.PROMOTED_PLAY_APPLICATION)
        {
            webPlayerType = WebPlayerType.EXTERNAL_LINK;
        }

        WebPlayerDialog webPlayerDialog = new WebPlayerDialog(context, contentItem, widgetType, webPlayerType, allowModifyOrientation);
        webPlayerDialog.openDialog();

       /* Intent webPlayerActivity = new Intent(context, WebPlayerActivity.class);
        webPlayerActivity.putExtra(WebPlayerActivity.EXTRA_CONTENT_ITEM_KEY, contentItem);
        webPlayerActivity.putExtra(WebPlayerActivity.EXTRA_WEB_PLAYER_TYPE_KEY, WebPlayerType.WEB_BROWSER);
        context.startActivity(webPlayerActivity);*/
    }


    /**
     * Handle click on content type Video game
     *
     * @param contentItem
     */
    protected static void onYouTubeVideolItemClick(Context context, ContentItem contentItem, WidgetType widgetType, int position, boolean allowModifyOrientation, boolean storeLogEventLaterSending)
    {
        if (context != null && contentItem != null && contentItem.getData() != null)
        {
            final FullScreenViewDialog fullScreenViewDialog = new FullScreenViewDialog(context, widgetType, allowModifyOrientation);
            fullScreenViewDialog.openDialog(contentItem);

            EventManager.getInstance(context).logClickEvent(context, widgetType, EventParameters.ACTION_FEED_ITEM_CLICK, EventParameters.LABEL_CONTENT_TYPE_YOUTUBE, contentItem.getId(), position, storeLogEventLaterSending);

            //          Intent youtubeActivity = new Intent(context, YouTubePlayerActivity.class);
            //          youtubeActivity.putExtra(YouTubePlayerActivity.INTENT_EXTRA_VIDEO_ID, YouTubeUtils.extractYouTubeVideoIDString(contentItem.getData()));
            //          youtubeActivity.putExtra(YouTubePlayerActivity.INTENT_EXTRA_VIDEO_NAME, contentItem.getName());
            //          youtubeActivity.putExtra(YouTubePlayerActivity.INTENT_EXTRA_CONTENT_ITEM_ID, contentItem.getId());
            //          context.startActivity(youtubeActivity);
        }
    }


    /**
     * Handle click on external type
     *
     * @param contentItem
     */
    private static void onExternalLinkItemClick(Context context, ContentItem contentItem, WidgetType widgetType, int position, boolean storeLogEventLaterSending)
    {

        if (contentItem.isPromoted())
        {
            EventManager.getInstance(context).logSponsoredContentClickEvent(context, widgetType, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position, storeLogEventLaterSending);

        }
        else
        {
            EventManager.getInstance(context).logClickEvent(context, widgetType, EventParameters.ACTION_FEED_ITEM_CLICK, EventParameters.LABEL_CONTENT_TYPE_EXTERNAL_URL, contentItem.getId(), position, storeLogEventLaterSending);
        }

        Intent i = new Intent(Intent.ACTION_VIEW, Uri.parse(contentItem.getData()));
        context.startActivity(i);
    }


    /**
     * Lounch parenal lock checkHandle click on external type
     *
     * @param context
     * @param lockStatusListener listener
     */
    private static void checkForParentalLock(final Context context, final IonParentalLockStatusListener lockStatusListener)
    {
        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(context, ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
        if (isLockActive == true && ParentalLockDialog.getIsCanShowDialog(context) == true)
        {
            int[] popLocation = new int[2];
            popLocation[0] = (int) (ScreenUtils.getScreenSize(context, true) * 0.5f);
            popLocation[1] = (int) (ScreenUtils.getScreenSize(context, false) * 0.5f);
            ParentalLockDialog parentalLockDialog = new ParentalLockDialog(context, true, popLocation);
            parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener()
            {
                @Override public void onPasswordEntered(boolean isPasswordCorrect)
                {
                    lockStatusListener.onLockActive(isPasswordCorrect);
                }
            });
            parentalLockDialog.show();
        }
        else
        {
            lockStatusListener.onLockNotActive();
        }
    }

    private interface IonParentalLockStatusListener
    {
        public void onLockActive(boolean isPasswordCorrect);

        public void onLockNotActive();
    }
}

  /* Intent lounchIntent = null;
                if (context != null) {
                    // Check if application is already installed on device
                    lounchIntent = context.getPackageManager().getLaunchIntentForPackage(contentItem.getId());
                }*/

//Otherwise check if Google Account is exists ,At least one
//if(Utils.isManifetsPermissionExists(context,"android.permission.GET_ACCOUNTS")) {
//
//}else {
//
//}
//
//
//if(Utils.isDeviceHasGoogleAccount(context)) {
//// Google account exists ,Lounch Google Play Store
//Intent googlePlayIntent = new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + contentItem.getId()));
//googlePlayIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//googlePlayIntent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK);
//context.startActivity(googlePlayIntent);
//}else {
//Log.e("[KIDOZ SDK]","User doesn't have a valid Google Account Login on the device!");
//}